/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRow;

public class FTAggregationHelper {
    private IAggrFunction[] functions;
    private Object[] currentRoundAggrValue;
    private List<Accumulator> accumulators;

    public FTAggregationHelper(IAggrFunction[] functions) throws DataException {
        this.functions = functions;
        this.currentRoundAggrValue = new Object[functions.length];
        this.accumulators = new ArrayList<Accumulator>();
        this.populateAggregations();
    }

    private void populateAggregations() throws DataException {
        int i = 0;
        while (i < this.functions.length) {
            Accumulator acc = this.functions[i].newAccumulator();
            acc.start();
            this.accumulators.add(acc);
            ++i;
        }
    }

    public void onRow(boolean populateValue, FactTableRow factTableRow) throws DataException {
        int aggrIndex = 0;
        while (aggrIndex < this.functions.length) {
            Accumulator acc = this.accumulators.get(aggrIndex);
            acc.onRow(new Object[]{factTableRow.getMeasures()[aggrIndex]});
            if (populateValue) {
                acc.finish();
                this.currentRoundAggrValue[aggrIndex] = acc.getValue();
                acc.start();
            }
            ++aggrIndex;
        }
    }

    public Object[] getCurrentValues() {
        Object[] result = new Object[this.currentRoundAggrValue.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.currentRoundAggrValue[i];
            ++i;
        }
        return result;
    }
}

