/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.odf.SpanInfo;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;

public class TableInfo {
    private Hashtable<Integer, List<SpanInfo>> spans = new Hashtable();
    private double[] cols;
    private int crow = 0;
    private IStyle style = null;
    private Map<DimensionType, StyleEntry> rowHeightStyles;

    public TableInfo(double[] cols, IStyle style) {
        this.cols = cols;
        this.style = style;
        this.rowHeightStyles = new HashMap<DimensionType, StyleEntry>();
    }

    void newRow() {
        ++this.crow;
    }

    void addSpan(int columnId, int columnSpan, int rowSpan, StyleEntry style) {
        int i = 1;
        while (i < rowSpan) {
            List<Object> rSpan;
            Integer key = this.crow + i;
            if (this.spans.containsKey(key)) {
                rSpan = this.spans.get(key);
                rSpan.add(new SpanInfo(columnId, columnSpan, 1, false, style));
                Collections.sort(rSpan, new Comparator<SpanInfo>(){

                    @Override
                    public int compare(SpanInfo o1, SpanInfo o2) {
                        SpanInfo r1 = o1;
                        SpanInfo r2 = o2;
                        return r1.getColumnId() - r2.getColumnId();
                    }
                });
            } else {
                rSpan = new Vector<SpanInfo>();
                ((Vector)rSpan).add(new SpanInfo(columnId, columnSpan, 1, false, style));
                this.spans.put(key, rSpan);
            }
            ++i;
        }
    }

    List<SpanInfo> getSpans(int end) {
        List<SpanInfo> cSpans = this.spans.get(this.crow);
        if (cSpans == null) {
            return null;
        }
        Vector<SpanInfo> cList = new Vector<SpanInfo>();
        int pos = -1;
        int i = 0;
        while (i < cSpans.size()) {
            SpanInfo r = cSpans.get(i);
            if (r.getColumnId() + r.getColumnSpan() - 1 > end) break;
            cList.add(r);
            pos = i++;
        }
        i = 0;
        while (i <= pos) {
            cSpans.remove(0);
            ++i;
        }
        if (cSpans.size() == 0) {
            this.removeSpan();
        }
        return cList.size() == 0 ? null : cList;
    }

    public void removeSpan() {
        this.spans.remove(this.crow);
    }

    public double[] getColumnWidths() {
        return this.cols;
    }

    int getRow() {
        return this.crow;
    }

    public IStyle getTableStyle() {
        return this.style;
    }

    public StyleEntry getRowHeightStyle(DimensionType rowHeight) {
        return this.rowHeightStyles.get(rowHeight);
    }

    public void addRowHeightStyle(DimensionType rowHeight, StyleEntry style) {
        this.rowHeightStyles.put(rowHeight, style);
    }
}

