/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.impl.LoggerSetting;
import org.eclipse.birt.report.engine.api.impl.LoggerSettingManager;

public class EngineLogger {
    private static final String BIRT_NAME_SPACE = "org.eclipse.birt";
    private static final Logger ROOT_LOGGER = Logger.getLogger("org.eclipse.birt");
    private static final List<Logger> ROOT_LOGGERS = new ArrayList<Logger>();
    private static AdapterHandler adapterHandler;

    static {
        ROOT_LOGGERS.add(ROOT_LOGGER);
    }

    private static void startEngineLogging(LoggerSetting setting) {
        AdapterHandler adapter = EngineLogger.getAdapterHandler();
        adapter.setUserLoggers(setting.getUserLoggers());
        adapter.setFileHandlers((FileHandler[])setting.getHandlers());
        for (Logger rootLogger : ROOT_LOGGERS) {
            rootLogger.setLevel(setting.getLogLevel());
        }
    }

    public static void setLogger(LoggerSetting loggerSetting, Logger logger) {
        if (logger != null && !EngineLogger.isValidLogger(logger)) {
            logger.log(Level.WARNING, "the logger can't be the child of org.eclipse.birt");
        }
        LoggerSettingManager lsmInst = LoggerSettingManager.getInstance();
        lsmInst.setLogger(loggerSetting, logger);
        EngineLogger.startEngineLogging(LoggerSettingManager.getInstance().getMergedSetting());
    }

    public static boolean isValidLogger(Logger logger) {
        while (logger != null) {
            for (Logger rootlogger : ROOT_LOGGERS) {
                if (logger != rootlogger) continue;
                return true;
            }
            logger = logger.getParent();
        }
        return false;
    }

    private static void stopEngineLogging() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                EngineLogger.doStopEngineLogging();
                return null;
            }
        });
    }

    private static void doStopEngineLogging() {
        if (adapterHandler != null) {
            for (Logger rootLogger : ROOT_LOGGERS) {
                rootLogger.setUseParentHandlers(true);
                rootLogger.removeHandler(adapterHandler);
            }
            adapterHandler.close();
            adapterHandler = null;
        }
    }

    public static void changeLogLevel(LoggerSetting loggerSetting, Level newLevel) {
        LoggerSettingManager lsmInst = LoggerSettingManager.getInstance();
        lsmInst.changeSettingLevel(loggerSetting, newLevel);
        EngineLogger.startEngineLogging(lsmInst.getMergedSetting());
        for (Logger rootLogger : ROOT_LOGGERS) {
            rootLogger.setLevel(newLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static AdapterHandler getAdapterHandler() {
        if (adapterHandler != null) return adapterHandler;
        Class<EngineLogger> clazz = EngineLogger.class;
        synchronized (EngineLogger.class) {
            if (adapterHandler != null) return adapterHandler;
            adapterHandler = new AdapterHandler(ROOT_LOGGER.getParent());
            for (Logger rootLogger : ROOT_LOGGERS) {
                rootLogger.addHandler(adapterHandler);
                rootLogger.setUseParentHandlers(false);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return adapterHandler;
        }
    }

    public static void setThreadLogger(Logger logger) {
        if (logger == null && adapterHandler == null) {
            return;
        }
        AdapterHandler adapter = EngineLogger.getAdapterHandler();
        adapter.setThreadLogger(logger);
    }

    public static void addRootLogger(Logger rootLogger) {
        if (ROOT_LOGGERS.contains(rootLogger)) {
            return;
        }
        ROOT_LOGGERS.add(rootLogger);
        Level level = ROOT_LOGGERS.get(0).getLevel();
        rootLogger.setLevel(level);
        if (adapterHandler != null) {
            rootLogger.addHandler(adapterHandler);
            rootLogger.setUseParentHandlers(false);
        }
    }

    public static LoggerSetting createSetting(Logger logger, String directoryName, String fileName, Level logLevel, int rollingSize, int maxBackupIndex) {
        LoggerSettingManager lsmInst = LoggerSettingManager.getInstance();
        LoggerSetting setting = lsmInst.createLoggerSetting(logger, directoryName, fileName, logLevel, rollingSize, maxBackupIndex);
        EngineLogger.startEngineLogging(lsmInst.getMergedSetting());
        return setting;
    }

    public static void removeSetting(LoggerSetting loggerSetting) {
        LoggerSettingManager lsmInst = LoggerSettingManager.getInstance();
        lsmInst.removeLoggerSetting(loggerSetting);
        LoggerSetting mergedSetting = lsmInst.getMergedSetting();
        if (mergedSetting != null) {
            EngineLogger.startEngineLogging(lsmInst.getMergedSetting());
        } else {
            EngineLogger.stopEngineLogging();
        }
    }

    static class AdapterHandler
    extends Handler {
        private Logger parent;
        private Logger[] userLoggers;
        private Handler[] fileHandlers;
        private ThreadLocal<Logger> threadLoggers;

        public AdapterHandler(Logger logger) {
            this.parent = logger;
        }

        public void setUserLoggers(Logger[] loggers) {
            this.userLoggers = loggers;
        }

        public void setFileHandlers(FileHandler[] fileHandlers) {
            this.fileHandlers = fileHandlers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setThreadLogger(Logger logger) {
            if (logger != null) {
                if (this.threadLoggers == null) {
                    AdapterHandler adapterHandler = this;
                    synchronized (adapterHandler) {
                        if (this.threadLoggers == null) {
                            this.threadLoggers = new ThreadLocal();
                        }
                    }
                }
                this.threadLoggers.set(logger);
            } else if (this.threadLoggers != null) {
                this.threadLoggers.set(null);
            }
        }

        @Override
        public void publish(LogRecord record) {
            Object logger;
            if (this.threadLoggers != null && (logger = this.threadLoggers.get()) != null) {
                this.publishToLogger((Logger)logger, record);
                return;
            }
            if (this.userLoggers != null || this.fileHandlers != null) {
                int n;
                int n2;
                Object[] objectArray;
                if (this.userLoggers != null) {
                    objectArray = this.userLoggers;
                    n2 = this.userLoggers.length;
                    n = 0;
                    while (n < n2) {
                        logger = objectArray[n];
                        this.publishToLogger((Logger)logger, record);
                        ++n;
                    }
                }
                if (this.fileHandlers != null) {
                    objectArray = this.fileHandlers;
                    n2 = this.fileHandlers.length;
                    n = 0;
                    while (n < n2) {
                        Object handler = objectArray[n];
                        ((Handler)handler).publish(record);
                        ++n;
                    }
                }
                return;
            }
            this.publishToLogger(this.parent, record);
        }

        @Override
        public void close() throws SecurityException {
            if (this.fileHandlers != null) {
                this.fileHandlers = null;
            }
            if (this.userLoggers != null) {
                this.userLoggers = null;
            }
        }

        @Override
        public void flush() {
            if (this.fileHandlers != null) {
                Handler[] handlerArray = this.fileHandlers;
                int n = this.fileHandlers.length;
                int n2 = 0;
                while (n2 < n) {
                    Handler handler = handlerArray[n2];
                    handler.flush();
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void publishToLogger(Logger logger, LogRecord record) {
            if (!logger.isLoggable(record.getLevel())) {
                return;
            }
            var3_3 = logger;
            synchronized (var3_3) {
                filter = logger.getFilter();
                if (filter != null && !filter.isLoggable(record)) {
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                if (true) ** GOTO lbl22
            }
            do {
                if ((targets = logger.getHandlers()) != null) {
                    i = 0;
                    while (i < targets.length) {
                        targets[i].publish(record);
                        ++i;
                    }
                }
                if (!logger.getUseParentHandlers()) break;
                logger = logger.getParent();
lbl22:
                // 2 sources

            } while (logger != null);
        }
    }
}

