/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.BorderConflictResolver;
import org.eclipse.birt.report.engine.layout.pdf.cache.CursorableList;
import org.eclipse.birt.report.engine.layout.pdf.cache.DummyCell;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableLayout;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.w3c.dom.css.CSSValue;

public class TableAreaLayout {
    protected CursorableList rows = new CursorableList();
    protected BorderConflictResolver bcr = new BorderConflictResolver();
    protected TableLayout.TableLayoutInfo layoutInfo = null;
    protected ITableContent tableContent;
    protected ICellContent[] cellCache = new ICellContent[2];
    protected int startCol;
    protected int endCol;
    protected Row unresolvedRow;

    public TableAreaLayout(ITableContent tableContent, TableLayout.TableLayoutInfo layoutInfo, int startCol, int endCol) {
        this.tableContent = tableContent;
        this.layoutInfo = layoutInfo;
        this.startCol = startCol;
        this.endCol = endCol;
        if (tableContent != null) {
            this.bcr.setRTL(tableContent.isRTL());
        }
    }

    public void setUnresolvedRow(Row row) {
        this.unresolvedRow = row;
    }

    public Row getUnresolvedRow() {
        return (Row)this.rows.getCurrent();
    }

    public Row createUnresolvedRow(RowArea rowArea) {
        Row lastRow = (Row)this.rows.getCurrent();
        Row row = new Row(rowArea, this.startCol, this.endCol);
        boolean usedResolvedRow = false;
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea upperCell = null;
            if (lastRow != null) {
                upperCell = lastRow.getCell(i);
            }
            if (upperCell != null && upperCell.getRowSpan() > 1) {
                DummyCell dummyCell = this.createDummyCell(upperCell);
                row.addArea(dummyCell);
                i = i + upperCell.getColSpan() - 1;
            } else {
                CellArea cell = row.getCell(i);
                if (cell == null) {
                    if (this.unresolvedRow != null) {
                        upperCell = this.unresolvedRow.getCell(i);
                        usedResolvedRow = true;
                    }
                    cell = this.createEmptyCell(upperCell, i, row, lastRow);
                }
                i = i + cell.getColSpan() - 1;
            }
            ++i;
        }
        if (usedResolvedRow) {
            this.unresolvedRow = null;
        }
        return row;
    }

    protected int resolveBottomBorder(CellArea cell) {
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IContent cellContent = cell.getContent();
        IStyle columnStyle = this.getColumnStyle(cell.getColumnID());
        IStyle cellAreaStyle = cell.getStyle();
        IStyle cellContentStyle = cellContent.getComputedStyle();
        IStyle rowStyle = ((IContent)cellContent.getParent()).getComputedStyle();
        this.bcr.resolveTableBottomBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
        return PropertyUtil.getDimensionValue(cellAreaStyle.getProperty(11));
    }

    protected void add(ContainerArea area, ArrayList rows) {
        if (area instanceof RowArea) {
            rows.add(area);
        } else {
            Iterator iter = area.getChildren();
            while (iter.hasNext()) {
                ContainerArea container = (ContainerArea)iter.next();
                this.add(container, rows);
            }
        }
    }

    public void remove(TableArea table) {
        ArrayList rowColloection = new ArrayList();
        this.add(table, rowColloection);
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (!rowColloection.contains(row.getArea())) continue;
            iter.remove();
        }
        this.rows.resetCursor();
    }

    protected IStyle getLeftCellContentStyle(Row lastRow, int columnID) {
        CellArea cell;
        if (this.cellCache[1] != null && this.cellCache[1].getColumn() + this.cellCache[1].getColSpan() <= columnID) {
            CellArea cell2;
            if (lastRow != null && columnID > 0 && (cell2 = lastRow.getCell(columnID - 1)) != null && cell2.getRowSpan() < 0 && cell2.getContent() != null) {
                return cell2.getContent().getComputedStyle();
            }
            return this.cellCache[1].getComputedStyle();
        }
        if (lastRow != null && columnID > 0 && (cell = lastRow.getCell(columnID - 1)) != null && cell.getRowSpan() > 1 && cell.getContent() != null) {
            return cell.getContent().getComputedStyle();
        }
        return null;
    }

    public void resolveBorderConflict(CellArea cellArea, boolean isFirst) {
        IContent cellContent = cellArea.getContent();
        int columnID = cellArea.getColumnID();
        int colSpan = cellArea.getColSpan();
        IRowContent row = (IRowContent)cellContent.getParent();
        IStyle cellContentStyle = cellContent.getComputedStyle();
        IStyle cellAreaStyle = cellArea.getStyle();
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IStyle rowStyle = row.getComputedStyle();
        IStyle columnStyle = this.getColumnStyle(columnID);
        IStyle preRowStyle = null;
        IStyle preColumnStyle = this.getColumnStyle(columnID - 1);
        IStyle topCellStyle = null;
        Row lastRow = null;
        if (this.cellCache[0] != cellContent) {
            this.cellCache[1] = this.cellCache[0];
            this.cellCache[0] = (ICellContent)cellContent;
        }
        if (this.rows.size() > 0) {
            lastRow = (Row)this.rows.getCurrent();
        }
        IStyle leftCellContentStyle = this.getLeftCellContentStyle(lastRow, columnID);
        if (lastRow != null) {
            preRowStyle = lastRow.getContent().getComputedStyle();
            CellArea cell = lastRow.getCell(columnID);
            if (cell != null && cell.getContent() != null) {
                topCellStyle = cell.getContent().getComputedStyle();
            }
        }
        if (this.rows.size() == 0 && lastRow == null) {
            if (isFirst) {
                this.bcr.resolveTableTopBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveTableTopBorder(tableStyle, null, columnStyle, null, cellAreaStyle);
            }
            if (columnID == this.startCol) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan - 1 == this.endCol) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        } else {
            if (isFirst) {
                this.bcr.resolveCellTopBorder(preRowStyle, rowStyle, topCellStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellTopBorder(preRowStyle, null, topCellStyle, null, cellAreaStyle);
            }
            if (columnID == this.startCol) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan - 1 == this.endCol) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        }
    }

    private IStyle getColumnStyle(int columnID) {
        return null;
    }

    protected void verticalAlign(CellArea c) {
        CSSValue align;
        boolean isRightAligned;
        CellArea cell = c instanceof DummyCell ? ((DummyCell)c).getCell() : c;
        IContent content = cell.getContent();
        if (content == null) {
            return;
        }
        CSSValue verticalAlign = content.getComputedStyle().getProperty(48);
        if (IStyle.BOTTOM_VALUE.equals(verticalAlign) || IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
            int totalHeight = 0;
            Iterator iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                totalHeight += child.getAllocatedHeight();
            }
            int offset = cell.getContentHeight() - totalHeight;
            if (offset > 0) {
                AbstractArea child;
                if (IStyle.BOTTOM_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset);
                    }
                } else if (IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset / 2);
                    }
                }
            }
        }
        if ((isRightAligned = BidiAlignmentResolver.isRightAligned(content, align = content.getComputedStyle().getProperty(23), false)) || IStyle.CENTER_VALUE.equals(align)) {
            Iterator iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                int spacing = cell.getContentWidth() - area.getAllocatedWidth();
                if (spacing <= 0) continue;
                if (isRightAligned) {
                    area.setAllocatedPosition(spacing + area.getAllocatedX(), area.getAllocatedY());
                    continue;
                }
                if (!IStyle.CENTER_VALUE.equals(align)) continue;
                area.setAllocatedPosition(spacing / 2 + area.getAllocatedX(), area.getAllocatedY());
            }
        }
    }

    public void reset(TableArea table) {
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (!table.contains(row.getArea())) continue;
            iter.remove();
        }
        this.rows.resetCursor();
    }

    public int resolveAll() {
        int originalRowHeight;
        if (this.rows.size() == 0) {
            return 0;
        }
        Row row = (Row)this.rows.getCurrent();
        int height = originalRowHeight = row.getArea().getHeight();
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null) {
                if (cell instanceof DummyCell) {
                    DummyCell dummyCell = (DummyCell)cell;
                    int delta = dummyCell.getDelta();
                    height = Math.max(height, delta);
                } else {
                    height = Math.max(height, cell.getHeight());
                }
                i = i + cell.getColSpan() - 1;
            }
            ++i;
        }
        int dValue = height - originalRowHeight;
        int i2 = this.startCol;
        while (i2 <= this.endCol) {
            CellArea cell = row.getCell(i2);
            if (cell != null) {
                if (cell instanceof DummyCell) {
                    if (cell.getRowSpan() == 1) {
                        if (dValue != 0) {
                            CellArea refCell = ((DummyCell)cell).getCell();
                            refCell.setHeight(refCell.getHeight() + height - originalRowHeight);
                            this.verticalAlign(refCell);
                        }
                    } else {
                        CellArea refCell = ((DummyCell)cell).getCell();
                        int delta = ((DummyCell)cell).getDelta();
                        if (delta < height) {
                            refCell.setHeight(refCell.getHeight() - delta + height);
                        }
                        this.verticalAlign(refCell);
                    }
                } else if (dValue != 0) {
                    cell.setHeight(height);
                    this.verticalAlign(cell);
                }
                i2 = i2 + cell.getColSpan() - 1;
            }
            ++i2;
        }
        row.getArea().setHeight(height);
        return dValue;
    }

    public int resolveBottomBorder() {
        CellArea cell;
        if (this.rows.size() == 0) {
            return 0;
        }
        Row row = (Row)this.rows.getCurrent();
        int result = 0;
        int width = 0;
        int i = this.startCol;
        while (i <= this.endCol) {
            cell = row.getCell(i);
            if (cell != null) {
                width = cell instanceof DummyCell ? this.resolveBottomBorder(((DummyCell)cell).getCell()) : this.resolveBottomBorder(cell);
                if (width > result) {
                    result = width;
                }
                i = i + cell.getColSpan() - 1;
            }
            ++i;
        }
        if (result > 0) {
            row.getArea().setHeight(row.getArea().getHeight() + result);
            i = this.startCol;
            while (i <= this.endCol) {
                cell = row.getCell(i);
                if (cell instanceof DummyCell) {
                    CellArea refCell = ((DummyCell)cell).getCell();
                    refCell.setHeight(refCell.getHeight() + result);
                } else {
                    cell.setHeight(cell.getHeight() + result);
                }
                i = i + cell.getColSpan() - 1;
                ++i;
            }
        }
        return result;
    }

    public void addRows(CursorableList rs) {
        Iterator iter = rs.iterator();
        while (iter.hasNext()) {
            this.rows.add(iter.next());
        }
    }

    public void addRow(RowArea rowArea, int specifiedHeight) {
        Row row = this.updateRow(rowArea, specifiedHeight);
        this.rows.add(row);
    }

    private Row updateRow(RowArea rowArea, int specifiedHeight) {
        int height = specifiedHeight;
        Row lastRow = (Row)this.rows.getCurrent();
        Row row = new Row(rowArea, this.startCol, this.endCol);
        boolean usedResolvedRow = false;
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea upperCell = null;
            if (lastRow != null) {
                upperCell = lastRow.getCell(i);
            }
            if (upperCell != null && upperCell.getRowSpan() > 1) {
                DummyCell dummyCell = this.createDummyCell(upperCell);
                row.addArea(dummyCell);
                int delta = dummyCell.getDelta();
                if (dummyCell.getRowSpan() == 1) {
                    height = Math.max(height, delta);
                }
                i = i + upperCell.getColSpan() - 1;
            } else {
                CellArea cell = row.getCell(i);
                if (cell == null) {
                    if (this.unresolvedRow != null) {
                        upperCell = this.unresolvedRow.getCell(i);
                        usedResolvedRow = true;
                    }
                    cell = this.createEmptyCell(upperCell, i, row, lastRow);
                }
                if (cell.getRowSpan() == 1) {
                    height = Math.max(height, cell.getHeight());
                }
                i = i + cell.getColSpan() - 1;
            }
            ++i;
        }
        if (usedResolvedRow) {
            this.unresolvedRow = null;
        }
        this.updateRowHeight(row, height);
        return row;
    }

    private DummyCell createDummyCell(CellArea upperCell) {
        DummyCell dummyCell = null;
        CellArea refCell = null;
        Row lastRow = (Row)this.rows.getCurrent();
        int lastRowHeight = lastRow.getArea().getHeight();
        int delta = 0;
        if (upperCell instanceof DummyCell) {
            refCell = ((DummyCell)upperCell).getCell();
            dummyCell = new DummyCell(refCell);
            delta = ((DummyCell)upperCell).getDelta() - lastRowHeight;
            dummyCell.setDelta(delta);
        } else {
            refCell = upperCell;
            dummyCell = new DummyCell(upperCell);
            delta = refCell.getHeight() - lastRowHeight;
            dummyCell.setDelta(delta);
        }
        dummyCell.setRowSpan(upperCell.getRowSpan() - 1);
        dummyCell.setColSpan(upperCell.getColSpan());
        return dummyCell;
    }

    private CellArea createEmptyCell(CellArea upperCell, int columnId, Row row, Row lastRow) {
        ICellContent cellContent = null;
        int rowSpan = 1;
        if (upperCell != null) {
            cellContent = (ICellContent)upperCell.getContent();
            rowSpan = upperCell.getRowSpan();
        }
        if (cellContent == null) {
            cellContent = this.tableContent.getReportContent().createCellContent();
            cellContent.setColumn(columnId);
            cellContent.setColSpan(1);
            cellContent.setRowSpan(1);
            cellContent.setParent(row.getArea().getContent());
        }
        int emptyCellColID = cellContent.getColumn();
        int emptyCellColSpan = cellContent.getColSpan();
        CellArea emptyCell = AreaFactory.createCellArea(cellContent);
        emptyCell.setRowSpan(rowSpan);
        row.addArea(emptyCell);
        CellArea leftSideCellArea = null;
        if (emptyCellColID > this.startCol) {
            leftSideCellArea = row.getCell(emptyCellColID - 1);
            if (leftSideCellArea == null) {
                this.cellCache[0] = (ICellContent)lastRow.getCell(emptyCellColID - 1).getContent();
                int k = emptyCellColID - 1;
                while (leftSideCellArea == null && k > this.startCol) {
                    leftSideCellArea = row.getCell(--k);
                }
            } else {
                this.cellCache[0] = (ICellContent)leftSideCellArea.getContent();
            }
        } else {
            leftSideCellArea = null;
        }
        this.resolveBorderConflict(emptyCell, true);
        IStyle areaStyle = emptyCell.getStyle();
        areaStyle.setProperty(6, IStyle.NUMBER_0);
        areaStyle.setProperty(19, IStyle.NUMBER_0);
        emptyCell.setWidth(this.getCellWidth(emptyCellColID, emptyCellColID + emptyCellColSpan));
        emptyCell.setPosition(this.layoutInfo.getXPosition(columnId), 0);
        if (leftSideCellArea != null) {
            int index = row.getArea().indexOf(leftSideCellArea);
            row.getArea().addChild(index + 1, emptyCell);
        } else {
            row.getArea().addChild(0, emptyCell);
        }
        return emptyCell;
    }

    private void updateRowHeight(Row row, int height) {
        if (height < 0) {
            return;
        }
        row.getArea().setHeight(height);
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell.getRowSpan() == 1) {
                if (cell instanceof DummyCell) {
                    CellArea refCell = ((DummyCell)cell).getCell();
                    int delta = ((DummyCell)cell).getDelta();
                    if (delta < height) {
                        refCell.setHeight(refCell.getHeight() - delta + height);
                    }
                    ((DummyCell)cell).setDelta(0);
                    this.verticalAlign(refCell);
                } else {
                    cell.setHeight(height);
                    this.verticalAlign(cell);
                }
            }
            i = i + cell.getColSpan() - 1;
            ++i;
        }
    }

    private int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    public CursorableList getRows() {
        return this.rows;
    }

    public static class Row {
        protected int start;
        protected int length;
        protected int end;
        protected RowArea row;
        protected CellArea[] cells;

        Row(RowArea row, int start, int end) {
            this.row = row;
            this.start = start;
            this.end = end;
            this.length = end - start + 1;
            this.cells = new CellArea[this.length];
            Iterator iter = row.getChildren();
            while (iter.hasNext()) {
                CellArea cell = (CellArea)iter.next();
                int colId = cell.getColumnID();
                int colSpan = cell.getColSpan();
                if (colId < start || colId + colSpan - 1 > end) continue;
                int loopEnd = Math.min(colSpan, end - colId + 1);
                int j = 0;
                while (j < loopEnd) {
                    this.cells[colId - start + j] = cell;
                    ++j;
                }
            }
        }

        public IContent getContent() {
            return this.row.getContent();
        }

        public void remove(int colId) {
            this.row.removeChild(this.getCell(colId));
        }

        public void remove(IArea area) {
            if (area != null) {
                if (!(area instanceof DummyCell)) {
                    this.row.removeChild(area);
                }
                CellArea cell = (CellArea)area;
                int colId = cell.getColumnID();
                int colSpan = cell.getColSpan();
                if (colId >= this.start && colId + colSpan - 1 <= this.end) {
                    int loopEnd = Math.min(colSpan, this.end - colId + 1);
                    int j = 0;
                    while (j < loopEnd) {
                        this.cells[colId - this.start + j] = null;
                        ++j;
                    }
                }
            }
        }

        public CellArea getCell(int colId) {
            if (colId < this.start || colId > this.end) {
                assert (false);
                return null;
            }
            return this.cells[colId - this.start];
        }

        public void addArea(IArea area) {
            CellArea cell = (CellArea)area;
            int colId = cell.getColumnID();
            int colSpan = cell.getColSpan();
            if (colId >= this.start && colId + colSpan - 1 <= this.end) {
                int loopEnd = Math.min(colSpan, this.end - colId + 1);
                int j = 0;
                while (j < loopEnd) {
                    this.cells[colId - this.start + j] = cell;
                    ++j;
                }
            }
        }

        public RowArea getArea() {
            return this.row;
        }
    }
}

