/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectFacetAliasesExtensionPoint {
    public static final String EXTENSION_POINT_ID = "aliases";
    private static final String EL_FACET_ALIAS = "facet-alias";
    private static final String EL_FACET_VERSION_ALIAS = "facet-version-alias";
    private static final String ATTR_ALIAS = "alias";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_VERSION = "version";
    private static Map<String, Set<String>> facetAliases = null;
    private static Map<String, Map<String, Set<String>>> facetVersionAliases = null;

    public static Set<String> getAliases(IProjectFacet f) {
        ProjectFacetAliasesExtensionPoint.readExtensions();
        Set<String> aliases = facetAliases.get(f.getId());
        if (aliases != null) {
            return aliases;
        }
        return Collections.emptySet();
    }

    public static Set<String> getAliases(IProjectFacetVersion fv) {
        Set<String> aliases;
        ProjectFacetAliasesExtensionPoint.readExtensions();
        Map<String, Set<String>> versionToAliasesMap = facetVersionAliases.get(fv.getProjectFacet().getId());
        if (versionToAliasesMap != null && (aliases = versionToAliasesMap.get(fv.getVersionString())) != null) {
            return aliases;
        }
        return Collections.emptySet();
    }

    private static synchronized void readExtensions() {
        if (facetAliases != null) {
            return;
        }
        facetAliases = new HashMap<String, Set<String>>();
        facetVersionAliases = new HashMap<String, Map<String, Set<String>>>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", EXTENSION_POINT_ID))) {
            String elname = element.getName();
            try {
                Set<String> aliases;
                if (!elname.equals(EL_FACET_ALIAS) && !elname.equals(EL_FACET_VERSION_ALIAS)) continue;
                String fid = PluginUtil.findRequiredAttribute(element, ATTR_FACET);
                String alias = PluginUtil.findRequiredAttribute(element, ATTR_ALIAS);
                if (elname.equals(EL_FACET_ALIAS)) {
                    Set<String> aliases2 = facetAliases.get(fid);
                    if (aliases2 == null) {
                        aliases2 = new HashSet<String>();
                        facetAliases.put(fid, aliases2);
                    }
                    aliases2.add(alias);
                    continue;
                }
                String fvstr = PluginUtil.findRequiredAttribute(element, ATTR_VERSION);
                Map<String, Set<String>> versionToAliasesMap = facetVersionAliases.get(fid);
                if (versionToAliasesMap == null) {
                    versionToAliasesMap = new HashMap<String, Set<String>>();
                    facetVersionAliases.put(fid, versionToAliasesMap);
                }
                if ((aliases = versionToAliasesMap.get(fvstr)) == null) {
                    aliases = new HashSet<String>();
                    versionToAliasesMap.put(fvstr, aliases);
                }
                aliases.add(alias);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }
}

