/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.internal.datafeed.GroupingUtil;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.util.CDateTime;

public class SeriesNameFormat {
    public static final SeriesNameFormat DEFAULT_FORMAT = new SeriesNameFormat();

    private SeriesNameFormat() {
    }

    public static SeriesNameFormat getSeriesNameFormat(SeriesDefinition sd, ULocale loc) {
        return SeriesNameFormat.getSeriesNameFormat(sd, loc, true);
    }

    public static SeriesNameFormat getSeriesNameFormat(SeriesDefinition sd, ULocale loc, boolean keepHierarchy) {
        SeriesGrouping sg;
        if (sd != null && sd.getQuery() != null && sd.getQuery().getGrouping() != null && (sg = sd.getQuery().getGrouping()).getGroupType() == DataType.DATE_TIME_LITERAL) {
            return new SeriesNameDateFormat(sg.getGroupingUnit(), loc, keepHierarchy);
        }
        return DEFAULT_FORMAT;
    }

    public String format(Object obj) {
        String str = "";
        if (obj != null) {
            if (obj instanceof Number) {
                double d = ((Number)obj).doubleValue();
                String sPattern = ValueFormatter.getNumericPattern(d);
                DecimalFormat df = new DecimalFormat(sPattern);
                str = df.format(d);
            } else {
                str = obj.toString();
            }
        }
        return str;
    }

    /* synthetic */ SeriesNameFormat(SeriesNameFormat seriesNameFormat) {
        this();
    }

    private static class SeriesNameDateFormat
    extends SeriesNameFormat {
        private GroupingUnitType unitType;
        private IDateFormatWrapper dfWrapper;

        public SeriesNameDateFormat(GroupingUnitType unitType, ULocale loc, boolean keepHierarchy) {
            super(null);
            this.unitType = unitType;
            this.dfWrapper = DateFormatWrapperFactory.getPreferredDateFormat(GroupingUtil.groupingUnit2CDateUnit(unitType), loc, keepHierarchy);
        }

        private static int groupingUnit2CDateUnit(GroupingUnitType groupingUnitType) {
            if (groupingUnitType != null) {
                switch (groupingUnitType.getValue()) {
                    case 0: {
                        return 13;
                    }
                    case 1: {
                        return 12;
                    }
                    case 2: {
                        return 11;
                    }
                    case 3: {
                        return 5;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                    case 7: {
                        return 1;
                    }
                    case 6: {
                        return 6;
                    }
                }
            }
            return 14;
        }

        public String format(Object obj) {
            if (obj instanceof CDateTime) {
                return this.formatCDateTime((CDateTime)((Object)obj));
            }
            return super.format(obj);
        }

        private String formatCDateTime(CDateTime cd) {
            cd.clearBelow(SeriesNameDateFormat.groupingUnit2CDateUnit(this.unitType));
            return this.dfWrapper.format(cd.getTime());
        }
    }
}

