/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.ui.swt.interfaces.IImageServiceProvider;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.BirtImageLoader;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class ChartImageServiceProvider
implements IImageServiceProvider {
    private ExtendedItemHandle extendedHandle = null;

    public ChartImageServiceProvider(Object extendedHandle) {
        try {
            this.extendedHandle = (ExtendedItemHandle)extendedHandle;
        }
        catch (Exception exception) {
            this.extendedHandle = null;
        }
    }

    public List<String> getEmbeddedImageName() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.extendedHandle == null) {
            return list;
        }
        for (EmbeddedImageHandle handle : this.extendedHandle.getModuleHandle().getVisibleImages()) {
            list.add(handle.getQualifiedName());
        }
        return list;
    }

    public String saveImage(String fullPath, String fileName) throws ChartException {
        BirtImageLoader imageLoader = new BirtImageLoader();
        try {
            EmbeddedImage image = imageLoader.save(this.extendedHandle.getModuleHandle(), fullPath, fileName);
            return image.getName();
        }
        catch (Exception e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 4, (Throwable)e);
        }
    }

    public org.eclipse.swt.graphics.Image getEmbeddedImage(String fileName) {
        if (this.extendedHandle == null) {
            return null;
        }
        return ImageManager.getInstance().getEmbeddedImage(this.extendedHandle.getModuleHandle(), fileName);
    }

    public org.eclipse.swt.graphics.Image loadImage(String fileName) throws ChartException {
        try {
            return ImageManager.getInstance().loadImage(fileName);
        }
        catch (IOException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 4, (Throwable)e);
        }
    }

    public String getImageAbsoluteURL(Image image) {
        if (this.extendedHandle == null) {
            return null;
        }
        return ChartItemUtil.getImageAbsoluteURL((Image)image, (ExtendedItemHandle)this.extendedHandle);
    }
}

