/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.impl.EmbeddedImageImpl;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.IconCanvas;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MarkerIconDialog
extends TrayDialog
implements SelectionListener,
ModifyListener {
    protected transient Button btnURL;
    protected transient Button btnLocal;
    private transient Button btnPreview;
    private Composite inputArea;
    private IconCanvas previewCanvas;
    private transient Button btnBrowse;
    private static final int URI_TYPE = 0;
    private static final int LOCAL_TYPE = 1;
    private static final int EMBEDDED_TYPE = 2;
    private int selectedType = -1;
    private Text uriEditor;
    private transient Fill icon = null;
    protected Button btnEmbeddedImage;
    private boolean validateURL = false;
    private Label lblException;
    protected ChartWizardContext context;

    public MarkerIconDialog(Shell parent, Fill fill, ChartWizardContext context) {
        super(parent);
        if (fill != null) {
            this.icon = fill.copyInstance();
        }
        this.context = context;
    }

    protected Control createContents(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.MarkerIcon_ID");
        this.getShell().setText(Messages.getString("MarkerIconDialog.Title.MarkerIconSelector"));
        Control c = super.createContents(parent);
        if (this.btnEmbeddedImage != null && this.icon instanceof EmbeddedImage) {
            this.btnEmbeddedImage.setSelection(true);
            this.switchTo(2);
        } else if (this.icon instanceof Image) {
            try {
                if (this.btnLocal != null && "file".equals(new URL(((Image)this.icon).getURL()).getProtocol())) {
                    this.btnLocal.setSelection(true);
                    this.switchTo(1);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        c.pack();
        this.preview();
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size.x, size.y);
        UIHelper.centerOnScreen((Shell)this.getShell());
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmpContent = new Composite(parent, 0);
        cmpContent.setLayout((Layout)new GridLayout());
        this.createSelectionArea(cmpContent);
        new Label(cmpContent, 258).setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(cmpContent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createListArea(composite);
        this.createPreviewArea(composite);
        new Label(cmpContent, 258).setLayoutData((Object)new GridData(768));
        return cmpContent;
    }

    protected Control createButtonBar(Composite parent) {
        Control cmp = super.createButtonBar(parent);
        this.updateButton();
        return cmp;
    }

    protected void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("MarkerIconDialog.Lbl.SelectIconFrom"));
        label.setLayoutData((Object)new GridData(2));
        Composite selectionArea = new Composite(composite, 0);
        selectionArea.setLayout((Layout)new FillLayout(512));
        this.btnURL = new Button(selectionArea, 16);
        this.btnURL.setText(Messages.getString("MarkerIconDialog.Lbl.URL"));
        this.btnURL.addSelectionListener((SelectionListener)this);
        this.btnLocal = new Button(selectionArea, 16);
        this.btnLocal.setText(Messages.getString("MarkerIconDialog.Lbl.Local"));
        this.btnLocal.addSelectionListener((SelectionListener)this);
        this.btnEmbeddedImage = new Button(selectionArea, 16);
        this.btnEmbeddedImage.setText(Messages.getString("MarkerIconDialog.Button.EmbeddedImage"));
        this.btnEmbeddedImage.addSelectionListener((SelectionListener)this);
    }

    private void createListArea(Composite parent) {
        Composite listArea = new Composite(parent, 0);
        GridData gd = new GridData(1840);
        gd.widthHint = 300;
        gd.heightHint = 260;
        listArea.setLayoutData((Object)gd);
        listArea.setLayout((Layout)new GridLayout());
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.inputArea = new Composite(listArea, 0);
        GridData gdInputArea = new GridData(1840);
        this.inputArea.setLayoutData((Object)gdInputArea);
        this.inputArea.setLayout((Layout)gl);
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 260;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new IconCanvas(previewArea);
    }

    private void switchTo(int type) {
        if (type == this.selectedType) {
            return;
        }
        this.selectedType = type;
        Control[] controls = this.inputArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        switch (type) {
            case 0: {
                this.swtichToURIType();
                break;
            }
            case 1: {
                this.swtichToLocalType();
                break;
            }
            case 2: {
                this.switchToEmbeddedType();
            }
        }
        this.inputArea.layout();
        this.updateButton();
    }

    private void swtichToURIType() {
        Label title = new Label(this.inputArea, 0);
        title.setLayoutData((Object)new GridData(2));
        title.setText(Messages.getString("MarkerIconDialog.Lbl.EnterURL"));
        this.uriEditor = new Text(this.inputArea, 2052);
        this.uriEditor.setLayoutData((Object)new GridData(768));
        this.uriEditor.addModifyListener((ModifyListener)this);
        Composite innerComp = new Composite(this.inputArea, 0);
        innerComp.setLayoutData((Object)new GridData(128));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 2;
        innerComp.setLayout((Layout)gl);
        this.btnPreview = new Button(innerComp, 8);
        this.btnPreview.setText(Messages.getString("MarkerIconDialog.Lbl.Preview"));
        this.btnPreview.setLayoutData((Object)new GridData(128));
        this.btnPreview.setEnabled(false);
        this.btnPreview.addSelectionListener((SelectionListener)this);
        if (this.icon != null) {
            String url = ((Image)this.icon).getURL();
            this.uriEditor.setText(url == null ? "" : url);
        }
    }

    private void swtichToLocalType() {
        Composite buttonBar = new Composite(this.inputArea, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonBar.setLayoutData((Object)new GridData(768));
        buttonBar.setLayout((Layout)gl);
        Label description = new Label(buttonBar, 64);
        description.setLayoutData((Object)new GridData(800));
        description.setText(Messages.getString("MarkerIconDialog.Lbl.Description"));
        this.btnBrowse = new Button(buttonBar, 8);
        this.btnBrowse.setText(Messages.getString("MarkerIconDialog.Lbl.Browse"));
        GridData gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        this.btnBrowse.setLayoutData((Object)gd);
        this.btnBrowse.addSelectionListener((SelectionListener)this);
    }

    private void switchToEmbeddedType() {
        Composite buttonBar = new Composite(this.inputArea, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonBar.setLayoutData((Object)new GridData(768));
        buttonBar.setLayout((Layout)gl);
        Label description = new Label(buttonBar, 0);
        description.setLayoutData((Object)new GridData(32));
        description.setText(Messages.getString("MarkerIconDialog.Label.Description.EmbeddedImage"));
        this.btnBrowse = new Button(buttonBar, 8);
        this.btnBrowse.setText(Messages.getString("MarkerIconDialog.Lbl.Browse"));
        GridData gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        this.btnBrowse.setLayoutData((Object)gd);
        this.btnBrowse.addSelectionListener((SelectionListener)this);
    }

    private void updateButton() {
        this.getButtonOk().setEnabled((this.selectedType == 1 || this.selectedType == 2) && this.icon != null && ((Image)this.icon).getURL() != null || this.selectedType == 0 && this.validateURL);
    }

    private Button getButtonOk() {
        return this.getButton(0);
    }

    private void preview(String uri) {
        try {
            URL url = new URL(uri);
            url.getContent();
            if (this.previewCanvas.loadImage(url) != null) {
                this.validateURL = true;
                if (this.lblException != null && !this.lblException.isDisposed()) {
                    this.lblException.setText("");
                }
            }
        }
        catch (Exception exception) {
            this.getButtonOk().setEnabled(false);
            this.validateURL = false;
            if (this.lblException == null || this.lblException.isDisposed()) {
                this.lblException = new Label(this.inputArea, 0);
                this.lblException.setLayoutData((Object)new GridData());
                this.lblException.setForeground(Display.getDefault().getSystemColor(3));
            }
            this.lblException.setText(Messages.getString("MarkerIconDialog.Exception.InvalidURL"));
            this.inputArea.layout();
        }
    }

    private void preview() {
        if (this.icon == null) {
            return;
        }
        if (this.icon instanceof EmbeddedImage) {
            try {
                byte[] data = Base64.decodeBase64((byte[])((EmbeddedImage)this.icon).getData().getBytes());
                this.getButtonOk().setEnabled(true);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                BufferedInputStream bis = new BufferedInputStream(bais);
                this.previewCanvas.loadImage(bis);
                bis.close();
            }
            catch (Exception e) {
                this.getButtonOk().setEnabled(false);
                WizardBase.displayException((Throwable)e);
            }
        } else if (this.icon instanceof Image) {
            this.preview(((Image)this.icon).getURL());
        }
    }

    private void checkIcon() {
        if (this.selectedType == 0 && (this.icon == null || ((Image)this.icon).getURL() != null && !((Image)this.icon).getURL().equals(MarkerIconDialog.trimString(this.uriEditor.getText())))) {
            this.icon = ImageImpl.create((String)MarkerIconDialog.trimString(this.uriEditor.getText()));
        }
    }

    protected void okPressed() {
        this.checkIcon();
        super.okPressed();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(this.btnURL)) {
            this.switchTo(0);
            if (this.icon instanceof EmbeddedImage) {
                this.previewCanvas.clear();
                this.icon = null;
            }
        } else if (e.widget.equals(this.btnLocal)) {
            this.switchTo(1);
            if (this.icon instanceof EmbeddedImage) {
                this.previewCanvas.clear();
                this.icon = null;
            }
        } else if (e.widget.equals(this.btnEmbeddedImage)) {
            boolean modified = this.selectedType != 2;
            this.switchTo(2);
            if (modified && this.icon instanceof EmbeddedImage) {
                try {
                    this.preview();
                }
                catch (Exception ex) {
                    WizardBase.displayException((Throwable)ex);
                }
            } else {
                this.previewCanvas.clear();
                this.icon = null;
            }
        } else if (e.widget.equals(this.btnPreview)) {
            this.uriEditor.setText(this.uriEditor.getText().trim());
            String path = this.uriEditor.getText();
            this.preview(path);
        } else if (e.widget.equals(this.btnBrowse)) {
            FileDialog fileChooser = new FileDialog(this.getShell(), 4096);
            fileChooser.setText(Messages.getString("MarkerIconDialog.Chooser.Title"));
            fileChooser.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.png"});
            try {
                String path = fileChooser.open();
                if (path != null) {
                    path = new StringBuffer("file:///").append(path).toString();
                    this.preview(path);
                    if (this.selectedType == 2) {
                        this.setEmbeddedIcon(path);
                    } else {
                        this.icon = ImageImpl.create((String)path);
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        this.updateButton();
    }

    private void setEmbeddedIcon(String path) throws IOException, MalformedURLException {
        BufferedInputStream bis = new BufferedInputStream(new URL(path).openStream());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int count = bis.read(buf);
        while (count != -1) {
            bos.write(buf, 0, count);
            count = bis.read(buf);
        }
        if (bis != null) {
            bis.close();
        }
        String data = new String(Base64.encodeBase64((byte[])bos.toByteArray()));
        this.icon = EmbeddedImageImpl.create((String)path, (String)data);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals(this.uriEditor)) {
            this.btnPreview.setEnabled(MarkerIconDialog.trimString(this.uriEditor.getText()) != null);
            this.getButtonOk().setEnabled(false);
        }
    }

    private static String trimString(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public Fill getFill() {
        return this.icon;
    }
}

