/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPopupSheet;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPreviewable;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetBase;
import org.eclipse.birt.chart.ui.util.ChartUIConstants;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TreeCompoundTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtaskSheetImpl
extends SubtaskSheetBase<Chart, ChartWizardContext>
implements ShellListener,
ChartUIConstants,
ITaskPreviewable {
    private Shell popupShell;
    private ITaskPopupSheet popupSheet;
    private static boolean POPUP_ATTACHING = false;
    private Map<String, Button> popupButtonRegistry = new HashMap<String, Button>(6);
    private Map<String, ITaskPopupSheet> popupSheetRegistry = new HashMap<String, ITaskPopupSheet>(6);
    private Map<String, String> lastPopupRegistry = new HashMap<String, String>(3);

    @Override
    public Object onHide() {
        ChartWizard.POPUP_CLOSING_BY_USER = false;
        this.detachPopup();
        ChartWizard.POPUP_CLOSING_BY_USER = true;
        this.popupButtonRegistry.clear();
        this.popupSheetRegistry.clear();
        return super.onHide();
    }

    protected boolean detachPopup(Widget widget) {
        if (widget instanceof Button && this.popupShell != null && !this.popupShell.isDisposed() && !this.isButtonSelected()) {
            this.getWizard().detachPopup();
            this.popupShell = null;
            this.setCurrentPopupSelection(null);
            this.getParentTask().setPopupSelection(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean detachPopup() {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.getWizard().detachPopup();
            this.popupShell = null;
            return true;
        }
        return false;
    }

    protected Shell createPopupShell() {
        POPUP_ATTACHING = true;
        Shell shell = this.getWizard().createPopupContainer();
        shell.addShellListener((ShellListener)this);
        shell.setImage(UIHelper.getImage((String)"icons/obj16/chartbuilder.gif"));
        POPUP_ATTACHING = false;
        return shell;
    }

    protected final void selectAllButtons(boolean isSelected) {
        Iterator<Button> buttons = this.popupButtonRegistry.values().iterator();
        while (buttons.hasNext()) {
            buttons.next().setSelection(isSelected);
        }
    }

    protected boolean isButtonSelected() {
        Iterator<Button> buttons = this.popupButtonRegistry.values().iterator();
        while (buttons.hasNext()) {
            if (!buttons.next().getSelection()) continue;
            return true;
        }
        return false;
    }

    protected boolean isRegistered(Widget widget) {
        Iterator<Button> buttons = this.popupButtonRegistry.values().iterator();
        while (buttons.hasNext()) {
            if (!buttons.next().equals(widget)) continue;
            return true;
        }
        return false;
    }

    protected Collection<Button> getToggleButtons() {
        return this.popupButtonRegistry.values();
    }

    protected void refreshPopupSheet() {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupSheet.refreshComponent((Composite)this.popupShell);
        }
    }

    protected Button createToggleButton(Composite parent, String buttonId, String popupName, ITaskPopupSheet popupSheet, boolean bEnabled) {
        Button button = new Button(parent, 2);
        button.setText(popupName);
        GC gc = new GC((Drawable)parent);
        int width = Math.max(80, gc.textExtent((String)popupName).x + 14);
        gc.dispose();
        GridData gd = new GridData();
        gd.widthHint = width;
        button.setLayoutData((Object)gd);
        String id = String.valueOf(this.getNodePath()) + buttonId;
        button.setData((Object)buttonId);
        this.popupButtonRegistry.put(id, button);
        this.popupSheetRegistry.put(id, popupSheet);
        if (!((ChartWizardContext)this.getContext()).isEnabled(id)) {
            button.setEnabled(false);
        } else {
            button.setEnabled(bEnabled);
        }
        return button;
    }

    protected Button createToggleButton(Composite parent, String buttonId, String popupName, ITaskPopupSheet popupSheet) {
        return this.createToggleButton(parent, buttonId, popupName, popupSheet, true);
    }

    protected void updatePopupSheet(String buttonId, ITaskPopupSheet popupSheet) {
        String id = String.valueOf(this.getNodePath()) + buttonId;
        if (this.popupSheetRegistry.containsKey(id)) {
            this.popupSheetRegistry.put(id, popupSheet);
        }
    }

    protected Button getToggleButton(String buttonId) {
        Button button = this.popupButtonRegistry.get(buttonId);
        if (button == null) {
            button = this.popupButtonRegistry.get(String.valueOf(this.getNodePath()) + buttonId);
        }
        return button;
    }

    protected boolean getToggleButtonSelection(String buttonId) {
        Button button = this.popupButtonRegistry.get(buttonId);
        if (button == null) {
            button = this.popupButtonRegistry.get(String.valueOf(this.getNodePath()) + buttonId);
        }
        if (button != null) {
            return button.getSelection();
        }
        return false;
    }

    protected void setToggleButtonEnabled(String buttonId, boolean isEnabled) {
        String id = String.valueOf(this.getNodePath()) + buttonId;
        if (this.getToggleButton(id) == null) {
            return;
        }
        if (((ChartWizardContext)this.getContext()).isEnabled(id)) {
            this.getToggleButton(id).setEnabled(isEnabled);
        } else {
            this.getToggleButton(id).setEnabled(false);
        }
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellClosed(ShellEvent e) {
        Control focusControl = Display.getDefault().getFocusControl();
        if (focusControl instanceof Text) {
            focusControl.notifyListeners(16, null);
        }
        if (e.widget.equals(this.popupShell)) {
            if (!POPUP_ATTACHING) {
                this.selectAllButtons(false);
            }
            if (ChartWizard.POPUP_CLOSING_BY_USER) {
                this.setCurrentPopupSelection(null);
                this.getParentTask().setPopupSelection(null);
            }
        }
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    @Override
    public boolean attachPopup(String buttonId) {
        String id;
        boolean affectTaskSelection = true;
        String string = id = buttonId == null ? null : String.valueOf(this.getNodePath()) + buttonId;
        if (id == null || !this.popupSheetRegistry.containsKey(id)) {
            buttonId = this.getCurrentPopupSelection();
            id = buttonId == null ? null : String.valueOf(this.getNodePath()) + buttonId;
            affectTaskSelection = false;
        }
        if (buttonId == null) {
            return false;
        }
        this.detachPopup();
        if (this.popupSheetRegistry.containsKey(id) && this.getToggleButton(id).isEnabled()) {
            this.selectAllButtons(false);
            this.getToggleButton(id).setSelection(true);
            this.setCurrentPopupSelection(buttonId);
            if (affectTaskSelection) {
                this.getParentTask().setPopupSelection(buttonId);
            }
            this.popupShell = this.createPopupShell();
            this.popupSheet = this.popupSheetRegistry.get(id);
            this.popupSheet.getUI((Composite)this.popupShell);
            this.getWizard().attachPopup(this.popupSheet.getTitle(), -1, -1);
            return true;
        }
        return false;
    }

    private String getCurrentPopupSelection() {
        return this.lastPopupRegistry.get(((ChartWizardContext)this.getContext()).getWizardID());
    }

    private void setCurrentPopupSelection(String lastPopup) {
        this.lastPopupRegistry.put(((ChartWizardContext)this.getContext()).getWizardID(), lastPopup);
    }

    public boolean isPreviewable() {
        return false;
    }

    public ChartPreviewPainter createPreviewPainter() {
        return null;
    }

    public void doPreview() {
    }

    public Canvas getPreviewCanvas() {
        return null;
    }

    @Override
    public void setParentTask(ITask parentTask) {
        assert (parentTask instanceof TreeCompoundTask);
        super.setParentTask(parentTask);
    }

    protected TreeCompoundTask getParentTask() {
        return (TreeCompoundTask)super.getParentTask();
    }
}

