/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.PlotClientAreaSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartPlotSheetImpl
extends SubtaskSheetImpl
implements Listener,
SelectionListener {
    private ChartCheckbox btnIncludingVisible;
    protected ChartCheckbox btnWithinVisible;
    private FillChooserComposite cmbBlockColor;
    protected FillChooserComposite cmbClientAreaColor;
    protected Label lblVisibleWithin;

    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartPlot_ID");
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(768);
        cmpBasic.setLayoutData((Object)gd);
        int fillStyles = 27;
        this.createControlForAreaIncludingAxes(cmpBasic, fillStyles |= ((ChartWizardContext)this.getContext()).getUIFactory().supportAutoUI() ? 4 : fillStyles);
        this.createControlForAreaWithinAxes(cmpBasic, fillStyles);
        this.createButtonGroup(this.cmpContent);
    }

    protected void createControlForAreaIncludingAxes(Composite cmpBasic, int fillStyles) {
        Label lblIncludingAxes = new Label(cmpBasic, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        lblIncludingAxes.setLayoutData((Object)gd);
        lblIncludingAxes.setFont(JFaceResources.getBannerFont());
        lblIncludingAxes.setText(this.getChart() instanceof ChartWithAxes ? Messages.getString("ChartPlotSheetImpl.Label.AreaIncludingAxes") : Messages.getString("ChartPlotSheetImpl.Label.PlotArea"));
        new Label(cmpBasic, 0).setText(Messages.getString("ChartPlotSheetImpl.Label.Background"));
        this.cmbBlockColor = new FillChooserComposite(cmpBasic, 12, fillStyles, (ChartWizardContext)this.getContext(), ((Chart)this.getChart()).getPlot().getBackground());
        gd = new GridData();
        gd.widthHint = 200;
        this.cmbBlockColor.setLayoutData(gd);
        this.cmbBlockColor.addListener(this);
        new Label(cmpBasic, 0).setText(Messages.getString("ChartPlotSheetImpl.Label.Outline"));
        this.btnIncludingVisible = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBasic, 0, DefaultValueProvider.defChartWithAxes().getPlot().getOutline().isVisible());
        this.btnIncludingVisible.setText(Messages.getString("ChartPlotSheetImpl.Label.Visible"));
        this.btnIncludingVisible.setSelectionState(((Chart)this.getChart()).getPlot().getOutline().isSetVisible() ? (((Chart)this.getChart()).getPlot().getOutline().isVisible() ? 1 : 2) : 0);
        this.btnIncludingVisible.addSelectionListener((SelectionListener)this);
    }

    protected void createControlForAreaWithinAxes(Composite cmpBasic, int fillStyles) {
        Label lblWithinAxes = new Label(cmpBasic, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        lblWithinAxes.setLayoutData((Object)gd);
        lblWithinAxes.setFont(JFaceResources.getBannerFont());
        lblWithinAxes.setText(this.getChart() instanceof ChartWithAxes ? Messages.getString("ChartPlotSheetImpl.Label.AreaWithinAxes") : Messages.getString("ChartPlotSheetImpl.Label.ClientArea"));
        if (this.enableAreaWithinAxesUI()) {
            new Label(cmpBasic, 0).setText(Messages.getString("ChartPlotSheetImpl.Label.Background2"));
            this.cmbClientAreaColor = new FillChooserComposite(cmpBasic, 12, fillStyles, (ChartWizardContext)this.getContext(), ((Chart)this.getChart()).getPlot().getClientArea().getBackground());
            GridData gridData = new GridData();
            gridData.widthHint = 200;
            this.cmbClientAreaColor.setLayoutData(gridData);
            this.cmbClientAreaColor.addListener(this);
        }
        boolean is3DWallFloorSet = ChartUIUtil.is3DWallFloorSet((Chart)((Chart)this.getChart()));
        this.lblVisibleWithin = new Label(cmpBasic, 0);
        this.lblVisibleWithin.setText(Messages.getString("ChartPlotSheetImpl.Label.Outline"));
        this.lblVisibleWithin.setEnabled(is3DWallFloorSet);
        this.btnWithinVisible = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBasic, 0, DefaultValueProvider.defChartWithAxes().getPlot().getClientArea().getOutline().isVisible());
        this.btnWithinVisible.setText(Messages.getString("ChartPlotSheetImpl.Label.Visible2"));
        this.btnWithinVisible.setSelectionState(((Chart)this.getChart()).getPlot().getClientArea().getOutline().isSetVisible() ? (((Chart)this.getChart()).getPlot().getClientArea().getOutline().isVisible() ? 1 : 2) : 0);
        this.btnWithinVisible.setEnabled(is3DWallFloorSet);
        if (!this.btnWithinVisible.getEnabled()) {
            this.btnWithinVisible.setSelectionState(2);
        }
        this.btnWithinVisible.addSelectionListener((SelectionListener)this);
    }

    protected boolean enableAreaWithinAxesUI() {
        return !ChartUIUtil.is3DType((Chart)((Chart)this.getChart()));
    }

    protected void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        PlotClientAreaSheet popup = new PlotClientAreaSheet(Messages.getString("ChartPlotSheetImpl.Label.AreaFormat"), (ChartWizardContext)this.getContext());
        Button btnArea = this.createToggleButton(cmp, ".Area", Messages.getString("ChartPlotSheetImpl.Label.AreaFormat&"), popup);
        btnArea.addSelectionListener((SelectionListener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.cmbBlockColor)) {
            if (event.type == 1) {
                ((Chart)this.getChart()).getPlot().setBackground((Fill)event.data);
            }
        } else if (event.widget.equals((Object)this.cmbClientAreaColor) && event.type == 1) {
            ((Chart)this.getChart()).getPlot().getClientArea().setBackground((Fill)event.data);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.btnIncludingVisible)) {
            if (this.btnIncludingVisible.getSelectionState() == 0) {
                ((Chart)this.getChart()).getPlot().getOutline().unsetVisible();
            } else {
                ((Chart)this.getChart()).getPlot().getOutline().setVisible(((ChartCheckbox)e.widget).getSelectionState() == 1);
            }
            this.refreshPopupSheet();
        } else if (e.widget.equals(this.btnWithinVisible)) {
            if (this.btnWithinVisible.getSelectionState() == 0) {
                ((Chart)this.getChart()).getPlot().getClientArea().getOutline().unsetVisible();
            } else {
                ((Chart)this.getChart()).getPlot().getClientArea().getOutline().setVisible(((ChartCheckbox)e.widget).getSelectionState() == 1);
            }
            this.refreshPopupSheet();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

