/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.series;

import java.util.Collection;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesButtonEntry;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DecorationSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DialLabelSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DialScaleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DialTickSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.LineSeriesMarkerSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.NeedleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.PieTitleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesLabelSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesRegionSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesTrendlineSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SeriesYSheetImpl
extends SubtaskSheetImpl
implements Listener,
SelectionListener {
    private Button btnShowCurveLine;
    protected ChartCheckbox btnLabelVisible;
    private ChartCheckbox btnDecoVisible;

    public void createControl(Composite parent) {
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Group grpDetails = new Group(this.cmpContent, 0);
        GridData gdCMPDetails = new GridData(1808);
        gdCMPDetails.horizontalSpan = 2;
        grpDetails.setLayoutData((Object)gdCMPDetails);
        grpDetails.setLayout((Layout)new FillLayout());
        grpDetails.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDetails"));
        Series series = this.getCurrentDesignTimeSeries();
        Series defSeries = ChartDefaultValueUtil.getDefaultSeries((Series)series);
        this.getSeriesAttributeUI(series, (Composite)grpDetails);
        Composite cmpBottom = new Composite(this.cmpContent, 0);
        GridLayout glBottom = new GridLayout(4, false);
        cmpBottom.setLayout((Layout)glBottom);
        this.btnLabelVisible = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBottom, 0, false);
        Label l = null;
        Label defLabel = null;
        if (this.isMeterSeries()) {
            l = ((DialSeries)this.getCurrentDesignTimeSeries()).getDial().getLabel();
            defLabel = ((DialSeries)defSeries).getDial().getLabel();
        } else {
            l = this.getCurrentDesignTimeSeries().getLabel();
            defLabel = defSeries.getLabel();
        }
        this.btnLabelVisible.setDefaultSelection(defLabel.isVisible());
        this.btnLabelVisible.setSelectionState(l.isSetVisible() ? (l.isVisible() ? 1 : 2) : 0);
        this.btnLabelVisible.addSelectionListener((SelectionListener)this);
        if (this.isMeterSeries()) {
            this.btnLabelVisible.setText(Messages.getString("SeriesYSheetImpl.Label.ShowDialLabels"));
        } else {
            this.btnLabelVisible.setText(Messages.getString("SeriesYSheetImpl.Label.ShowLabels"));
        }
        if (this.isShowTaskLabelsAvailable()) {
            this.btnDecoVisible = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBottom, 0, false);
            l = ((GanttSeries)this.getCurrentDesignTimeSeries()).getDecorationLabel();
            this.btnDecoVisible.setDefaultSelection(((GanttSeries)defSeries).getDecorationLabel().isVisible());
            this.btnDecoVisible.setSelectionState(l.isSetVisible() ? (l.isVisible() ? 1 : 2) : 0);
            this.btnDecoVisible.addSelectionListener((SelectionListener)this);
            this.btnDecoVisible.setText(Messages.getString("SeriesYSheetImpl.Label.ShowDecoLabels"));
        }
        if (this.isTrendlineAvailable()) {
            this.btnShowCurveLine = new Button(cmpBottom, 32);
            GridData gd2 = new GridData();
            gd2.horizontalSpan = 2;
            this.btnShowCurveLine.setText(Messages.getString("SeriesYSheetImpl.Label.ShowTrendline"));
            this.btnShowCurveLine.addSelectionListener((SelectionListener)this);
            this.btnShowCurveLine.setSelection(this.getCurrentDesignTimeSeries().getCurveFitting() != null);
        }
        this.createButtonGroup(this.cmpContent);
    }

    protected boolean isShowTaskLabelsAvailable() {
        return this.isGanttSeries();
    }

    protected void createButtonGroup(Composite parent) {
        AbstractPopupSheet popup;
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        Series series = this.getCurrentDesignTimeSeries();
        if (this.isMeterSeries()) {
            this.createDialLabelBtnUI(cmp);
            if (this.needDialNeedle()) {
                popup = new NeedleSheet(Messages.getString("SeriesYSheetImpl.Label.Needles"), (ChartWizardContext)this.getContext(), this.getCurrentDesignTimeSeries());
                Button btnNeedles = this.createToggleButton(cmp, ".Needles", Messages.getString("SeriesYSheetImpl.Label.Needles&"), popup);
                btnNeedles.addSelectionListener((SelectionListener)this);
            }
            popup = new SeriesRegionSheet(Messages.getString("SeriesYSheetImpl.Label.Region"), (ChartWizardContext)this.getContext(), this.getCurrentDesignTimeSeries());
            Button btnDialRegion = this.createToggleButton(cmp, ".Regions", Messages.getString("SeriesYSheetImpl.Label.Region&"), popup);
            btnDialRegion.addSelectionListener((SelectionListener)this);
            popup = new DialTickSheet(Messages.getString("DialTicksDialog.Title.DialTicks"), (ChartWizardContext)this.getContext(), (DialSeries)this.getCurrentDesignTimeSeries());
            Button btnDialTicks = this.createToggleButton(cmp, ".Ticks", Messages.getString("MeterSeriesAttributeComposite.Lbl.DialTicks"), popup);
            btnDialTicks.addSelectionListener((SelectionListener)this);
            popup = new DialScaleSheet(Messages.getString("DialScaleDialog.Title.DialScale"), (ChartWizardContext)this.getContext(), (DialSeries)this.getCurrentDesignTimeSeries());
            Button btnDialScale = this.createToggleButton(cmp, ".Scale", Messages.getString("MeterSeriesAttributeComposite.Lbl.DialScale"), popup);
            btnDialScale.addSelectionListener((SelectionListener)this);
        } else {
            this.createSeriesLabelBtnUI(cmp);
        }
        this.createSeriesSpecificButton(cmp);
        if (this.isMarkerAvailable()) {
            popup = new LineSeriesMarkerSheet(Messages.getString("SeriesYSheetImpl.Label.Markers"), (ChartWizardContext)this.getContext(), (LineSeries)this.getCurrentDesignTimeSeries());
            Button btnLineMarker = this.createToggleButton(cmp, ".Markers", Messages.getString("SeriesYSheetImpl.Label.Markers&"), popup);
            btnLineMarker.addSelectionListener((SelectionListener)this);
        }
        if (this.isTrendlineAvailable()) {
            popup = new SeriesTrendlineSheet(Messages.getString("SeriesYSheetImpl.Label.Trendline"), (ChartWizardContext)this.getContext(), this.getCurrentDesignTimeSeries());
            Button btnTrendline = this.createToggleButton(cmp, ".Curve", Messages.getString("SeriesYSheetImpl.Label.Trendline&"), popup, this.btnShowCurveLine.getSelection());
            btnTrendline.addSelectionListener((SelectionListener)this);
        }
        if (!(!((ChartWizardContext)this.getContext()).isInteractivityEnabled() || this.getChart() instanceof DialChart && ((DialChart)this.getChart()).isDialSuperimposition())) {
            popup = new InteractivitySheet(Messages.getString("SeriesYSheetImpl.Label.Interactivity"), (ChartWizardContext)this.getContext(), (EList<Trigger>)this.getCurrentDesignTimeSeries().getTriggers(), (EObject)this.getCurrentDesignTimeSeries(), 1, 33);
            Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, ((Chart)this.getChart()).getInteractivity().isEnable());
            btnInteractivity.addSelectionListener((SelectionListener)this);
        }
        SeriesDefinition sd = this.getSeriesDefinitionForProcessing();
        for (ISeriesButtonEntry buttonEntry : this.getSeriesUIProvider(series).getCustomButtons((ChartWizardContext)this.getContext(), sd)) {
            Button button = this.createToggleButton(cmp, buttonEntry.getButtonId(), buttonEntry.getPopupName(), buttonEntry.getPopupSheet(), buttonEntry.isEnabled());
            button.addSelectionListener((SelectionListener)this);
        }
    }

    protected void createPieSeriesButton(Composite cmp) {
        PieTitleSheet popup = new PieTitleSheet(Messages.getString("SeriesYSheetImpl.Label.Titles"), (ChartWizardContext)this.getContext(), this.getCurrentDesignTimeSeries());
        Button btnPieTitle = this.createToggleButton(cmp, ".Title", Messages.getString("SeriesYSheetImpl.Label.Titles&"), popup);
        btnPieTitle.addSelectionListener((SelectionListener)this);
    }

    protected void createDifferenceSeriesButton(Composite cmp) {
        LineSeriesMarkerSheet popup = new LineSeriesMarkerSheet(Messages.getString("SeriesYSheetImpl.Label.PositiveMarkers"), (ChartWizardContext)this.getContext(), (LineSeries)((DifferenceSeries)this.getCurrentDesignTimeSeries()), true);
        Button btnPLineMarker = this.createToggleButton(cmp, ".Positive", Messages.getString("SeriesYSheetImpl.Label.PositiveMarkers&"), popup);
        btnPLineMarker.addSelectionListener((SelectionListener)this);
        popup = new LineSeriesMarkerSheet(Messages.getString("SeriesYSheetImpl.Label.NegativeMarkers"), (ChartWizardContext)this.getContext(), (LineSeries)((DifferenceSeries)this.getCurrentDesignTimeSeries()), false);
        Button btnNLineMarker = this.createToggleButton(cmp, ".Negative", Messages.getString("SeriesYSheetImpl.Label.NegativeMarkers&"), popup);
        btnNLineMarker.addSelectionListener((SelectionListener)this);
    }

    protected void createGanttSeriesButton(Composite cmp) {
        DecorationSheet popup = new DecorationSheet(Messages.getString("SeriesYSheetImpl.Label.Decoration"), (ChartWizardContext)this.getContext(), (GanttSeries)this.getCurrentDesignTimeSeries());
        Button btnDecoration = this.createToggleButton(cmp, ".Decoration", Messages.getString("SeriesYSheetImpl.Label.Decoration&"), popup, ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnDecoVisible));
        btnDecoration.addSelectionListener((SelectionListener)this);
    }

    protected void createSeriesSpecificButton(Composite cmp) {
        if (this.isPieSeries()) {
            this.createPieSeriesButton(cmp);
        }
        if (this.isDifferenceSeries()) {
            this.createDifferenceSeriesButton(cmp);
        }
        if (this.isGanttSeries()) {
            this.createGanttSeriesButton(cmp);
        }
    }

    protected ISeriesUIProvider getSeriesUIProvider(Series series) {
        return ChartUIUtil.getSeriesUIProvider((Series)series);
    }

    protected boolean needDialNeedle() {
        return this.getChart() instanceof DialChart && !((DialChart)this.getChart()).isDialSuperimposition();
    }

    protected void createSeriesLabelBtnUI(Composite cmp) {
        SeriesLabelSheet popup = new SeriesLabelSheet(Messages.getString("SeriesYSheetImpl.Label.Labels"), (ChartWizardContext)this.getContext(), this.getCurrentDesignTimeSeries());
        Button btnLabel = this.createToggleButton(cmp, ".Label", Messages.getString("SeriesYSheetImpl.Label.Labels&"), popup, ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnLabelVisible));
        btnLabel.addSelectionListener((SelectionListener)this);
    }

    protected void createDialLabelBtnUI(Composite cmp) {
        DialLabelSheet popup = new DialLabelSheet(Messages.getString("SeriesYSheetImpl.Label.DialLabels"), (ChartWizardContext)this.getContext(), this.getCurrentDesignTimeSeries());
        Button btnDialLabel = this.createToggleButton(cmp, ".DialLables", Messages.getString("SeriesYSheetImpl.Label.DialLabels&"), popup, ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnLabelVisible));
        btnDialLabel.addSelectionListener((SelectionListener)this);
    }

    protected void getSeriesAttributeUI(Series series, Composite parent) {
        this.getSeriesUIProvider(series).getSeriesAttributeSheet(parent, series, (ChartWizardContext)this.getContext());
    }

    public void handleEvent(Event event) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.btnShowCurveLine)) {
            this.setToggleButtonEnabled(".Curve", this.btnShowCurveLine.getSelection());
            if (this.btnShowCurveLine.getSelection()) {
                CurveFitting cf = ChartUIExtensionUtil.createCurveFitting((ChartWizardContext)this.getContext());
                cf.eAdapters().addAll((Collection)this.getCurrentDesignTimeSeries().eAdapters());
                this.getCurrentDesignTimeSeries().setCurveFitting(cf);
            } else {
                this.getCurrentDesignTimeSeries().setCurveFitting(null);
                Button btnTrendline = this.getToggleButton(".Curve");
                if (btnTrendline.getSelection()) {
                    btnTrendline.setSelection(false);
                    this.detachPopup((Widget)btnTrendline);
                }
            }
        } else if (e.widget == this.btnLabelVisible) {
            boolean isAuto;
            boolean bl = isAuto = this.btnLabelVisible.getSelectionState() == 0;
            if (this.isMeterSeries()) {
                this.setToggleButtonEnabled(".DialLables", ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnLabelVisible));
                if (isAuto) {
                    ((DialSeries)this.getCurrentDesignTimeSeries()).getDial().getLabel().unsetVisible();
                } else {
                    ((DialSeries)this.getCurrentDesignTimeSeries()).getDial().getLabel().setVisible(this.btnLabelVisible.getSelectionState() == 1);
                }
                Button btnDialLabel = this.getToggleButton(".DialLables");
                if (this.btnLabelVisible.getSelectionState() != 1 && btnDialLabel.getSelection()) {
                    btnDialLabel.setSelection(false);
                    this.detachPopup((Widget)btnDialLabel);
                }
            } else {
                this.setToggleButtonEnabled(".Label", ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnLabelVisible));
                if (isAuto) {
                    this.getCurrentDesignTimeSeries().getLabel().unsetVisible();
                } else {
                    this.getCurrentDesignTimeSeries().getLabel().setVisible(this.btnLabelVisible.getSelectionState() == 1);
                }
            }
            this.refreshPopupSheet();
        } else if (e.widget == this.btnDecoVisible) {
            this.setToggleButtonEnabled(".Decoration", ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnDecoVisible));
            if (this.btnDecoVisible.getSelectionState() == 0) {
                ((GanttSeries)this.getCurrentDesignTimeSeries()).getDecorationLabel().unsetVisible();
            } else {
                ((GanttSeries)this.getCurrentDesignTimeSeries()).getDecorationLabel().setVisible(this.btnDecoVisible.getSelectionState() == 1);
            }
            Button btnDecoration = this.getToggleButton(".Decoration");
            if (this.btnDecoVisible.getSelectionState() != 1 && btnDecoration.getSelection()) {
                btnDecoration.setSelection(false);
                this.detachPopup((Widget)btnDecoration);
            } else {
                this.refreshPopupSheet();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected SeriesDefinition getSeriesDefinitionForProcessing() {
        SeriesDefinition sd = null;
        if (this.getChart() instanceof ChartWithAxes) {
            int iAxis = this.getParentAxisIndex(this.getIndex());
            int iAxisSeries = this.getSeriesIndexWithinAxis(this.getIndex());
            sd = (SeriesDefinition)((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(iAxis)).getSeriesDefinitions().get(iAxisSeries);
        } else if (this.getChart() instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.getChart()).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(this.getIndex());
        }
        return sd;
    }

    private int getParentAxisIndex(int iSeriesDefinitionIndex) {
        int iTmp = 0;
        int iAxisCount = ((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().size();
        int i = 0;
        while (i < iAxisCount) {
            if ((iTmp += ((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(i)).getSeriesDefinitions().size()) - 1 >= iSeriesDefinitionIndex) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getSeriesIndexWithinAxis(int iSeriesDefinitionIndex) {
        int iTotalDefinitions = 0;
        int iAxisCount = ((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().size();
        int i = 0;
        while (i < iAxisCount) {
            int iOldTotal = iTotalDefinitions;
            if ((iTotalDefinitions += ((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(i)).getSeriesDefinitions().size()) - 1 >= iSeriesDefinitionIndex) {
                return iSeriesDefinitionIndex - iOldTotal;
            }
            ++i;
        }
        return iSeriesDefinitionIndex;
    }

    protected boolean isTrendlineAvailable() {
        return this.getChart() instanceof ChartWithAxes && !this.isGanttSeries() && !this.isDifferenceSeries() && ((Chart)this.getChart()).getDimension() != ChartDimension.THREE_DIMENSIONAL_LITERAL && ((ChartWizardContext)this.getContext()).isEnabled("Series.Y Series.Curve");
    }

    protected boolean isMeterSeries() {
        return this.getCurrentDesignTimeSeries() instanceof DialSeries;
    }

    protected Series getCurrentDesignTimeSeries() {
        return this.getSeriesDefinitionForProcessing().getDesignTimeSeries();
    }

    protected boolean isGanttSeries() {
        return this.getCurrentDesignTimeSeries() instanceof GanttSeries;
    }

    protected boolean isDifferenceSeries() {
        return this.getCurrentDesignTimeSeries() instanceof DifferenceSeries;
    }

    protected boolean isPieSeries() {
        return this.getCurrentDesignTimeSeries() instanceof PieSeries;
    }

    protected boolean isMarkerAvailable() {
        return this.getCurrentDesignTimeSeries() instanceof LineSeries && !this.isDifferenceSeries();
    }
}

