/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.util;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.impl.AxisOriginImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainterBase;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartUIUtil {
    public static final String FONT_AUTO = Messages.getString("ChartUIUtil.Font.Auto");
    public static final String[] FONT_SIZES = new String[]{FONT_AUTO, "9", "10", "12", "14", "16", "18", "24", "36"};
    private static IDisplayServer swtDisplayServer = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/swt");
    private static HashMap<String, ISeriesUIProvider> htSeriesAttributeUIProviders = new HashMap();
    private static LinkedHashMap<String, IChartType> htTypes = null;
    public static final TreeMap<String, ULocale> LOCALE_TABLE;
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_WIDTH = 20;

    static {
        try {
            swtDisplayServer = PluginSettings.instance().getDisplayServer("ds.SWT");
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
        Collection<ISeriesUIProvider> cRegisteredEntries = ChartUIExtensionsImpl.instance().getSeriesUIComponents(ChartWizardContext.class.getSimpleName());
        for (ISeriesUIProvider provider : cRegisteredEntries) {
            String sSeries = provider.getSeriesClass();
            htSeriesAttributeUIProviders.put(sSeries, provider);
        }
        LOCALE_TABLE = new TreeMap(Collator.getInstance());
        ULocale[] locales = ULocale.getAvailableLocales();
        if (locales != null) {
            int i = 0;
            while (i < locales.length) {
                ULocale locale = locales[i];
                if (locale != null) {
                    LOCALE_TABLE.put(locale.getDisplayName(), locale);
                }
                ++i;
            }
        }
    }

    public static IDisplayServer getDisplayServer() {
        return swtDisplayServer;
    }

    public static void setBackgroundColor(Control control, boolean selected, Color color) {
        if (control != null && !control.isDisposed()) {
            if (selected) {
                control.setBackground(color);
            } else {
                control.setBackground(null);
            }
        }
    }

    public static Composite createCompositeWrapper(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmp.setLayout((Layout)gridLayout);
        return cmp;
    }

    public static Query getDataQuery(SeriesDefinition seriesDefn, int queryIndex) {
        return ChartUtil.getDataQuery((SeriesDefinition)seriesDefn, (int)queryIndex);
    }

    public static String getExpressionString(String colName) {
        return ExpressionUtil.createJSRowExpression((String)colName);
    }

    public static NumberFormat getDefaultNumberFormatInstance() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(100);
        return numberFormat;
    }

    public static EList<SeriesDefinition> getBaseSeriesDefinitions(Chart chart) {
        return ChartUtil.getBaseSeriesDefinitions((Chart)chart);
    }

    public static int getOrthogonalAxisNumber(Chart chart) {
        return ChartUtil.getOrthogonalAxisNumber((Chart)chart);
    }

    public static EList<SeriesDefinition> getOrthogonalSeriesDefinitions(Chart chart, int axisIndex) {
        return ChartUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)axisIndex);
    }

    public static List<SeriesDefinition> getAllOrthogonalSeriesDefinitions(Chart chart) {
        return ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)chart);
    }

    public static String getStockTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.StockExp.High");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.StockExp.Low");
            }
            case 2: {
                return Messages.getString("ChartUIUtil.StockExp.Open");
            }
            case 3: {
                return Messages.getString("ChartUIUtil.StockExp.Close");
            }
        }
        return "";
    }

    public static String getGanttTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.GanttExp.Start");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.GanttExp.End");
            }
            case 2: {
                return Messages.getString("ChartUIUtil.GanttExp.Label");
            }
        }
        return "";
    }

    public static String getBubbleTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.BubbleExp.Label");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.BubbleExp.Size");
            }
        }
        return "";
    }

    public static String getDifferenceTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.DifferenceExp.Postive");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.DifferenceExp.Negative");
            }
        }
        return "";
    }

    public static Axis getAxisXForProcessing(ChartWithAxes chartWithAxis) {
        return (Axis)chartWithAxis.getAxes().get(0);
    }

    public static Axis getAxisYForProcessing(ChartWithAxes chartWithAxis, int axisIndex) {
        return (Axis)ChartUIUtil.getAxisXForProcessing(chartWithAxis).getAssociatedAxes().get(axisIndex);
    }

    public static Axis getAxisZForProcessing(ChartWithAxes chartWithAxis) {
        return (Axis)ChartUIUtil.getAxisXForProcessing(chartWithAxis).getAncillaryAxes().get(0);
    }

    public static boolean is3DType(Chart chart) {
        return chart.getDimension().getValue() == 2;
    }

    public static int getFontRotation(FontDefinition font) {
        return font.isSetRotation() ? (int)font.getRotation() : 0;
    }

    public static String getFontName(FontDefinition font) {
        return font.getName() == null ? FONT_AUTO : font.getName();
    }

    public static TextAlignment getFontTextAlignment(FontDefinition font) {
        return font.getAlignment() == null ? TextAlignmentImpl.create() : font.getAlignment();
    }

    public static boolean checkDataBinding(Chart chart) {
        EList<SeriesDefinition> sdList = ChartUIUtil.getBaseSeriesDefinitions(chart);
        if (!ChartUIUtil.checkDataDefinition(sdList)) {
            return false;
        }
        int i = 0;
        while (i < ChartUIUtil.getOrthogonalAxisNumber(chart)) {
            sdList = ChartUIUtil.getOrthogonalSeriesDefinitions(chart, i);
            if (!ChartUIUtil.checkDataDefinition(sdList)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkDataDefinition(List<SeriesDefinition> sdList) {
        int i = 0;
        while (i < sdList.size()) {
            Series series = sdList.get(i).getDesignTimeSeries();
            EList ddList = series.getDataDefinition();
            if (ddList.size() == 0) {
                return false;
            }
            int[] validIndex = series.getDefinedDataDefinitionIndex();
            int j = 0;
            while (j < validIndex.length) {
                String query;
                int vi = validIndex[j];
                if (vi >= 0 && vi < ddList.size() && ((query = ((Query)ddList.get(vi)).getDefinition()) == null || query.length() == 0)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static void syncRuntimeSeries(Chart chart) {
        block15: {
            block14: {
                if (!(chart instanceof ChartWithAxes)) break block14;
                ChartWithAxes cwa = (ChartWithAxes)chart;
                Axis[] axa = cwa.getOrthogonalAxes(cwa.getPrimaryBaseAxes()[0], true);
                int iOrthogonalSeriesDefinitionCount = 0;
                int i = 0;
                while (i < axa.length) {
                    EList elSD = axa[i].getSeriesDefinitions();
                    int j = 0;
                    while (j < elSD.size()) {
                        String sExpression;
                        SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                        Query qy = sd.getQuery();
                        if (qy != null && (sExpression = qy.getDefinition()) != null && sExpression.length() != 0) {
                            ++iOrthogonalSeriesDefinitionCount;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < axa.length) {
                    for (SeriesDefinition sdOrthogonal : axa[i].getSeriesDefinitions()) {
                        Series seDesignOrthogonal = sdOrthogonal.getDesignTimeSeries();
                        List seRuntimes = sdOrthogonal.getRunTimeSeries();
                        sdOrthogonal.getSeries().removeAll((Collection)seRuntimes);
                        int j = 0;
                        while (j < seRuntimes.size()) {
                            Series seRuntimeOrthogonal = seDesignOrthogonal.copyInstance();
                            seRuntimeOrthogonal.setDataSet(((Series)seRuntimes.get(j)).getDataSet());
                            if (iOrthogonalSeriesDefinitionCount < 1) {
                                seRuntimeOrthogonal.setSeriesIdentifier(seDesignOrthogonal.getSeriesIdentifier());
                            } else {
                                seRuntimeOrthogonal.setSeriesIdentifier(((Series)seRuntimes.get(j)).getSeriesIdentifier());
                            }
                            sdOrthogonal.getSeries().add((Object)seRuntimeOrthogonal);
                            ++j;
                        }
                    }
                    ++i;
                }
                break block15;
            }
            if (!(chart instanceof ChartWithoutAxes)) break block15;
            ChartWithoutAxes cwoa = (ChartWithoutAxes)chart;
            SeriesDefinition sdBase = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            int iOrthogonalSeriesDefinitionCount = 0;
            EList elSD = sdBase.getSeriesDefinitions();
            int j = 0;
            while (j < elSD.size()) {
                String sExpression;
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                Query qy = sd.getQuery();
                if (qy != null && (sExpression = qy.getDefinition()) != null && sExpression.length() != 0) {
                    ++iOrthogonalSeriesDefinitionCount;
                }
                ++j;
            }
            for (SeriesDefinition sdOrthogonal : elSD) {
                Series seDesignOrthogonal = sdOrthogonal.getDesignTimeSeries();
                List seRuntimes = sdOrthogonal.getRunTimeSeries();
                sdOrthogonal.getSeries().removeAll((Collection)seRuntimes);
                int j2 = 0;
                while (j2 < seRuntimes.size()) {
                    Series seRuntimeOrthogonal = seDesignOrthogonal.copyInstance();
                    seRuntimeOrthogonal.setDataSet(((Series)seRuntimes.get(j2)).getDataSet());
                    if (iOrthogonalSeriesDefinitionCount < 1) {
                        seRuntimeOrthogonal.setSeriesIdentifier(seDesignOrthogonal.getSeriesIdentifier());
                    } else {
                        seRuntimeOrthogonal.setSeriesIdentifier(((Series)seRuntimes.get(j2)).getSeriesIdentifier());
                    }
                    sdOrthogonal.getSeries().add((Object)seRuntimeOrthogonal);
                    ++j2;
                }
            }
        }
    }

    public static Chart doLivePreview(Chart cmRunTime, IDataServiceProvider dataProvider, IActionEvaluator iae) throws ChartException {
        boolean isSharingQuery = dataProvider.checkState(16) || dataProvider.checkState(1024);
        List expressions = Generator.instance().getRowExpressions(cmRunTime, iae, !(isSharingQuery &= !dataProvider.checkState(16384)));
        IDataRowExpressionEvaluator evaluator = dataProvider.prepareRowExpressionEvaluator(cmRunTime, expressions, -1, false);
        RunTimeContext context = new RunTimeContext();
        context.setULocale(ULocale.getDefault());
        context.setSharingQuery(isSharingQuery);
        Generator.instance().bindData(evaluator, iae, cmRunTime, context);
        if (evaluator != null) {
            evaluator.close();
        }
        return cmRunTime;
    }

    public static String getConvertedSampleDataRepresentation(AxisType axisType, String sOldRepresentation, int index) {
        return ChartUtil.getNewSampleData((AxisType)axisType, (int)index);
    }

    public static void setAllGroupingQueryExceptFirst(Chart chart, String queryDefinition) {
        List<SeriesDefinition> sds = ChartUIUtil.getAllOrthogonalSeriesDefinitions(chart);
        int i = 0;
        while (i < sds.size()) {
            if (i != 0) {
                SeriesDefinition sd = sds.get(i);
                if (sd.getQuery() != null) {
                    sd.getQuery().setDefinition(queryDefinition);
                } else {
                    Query query = QueryImpl.create((String)queryDefinition);
                    query.eAdapters().addAll((Collection)sd.eAdapters());
                    sd.setQuery(query);
                }
            }
            ++i;
        }
    }

    public static void addAxis(ChartWithAxes chartModel) {
        ChartAdapter.beginIgnoreNotifications();
        Axis xAxis = (Axis)chartModel.getAxes().get(0);
        Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
        Axis overlayAxis = yAxis.copyInstance();
        overlayAxis.setPrimaryAxis(false);
        overlayAxis.setOrigin(AxisOriginImpl.create((IntersectionType)IntersectionType.MAX_LITERAL, null));
        overlayAxis.setLabelPosition(Position.RIGHT_LITERAL);
        overlayAxis.setTitlePosition(Position.RIGHT_LITERAL);
        overlayAxis.eAdapters().addAll((Collection)yAxis.eAdapters());
        if (overlayAxis.getSeriesDefinitions().size() > 1) {
            EList list = overlayAxis.getSeriesDefinitions();
            int i = list.size() - 1;
            while (i > 0) {
                list.remove(i);
                --i;
            }
        }
        SeriesDefinition sdOverlay = (SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0);
        EList dds = sdOverlay.getDesignTimeSeries().getDataDefinition();
        int i = 0;
        while (i < dds.size()) {
            ((Query)dds.get(i)).setDefinition("");
            ++i;
        }
        SampleData sd = chartModel.getSampleData();
        int currentSize = sd.getOrthogonalSampleData().size();
        OrthogonalSampleData sdOrthogonal = ((OrthogonalSampleData)chartModel.getSampleData().getOrthogonalSampleData().get(0)).copyInstance();
        sdOrthogonal.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)overlayAxis.getType(), (int)currentSize));
        sdOrthogonal.setSeriesDefinitionIndex(currentSize);
        sdOrthogonal.eAdapters().addAll((Collection)sd.eAdapters());
        sd.getOrthogonalSampleData().add((Object)sdOrthogonal);
        ((Axis)chartModel.getAxes().get(0)).getAssociatedAxes().add((Object)overlayAxis);
        ChartAdapter.endIgnoreNotifications();
        ChartUIUtil.setSeriesName((Chart)chartModel);
    }

    public static void setSeriesName(Chart chart) {
        List<SeriesDefinition> seriesDefinitions = ChartUIUtil.getAllOrthogonalSeriesDefinitions(chart);
        String seriesText = Messages.getString("ChartUIUtil.SeriesLabel");
        int i = 0;
        while (i < seriesDefinitions.size()) {
            SeriesDefinition sd = seriesDefinitions.get(i);
            if (ChartUIUtil.needSeriesName(sd.getDesignTimeSeries().getSeriesIdentifier() == null ? null : sd.getDesignTimeSeries().getSeriesIdentifier().toString(), seriesText)) {
                sd.getDesignTimeSeries().setSeriesIdentifier((Object)MessageFormat.format(seriesText, i + 1));
            }
            ++i;
        }
    }

    private static boolean needSeriesName(String name, String seriesText) {
        if (name == null) {
            return false;
        }
        String pattern = MessageFormat.format(seriesText, "[0-9]+");
        return name.trim().matches(pattern) || name.trim().length() == 0;
    }

    public static void removeLastAxes(ChartWithAxes chartModel, int removedAxisNumber) {
        int i = 0;
        while (i < removedAxisNumber) {
            ChartUIUtil.removeLastAxis(chartModel);
            ++i;
        }
    }

    public static void removeLastAxis(ChartWithAxes chartModel) {
        ChartUIUtil.removeAxis((Chart)chartModel, ChartUIUtil.getOrthogonalAxisNumber((Chart)chartModel) - 1);
    }

    public static void removeAxis(Chart chartModel, int axisIndex) {
        if (chartModel instanceof ChartWithoutAxes) {
            return;
        }
        ChartAdapter.beginIgnoreNotifications();
        Axis oldPrimaryAxis = ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, axisIndex);
        if (oldPrimaryAxis.isPrimaryAxis()) {
            int yAxisSize = ChartUIUtil.getOrthogonalAxisNumber(chartModel);
            Axis newPrimaryAxis = null;
            newPrimaryAxis = axisIndex + 1 < yAxisSize ? ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, axisIndex + 1) : ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, 0);
            newPrimaryAxis.setPrimaryAxis(true);
            newPrimaryAxis.setOrigin(oldPrimaryAxis.getOrigin());
            newPrimaryAxis.setLabelPosition(oldPrimaryAxis.getLabelPosition());
            newPrimaryAxis.setTitlePosition(oldPrimaryAxis.getTitlePosition());
        }
        ChartAdapter.endIgnoreNotifications();
        ChartUIUtil.getAxisXForProcessing((ChartWithAxes)chartModel).getAssociatedAxes().remove(axisIndex);
    }

    public static int getLastSeriesIndexWithinAxis(Chart chartModel, int axisIndex) {
        if (chartModel instanceof ChartWithoutAxes || axisIndex < 0 || axisIndex >= ChartUIUtil.getOrthogonalAxisNumber(chartModel)) {
            return -1;
        }
        int seriesIndex = -1;
        int i = 0;
        while (i <= axisIndex) {
            seriesIndex += ChartUIUtil.getOrthogonalSeriesDefinitions(chartModel, i).size();
            ++i;
        }
        return seriesIndex;
    }

    public static void reorderOrthogonalSampleDataIndex(Chart chartModel) {
        EList list = chartModel.getSampleData().getOrthogonalSampleData();
        int i = 0;
        while (i < list.size()) {
            ((OrthogonalSampleData)list.get(i)).setSeriesDefinitionIndex(i);
            ++i;
        }
    }

    public static void copyGeneralSeriesAttributes(Series oldSeries, Series newSeries) {
        newSeries.setLabel(oldSeries.getLabel());
        newSeries.setSeriesIdentifier(oldSeries.getSeriesIdentifier());
        if (oldSeries.isSetVisible()) {
            newSeries.setVisible(oldSeries.isVisible());
        }
        if (oldSeries.isSetStacked() && newSeries.canBeStacked()) {
            newSeries.setStacked(oldSeries.isStacked());
        }
        if (oldSeries.isSetTranslucent()) {
            newSeries.setTranslucent(oldSeries.isTranslucent());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_Triggers())) {
            newSeries.getTriggers().clear();
            newSeries.getTriggers().addAll((Collection)oldSeries.getTriggers());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataPoint())) {
            newSeries.setDataPoint(oldSeries.getDataPoint());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_CurveFitting())) {
            newSeries.setCurveFitting(oldSeries.getCurveFitting());
        }
        if (oldSeries.isSetLabelPosition()) {
            if (oldSeries.getLabelPosition().equals((Object)Position.INSIDE_LITERAL) || oldSeries.getLabelPosition().equals((Object)Position.OUTSIDE_LITERAL)) {
                if (newSeries instanceof LineSeries || newSeries instanceof StockSeries || newSeries instanceof GanttSeries) {
                    newSeries.setLabelPosition(Position.ABOVE_LITERAL);
                } else {
                    newSeries.setLabelPosition(oldSeries.getLabelPosition());
                }
            } else if (newSeries instanceof LineSeries || newSeries instanceof StockSeries || newSeries instanceof GanttSeries) {
                newSeries.setLabelPosition(oldSeries.getLabelPosition());
            } else {
                newSeries.setLabelPosition(Position.OUTSIDE_LITERAL);
            }
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataDefinition())) {
            Query query = (Query)oldSeries.getDataDefinition().get(0);
            newSeries.getDataDefinition().clear();
            if (newSeries instanceof StockSeries) {
                if (oldSeries.getDataDefinition().size() != 4) {
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else if (newSeries instanceof BubbleSeries) {
                if (oldSeries.getDataDefinition().size() != 2) {
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else if (newSeries instanceof DifferenceSeries) {
                if (oldSeries.getDataDefinition().size() != 2) {
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else if (newSeries instanceof GanttSeries) {
                if (oldSeries.getDataDefinition().size() != 3) {
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                    newSeries.getDataDefinition().add((Object)query.copyInstance());
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else {
                newSeries.getDataDefinition().add((Object)query);
            }
        }
    }

    public static ChartDimension getDimensionType(String sDimension) {
        if (sDimension == null || sDimension.equals(IChartType.TWO_DIMENSION_TYPE)) {
            return ChartDimension.TWO_DIMENSIONAL_LITERAL;
        }
        if (sDimension.equals(IChartType.THREE_DIMENSION_TYPE)) {
            return ChartDimension.THREE_DIMENSIONAL_LITERAL;
        }
        return ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL;
    }

    public static String getDimensionString(ChartDimension dimension) {
        if (dimension == null || dimension == ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            return IChartType.TWO_DIMENSION_TYPE;
        }
        if (dimension == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return IChartType.THREE_DIMENSION_TYPE;
        }
        return IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE;
    }

    public static void bindHelp(Control control, String contextId) {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getHelpSystem().setHelp((Control)control.getShell(), contextId);
        }
        catch (RuntimeException runtimeException) {}
    }

    public static boolean is3DWallFloorSet(Chart chart) {
        if (!ChartUIUtil.is3DType(chart) || chart instanceof ChartWithoutAxes) {
            return true;
        }
        ChartWithAxes chartWithAxes = (ChartWithAxes)chart;
        Fill wall = chartWithAxes.getWallFill();
        if (wall != null) {
            if (wall instanceof ColorDefinition && ((ColorDefinition)wall).getTransparency() > 0) {
                return true;
            }
            return true;
        }
        Fill floor = chartWithAxes.getFloorFill();
        if (floor != null) {
            if (floor instanceof ColorDefinition && ((ColorDefinition)floor).getTransparency() > 0) {
                return true;
            }
            return true;
        }
        return false;
    }

    public static Anchor getFlippedAnchor(Anchor anchor, boolean isFlippedAxes) {
        if (isFlippedAxes) {
            return ChartUtil.transposeAnchor((Anchor)anchor);
        }
        return anchor;
    }

    public static TextAlignment getFlippedAlignment(TextAlignment ta, boolean isFlippedAxes) {
        if (isFlippedAxes) {
            return ChartUtil.transposeAlignment((TextAlignment)ta);
        }
        return ta;
    }

    public static Position getFlippedPosition(Position position, boolean isFlippedAxes) {
        if (position != null && isFlippedAxes) {
            switch (position.getValue()) {
                case 0: {
                    position = Position.RIGHT_LITERAL;
                    break;
                }
                case 1: {
                    position = Position.LEFT_LITERAL;
                    break;
                }
                case 2: {
                    position = Position.BELOW_LITERAL;
                    break;
                }
                case 3: {
                    position = Position.ABOVE_LITERAL;
                }
            }
        }
        return position;
    }

    public static String[] getPositionDisplayNames(int positionScope, boolean isFlipped) {
        if ((positionScope & 0x3F) == 63) {
            return LiteralHelper.fullPositionSet.getDisplayNames();
        }
        ArrayList<String> items = new ArrayList<String>(5);
        if ((positionScope & 3) == 3) {
            if (isFlipped) {
                ChartUIUtil.addArrayToList(LiteralHelper.horizontalPositionSet.getDisplayNames(), items);
            } else {
                ChartUIUtil.addArrayToList(LiteralHelper.verticalPositionSet.getDisplayNames(), items);
            }
        }
        if ((positionScope & 0xC) == 12) {
            if (isFlipped) {
                ChartUIUtil.addArrayToList(LiteralHelper.verticalPositionSet.getDisplayNames(), items);
            } else {
                ChartUIUtil.addArrayToList(LiteralHelper.horizontalPositionSet.getDisplayNames(), items);
            }
        }
        if ((positionScope & 0x10) == 16) {
            items.add(LiteralHelper.inoutPositionSet.getDisplayNameByName(Position.INSIDE_LITERAL.getName()));
        }
        if ((positionScope & 0x20) == 32) {
            items.add(LiteralHelper.inoutPositionSet.getDisplayNameByName(Position.OUTSIDE_LITERAL.getName()));
        }
        return items.toArray(new String[items.size()]);
    }

    public static String[] getPositionNames(int positionScope, boolean isFlipped) {
        if ((positionScope & 0x3F) == 63) {
            return LiteralHelper.fullPositionSet.getNames();
        }
        ArrayList<String> items = new ArrayList<String>(5);
        if ((positionScope & 3) == 3) {
            if (isFlipped) {
                ChartUIUtil.addArrayToList(LiteralHelper.horizontalPositionSet.getNames(), items);
            } else {
                ChartUIUtil.addArrayToList(LiteralHelper.verticalPositionSet.getNames(), items);
            }
        }
        if ((positionScope & 0xC) == 12) {
            if (isFlipped) {
                ChartUIUtil.addArrayToList(LiteralHelper.verticalPositionSet.getNames(), items);
            } else {
                ChartUIUtil.addArrayToList(LiteralHelper.horizontalPositionSet.getNames(), items);
            }
        }
        if ((positionScope & 0x10) == 16) {
            items.add(Position.INSIDE_LITERAL.getName());
        }
        if ((positionScope & 0x20) == 32) {
            items.add(Position.OUTSIDE_LITERAL.getName());
        }
        return items.toArray(new String[items.size()]);
    }

    private static void addArrayToList(String[] array, List<String> list) {
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
    }

    public static void saveLabelPositionIntoCache(SeriesDefinition seriesDefinition) {
        if (seriesDefinition == null) {
            return;
        }
        for (Series series : seriesDefinition.getSeries()) {
            if (!(series instanceof BarSeries)) continue;
            String stackedCase = "non-stacked";
            if (series.isStacked()) {
                stackedCase = "stacked";
            }
            ChartCacheManager.getInstance().cacheLabelPositionWithStackedCase(stackedCase, series.getLabelPosition());
            break;
        }
    }

    public static void restoreLabelPositionFromCache(Chart currentChart) {
        if (currentChart == null) {
            return;
        }
        SeriesDefinition[] sds = currentChart.getSeriesForLegend();
        int i = 0;
        while (i < sds.length) {
            EList seriesList = sds[i].getSeries();
            for (Series series : seriesList) {
                Position labelPosition;
                if (!(series instanceof BarSeries)) continue;
                String stackedCase = "non-stacked";
                if (series.isStacked()) {
                    stackedCase = "stacked";
                }
                if ((labelPosition = ChartCacheManager.getInstance().findLabelPositionWithStackedCase(stackedCase)) != null) {
                    series.setLabelPosition(labelPosition);
                    continue;
                }
                if (!series.isStacked()) continue;
                series.setLabelPosition(Position.INSIDE_LITERAL);
            }
            ++i;
        }
    }

    public static ISeriesUIProvider getSeriesUIProvider(Series series) {
        return htSeriesAttributeUIProviders.get(series.getClass().getName());
    }

    public static void setChartImageButtonSizeByPlatform(GridData gridData) {
        if (ChartUIUtil.isWindows()) {
            gridData.heightHint = 20;
            gridData.widthHint = 20;
        }
    }

    public static void setChartImageButtonHeightByPlatform(GridData gridData) {
        if (ChartUIUtil.isWindows()) {
            gridData.heightHint = 20;
        }
    }

    public static int getImageButtonDefaultHeightByPlatform() {
        if (ChartUIUtil.isWindows()) {
            return 20;
        }
        return 0;
    }

    private static boolean isWindows() {
        String platform = SWT.getPlatform();
        return "win32".equals(platform);
    }

    public static boolean isGroupingSupported(ChartWizardContext wizardContext) {
        int state = wizardContext.getDataServiceProvider().getState();
        return (state & 0x10) != 16 && (state & 0x400) != 1024 && (state & 2) != 2 && (state & 0x2000) != 8192;
    }

    private static String checkGroupTypeOnCategory(ChartWizardContext context, Chart chart) {
        String isConsistent = "";
        SeriesDefinition seriesdefinition = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions(chart).get(0);
        DataType queryDataType = context.getDataServiceProvider().getDataType(ChartUIUtil.getDataQuery(seriesdefinition, 0).getDefinition());
        if (queryDataType != null && seriesdefinition.getGrouping() != null) {
            if (!seriesdefinition.getGrouping().isEnabled()) {
                return isConsistent;
            }
            DataType groupDataType = seriesdefinition.getGrouping().getGroupType();
            if (queryDataType == DataType.NUMERIC_LITERAL && groupDataType == DataType.DATE_TIME_LITERAL) {
                return groupDataType.getName();
            }
            if (queryDataType == DataType.TEXT_LITERAL && groupDataType != DataType.TEXT_LITERAL) {
                return groupDataType.getName();
            }
        }
        return isConsistent;
    }

    private static String checkGroupTypeOnYGrouping(ChartWizardContext context, Chart chart) {
        DataType queryDataType;
        String isConsistent = "";
        SeriesDefinition seriesdefinition = (SeriesDefinition)ChartUIUtil.getOrthogonalSeriesDefinitions(chart, 0).get(0);
        if (seriesdefinition.getQuery() != null && (queryDataType = context.getDataServiceProvider().getDataType(seriesdefinition.getQuery().getDefinition())) != null && seriesdefinition.getQuery().getGrouping() != null) {
            DataType groupDataType = seriesdefinition.getQuery().getGrouping().getGroupType();
            if (queryDataType == DataType.NUMERIC_LITERAL && groupDataType == DataType.DATE_TIME_LITERAL) {
                return groupDataType.getName();
            }
            if (queryDataType == DataType.TEXT_LITERAL && groupDataType != DataType.TEXT_LITERAL) {
                return groupDataType.getName();
            }
        }
        return isConsistent;
    }

    public static void checkGroupType(ChartWizardContext context, Chart chart) {
        String yGroupWarning;
        String cGroupWarning = ChartUIUtil.checkGroupTypeOnCategory(context, chart);
        if (cGroupWarning.length() != 0) {
            cGroupWarning = Messages.getString("TaskSelectData.Warning.CategoryGroupTypeCheck", new String[]{cGroupWarning});
        }
        if ((yGroupWarning = ChartUIUtil.checkGroupTypeOnYGrouping(context, chart)).length() != 0) {
            yGroupWarning = Messages.getString("TaskSelectData.Warning.YGroupTypeCheck", new String[]{yGroupWarning});
        }
        if (cGroupWarning.length() != 0 || yGroupWarning.length() != 0) {
            ChartWizard.showException("ChartUIUtil.checkGroupType", String.valueOf(cGroupWarning) + yGroupWarning);
        } else {
            ChartWizard.removeException("ChartUIUtil.checkGroupType");
        }
    }

    public static boolean checkAggregateType(ChartWizardContext context) {
        boolean isValid = true;
        SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions(context.getModel()).get(0);
        for (SeriesDefinition orthSD : ChartUIUtil.getOrthogonalSeriesDefinitions(context.getModel(), 0)) {
            if (!isValid) break;
            Series oSeries = orthSD.getDesignTimeSeries();
            isValid = ChartUIUtil.getSeriesUIProvider(oSeries).isValidAggregationType(oSeries, orthSD, baseSD);
        }
        return isValid;
    }

    public static NameSet getCompatibleAxisType(Series series) {
        ISeriesUIProvider provider = ChartUIUtil.getSeriesUIProvider(series);
        AxisType[] types = provider.getCompatibleAxisType(series);
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            names[i] = types[i].getName();
            ++i;
        }
        String prefix = "AxisType.";
        String suffix = ".displayName";
        return new NameSet(prefix, suffix, names);
    }

    public static Chart prepareLivePreview(Chart cm, IDataServiceProvider dataServiceProvider) {
        return ChartUIUtil.prepareLivePreview(cm, dataServiceProvider, null);
    }

    public static Chart prepareLivePreview(Chart cm, IDataServiceProvider dataServiceProvider, IActionEvaluator iae) {
        Chart cmRuntime = null;
        if (dataServiceProvider.isLivePreviewEnabled() && ChartUIUtil.checkDataBinding(cm)) {
            boolean bException;
            block7: {
                ChartPreviewPainterBase.activateLivePreview(true);
                bException = false;
                try {
                    cmRuntime = cm.copyInstance();
                    cmRuntime.eAdapters().clear();
                    TreeIterator iterator = cmRuntime.eAllContents();
                    while (iterator.hasNext()) {
                        EObject content = (EObject)iterator.next();
                        content.eAdapters().clear();
                    }
                    cmRuntime = ChartUIUtil.doLivePreview(cmRuntime, dataServiceProvider, iae);
                }
                catch (Exception e) {
                    ChartPreviewPainterBase.activateLivePreview(false);
                    boolean isZeroDataset = false;
                    if (e instanceof ChartException && ((ChartException)((Object)e)).getType() == 16) {
                        isZeroDataset = true;
                    }
                    if (isZeroDataset) break block7;
                    bException = true;
                    ChartPreviewPainterBase.activateLivePreview(false);
                    ChartWizard.showException("ChartUIUtil.prepareLivePreview", e.getLocalizedMessage());
                }
            }
            if (!bException) {
                ChartWizard.removeException("ChartUIUtil.prepareLivePreview");
            }
        } else {
            ChartPreviewPainterBase.activateLivePreview(false);
            ChartWizard.removeException("ChartUIUtil.prepareLivePreview");
        }
        return cmRuntime != null ? cmRuntime : cm.copyInstance();
    }

    public static String getText(Control control) {
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        if (control instanceof CCombo) {
            return ((CCombo)control).getText().trim();
        }
        if (control instanceof Combo) {
            return ((Combo)control).getText();
        }
        return "";
    }

    public static void setText(Control control, String text) {
        if (control instanceof Text) {
            ((Text)control).setText(text);
        } else if (control instanceof CCombo) {
            if (text.trim().length() > 0) {
                text = String.valueOf(text) + " ";
            }
            ((CCombo)control).setText(text);
        } else if (control instanceof Combo) {
            ((Combo)control).setText(text);
        }
    }

    public static boolean isNumericAggregate(Series series) {
        Chart cm = ChartUtil.getChartFromSeries((Series)series);
        SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions(cm).get(0);
        SeriesDefinition orthSD = null;
        orthSD = (SeriesDefinition)series.eContainer();
        for (Query query : series.getDataDefinition()) {
            String aggFunc = null;
            try {
                aggFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)query);
            }
            catch (ChartException chartException) {}
            if (baseSD == orthSD || !ChartUtil.isMagicAggregate((String)aggFunc)) continue;
            return true;
        }
        return false;
    }

    public static void updateDefaultAggregations(Chart cm) {
        for (SeriesDefinition vsd : ChartUIUtil.getAllOrthogonalSeriesDefinitions(cm)) {
            EList queries;
            Series vs = vsd.getDesignTimeSeries();
            if (vs instanceof StockSeries) {
                queries = vs.getDataDefinition();
                while (queries.size() < 4) {
                    queries.add((Object)QueryImpl.create((String)""));
                }
                ChartUIUtil.setSeriesAggregation((Query)queries.get(0), "Max");
                ChartUIUtil.setSeriesAggregation((Query)queries.get(1), "Min");
                ChartUIUtil.setSeriesAggregation((Query)queries.get(2), "First");
                ChartUIUtil.setSeriesAggregation((Query)queries.get(3), "Last");
            }
            if (!(vs instanceof GanttSeries)) continue;
            queries = vs.getDataDefinition();
            while (queries.size() < 3) {
                queries.add((Object)QueryImpl.create((String)""));
            }
            ChartUIUtil.setSeriesAggregation((Query)queries.get(0), "Min");
            ChartUIUtil.setSeriesAggregation((Query)queries.get(1), "Max");
        }
    }

    private static void setSeriesAggregation(Query query, String aggFunc) {
        SeriesGrouping grouping = query.getGrouping();
        if (grouping == null) {
            grouping = SeriesGroupingImpl.create();
            query.setGrouping(grouping);
        }
        grouping.setEnabled(true);
        grouping.setAggregateExpression(aggFunc);
        query.setGrouping(grouping);
    }

    public static void populateTypeTable(IWizardContext context) {
        if (htTypes == null) {
            htTypes = new LinkedHashMap();
        }
        htTypes.clear();
        Collection<IChartType> cTypes = ChartUIExtensionsImpl.instance().getUIChartTypeExtensions(((ChartWizardContext)context).getIdentifier());
        Iterator<IChartType> iterTypes = cTypes.iterator();
        boolean needExpand = ((ChartWizardContext)context).getDataServiceProvider().checkState(32);
        while (iterTypes.hasNext()) {
            IChartType type = iterTypes.next();
            if (needExpand && !type.canExpand()) continue;
            htTypes.put(type.getName(), type);
        }
    }

    public static Iterator<IChartType> getChartTypeInstancesIterator() {
        return htTypes.values().iterator();
    }

    public static Iterator<String> getChartTypeNameIterator() {
        return htTypes.keySet().iterator();
    }

    public static IChartType getChartType(String name) {
        return htTypes.get(name);
    }

    public static boolean hasLimitOnCategorySortKey(ChartWizardContext wizardContext) {
        boolean isCube;
        int stateInfo = wizardContext.getDataServiceProvider().getState();
        boolean bl = isCube = (stateInfo & 2) == 2 && (stateInfo & 0x10) != 16;
        return ChartUtil.isSpecifiedYOptionalExpression((Chart)wizardContext.getModel()) && !isCube;
    }

    public static boolean isDataTimeSupportedAgg(String aggFunc) {
        return "Average".equals(aggFunc) || "First".equals(aggFunc) || "Last".equals(aggFunc) || "Min".equals(aggFunc) || "Max".equals(aggFunc) || "Median".equals(aggFunc) || "Mode".equals(aggFunc) || ChartUtil.isMagicAggregate((String)aggFunc);
    }

    public static void addScreenReaderAccessbility(Control composite, final String description) {
        if (composite == null) {
            return;
        }
        if (description != null) {
            if (composite instanceof Spinner) {
                ChartUIUtil.addSpinnerScreenReaderAccessbility((Spinner)composite, description);
            } else {
                composite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                    public void getName(AccessibleEvent e) {
                        e.result = description.replaceAll("&", "").replaceAll(":", "").replaceAll("\\*", "");
                    }
                });
            }
        }
    }

    public static void addSpinnerScreenReaderAccessbility(final Spinner spinner, final String description) {
        spinner.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = description.replaceAll("&", "").replaceAll(":", "").replaceAll("\\*", "");
            }
        });
        spinner.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                spinner.getAccessible().setFocus(-1);
            }
        });
        spinner.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                e.result = Integer.toString(spinner.getSelection());
            }
        });
    }

    public static void addScreenReaderAccessibility(Control chartComposite, Control composite) {
        Control[] controls = chartComposite.getParent().getChildren();
        int i = 1;
        while (i < controls.length) {
            if (controls[i] == chartComposite && Label.class.isInstance(controls[i - 1])) {
                ChartUIUtil.addScreenReaderAccessbility(composite, ((Label)controls[i - 1]).getText());
                break;
            }
            ++i;
        }
    }

    public static abstract class ComboProxy {
        public abstract void setText(String var1);

        public abstract String getText();

        public abstract void removeAll();

        public abstract void setItem(int var1, String var2);

        public abstract void setItems(String[] var1);

        public abstract String[] getItems();

        public abstract void add(String var1);

        public abstract void setData(String var1, Object var2);

        public abstract Object getData(String var1);

        public abstract int getSelectionIndex();

        public static ComboProxy getInstance(Control control) {
            if (control != null && !control.isDisposed()) {
                if (control instanceof Combo) {
                    return new ProxyOfCombo((Combo)control);
                }
                if (control instanceof CCombo) {
                    return new ProxyOfCCombo((CCombo)control);
                }
            }
            return null;
        }

        public boolean contains(String text) {
            String[] stringArray = this.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.equals(text)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        static class ProxyOfCCombo
        extends ComboProxy {
            private final CCombo ccombo;

            public ProxyOfCCombo(CCombo ccombo) {
                this.ccombo = ccombo;
            }

            public void add(String string) {
                this.ccombo.add(string);
            }

            public String[] getItems() {
                return this.ccombo.getItems();
            }

            public void removeAll() {
                this.ccombo.removeAll();
            }

            public void setItem(int index, String string) {
                this.ccombo.setItem(index, string);
            }

            public void setItems(String[] items) {
                this.ccombo.setItems(items);
            }

            public void setText(String string) {
                this.ccombo.setText(string);
            }

            public String getText() {
                return this.ccombo.getText();
            }

            public Object getData(String key) {
                return this.ccombo.getData(key);
            }

            public void setData(String key, Object value) {
                this.ccombo.setData(key, value);
            }

            public int getSelectionIndex() {
                return this.ccombo.getSelectionIndex();
            }
        }

        static class ProxyOfCombo
        extends ComboProxy {
            private final Combo combo;

            public ProxyOfCombo(Combo combo) {
                this.combo = combo;
            }

            public void add(String string) {
                this.combo.add(string);
            }

            public String[] getItems() {
                return this.combo.getItems();
            }

            public void removeAll() {
                this.combo.removeAll();
            }

            public void setItem(int index, String string) {
                this.combo.setItem(index, string);
            }

            public void setItems(String[] items) {
                this.combo.setItems(items);
            }

            public void setText(String string) {
                this.combo.setText(string);
            }

            public String getText() {
                return this.combo.getText();
            }

            public Object getData(String key) {
                return this.combo.getData(key);
            }

            public void setData(String key, Object value) {
                this.combo.setData(key, value);
            }

            public int getSelectionIndex() {
                return this.combo.getSelectionIndex();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EAttributeAccessor<T> {
        private final EObject eObj;
        private final EAttribute eAttr;

        public EAttributeAccessor(EObject eObj, EAttribute eAttr) {
            this.eObj = eObj;
            this.eAttr = eAttr;
        }

        public T load() {
            return (T)this.eObj.eGet((EStructuralFeature)this.eAttr);
        }

        public void save(T value) {
            this.save(value, false);
        }

        public void save(T value, boolean bIgnoreNotification) {
            if (bIgnoreNotification) {
                ChartAdapter.beginIgnoreNotifications();
            }
            this.eObj.eSet((EStructuralFeature)this.eAttr, value);
            if (bIgnoreNotification) {
                ChartAdapter.endIgnoreNotifications();
            }
        }
    }
}

