/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.birt.data.oda.mongodb.impl.MDbConnection;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbOperation;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryModel;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.internal.impl.ResultDataHandler;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class MDbMetaData {
    public static final int DEFAULT_META_DATA_SEARCH_LIMIT = 1;
    private static final MDbMetaData sm_factory = new MDbMetaData();
    private static final DocumentsMetaData sm_emptyFields = sm_factory.new DocumentsMetaData();
    private static final FieldMetaData sm_emptyFieldMetaData;
    private static final String SYSTEM_NAMESPACE_PREFIX = "system.";
    private static final String FIELD_FULL_NAME_SEPARATOR = ".";
    private DB m_connectedDB;

    static {
        MDbMetaData mDbMetaData = sm_factory;
        mDbMetaData.getClass();
        sm_emptyFieldMetaData = mDbMetaData.new FieldMetaData("");
    }

    public MDbMetaData(Properties connProperties) throws OdaException {
        this.m_connectedDB = MDbConnection.getMongoDatabase(connProperties);
    }

    public MDbMetaData(DB connectedDB) {
        if (connectedDB == null) {
            throw new IllegalArgumentException("null");
        }
        this.m_connectedDB = connectedDB;
    }

    private MDbMetaData() {
    }

    public String getDatabaseName() {
        return this.m_connectedDB.getName();
    }

    public List<String> getCollectionsList() {
        return this.getCollectionsList(true);
    }

    public List<String> getCollectionsList(boolean excludeSystemCollections) {
        Set collectionNames;
        try {
            collectionNames = this.m_connectedDB.getCollectionNames();
        }
        catch (MongoException ex) {
            DriverUtil.getLogger().log(Level.INFO, "Ignoring error to get collection names from database.", ex);
            return Collections.emptyList();
        }
        if (excludeSystemCollections) {
            ArrayList<String> filteredNames = new ArrayList<String>(collectionNames.size());
            for (String collectionName : collectionNames) {
                if (collectionName.startsWith(SYSTEM_NAMESPACE_PREFIX)) continue;
                filteredNames.add(collectionName);
            }
            return filteredNames;
        }
        return new ArrayList<String>(collectionNames);
    }

    public DBCollection getCollection(String collectionName) {
        if (!this.m_connectedDB.collectionExists(collectionName)) {
            return null;
        }
        return this.m_connectedDB.getCollectionFromString(collectionName);
    }

    public DocumentsMetaData getAvailableFields(String collectionName, int searchLimit, QueryProperties runtimeProps) throws OdaException {
        DBCollection collection = this.getCollection(collectionName);
        if (collection == null && !runtimeProps.hasRunCommand()) {
            if (runtimeProps.getOperationType() == QueryProperties.CommandOperationType.RUN_DB_COMMAND && runtimeProps.getOperationExpression().isEmpty()) {
                throw new OdaException(Messages.bind((String)Messages.mDbMetaData_missingCmdExprText, (Object)runtimeProps.getOperationType().displayName()));
            }
            throw new OdaException(Messages.bind((String)Messages.mDbMetaData_invalidCollectionName, (Object)collectionName));
        }
        if (searchLimit <= 0) {
            searchLimit = 1;
        }
        if (runtimeProps.hasValidCommandOperation()) {
            QueryModel.validateCommandSyntax(runtimeProps.getOperationType(), runtimeProps.getOperationExpression());
            Iterable<DBObject> commandResults = null;
            if (runtimeProps.hasAggregateCommand()) {
                commandResults = MDbOperation.callAggregateCmd(collection, runtimeProps);
            } else if (runtimeProps.hasMapReduceCommand()) {
                MapReduceOutput mapReduceOut = MDbOperation.callMapReduceCmd(collection, runtimeProps);
                commandResults = mapReduceOut.results();
            } else if (runtimeProps.hasRunCommand()) {
                commandResults = MDbOperation.callDBCommand(this.m_connectedDB, runtimeProps);
            }
            if (commandResults != null) {
                return MDbMetaData.getMetaData(commandResults, searchLimit);
            }
            return sm_emptyFields;
        }
        DBCursor rowsCursor = collection.find();
        if (searchLimit > 0) {
            rowsCursor.limit(searchLimit);
        }
        QueryProperties mdCursorProps = runtimeProps != null ? runtimeProps : QueryProperties.defaultValues();
        MDbOperation.applyPropertiesToCursor(rowsCursor, mdCursorProps, false);
        return MDbMetaData.getMetaData(rowsCursor);
    }

    public static int defaultPort() {
        return ServerAddress.defaultPort();
    }

    static String[] splitFieldName(String fieldFullName) {
        if (fieldFullName == null || fieldFullName.isEmpty()) {
            return new String[0];
        }
        return fieldFullName.split("\\.");
    }

    static String getSimpleName(String fieldFullName) {
        String[] nameFragments = MDbMetaData.splitFieldName(fieldFullName);
        if (nameFragments.length == 0) {
            return "";
        }
        return nameFragments[nameFragments.length - 1];
    }

    static String stripParentName(String fieldFullName, String parentName) {
        if (parentName == null || parentName.isEmpty()) {
            return fieldFullName;
        }
        int stripFromIndex = parentName.length() + FIELD_FULL_NAME_SEPARATOR.length();
        if (stripFromIndex > fieldFullName.length()) {
            return fieldFullName;
        }
        return fieldFullName.substring(stripFromIndex);
    }

    public static FieldMetaData findFieldByFullName(String fieldFullName, DocumentsMetaData fromDocMetaData) {
        String[] nameFragments = MDbMetaData.splitFieldName(fieldFullName);
        if (nameFragments.length == 0) {
            return null;
        }
        FieldMetaData firstLevelMd = fromDocMetaData.getFieldMetaData(nameFragments[0]);
        if (nameFragments.length == 1) {
            return firstLevelMd;
        }
        if (!firstLevelMd.hasChildDocuments()) {
            return null;
        }
        String childFullName = MDbMetaData.stripParentName(fieldFullName, nameFragments[0]);
        return MDbMetaData.findFieldByFullName(childFullName, firstLevelMd.getChildMetaData());
    }

    public static boolean isFlattenableNestedField(FieldMetaData fieldMd, DocumentsMetaData topLevelDocMD) {
        String cachedAncestorName;
        if (fieldMd == null) {
            return false;
        }
        DocumentsMetaData containingDocMD = fieldMd.getContainingMetaData();
        if (containingDocMD == null) {
            containingDocMD = topLevelDocMD;
        }
        if ((cachedAncestorName = containingDocMD.getFlattenableFieldName()) != null && cachedAncestorName.equals(fieldMd.getFullName())) {
            return true;
        }
        if (fieldMd.isChildField()) {
            return MDbMetaData.isFlattenableNestedField(fieldMd.getParentMetaData(), topLevelDocMD);
        }
        return false;
    }

    public static Map<String, FieldMetaData> flattenFieldsMetaData(List<String> fieldFullNames, DocumentsMetaData fromDocMetaData) {
        if (fieldFullNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, FieldMetaData> resultFieldsMD = new LinkedHashMap<String, FieldMetaData>(fieldFullNames.size());
        for (String fieldFullName : fieldFullNames) {
            FieldMetaData fieldMD = MDbMetaData.findFieldByFullName(fieldFullName, fromDocMetaData);
            if (fieldMD == null) continue;
            resultFieldsMD.put(fieldFullName, fieldMD);
        }
        return resultFieldsMD;
    }

    public static Map<String, FieldMetaData> flattenFieldsMetaData(DocumentsMetaData fromDocMetaData, Map<String, FieldMetaData> toResultFieldsMD) {
        if (toResultFieldsMD == null) {
            toResultFieldsMD = new LinkedHashMap<String, FieldMetaData>();
        }
        for (FieldMetaData fieldMD : fromDocMetaData.m_fieldsMetaData.values()) {
            toResultFieldsMD.put(fieldMD.getFullName(), fieldMD);
            if (!fieldMD.hasChildDocuments()) continue;
            toResultFieldsMD = MDbMetaData.flattenFieldsMetaData(fieldMD.getChildMetaData(), toResultFieldsMD);
        }
        return toResultFieldsMD;
    }

    public static DocumentsMetaData getMetaData(DBCursor resultCursor) {
        if (resultCursor == null) {
            return sm_emptyFields;
        }
        DocumentsMetaData newMetaData = sm_factory.new DocumentsMetaData();
        while (resultCursor.hasNext()) {
            DBObject doc = resultCursor.next();
            newMetaData.addDocumentMetaData(doc, null);
        }
        return newMetaData;
    }

    public static DocumentsMetaData getMetaData(Iterable<DBObject> resultObjs, int searchLimit) {
        if (resultObjs == null) {
            return sm_emptyFields;
        }
        DocumentsMetaData newMetaData = sm_factory.new DocumentsMetaData();
        int count = 1;
        Iterator<DBObject> resultObjItr = resultObjs.iterator();
        while (resultObjItr.hasNext() && (searchLimit <= 0 || count <= searchLimit)) {
            DBObject doc = resultObjItr.next();
            newMetaData.addDocumentMetaData(doc, null);
            ++count;
        }
        return newMetaData;
    }

    public class DocumentsMetaData {
        private Map<String, FieldMetaData> m_fieldsMetaData = new LinkedHashMap<String, FieldMetaData>();
        private String m_nestedCollFieldName;

        private void addDocumentMetaData(DBObject doc, FieldMetaData parentMd) {
            if (doc == null) {
                return;
            }
            Set fieldNames = doc.keySet();
            for (String fieldName : fieldNames) {
                Object value = doc.get(fieldName);
                this.addDataTypeOfFieldValue(fieldName, value, parentMd);
            }
        }

        private FieldMetaData addDataTypeOfFieldValue(String fieldName, Object fieldValue, FieldMetaData parentMd) {
            FieldMetaData fieldMd = this.m_fieldsMetaData.get(fieldName);
            if (fieldMd == null) {
                fieldMd = new FieldMetaData(fieldName);
                fieldMd.setParentMetaData(parentMd);
            }
            fieldMd.addDataType(fieldValue);
            this.m_fieldsMetaData.put(fieldMd.getSimpleName(), fieldMd);
            return fieldMd;
        }

        private void removeField(String fieldName) {
            if (fieldName != null) {
                this.m_fieldsMetaData.remove(fieldName);
            }
        }

        public List<String> getFieldNames() {
            ArrayList<String> docFields = new ArrayList<String>(this.m_fieldsMetaData.size());
            for (String fieldName : this.m_fieldsMetaData.keySet()) {
                docFields.add(fieldName);
            }
            return docFields;
        }

        public List<String> getSortedFieldNames() {
            Set<String> attributeNames = this.m_fieldsMetaData.keySet();
            return this.sortFieldNames(attributeNames);
        }

        private List<String> sortFieldNames(Set<String> fieldNames) {
            if (fieldNames == null || fieldNames.isEmpty()) {
                return Collections.emptyList();
            }
            Object[] attrNamesArray = fieldNames.toArray(new String[fieldNames.size()]);
            Arrays.sort(attrNamesArray);
            ArrayList<String> sortedAttrList = new ArrayList<String>(attrNamesArray.length);
            sortedAttrList.addAll(Arrays.asList(attrNamesArray));
            return sortedAttrList;
        }

        public FieldMetaData getFieldMetaData(String fieldSimpleName) {
            FieldMetaData fieldMd = this.m_fieldsMetaData.get(fieldSimpleName);
            return fieldMd != null ? fieldMd : sm_emptyFieldMetaData;
        }

        public void setFlattenableFields(Map<String, FieldMetaData> resultFieldsMD, boolean isTopLevelDoc) {
            if (resultFieldsMD == null || resultFieldsMD.isEmpty()) {
                return;
            }
            FieldMetaData flattenableFieldMD = null;
            if (this.m_nestedCollFieldName != null) {
                flattenableFieldMD = resultFieldsMD.get(this.m_nestedCollFieldName);
            }
            if (flattenableFieldMD == null) {
                Iterator<FieldMetaData> iterator = resultFieldsMD.values().iterator();
                while (iterator.hasNext()) {
                    FieldMetaData resultFieldMD;
                    FieldMetaData fieldLevelMD = resultFieldMD = iterator.next();
                    while (fieldLevelMD != null) {
                        if (!this.m_fieldsMetaData.containsValue(fieldLevelMD)) {
                            fieldLevelMD = fieldLevelMD.getParentMetaData();
                            continue;
                        }
                        if (fieldLevelMD.isArrayOfDocuments()) {
                            this.m_nestedCollFieldName = fieldLevelMD.getFullName();
                            flattenableFieldMD = fieldLevelMD;
                        }
                        fieldLevelMD = null;
                    }
                    if (flattenableFieldMD != null) break;
                }
            }
            if (flattenableFieldMD != null) {
                if (flattenableFieldMD.hasChildDocuments()) {
                    flattenableFieldMD.getChildMetaData().setFlattenableFields(resultFieldsMD, false);
                }
                return;
            }
            if (this.m_nestedCollFieldName == null && isTopLevelDoc) {
                for (FieldMetaData resultFieldMD : resultFieldsMD.values()) {
                    if (!resultFieldMD.isArrayOfScalarValues()) continue;
                    this.m_nestedCollFieldName = resultFieldMD.getFullName();
                    break;
                }
            }
        }

        public String getFlattenableFieldName() {
            return this.m_nestedCollFieldName;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("\n " + this.getClass().getSimpleName() + ":");
            buf.append("; flattenableFieldName: " + this.m_nestedCollFieldName);
            for (Map.Entry<String, FieldMetaData> entry : this.m_fieldsMetaData.entrySet()) {
                buf.append("\n  field key: " + entry.getKey());
                buf.append("; metadata: " + entry.getValue());
            }
            return buf.toString();
        }
    }

    public class FieldMetaData {
        private static final String ARRAY_NOTATION = "[]";
        private String m_simpleName;
        private Set<Integer> m_nativeDataTypes;
        private DocumentsMetaData m_childDocMetaData;
        private FieldMetaData m_parentMd;
        private String[] m_nameFragments;

        private FieldMetaData(String simpleName) {
            this.m_simpleName = simpleName;
        }

        public String getSimpleName() {
            return this.m_simpleName;
        }

        public String getSimpleDisplayName() {
            return this.hasArrayDataType() ? String.valueOf(this.getSimpleName()) + ARRAY_NOTATION : this.getSimpleName();
        }

        public String getFullName() {
            if (this.m_parentMd == null) {
                return this.getSimpleName();
            }
            StringBuffer fullName = new StringBuffer(this.m_parentMd.getFullName());
            fullName.append(MDbMetaData.FIELD_FULL_NAME_SEPARATOR);
            fullName.append(this.getSimpleName());
            return fullName.toString();
        }

        public String getFullDisplayName() {
            if (this.m_parentMd == null) {
                return this.getSimpleDisplayName();
            }
            StringBuffer fullName = new StringBuffer(this.m_parentMd.getFullDisplayName());
            fullName.append(MDbMetaData.FIELD_FULL_NAME_SEPARATOR);
            fullName.append(this.getSimpleDisplayName());
            return fullName.toString();
        }

        String[] getLevelNames() {
            if (this.m_nameFragments == null) {
                this.m_nameFragments = MDbMetaData.splitFieldName(this.getFullName());
            }
            return this.m_nameFragments;
        }

        private void setParentMetaData(FieldMetaData parentMd) {
            if (parentMd != null) {
                this.m_parentMd = parentMd;
            }
        }

        private FieldMetaData getParentMetaData() {
            return this.m_parentMd;
        }

        private DocumentsMetaData getContainingMetaData() {
            if (this.m_parentMd == null) {
                return null;
            }
            return this.m_parentMd.getChildMetaData();
        }

        public boolean isChildField() {
            return this.m_parentMd != null;
        }

        private void addDataType(Object fieldValue) {
            List listOfObjects;
            byte nativeBSonDataTypeCode = Bytes.getType((Object)fieldValue);
            if (this.m_nativeDataTypes == null) {
                this.m_nativeDataTypes = new HashSet<Integer>(2);
            }
            this.m_nativeDataTypes.add(Integer.valueOf(nativeBSonDataTypeCode));
            if (nativeBSonDataTypeCode == 4 && fieldValue instanceof List && (listOfObjects = (List)fieldValue).size() > 0) {
                this.addDataType(listOfObjects.get(0));
                return;
            }
            DBObject fieldObjValue = ResultDataHandler.fetchFieldDocument(fieldValue, nativeBSonDataTypeCode);
            if (fieldObjValue != null) {
                if (this.m_childDocMetaData == null) {
                    this.m_childDocMetaData = sm_factory.new DocumentsMetaData();
                }
                this.m_childDocMetaData.addDocumentMetaData(fieldObjValue, this);
            }
        }

        public Integer getPreferredNativeDataType(boolean isAutoFlattening) {
            Set<Integer> nativeDataTypes = this.getNativeDataTypes();
            if (nativeDataTypes.isEmpty()) {
                return 10;
            }
            if (this.hasArrayDataType()) {
                if (isAutoFlattening && !this.hasDocumentDataType()) {
                    return this.getScalarNativeDataType();
                }
                return 4;
            }
            if (this.hasDocumentDataType()) {
                return 3;
            }
            if (this.getNativeDataTypes().contains(2)) {
                return 2;
            }
            return nativeDataTypes.iterator().next();
        }

        public Set<Integer> getNativeDataTypes() {
            if (this.m_nativeDataTypes == null) {
                return Collections.emptySet();
            }
            return this.m_nativeDataTypes;
        }

        private Integer getScalarNativeDataType() {
            Set<Integer> nativeDataTypes = this.getNativeDataTypes();
            for (Integer nativeDataType : nativeDataTypes) {
                if (nativeDataType == Integer.valueOf(4) || nativeDataType == Integer.valueOf(3)) continue;
                return nativeDataType;
            }
            return null;
        }

        public boolean isArrayOfScalarValues() {
            if (!this.hasArrayDataType()) {
                return false;
            }
            return !this.hasDocumentDataType();
        }

        public boolean isArrayOfDocuments() {
            if (!this.hasArrayDataType()) {
                return false;
            }
            return this.hasDocumentDataType();
        }

        public boolean hasDocumentDataType() {
            return this.getNativeDataTypes().contains(3);
        }

        public boolean hasArrayDataType() {
            return this.getNativeDataTypes().contains(4);
        }

        public boolean isDescendantOfArrayField() {
            if (!this.isChildField()) {
                return false;
            }
            return this.m_parentMd.hasArrayDataType() || this.m_parentMd.isDescendantOfArrayField();
        }

        public String getArrayAncestorName() {
            if (!this.isChildField()) {
                return null;
            }
            if (this.m_parentMd.hasArrayDataType()) {
                return this.m_parentMd.getFullName();
            }
            return this.m_parentMd.getArrayAncestorName();
        }

        public boolean hasChildDocuments() {
            return this.m_childDocMetaData != null;
        }

        public DocumentsMetaData getChildMetaData() {
            return this.m_childDocMetaData != null ? this.m_childDocMetaData : sm_emptyFields;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("name: " + this.m_simpleName);
            buf.append("; full display name: " + this.getFullDisplayName());
            buf.append("; nativeDataTypes: " + this.m_nativeDataTypes);
            String parentName = this.m_parentMd != null ? this.m_parentMd.getFullDisplayName() : "null";
            buf.append("; parent field: " + parentName);
            buf.append("; child document metadata: " + this.m_childDocMetaData);
            return buf.toString();
        }
    }
}

