/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.contols;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.ClassSelectionButton;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.MenuButtonHelper;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.MenuButtonProvider;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.MenuButtonUtil;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.ClassPathsPageHelper;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.JarsSelectionDialog;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ClassPathElement;
import org.eclipse.birt.data.oda.pojo.ui.impl.providers.ClassPathTableProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;

public class POJOClassTabFolderPage {
    private ClassPathsPageHelper parent;
    private TableViewer classPathsTableViewer;
    private Button editBtn;
    private Button upBtn;
    private Button downBtn;
    private Button removeBtn;
    private ClassSelectionButton jarButton;
    private File resouceDir;
    private List<ClassPathElement> elements;
    private String promp;
    private String dataSetClassPath;
    private static String PATH_SEPARATOR = ";";
    private POJOClassTabFolderPage friendPage;
    private boolean defaultPathInitialized = true;

    public boolean isDefaultPathInitialized() {
        return this.defaultPathInitialized;
    }

    public void setDefaultPathInitialized() {
        this.defaultPathInitialized = false;
    }

    public TableViewer getClassPathsTableViewer() {
        return this.classPathsTableViewer;
    }

    public POJOClassTabFolderPage getTabFriendClassTabFolderPage() {
        return this.friendPage;
    }

    public void setFriendPage(POJOClassTabFolderPage friendPage) {
        this.friendPage = friendPage;
    }

    public POJOClassTabFolderPage(ClassPathsPageHelper parent, File resouceDir) {
        this.parent = parent;
        this.resouceDir = resouceDir;
    }

    public TabItem createContents(TabFolder tabFolder) {
        Composite page = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        page.setLayout((Layout)layout);
        page.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setControl((Control)page);
        this.createComposite(page);
        return tabItem;
    }

    public void setPrompMessage(String promp) {
        this.promp = promp;
    }

    private void createComposite(Composite page) {
        this.createLeftArea(page);
        this.createRightArea(page);
    }

    private void createLeftArea(Composite page) {
        Composite left = new Composite(page, 0);
        left.setLayout((Layout)new GridLayout(1, false));
        left.setLayoutData((Object)new GridData(1808));
        Label label = new Label(left, 0);
        label.setText(this.promp);
        this.classPathsTableViewer = new TableViewer(left, 68418);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.classPathsTableViewer.getTable().setLayoutData((Object)gd);
        this.classPathsTableViewer.getTable().setLinesVisible(false);
        ClassPathTableProvider provider = new ClassPathTableProvider();
        this.classPathsTableViewer.setContentProvider((IContentProvider)provider);
        this.classPathsTableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.classPathsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                POJOClassTabFolderPage.this.updateButtons();
            }
        });
        this.classPathsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                POJOClassTabFolderPage.this.doEdit();
            }
        });
    }

    private void createRightArea(Composite page) {
        Composite right = new Composite(page, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 30;
        right.setLayout((Layout)layout);
        right.setLayoutData((Object)new GridData(1808));
        this.createMenuButtons(right);
        new Label(right, 0);
        GridData data = new GridData(768);
        this.editBtn = new Button(right, 8);
        this.editBtn.setText(Messages.getString("DataSource.POJOClassTabFolderPage.button.edit"));
        this.editBtn.setLayoutData((Object)data);
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                POJOClassTabFolderPage.this.doEdit();
            }
        });
        this.removeBtn = new Button(right, 8);
        this.removeBtn.setText(Messages.getString("DataSource.POJOClassTabFolderPage.button.remove"));
        this.removeBtn.setLayoutData((Object)data);
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                POJOClassTabFolderPage.this.doRemoveItems();
            }
        });
        new Label(right, 0);
        this.upBtn = new Button(right, 8);
        this.upBtn.setText(Messages.getString("DataSource.POJOClassTabFolderPage.button.up"));
        this.upBtn.setLayoutData((Object)data);
        this.upBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                POJOClassTabFolderPage.this.doMoveUp();
            }
        });
        this.downBtn = new Button(right, 8);
        this.downBtn.setText(Messages.getString("DataSource.POJOClassTabFolderPage.button.down"));
        this.downBtn.setLayoutData((Object)data);
        this.downBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                POJOClassTabFolderPage.this.doMoveDown();
            }
        });
        this.resetButtonSize();
        this.updateButtons();
    }

    private void createMenuButtons(Composite right) {
        GridData data = new GridData(768);
        this.jarButton = MenuButtonUtil.createClassSelectionButton(this, right, this.classPathsTableViewer, new MenuButtonProvider(), null, 8);
        this.jarButton.getMenuButtonHelper().setProperty("ResourceFileDIR", this.resouceDir);
        this.jarButton.refreshMenuItems();
        this.jarButton.getControl().setLayoutData((Object)data);
        if (this.jarButton.getProvider().getMenuItems().length == 2) {
            this.jarButton.getControl().setToolTipText(Messages.getString("DataSource.button.tooltip.AddJar.TwoItems"));
        } else {
            this.jarButton.getControl().setToolTipText(Messages.getString("DataSource.button.tooltip.AddJar.OneItems"));
        }
    }

    private void resetButtonSize() {
        int maxWidth = 80;
        maxWidth = this.computeMaxWidth((Control)this.jarButton.getControl(), maxWidth);
        maxWidth = this.computeMaxWidth((Control)this.editBtn, maxWidth);
        maxWidth = this.computeMaxWidth((Control)this.removeBtn, maxWidth);
        maxWidth = this.computeMaxWidth((Control)this.upBtn, maxWidth);
        maxWidth = this.computeMaxWidth((Control)this.downBtn, maxWidth);
        GridData data = new GridData(768);
        data.widthHint = maxWidth;
        this.jarButton.getControl().setLayoutData((Object)data);
        this.editBtn.setLayoutData((Object)data);
        this.removeBtn.setLayoutData((Object)data);
        this.upBtn.setLayoutData((Object)data);
        this.downBtn.setLayoutData((Object)data);
    }

    private int computeMaxWidth(Control button, int size) {
        int widthHint = button.computeSize((int)-1, (int)-1).x - button.getBorderWidth();
        return widthHint > size ? widthHint : size;
    }

    private void updateButtons() {
        if (this.classPathsTableViewer.getTable().getSelectionCount() == 1) {
            this.editBtn.setEnabled(true);
            this.upBtn.setEnabled(this.classPathsTableViewer.getTable().getSelectionIndex() > 0);
            this.downBtn.setEnabled(this.classPathsTableViewer.getTable().getSelectionIndex() < this.classPathsTableViewer.getTable().getItemCount() - 1);
        } else {
            this.editBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        }
        this.removeBtn.setEnabled(this.classPathsTableViewer.getTable().getSelectionCount() > 0);
    }

    public void updateWizardPageStatus() {
        if (this.parent != null) {
            this.parent.updatePageStatus();
        }
    }

    public boolean canFinish() {
        return ((MenuButtonHelper)this.jarButton.getMenuButtonHelper()).getElementCount() > 0;
    }

    public void initClassPathElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<ClassPathElement>();
        } else {
            this.elements.clear();
        }
        ((MenuButtonHelper)this.jarButton.getMenuButtonHelper()).clearTableElementsList();
        if (this.dataSetClassPath != null && this.dataSetClassPath.trim().length() > 0) {
            String[] paths = this.dataSetClassPath.split(PATH_SEPARATOR);
            ClassPathElement[] classPathElements = new ClassPathElement[paths.length];
            int i = 0;
            while (i < paths.length) {
                ClassPathElement element;
                File file = new File(paths[i]);
                classPathElements[i] = element = new ClassPathElement(file.getName(), paths[i], !file.isAbsolute());
                this.elements.add(element);
                ++i;
            }
            this.jarButton.getMenuButtonHelper().addClassPathElements(classPathElements, true);
        }
        this.classPathsTableViewer.setInput(this.elements);
        this.classPathsTableViewer.refresh();
        this.updateWizardPageStatus();
    }

    private void doEdit() {
        if (this.classPathsTableViewer.getTable().getSelectionCount() != 1) {
            return;
        }
        ClassPathElement element = (ClassPathElement)this.classPathsTableViewer.getTable().getSelection()[0].getData();
        Object value = this.jarButton.getMenuButtonHelper().getPropertyValue("ResourceFileDIR");
        String[] fileNames = null;
        String rootPath = null;
        if (value != null && value instanceof File && element.isRelativePath()) {
            JarsSelectionDialog dialog = new JarsSelectionDialog(this.jarButton.getControl().getShell(), (File)value);
            dialog.setInitialSelection(element);
            if (dialog.open() == 0) {
                fileNames = dialog.getSelectedItems();
            }
        } else {
            FileDialog dialog = new FileDialog(this.jarButton.getControl().getShell(), 2);
            dialog.setFilterExtensions(new String[]{"*.jar; *.zip"});
            dialog.setFileName(element.getValue());
            if (dialog.open() != null) {
                fileNames = dialog.getFileNames();
                rootPath = dialog.getFilterPath();
            }
        }
        if (fileNames != null && fileNames.length > 0) {
            element.setValue(new File(fileNames[0]).getName());
            element.setFullPath(String.valueOf(fileNames[0]) + File.separator + rootPath);
            this.classPathsTableViewer.refresh();
            this.elements.remove(element);
            this.jarButton.handleSelection(fileNames, rootPath, element.isRelativePath());
        }
        this.updateWizardPageStatus();
    }

    private void doMoveUp() {
        int currentIndex;
        if (this.elements != null && (currentIndex = this.classPathsTableViewer.getTable().getSelectionIndex()) > 0) {
            ClassPathElement originalAboveElement = this.elements.get(currentIndex - 1);
            this.elements.set(currentIndex - 1, this.elements.get(currentIndex));
            this.elements.set(currentIndex, originalAboveElement);
            this.classPathsTableViewer.refresh();
            this.updateButtons();
        }
    }

    private void doMoveDown() {
        int currentIndex;
        if (this.elements != null && (currentIndex = this.classPathsTableViewer.getTable().getSelectionIndex()) < this.elements.size() - 1) {
            ClassPathElement originalAboveElement = this.elements.get(currentIndex + 1);
            this.elements.set(currentIndex + 1, this.elements.get(currentIndex));
            this.elements.set(currentIndex, originalAboveElement);
            this.classPathsTableViewer.refresh();
            this.updateButtons();
        }
    }

    private void doRemoveItems() {
        if (this.elements != null) {
            TableItem[] items = this.classPathsTableViewer.getTable().getSelection();
            int i = 0;
            while (i < items.length) {
                Object data = items[i].getData();
                if (data instanceof ClassPathElement) {
                    this.elements.remove((ClassPathElement)data);
                }
                ++i;
            }
            this.classPathsTableViewer.refresh();
            this.updateButtons();
            this.updateWizardPageStatus();
        }
    }

    public String getClassPathString() {
        StringBuilder result = new StringBuilder();
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.size()) {
                ClassPathElement element = this.elements.get(i);
                result.append(element.getFullPath()).append(PATH_SEPARATOR);
                ++i;
            }
        }
        return result.toString();
    }

    public void setClassPath(String dataSetClassPath) {
        this.dataSetClassPath = dataSetClassPath;
    }

    public void refresh() {
        if (this.elements != null) {
            this.elements.clear();
            this.classPathsTableViewer.refresh();
            ((MenuButtonHelper)this.jarButton.getMenuButtonHelper()).clearTableElementsList();
        } else {
            this.elements = new ArrayList<ClassPathElement>();
        }
        this.initClassPathElements();
    }
}

