/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.POJOClassTabFolderPage;
import org.eclipse.birt.data.oda.pojo.ui.util.HelpUtil;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.birt.data.oda.pojo.util.URLParser;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ClassPathsPageHelper {
    public static final String DEFAULT_MSG = Messages.getString("DataSource.PageMessage");
    private Properties props = new Properties();
    private WizardPage wizardPage;
    private ResourceIdentifiers ri;
    private Composite parent;
    private TabFolder tabFolder;
    private POJOClassTabFolderPage runtimePage;
    private POJOClassTabFolderPage designtimePage;
    private boolean needsRefresh = false;

    public ClassPathsPageHelper(ResourceIdentifiers ri) {
        this.ri = ri;
    }

    public void setWizardPage(WizardPage page) {
        this.wizardPage = page;
    }

    public void setResourceIdentifiers(ResourceIdentifiers ri) {
        this.ri = ri;
    }

    public Properties collectCustomProperties() {
        this.props.put("pojoDataSetClassPath", this.runtimePage.getClassPathString());
        this.props.put("pojoClassPath", this.designtimePage.getClassPathString());
        return this.props;
    }

    public void createPageCustomControl(Composite parent) {
        this.parent = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createTabFolderArea(composite);
        HelpUtil.setSystemHelp((Control)parent, "org.eclipse.birt.cshelp.Wizard_POJO_Datasource_ID");
    }

    private void createTabFolderArea(Composite composite) {
        Composite tabArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        tabArea.setLayout((Layout)layout);
        tabArea.setLayoutData((Object)new GridData(1808));
        this.tabFolder = new TabFolder(tabArea, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.runtimePage = new POJOClassTabFolderPage(this, this.getApplResourceDir());
        this.runtimePage.setPrompMessage(Messages.getString("DataSource.POJOClassTabFolderPage.promptLabel.runtime"));
        TabItem runtimeTab = this.runtimePage.createContents(this.tabFolder);
        runtimeTab.setText(Messages.getString("DataSource.POJOClasses.tab.runtime"));
        this.designtimePage = new POJOClassTabFolderPage(this, this.getApplResourceDir());
        this.designtimePage.setPrompMessage(Messages.getString("DataSource.POJOClassTabFolderPage.promptLabel.designtime"));
        TabItem designTimeTab = this.designtimePage.createContents(this.tabFolder);
        designTimeTab.setText(Messages.getString("DataSource.POJOClasses.tab.designTime"));
        this.runtimePage.setFriendPage(this.designtimePage);
        this.designtimePage.setFriendPage(this.runtimePage);
        this.initControlValues();
    }

    public void setInitialProperties(Properties dataSourceProps) {
        if (dataSourceProps != null) {
            this.props = dataSourceProps;
            this.needsRefresh = true;
        }
    }

    public void refresh() {
        if (this.needsRefresh && this.runtimePage != null && this.designtimePage != null) {
            String dataSetClassPath = this.props.getProperty("pojoDataSetClassPath");
            String pojoClassPath = this.props.getProperty("pojoClassPath");
            this.runtimePage.setClassPath(dataSetClassPath);
            this.designtimePage.setClassPath(pojoClassPath);
            this.runtimePage.refresh();
            this.designtimePage.refresh();
        }
        this.needsRefresh = false;
    }

    private void initControlValues() {
        if (this.runtimePage != null) {
            String dataSetClassPath = this.props.getProperty("pojoDataSetClassPath");
            String pojoClassPath = this.props.getProperty("pojoClassPath");
            this.runtimePage.setClassPath(dataSetClassPath);
            this.designtimePage.setClassPath(pojoClassPath);
            this.runtimePage.initClassPathElements();
            this.designtimePage.initClassPathElements();
        }
    }

    private File getApplResourceDir() {
        if (this.ri != null && this.ri.getApplResourceBaseURI() != null) {
            return new File(this.ri.getApplResourceBaseURI());
        }
        return null;
    }

    public void updatePageStatus() {
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(this.runtimePage.canFinish() || this.designtimePage.canFinish());
        }
    }

    protected Runnable createTestConnectionRunnable(final IConnectionProfile profile) {
        return new Runnable(){

            @Override
            public void run() {
                IConnection conn = PingJob.createTestConnection((IConnectionProfile)profile);
                Throwable exception = PingJob.getTestConnectionException((IConnection)conn);
                if (exception == null) {
                    exception = this.testConnection();
                }
                PingJob.PingUIJob.showTestConnectionMessage((Shell)ClassPathsPageHelper.this.parent.getShell(), (Throwable)exception);
                if (conn != null) {
                    conn.close();
                }
            }

            private Throwable testConnection() {
                Object exception = null;
                exception = ClassPathsPageHelper.this.runtimePage.getClassPathString().length() == 0 ? new OdaException(Messages.getString("DataSource.MissDataSetPojoClassPath.runtime")) : (ClassPathsPageHelper.this.designtimePage.getClassPathString().length() == 0 ? new OdaException(Messages.getString("DataSource.MissDataSetPojoClassPath.designtime")) : this.validateAllJars((Throwable)exception));
                return exception;
            }

            private Throwable validateAllJars(Throwable exception) {
                URL url;
                int n;
                int n2;
                URL[] uRLArray;
                URL[] urls;
                URLParser up = Utils.createURLParser(ClassPathsPageHelper.this.ri);
                try {
                    uRLArray = urls = up.parse(ClassPathsPageHelper.this.runtimePage.getClassPathString());
                    n2 = urls.length;
                    n = 0;
                    while (n < n2) {
                        url = uRLArray[n];
                        try {
                            url.openStream().close();
                        }
                        catch (IOException iOException) {
                            throw new OdaException(Messages.getFormattedString("DataSource.ClassPathPage.testConnection.failed.runtime", new Object[]{url.getFile()}));
                        }
                        ++n;
                    }
                }
                catch (OdaException e1) {
                    exception = e1;
                }
                if (exception != null) {
                    return exception;
                }
                try {
                    uRLArray = urls = up.parse(ClassPathsPageHelper.this.designtimePage.getClassPathString());
                    n2 = urls.length;
                    n = 0;
                    while (n < n2) {
                        url = uRLArray[n];
                        try {
                            url.openStream().close();
                        }
                        catch (IOException iOException) {
                            throw new OdaException(Messages.getFormattedString("DataSource.ClassPathPage.testConnection.failed.designtime", new Object[]{url.getFile()}));
                        }
                        ++n;
                    }
                }
                catch (OdaException e1) {
                    exception = e1;
                }
                return exception;
            }
        };
    }
}

