/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.CubeCreationQueryDefinition;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.MemoryUsageSetting;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeElementFactory;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeMaterializer;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IColumnValueIterator;
import org.eclipse.birt.report.data.adapter.api.ICubeInterceptor;
import org.eclipse.birt.report.data.adapter.api.ICubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.IDataSetInterceptor;
import org.eclipse.birt.report.data.adapter.api.IFilterUtil;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IQueryDefinitionUtil;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.data.adapter.group.GroupCalculatorFactory;
import org.eclipse.birt.report.data.adapter.i18n.AdapterResourceHandle;
import org.eclipse.birt.report.data.adapter.impl.ColumnValueIterator;
import org.eclipse.birt.report.data.adapter.impl.CubeHandleUtil;
import org.eclipse.birt.report.data.adapter.impl.CubeInterceptorFinder;
import org.eclipse.birt.report.data.adapter.impl.CubeMeasureUtil;
import org.eclipse.birt.report.data.adapter.impl.CubeQueryUtil;
import org.eclipse.birt.report.data.adapter.impl.DataModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.DataSessionConfig;
import org.eclipse.birt.report.data.adapter.impl.DataSetInterceptorFinder;
import org.eclipse.birt.report.data.adapter.impl.DataSetIterator;
import org.eclipse.birt.report.data.adapter.impl.DataSetIteratorForTempPK;
import org.eclipse.birt.report.data.adapter.impl.DataSetMetaDataHelper;
import org.eclipse.birt.report.data.adapter.impl.DefineDataSourceSetUtil;
import org.eclipse.birt.report.data.adapter.impl.FilterUtil;
import org.eclipse.birt.report.data.adapter.impl.QueryAdapter;
import org.eclipse.birt.report.data.adapter.impl.QueryDefinitionUtil;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.data.adapter.impl.QueryValidator;
import org.eclipse.birt.report.data.adapter.impl.SecurityListener;
import org.eclipse.birt.report.data.adapter.internal.adapter.GroupAdapter;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRequestSessionImpl
extends DataRequestSession {
    private static Logger logger = Logger.getLogger(DataRequestSessionImpl.class.getName());
    private DataEngineImpl dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;
    private Map cubeHandleMap;
    private Map cubeMetaDataHandleMap;
    private Map<ReportElementHandle, QueryDefinition> cubeQueryMap = new HashMap<ReportElementHandle, QueryDefinition>();
    private Map<ReportElementHandle, List<DataSetIterator.ColumnMeta>> cubeMetaMap = new HashMap<ReportElementHandle, List<DataSetIterator.ColumnMeta>>();
    private Map<String, IDimension> createdDimensions;
    private CubeMaterializer cubeMaterializer;

    private CubeMaterializer getCubeMaterializer(int cacheSize) throws BirtException {
        if (this.cubeMaterializer == null) {
            try {
                this.cubeMaterializer = new CubeMaterializer(this.dataEngine, String.valueOf(this.dataEngine.hashCode()), cacheSize);
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.cubeMaterializer;
    }

    public DataRequestSessionImpl(DataSessionContext context) throws BirtException {
        if (context == null) {
            throw new AdapterException("context.null.error");
        }
        this.dataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context.getDataEngineContext());
        this.modelAdaptor = new DataModelAdapter(context);
        this.sessionContext = context;
        this.cubeHandleMap = new HashMap();
        this.cubeMetaDataHandleMap = new HashMap();
        this.createdDimensions = new HashMap<String, IDimension>();
        if (this.sessionContext != null) {
            this.setModuleHandleToAppContext();
        }
        DataSessionConfig.startup(this);
    }

    @Override
    public void defineDataSource(IBaseDataSourceDesign design) throws BirtException {
        this.dataEngine.defineDataSource(design);
    }

    @Override
    public void defineDataSet(IBaseDataSetDesign design) throws BirtException {
        IDataSetInterceptor dataSetInterceptor = DataSetInterceptorFinder.find(design);
        if (dataSetInterceptor != null) {
            dataSetInterceptor.preDefineDataSet(this.sessionContext, this.dataEngine.getDataSourceDesign(design.getDataSourceName()), design, null);
        }
        this.dataEngine.defineDataSet(design);
    }

    @Override
    public IResultMetaData getDataSetMetaData(String dataSetName, boolean useCache) throws BirtException {
        return this.getDataSetMetaData(this.sessionContext.getModuleHandle().findDataSet(dataSetName), useCache);
    }

    @Override
    public IResultMetaData getDataSetMetaData(DataSetHandle dataSetHandle, boolean useCache) throws BirtException {
        return new DataSetMetaDataHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext, this).getDataSetMetaData(dataSetHandle, useCache);
    }

    @Override
    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        return this.getColumnValueSet(dataSet, inputParamBindings, columnBindings, boundColumnName, null);
    }

    @Override
    public IColumnValueIterator getColumnValueIterator(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        return this.getColumnValueIterator(dataSet, inputParamBindings, columnBindings, null, boundColumnName, true, null);
    }

    private IColumnValueIterator getColumnValueIterator(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, Iterator groupDefn, String boundColumnName, boolean useDataSetFilter, IRequestInfo requestInfo) throws BirtException {
        IQueryResults queryResults = this.getQueryResults(dataSet, inputParamBindings, columnBindings, groupDefn, boundColumnName, useDataSetFilter);
        return new ColumnValueIterator(queryResults, boundColumnName, requestInfo);
    }

    @Override
    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName, IRequestInfo requestInfo) throws BirtException {
        IColumnValueIterator columnValueIterator = this.getColumnValueIterator(dataSet, inputParamBindings, columnBindings, null, boundColumnName, true, requestInfo);
        ArrayList<Object> values = new ArrayList<Object>();
        do {
            values.add(columnValueIterator.getValue());
        } while (columnValueIterator.next());
        columnValueIterator.close();
        return values;
    }

    @Override
    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, Iterator groupDefns, String boundColumnName, IRequestInfo requestInfo) throws BirtException {
        IColumnValueIterator columnValueIterator = this.getColumnValueIterator(dataSet, inputParamBindings, columnBindings, groupDefns, boundColumnName, true, requestInfo);
        ArrayList<Object> values = new ArrayList<Object>();
        do {
            values.add(columnValueIterator.getValue());
        } while (columnValueIterator.next());
        columnValueIterator.close();
        return values;
    }

    @Override
    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, Iterator groupDefns, String boundColumnName, boolean useDataSetFilter, IRequestInfo requestInfo) throws BirtException {
        IColumnValueIterator columnValueIterator = this.getColumnValueIterator(dataSet, inputParamBindings, columnBindings, groupDefns, boundColumnName, useDataSetFilter, requestInfo);
        ArrayList<Object> values = new ArrayList<Object>();
        do {
            values.add(columnValueIterator.getValue());
        } while (columnValueIterator.next());
        columnValueIterator.close();
        return values;
    }

    @Override
    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle) throws BirtException {
        return new DataSetMetaDataHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext, this).refreshMetaData(dataSetHandle);
    }

    @Override
    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle, boolean holdEvent) throws BirtException {
        return new DataSetMetaDataHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext, this).refreshMetaData(dataSetHandle, holdEvent);
    }

    @Override
    public IQueryResults executeQuery(IQueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt) throws BirtException {
        return new QueryExecutionHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext, this).executeQuery(queryDefn, paramBindingIt, filterIt, bindingIt, this.sessionContext.getTopScope());
    }

    @Override
    public IQueryResults getQueryResults(String queryResultID) throws BirtException {
        return this.dataEngine.getQueryResults(queryResultID);
    }

    @Override
    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        this.dataEngine.clearCache(dataSource, dataSet);
    }

    @Override
    public void clearCache(String cacheID) throws BirtException {
        this.dataEngine.clearCache(cacheID);
    }

    @Override
    public IPreparedQuery prepare(IQueryDefinition query, Map appContext) throws BirtException {
        QueryAdapter.adaptQuery((IDataQueryDefinition)query);
        this.defineDataSourceDataSet(query);
        if (appContext == null) {
            appContext = this.sessionContext.getAppContext();
        }
        this.setModuleHandleToAppContext(appContext);
        return this.dataEngine.prepare(query, appContext);
    }

    @Override
    public IPreparedQuery prepare(IQueryDefinition query) throws BirtException {
        return this.prepare(query, null);
    }

    @Override
    public void closeDataSource(String dataSourceName) throws BirtException {
        this.dataEngine.closeDataSource(dataSourceName);
    }

    @Override
    public IModelAdapter getModelAdaptor() {
        return this.modelAdaptor;
    }

    @Override
    public void shutdown() {
        if (this.cubeMaterializer != null) {
            try {
                this.cubeMaterializer.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        DataSessionConfig.finalize(this);
        if (this.dataEngine != null) {
            this.dataEngine.shutdown();
            this.dataEngine = null;
        }
    }

    private IQueryResults getQueryResults(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, Iterator groupDefns, String boundColumnName, boolean useDataSetFilter) throws BirtException {
        assert (dataSet != null);
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataSet.getQualifiedName());
        if (columnBindings == null || !columnBindings.hasNext()) {
            query.setAutoBinding(true);
            useDataSetFilter = false;
        }
        if (groupDefns != null) {
            while (groupDefns.hasNext()) {
                GroupHandle groupHandle = (GroupHandle)groupDefns.next();
                query.addGroup(this.modelAdaptor.adaptGroup(groupHandle));
            }
        }
        QueryExecutionHelper execHelper = new QueryExecutionHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext, this);
        IQueryResults results = execHelper.executeQuery((IQueryDefinition)query, inputParamBindings, null, columnBindings, useDataSetFilter, false, this.sessionContext.getTopScope());
        return results;
    }

    @Override
    public IBaseQueryResults execute(IBasePreparedQuery query, IBaseQueryResults outerResults, Scriptable scope) throws AdapterException {
        try {
            if (query instanceof IPreparedQuery) {
                return ((IPreparedQuery)query).execute(outerResults, scope);
            }
            if (query instanceof IPreparedCubeQuery) {
                String queryName = ((IPreparedCubeQuery)query).getCubeQueryDefinition().getName();
                if (this.cubeHandleMap.get(queryName) != null) {
                    this.materializeCube((CubeHandle)this.cubeHandleMap.get(queryName), this.sessionContext.getAppContext());
                    this.cubeHandleMap.remove(queryName);
                }
                return ((IPreparedCubeQuery)query).execute(outerResults, scope);
            }
            return null;
        }
        catch (BirtException e) {
            throw new AdapterException("exception.error", e);
        }
    }

    @Override
    public IBaseQueryResults execute(IBasePreparedQuery query, IBaseQueryResults outerResults, ScriptContext context) throws AdapterException {
        try {
            IDataScriptEngine engine = (IDataScriptEngine)context.getScriptEngine("javascript");
            Scriptable scope = engine.getJSScope(context);
            if (query instanceof IPreparedQuery) {
                return ((IPreparedQuery)query).execute(outerResults, scope);
            }
            if (query instanceof IPreparedCubeQuery) {
                String queryName = ((IPreparedCubeQuery)query).getCubeQueryDefinition().getName();
                if (this.cubeHandleMap.get(queryName) != null) {
                    this.materializeCube((CubeHandle)this.cubeHandleMap.get(queryName), this.sessionContext.getAppContext());
                    this.cubeHandleMap.remove(queryName);
                }
                return ((IPreparedCubeQuery)query).execute(outerResults, scope);
            }
            return null;
        }
        catch (BirtException e) {
            throw new AdapterException("exception.error", e);
        }
    }

    @Override
    public IBasePreparedQuery prepare(IDataQueryDefinition query, Map appContext) throws AdapterException {
        try {
            this.setModuleHandleToAppContext(appContext);
            if (query instanceof IQueryDefinition) {
                return this.prepare((IQueryDefinition)query, appContext == null ? this.sessionContext.getAppContext() : appContext);
            }
            if (query instanceof ICubeQueryDefinition) {
                return this.prepare((ICubeQueryDefinition)query, appContext == null ? this.sessionContext.getAppContext() : appContext);
            }
            if (query instanceof ISubCubeQueryDefinition) {
                return this.prepare((ISubCubeQueryDefinition)query, appContext == null ? this.sessionContext.getAppContext() : appContext);
            }
            return null;
        }
        catch (BirtException e) {
            throw new AdapterException("exception.error", e);
        }
    }

    @Override
    public void defineCube(CubeHandle cubeHandle) throws BirtException {
        CubeHandleUtil.defineCube(this.dataEngine, cubeHandle, this.sessionContext.getAppContext());
        this.cubeMetaDataHandleMap.put(cubeHandle.getQualifiedName(), cubeHandle);
        ICubeInterceptor cubeInterceptor = CubeInterceptorFinder.find(cubeHandle);
        if (cubeInterceptor != null) {
            cubeInterceptor.preDefineCube(this.sessionContext, cubeHandle);
        }
        if (cubeInterceptor == null || cubeInterceptor.needDefineCube()) {
            if (!(cubeHandle instanceof TabularCubeHandle)) {
                return;
            }
            Set involvedDataSets = this.getInvolvedDataSets((TabularCubeHandle)cubeHandle);
            for (DataSetHandle dsHandle : involvedDataSets) {
                BaseDataSourceDesign baseDataSource = this.modelAdaptor.adaptDataSource(dsHandle.getDataSource());
                BaseDataSetDesign baseDataSet = this.modelAdaptor.adaptDataSet(dsHandle);
                if (baseDataSource != null && this.dataEngine.getDataSourceRuntime(baseDataSource.getName()) == null) {
                    this.defineDataSource((IBaseDataSourceDesign)baseDataSource);
                }
                if (this.dataEngine.getDataSetDesign(baseDataSet.getName()) != null) continue;
                DefineDataSourceSetUtil.defineDataSourceAndDataSet(dsHandle, this);
            }
            if (!this.cubeHandleMap.containsKey(cubeHandle.getQualifiedName())) {
                this.cubeHandleMap.put(cubeHandle.getQualifiedName(), cubeHandle);
            }
            this.prepareForCubeGeneration((CubeHandle)((TabularCubeHandle)cubeHandle));
        }
    }

    void materializeCube(CubeHandle cubeHandle, Map appContext) throws BirtException {
        CubeMeasureUtil.validateDerivedMeasures(cubeHandle);
        int mode = this.sessionContext.getDataEngineContext().getMode();
        try {
            if (appContext == null) {
                appContext = this.sessionContext.getAppContext();
            }
            String memoryUsage = (String)appContext.get(DataEngine.MEMORY_USAGE);
            MemoryUsageSetting.setMemoryUsage((String)memoryUsage);
            if (mode == 3) {
                Integer value;
                int size = 0;
                if (appContext != null && (value = DataTypeUtil.toInteger(appContext.get(DataEngine.IN_MEMORY_CUBE_SIZE))) != null && value > 0) {
                    size = value;
                }
                CubeMaterializer cm = this.getCubeMaterializer(size);
                this.createCube((TabularCubeHandle)cubeHandle, cm, appContext);
            } else if (mode == 1) {
                CubeMaterializer cm = this.getCubeMaterializer(0);
                this.createCube((TabularCubeHandle)cubeHandle, cm, appContext);
                cm.saveCubeToReportDocument(cubeHandle.getQualifiedName(), this.sessionContext.getDocumentWriter(), this.dataEngine.getSession().getStopSign());
            }
        }
        catch (Exception e) {
            throw new DataException("exception.error", (Throwable)e);
        }
    }

    private void createCube(TabularCubeHandle cubeHandle, CubeMaterializer cubeMaterializer, Map appContext) throws BirtException {
        SecurityListener sl = new SecurityListener(this);
        sl.start(cubeHandle);
        HashMap backupAppContext = new HashMap();
        if (appContext == null) {
            appContext = new HashMap();
        }
        backupAppContext.putAll(appContext);
        ArrayList<String> measureNames = new ArrayList<String>();
        HashMap<String, Integer> calculatedMeasure = new HashMap<String, Integer>();
        List measureGroups = cubeHandle.getContents("measureGroups");
        int i = 0;
        while (i < measureGroups.size()) {
            MeasureGroupHandle mgh = (MeasureGroupHandle)measureGroups.get(i);
            List measures = mgh.getContents("measures");
            int j = 0;
            while (j < measures.size()) {
                MeasureHandle measure = (MeasureHandle)measures.get(j);
                if (!measure.isCalculated()) {
                    measureNames.add(measure.getName());
                } else {
                    calculatedMeasure.put(measure.getName(), DataAdapterUtil.adaptModelDataType(measure.getDataType()));
                }
                ++j;
            }
            ++i;
        }
        IDimension[] dimensions = this.populateDimensions(cubeMaterializer, cubeHandle, appContext, sl);
        String[][] factTableKey = new String[dimensions.length][];
        String[][] dimensionKey = new String[dimensions.length][];
        boolean fromJoin = false;
        int i2 = 0;
        while (i2 < dimensions.length) {
            DimensionHandle dim = cubeHandle.getDimension(dimensions[i2].getName());
            TabularHierarchyHandle tabularHierarchyHandle = (TabularHierarchyHandle)dim.getDefaultHierarchy();
            DimensionJoinConditionHandle dimensionJoinConditionHandle = this.getFacttableJointKey(cubeHandle, tabularHierarchyHandle);
            if (cubeHandle.getDataSet().equals(tabularHierarchyHandle.getDataSet()) || tabularHierarchyHandle.getDataSet() == null || this.isDateTimeDimension(tabularHierarchyHandle) && this.existColumnName(tabularHierarchyHandle, dimensionJoinConditionHandle.getHierarchyKey())) {
                String[] keyNames = dimensions[i2].getHierarchy().getLevels()[dimensions[i2].getHierarchy().getLevels().length - 1].getKeyNames();
                factTableKey[i2] = new String[keyNames.length];
                dimensionKey[i2] = new String[keyNames.length];
                int j = 0;
                while (j < keyNames.length) {
                    factTableKey[i2][j] = String.valueOf(dim.getName()) + "/" + keyNames[j];
                    dimensionKey[i2][j] = keyNames[j];
                    ++j;
                }
            } else {
                fromJoin = true;
                Iterator it = cubeHandle.joinConditionsIterator();
                if (!it.hasNext()) {
                    throw new AdapterException("missing.join.condition", new String[]{cubeHandle.getDataSet().getName(), dim.getName(), cubeHandle.getName()});
                }
                boolean foundJoinCondition = false;
                while (it.hasNext()) {
                    DimensionConditionHandle dimCondHandle = (DimensionConditionHandle)it.next();
                    if (!dimCondHandle.getHierarchy().getName().equals(tabularHierarchyHandle.getName())) continue;
                    Iterator conditionIt = dimCondHandle.getJoinConditions().iterator();
                    ArrayList<String> dimensionKeys = new ArrayList<String>();
                    ArrayList<String> factTableKeys = new ArrayList<String>();
                    while (conditionIt.hasNext()) {
                        foundJoinCondition = true;
                        DimensionJoinConditionHandle joinCondition = (DimensionJoinConditionHandle)conditionIt.next();
                        String levelName = joinCondition.getLevelName();
                        if (levelName != null && this.isAttribute(dimensions[i2], levelName, joinCondition.getHierarchyKey())) {
                            dimensionKeys.add(OlapExpressionUtil.getAttributeColumnName((String)this.getLevelName(dimensions[i2], levelName), (String)joinCondition.getHierarchyKey()));
                        } else {
                            String existLevelName = this.getLevelName(tabularHierarchyHandle, joinCondition.getHierarchyKey());
                            if (existLevelName != null) {
                                dimensionKeys.add(existLevelName);
                            } else {
                                dimensionKeys.add(this.getDummyLevelNameForJointHierarchyKey(joinCondition.getHierarchyKey()));
                            }
                        }
                        factTableKeys.add(OlapExpressionUtil.getQualifiedLevelName((String)dimensions[i2].getName(), (String)joinCondition.getCubeKey()));
                    }
                    factTableKey[i2] = new String[factTableKeys.size()];
                    dimensionKey[i2] = new String[dimensionKeys.size()];
                    int j = 0;
                    while (j < dimensionKeys.size()) {
                        factTableKey[i2][j] = factTableKeys.get(j).toString();
                        dimensionKey[i2][j] = dimensionKeys.get(j).toString();
                        ++j;
                    }
                }
                if (!foundJoinCondition) {
                    throw new AdapterException("missing.join.condition", dim.getName());
                }
            }
            ++i2;
        }
        DataSetIterator dataForCube = null;
        if (cubeHandle.autoPrimaryKey()) {
            QueryDefinition qd = this.cubeQueryMap.get(cubeHandle);
            for (Object e : measureNames) {
                IBinding b = (IBinding)qd.getBindings().get(e);
                if (b == null) continue;
                b.setAggrFunction(null);
                if (b.getAggregatOns() == null) continue;
                b.getAggregatOns().clear();
            }
            if (!fromJoin) {
                List<DataSetIterator.ColumnMeta> list = this.cubeMetaMap.get(cubeHandle);
                Binding binding = new Binding(DataSetIterator.createLevelName(DataRequestSessionImpl.getCubeTempPKDimensionName(cubeHandle), DataRequestSessionImpl.getCubeTempPKFieldName(cubeHandle)), (IBaseExpression)new ScriptExpression("row.__rownum"));
                qd.addBinding((IBinding)binding);
                DataSetIterator.ColumnMeta cm = new DataSetIterator.ColumnMeta(binding.getBindingName(), null, 1);
                cm.setDataType(2);
                list.add(cm);
                String countBindingName = "COUNT";
                Binding b = new Binding(countBindingName);
                b.setAggrFunction("COUNT");
                QueryDefinition q = this.cubeQueryMap.get(cubeHandle);
                q.addBinding((IBinding)b);
                dataForCube = new DataSetIterator(this, (IQueryDefinition)this.cubeQueryMap.get(cubeHandle), this.cubeMetaMap.get(cubeHandle), appContext);
                int rowCount = 0;
                try {
                    rowCount = dataForCube.getSummaryInt(countBindingName);
                }
                catch (BirtException birtException) {
                    rowCount = 1;
                }
                dimensions = DataRequestSessionImpl.appendArray(dimensions, this.populateTempPKDimension(cubeMaterializer, cubeHandle, new DataSetIteratorForTempPK(rowCount), appContext));
                factTableKey = DataRequestSessionImpl.appendArray(factTableKey, new String[]{DataSetIterator.createLevelName(DataRequestSessionImpl.getCubeTempPKDimensionName(cubeHandle), DataRequestSessionImpl.getCubeTempPKFieldName(cubeHandle))});
                dimensionKey = DataRequestSessionImpl.appendArray(dimensionKey, new String[]{DataRequestSessionImpl.getCubeTempPKFieldName(cubeHandle)});
            }
            if (dataForCube == null) {
                dataForCube = new DataSetIterator(this, (IQueryDefinition)this.cubeQueryMap.get(cubeHandle), this.cubeMetaMap.get(cubeHandle), appContext);
            }
        }
        try {
            try {
                ArrayList<String> measureAggrFunctions = new ArrayList<String>();
                if (dataForCube == null) {
                    QueryDefinition queryDefinition = this.cubeQueryMap.get(cubeHandle);
                    for (Object e : measureNames) {
                        IBinding b = (IBinding)queryDefinition.getBindings().get(e);
                        assert (b != null && b.getAggrFunction() != null);
                        measureAggrFunctions.add(b.getAggrFunction());
                        if (("COUNT".equalsIgnoreCase(b.getAggrFunction()) || "COUNTDISTINCT".equalsIgnoreCase(b.getAggrFunction())) && b.getExpression() == null) {
                            b.setExpression((IBaseExpression)new ScriptExpression("1"));
                        }
                        if (b.getExpression() == null || ((ScriptExpression)b.getExpression()).getText() == null) {
                            throw new AdapterException("invalid.measure.expression", e);
                        }
                        b.setAggrFunction(null);
                        if (b.getAggregatOns() == null) continue;
                        b.getAggregatOns().clear();
                    }
                    queryDefinition.getGroups().clear();
                    dataForCube = new DataSetIterator(this, (IQueryDefinition)queryDefinition, this.cubeMetaMap.get(cubeHandle), appContext);
                }
                cubeMaterializer.createCube(cubeHandle.getQualifiedName(), factTableKey, dimensionKey, dimensions, (IDatasetIterator)dataForCube, this.toStringArray(measureNames), calculatedMeasure, this.toStringArray(measureAggrFunctions), DataRequestSessionImpl.computeMemoryBufferSize(appContext), this.dataEngine.getSession().getStopSign());
            }
            catch (Exception e) {
                throw new AdapterException("cube.error.createmeasure", e);
            }
        }
        finally {
            if (dataForCube != null) {
                dataForCube.close();
            }
        }
        sl.end();
        appContext.clear();
        appContext.putAll(backupAppContext);
    }

    public static long computeMemoryBufferSize(Map appContext) {
        if (appContext == null) {
            return 0L;
        }
        return DataRequestSessionImpl.populateMemBufferSize(appContext.get(DataEngine.MEMORY_BUFFER_SIZE)) * 1024L * 1024L;
    }

    private static long populateMemBufferSize(Object propValue) {
        String targetBufferSize = propValue == null ? "0" : propValue.toString();
        long memoryCacheSize = 0L;
        if (targetBufferSize != null) {
            memoryCacheSize = Long.parseLong(targetBufferSize);
        }
        return memoryCacheSize;
    }

    private String getLevelName(TabularHierarchyHandle hierhandle, String columnName) {
        List levels = hierhandle.getContents("levels");
        int k = 0;
        while (k < levels.size()) {
            TabularLevelHandle level = (TabularLevelHandle)levels.get(k);
            if (columnName.equals(level.getColumnName())) {
                return level.getName();
            }
            ++k;
        }
        return null;
    }

    private void prepareForCubeGeneration(CubeHandle cHandle) throws BirtException {
        TabularCubeHandle cubeHandle = null;
        if (cHandle instanceof TabularCubeHandle) {
            cubeHandle = (TabularCubeHandle)cHandle;
        }
        ArrayList<QueryDefinition> queryDefns = new ArrayList<QueryDefinition>();
        ArrayList<DataSetIterator.ColumnMeta> metaList = new ArrayList<DataSetIterator.ColumnMeta>();
        QueryDefinition query = this.createQuery(this, cubeHandle, metaList);
        if (cubeHandle.autoPrimaryKey()) {
            query.setUsesDetails(true);
            query.getGroups().clear();
        }
        queryDefns.add(query);
        this.cubeQueryMap.put((ReportElementHandle)cubeHandle, query);
        this.cubeMetaMap.put((ReportElementHandle)cubeHandle, metaList);
        List dimHandles = cubeHandle.getContents("dimensions");
        for (DimensionHandle dim : dimHandles) {
            List hiers = dim.getContents("hierarchies");
            for (TabularHierarchyHandle hier : hiers) {
                String columnForDeepestLevel = null;
                List levels = hier.getContents("levels");
                if (levels.size() >= 1) {
                    TabularLevelHandle level = (TabularLevelHandle)levels.get(levels.size() - 1);
                    columnForDeepestLevel = level.getColumnName();
                }
                metaList = new ArrayList();
                query = this.createDimensionQuery(this, dim, hier, metaList, String.valueOf(cubeHandle.getElement().getID()));
                Object[] jointHierarchyKeys = this.getJointHierarchyKeys(cubeHandle, hier);
                if (cubeHandle.autoPrimaryKey() && jointHierarchyKeys.length > 0) {
                    if (!Arrays.deepEquals(jointHierarchyKeys, new String[]{columnForDeepestLevel})) {
                        Object[] objectArray = jointHierarchyKeys;
                        int n = jointHierarchyKeys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object key = objectArray[n2];
                            String exprString = ExpressionUtil.createJSDataSetRowExpression((String)key);
                            query.addBinding((IBinding)new Binding(this.getDummyLevelNameForJointHierarchyKey((String)key), (IBaseExpression)new ScriptExpression(exprString)));
                            DataSetIterator.ColumnMeta temp = new DataSetIterator.ColumnMeta(this.getDummyLevelNameForJointHierarchyKey((String)key), null, 1);
                            temp.setDataType(DataRequestSessionImpl.getColumnDataType(hier.getDataSet(), (String)key));
                            metaList.add(temp);
                            ++n2;
                        }
                    }
                    query.setUsesDetails(true);
                    query.getGroups().clear();
                }
                queryDefns.add(query);
                this.cubeQueryMap.put((ReportElementHandle)hier, query);
                this.cubeMetaMap.put((ReportElementHandle)hier, metaList);
            }
        }
        this.dataEngine.registerQueries(queryDefns.toArray(new IDataQueryDefinition[0]));
    }

    private FilterDefinition buildFilterForTimeDimension(DimensionHandle dim, TabularHierarchyHandle hier) throws BirtException {
        Date startTime = CubeHandleUtil.getStartTime(dim);
        Date endTime = CubeHandleUtil.getEndTime(dim);
        if (startTime == null && endTime == null) {
            return null;
        }
        List levels = hier.getContents("levels");
        TabularLevelHandle level = (TabularLevelHandle)levels.get(levels.size() - 1);
        FilterDefinition filter = null;
        String exprString = ExpressionUtil.createJSDataSetRowExpression((String)level.getColumnName());
        if (startTime != null && endTime != null) {
            ConditionalExpression expr = new ConditionalExpression(exprString, 7, JavascriptEvalUtil.transformToJsExpression((String)DataTypeUtil.toLocaleNeutralString((Object)startTime)), JavascriptEvalUtil.transformToJsExpression((String)DataTypeUtil.toLocaleNeutralString((Object)endTime)));
            filter = new FilterDefinition((IBaseExpression)expr);
        } else if (startTime != null) {
            ConditionalExpression expr = new ConditionalExpression(exprString, 5, JavascriptEvalUtil.transformToJsExpression((String)DataTypeUtil.toLocaleNeutralString((Object)startTime)));
            filter = new FilterDefinition((IBaseExpression)expr);
        } else if (endTime != null) {
            ConditionalExpression expr = new ConditionalExpression(exprString, 4, JavascriptEvalUtil.transformToJsExpression((String)DataTypeUtil.toLocaleNeutralString((Object)endTime)));
            filter = new FilterDefinition((IBaseExpression)expr);
        }
        return filter;
    }

    private List getDataSetsToCache(TabularCubeHandle cubeHandle) {
        ArrayList<DataSetHandle> list = new ArrayList<DataSetHandle>();
        if (cubeHandle.getDataSet() == null) {
            return list;
        }
        list.add(cubeHandle.getDataSet());
        List dimHandles = cubeHandle.getContents("dimensions");
        int i = 0;
        while (i < dimHandles.size()) {
            DimensionHandle dimHandle = (DimensionHandle)dimHandles.get(i);
            List hiers = dimHandle.getContents("hierarchies");
            TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)hiers.get(0);
            if (hierHandle.getDataSet() != null) {
                list.add(hierHandle.getDataSet());
            } else {
                list.add(cubeHandle.getDataSet());
            }
            ++i;
        }
        return list;
    }

    private Set getInvolvedDataSets(TabularCubeHandle cubeHandle) {
        return new HashSet(this.getDataSetsToCache(cubeHandle));
    }

    private boolean isAttribute(IDimension dimension, String levelName, String colName) {
        ILevel[] levels = dimension.getHierarchy().getLevels();
        int j = 0;
        while (j < levels.length) {
            String[] attributes;
            if (levelName.equals(OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)levels[j].getName())) && (attributes = levels[j].getAttributeNames()) != null) {
                int k = 0;
                while (k < attributes.length) {
                    if (attributes[k].equals(OlapExpressionUtil.getAttributeColumnName((String)levels[j].getName(), (String)colName))) {
                        return true;
                    }
                    ++k;
                }
            }
            ++j;
        }
        return false;
    }

    private String getLevelName(IDimension dimension, String targetName) {
        ILevel[] levels = dimension.getHierarchy().getLevels();
        int j = 0;
        while (j < levels.length) {
            if (targetName.equals(OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)levels[j].getName()))) {
                return levels[j].getName();
            }
            ++j;
        }
        return targetName;
    }

    private IDimension[] populateDimensions(CubeMaterializer cubeMaterializer, TabularCubeHandle cubeHandle, Map appContext, SecurityListener sl) throws AdapterException {
        List dimHandles = cubeHandle.getContents("dimensions");
        ArrayList<IDimension> result = new ArrayList<IDimension>();
        int i = 0;
        while (i < dimHandles.size()) {
            DimensionHandle dh = (DimensionHandle)dimHandles.get(i);
            IDimension dim = this.createdDimensions.get(dh.getName());
            if (dim == null) {
                dim = this.populateDimension(cubeMaterializer, dh, cubeHandle, appContext, sl);
                this.createdDimensions.put(dh.getName(), dim);
            }
            result.add(dim);
            ++i;
        }
        IDimension[] dimArray = new IDimension[dimHandles.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            dimArray[i2] = (IDimension)result.get(i2);
            ++i2;
        }
        return dimArray;
    }

    private IDimension populateDimension(CubeMaterializer cubeMaterializer, DimensionHandle dim, TabularCubeHandle cubeHandle, Map appContext, SecurityListener sl) throws AdapterException {
        List hiers = dim.getContents("hierarchies");
        ArrayList<IHierarchy> iHiers = new ArrayList<IHierarchy>();
        int j = 0;
        while (j < hiers.size()) {
            LevelAttributeHandle levelAttr;
            TabularHierarchyHandle hierhandle = (TabularHierarchyHandle)hiers.get(0);
            List levels = hierhandle.getContents("levels");
            ArrayList<ILevelDefn> levelInHier = new ArrayList<ILevelDefn>();
            ArrayList<String> leafLevelKeyColumn = new ArrayList<String>();
            HashSet<String> columnNamesForLevels = new HashSet<String>();
            int k = 0;
            while (k < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(k);
                columnNamesForLevels.add(level.getColumnName());
                ArrayList<String> levelAttrs = new ArrayList<String>();
                Iterator it = level.attributesIterator();
                while (it.hasNext()) {
                    levelAttr = (LevelAttributeHandle)it.next();
                    levelAttrs.add(OlapExpressionUtil.getAttributeColumnName((String)level.getName(), (String)levelAttr.getName()));
                }
                if ("dynamic".equals(level.getLevelType()) && level.getDisplayColumnName() != null) {
                    levelAttrs.add(OlapExpressionUtil.getDisplayColumnName((String)level.getName()));
                }
                leafLevelKeyColumn.add(level.getName());
                levelInHier.add(CubeElementFactory.createLevelDefinition((String)level.getName(), (String[])new String[]{level.getName()}, (String[])this.toStringArray(levelAttrs)));
                ++k;
            }
            LevelAttributeHandle jointHierarchyKeys = this.getJointHierarchyKeys(cubeHandle, hierhandle);
            if (!cubeHandle.autoPrimaryKey()) {
                levelAttr = jointHierarchyKeys;
                int it = ((String[])levelAttr).length;
                int levelAttrs = 0;
                while (levelAttrs < it) {
                    String jointKey = levelAttr[levelAttrs];
                    if (!columnNamesForLevels.contains(jointKey)) {
                        throw new AdapterException("cube.jointColumnNotInLevels", new String[]{jointKey, dim.getName()});
                    }
                    ++levelAttrs;
                }
            }
            if (levelInHier.size() >= 1) {
                if (cubeHandle.autoPrimaryKey() && ((String[])jointHierarchyKeys).length > 0) {
                    if (!Arrays.deepEquals((Object[])jointHierarchyKeys, new String[]{((TabularLevelHandle)levels.get(levels.size() - 1)).getColumnName()})) {
                        levelInHier.add(CubeElementFactory.createLevelDefinition((String)"_${INTERNAL_INDEX}$_", (String[])this.getDummyLevelNamesForJointHierarchyKeys((String[])jointHierarchyKeys), (String[])new String[0]));
                    } else if (levelInHier.size() > 1 && this.isDateTimeDimension(hierhandle)) {
                        levelInHier.add(CubeElementFactory.createLevelDefinition((String)"_${INTERNAL_INDEX}$_", (String[])leafLevelKeyColumn.toArray(new String[0]), (String[])new String[0]));
                    }
                } else if (levelInHier.size() > 1) {
                    levelInHier.add(CubeElementFactory.createLevelDefinition((String)"_${INTERNAL_INDEX}$_", (String[])leafLevelKeyColumn.toArray(new String[0]), (String[])new String[0]));
                }
            }
            Object originalMemCache = null;
            Object originalRowLimit = null;
            DataSetIterator valueIt = null;
            try {
                try {
                    sl.process(dim);
                    if (!cubeHandle.getDataSet().equals(hierhandle.getDataSet()) && hierhandle.getDataSet() != null) {
                        originalMemCache = appContext.remove(DataEngine.MEMORY_DATA_SET_CACHE);
                        originalRowLimit = appContext.remove(DataEngine.DATA_SET_CACHE_ROW_LIMIT);
                    }
                    String[] timeType = this.getTimeLevelType(hierhandle);
                    int i = 0;
                    while (i < timeType.length) {
                        ((ILevelDefn)levelInHier.get(i)).setTimeType(timeType[i]);
                        ++i;
                    }
                    valueIt = new DataSetIterator(this, (IQueryDefinition)this.cubeQueryMap.get(hierhandle), this.cubeMetaMap.get(hierhandle), appContext);
                    valueIt.initSecurityListenerAndDimension(dim.getName(), sl);
                    iHiers.add(cubeMaterializer.createHierarchy(dim.getName(), hierhandle.getName(), (IDatasetIterator)valueIt, levelInHier.toArray(new ILevelDefn[0]), this.dataEngine.getSession().getStopSign()));
                }
                catch (Exception e) {
                    throw new AdapterException("cube.error.createhierarchy", (Throwable)e, String.valueOf(dim.getName()) + "." + hierhandle.getName());
                }
            }
            catch (Throwable throwable) {
                if (valueIt != null) {
                    try {
                        valueIt.close();
                    }
                    catch (BirtException birtException) {}
                }
                if (originalMemCache != null) {
                    appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, originalMemCache);
                }
                if (originalRowLimit != null) {
                    appContext.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, originalRowLimit);
                }
                throw throwable;
            }
            if (valueIt != null) {
                try {
                    valueIt.close();
                }
                catch (BirtException birtException) {}
            }
            if (originalMemCache != null) {
                appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, originalMemCache);
            }
            if (originalRowLimit != null) {
                appContext.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, originalRowLimit);
            }
            ++j;
        }
        try {
            return cubeMaterializer.createDimension(dim.getName(), (IHierarchy)iHiers.get(0));
        }
        catch (Exception e) {
            throw new AdapterException("cube.error.createdimension", (Throwable)e, dim.getName());
        }
    }

    private String[] getFieldName(TabularHierarchyHandle timeHierhandle) {
        List levels = timeHierhandle.getContents("levels");
        String[] fieldName = new String[levels.size()];
        int i = 0;
        while (i < levels.size()) {
            TabularLevelHandle level = (TabularLevelHandle)levels.get(i);
            fieldName[i] = level.getName();
            ++i;
        }
        return fieldName;
    }

    private String[] getTimeLevelType(TabularHierarchyHandle timeHierhandle) {
        List levels = timeHierhandle.getContents("levels");
        String[] timeType = new String[levels.size()];
        int i = 0;
        while (i < levels.size()) {
            TabularLevelHandle level = (TabularLevelHandle)levels.get(i);
            timeType[i] = level.getDateTimeLevelType();
            ++i;
        }
        return timeType;
    }

    private String[] getJointHierarchyKeys(TabularCubeHandle cubeHandle, TabularHierarchyHandle hier) {
        ArrayList<String> hierarchyKeys = new ArrayList<String>();
        if (hier.getDataSet() != null && !hier.getDataSet().equals(cubeHandle.getDataSet())) {
            Iterator it = cubeHandle.joinConditionsIterator();
            while (it.hasNext()) {
                DimensionConditionHandle dimCondHandle = (DimensionConditionHandle)it.next();
                if (!dimCondHandle.getHierarchy().getName().equals(hier.getName())) continue;
                for (DimensionJoinConditionHandle joinCondition : dimCondHandle.getJoinConditions()) {
                    String key = joinCondition.getHierarchyKey();
                    hierarchyKeys.add(key);
                }
            }
        }
        return hierarchyKeys.toArray(new String[0]);
    }

    private IDimension populateTempPKDimension(CubeMaterializer cubeMaterializer, TabularCubeHandle cubeHandle, DataSetIteratorForTempPK dataForTempPK, Map appContext) throws AdapterException {
        ILevelDefn[] tempLevels = new ILevelDefn[]{CubeElementFactory.createLevelDefinition((String)DataRequestSessionImpl.getCubeTempPKFieldName(cubeHandle), (String[])new String[]{DataRequestSessionImpl.getCubeTempPKFieldName(cubeHandle)}, (String[])new String[0])};
        IHierarchy h = null;
        try {
            h = cubeMaterializer.createHierarchy(DataRequestSessionImpl.getCubeTempPKDimensionName(cubeHandle), DataRequestSessionImpl.getCubeTempPKHierarchyName(cubeHandle), (IDatasetIterator)dataForTempPK, tempLevels, this.dataEngine.getSession().getStopSign());
        }
        catch (Exception e) {
            throw new AdapterException("cube.error.createhierarchy", (Throwable)e, String.valueOf(DataRequestSessionImpl.getCubeTempPKDimensionName(cubeHandle)) + "." + DataRequestSessionImpl.getCubeTempPKHierarchyName(cubeHandle));
        }
        try {
            return cubeMaterializer.createDimension(DataRequestSessionImpl.getCubeTempPKDimensionName(cubeHandle), h);
        }
        catch (Exception e) {
            throw new AdapterException("cube.error.createdimension", (Throwable)e, DataRequestSessionImpl.getCubeTempPKDimensionName(cubeHandle));
        }
    }

    private String[] toStringArray(List object) {
        if (object == null) {
            return null;
        }
        String[] result = new String[object.size()];
        int i = 0;
        while (i < object.size()) {
            result[i] = object.get(i).toString();
            ++i;
        }
        return result;
    }

    @Override
    public IPreparedCubeQuery prepare(ICubeQueryDefinition query) throws BirtException {
        return this.prepare(query, this.sessionContext.getAppContext());
    }

    @Override
    public IPreparedCubeQuery prepare(ICubeQueryDefinition query, Map appContext) throws BirtException {
        this.refactorCubeQueryDefinition(query);
        this.populateMeasureDefinitionForCalculateMeasures(query);
        this.setMeasureDataTypeForCubeQuery(query);
        QueryAdapter.adaptQuery((IDataQueryDefinition)query);
        CubeHandle cubeHandle = null;
        if (this.cubeMetaDataHandleMap != null && this.cubeMetaDataHandleMap.containsKey(query.getName())) {
            cubeHandle = (CubeHandle)this.cubeMetaDataHandleMap.get(query.getName());
        }
        QueryValidator.validateTimeFunctionInCubeQuery(query, cubeHandle);
        this.dataEngine.getSession().getStopSign().start();
        this.setModuleHandleToAppContext(appContext);
        return this.dataEngine.prepare(query, appContext);
    }

    private void populateMeasureDefinitionForCalculateMeasures(ICubeQueryDefinition query) throws BirtException {
        List calculatedMeasures = query.getDerivedMeasures();
        List measures = query.getMeasures();
        HashSet<String> measureNameList = new HashSet<String>();
        int i = 0;
        while (i < measures.size()) {
            measureNameList.add(((IMeasureDefinition)measures.get(i)).getName());
            ++i;
        }
        HashSet<String> derivedMeasureNameList = new HashSet<String>();
        int i2 = 0;
        while (i2 < calculatedMeasures.size()) {
            derivedMeasureNameList.add(((IDerivedMeasureDefinition)calculatedMeasures.get(i2)).getName());
            ++i2;
        }
        if (this.cubeMetaDataHandleMap != null && this.cubeMetaDataHandleMap.containsKey(query.getName())) {
            CubeHandle cubeHandle = (CubeHandle)this.cubeMetaDataHandleMap.get(query.getName());
            CubeMeasureUtil.validateDerivedMeasures(cubeHandle);
            List measureGroups = cubeHandle.getContents("measureGroups");
            int i3 = 0;
            while (i3 < measureGroups.size()) {
                MeasureGroupHandle mgh = (MeasureGroupHandle)measureGroups.get(i3);
                List measureGroup = mgh.getContents("measures");
                int j = 0;
                while (j < measureGroup.size()) {
                    MeasureHandle measure = (MeasureHandle)measureGroup.get(j);
                    if (measure.isCalculated() && !derivedMeasureNameList.contains(measure.getName())) {
                        derivedMeasureNameList.add(measure.getName());
                        query.createDerivedMeasure(measure.getName(), DataAdapterUtil.adaptModelDataType(measure.getDataType()), (IBaseExpression)this.modelAdaptor.adaptExpression((Expression)measure.getExpressionProperty("measureExpression").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                    }
                    ++j;
                }
                ++i3;
            }
        }
        this.validateBindings(query.getBindings(), derivedMeasureNameList);
        calculatedMeasures = query.getDerivedMeasures();
        if (calculatedMeasures == null || calculatedMeasures.size() == 0) {
            return;
        }
        i = 0;
        while (i < calculatedMeasures.size()) {
            IDerivedMeasureDefinition dmd = (IDerivedMeasureDefinition)calculatedMeasures.get(i);
            List measureNames = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)dmd.getExpression(), (String)"measure");
            int j = 0;
            while (j < measureNames.size()) {
                if (!measureNameList.contains(measureNames.get(j).toString()) && !derivedMeasureNameList.contains(measureNames.get(j).toString())) {
                    IMeasureDefinition md = query.createMeasure(measureNames.get(j).toString());
                    measureNameList.add(md.getName());
                    if (this.cubeMetaDataHandleMap != null && this.cubeMetaDataHandleMap.containsKey(query.getName())) {
                        CubeHandle cubeHandle = (CubeHandle)this.cubeMetaDataHandleMap.get(query.getName());
                        MeasureHandle measureHandle = cubeHandle.getMeasure(measureNames.get(j).toString());
                        if (measureHandle == null) {
                            throw new DataException(AdapterResourceHandle.getInstance().getMessage("cube.derivedMeasure.invalid.reference", new Object[]{dmd.getName(), measureNames.get(j)}));
                        }
                        md.setAggrFunction(DataAdapterUtil.adaptModelAggregationType(measureHandle.getFunction()));
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void validateBindings(List<IBinding> bindings, Collection calculatedMeasures) throws AdapterException {
        try {
            for (IBinding b : bindings) {
                if (b.getAggrFunction() == null || b.getFilter() == null) continue;
                List referencedMeasures = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)b.getFilter(), (String)"measure");
                for (Object r : referencedMeasures) {
                    if (!calculatedMeasures.contains(r.toString())) continue;
                    throw new AdapterException(AdapterResourceHandle.getInstance().getMessage("cube.error.aggregationFilter.referCalculatedMeasure", new Object[]{b.getBindingName(), r.toString()}));
                }
            }
        }
        catch (DataException ex) {
            throw new AdapterException(ex.getMessage(), ex);
        }
    }

    private void setMeasureDataTypeForCubeQuery(ICubeQueryDefinition query) {
        List measures = query.getMeasures();
        if (this.cubeMetaDataHandleMap != null && this.cubeMetaDataHandleMap.containsKey(query.getName())) {
            CubeHandle cubeHandle = (CubeHandle)this.cubeMetaDataHandleMap.get(query.getName());
            int i = 0;
            while (i < measures.size()) {
                IMeasureDefinition measureDef = (IMeasureDefinition)measures.get(i);
                MeasureHandle measureHandle = cubeHandle.getMeasure(measureDef.getName());
                if (measureHandle != null) {
                    measureDef.setDataType(DataAdapterUtil.adaptModelDataType(measureHandle.getDataType()));
                }
                if (cubeHandle.getBooleanProperty("autoKey")) {
                    measureDef.setAggrFunction(null);
                }
                ++i;
            }
        }
    }

    private void refactorCubeQueryDefinition(ICubeQueryDefinition query) throws DataException, AdapterException {
        List bindings = query.getBindings();
        List levelExprList = this.getAllAggrOns(query);
        int i = 0;
        while (i < bindings.size()) {
            IBinding binding = (IBinding)bindings.get(i);
            String measureName = OlapExpressionUtil.getMeasure((IBaseExpression)binding.getExpression());
            if (measureName != null && binding.getAggrFunction() == null) {
                String aggrFunc = this.getAggrFunction(query, measureName);
                binding.setAggrFunction(aggrFunc);
                if (binding.getAggregatOns().size() == 0) {
                    Iterator itr = levelExprList.iterator();
                    while (itr.hasNext()) {
                        binding.addAggregateOn(itr.next().toString());
                    }
                }
            }
            ++i;
        }
    }

    private String getAggrFunction(ICubeQueryDefinition query, String measureName) {
        for (IMeasureDefinition measure : query.getMeasures()) {
            if (!measure.getName().equals(measureName)) continue;
            if (measure.getAggrFunction() == null) break;
            return measure.getAggrFunction();
        }
        if (this.cubeHandleMap != null && this.cubeHandleMap.containsKey(query.getName())) {
            CubeHandle cubeHandle = (CubeHandle)this.cubeHandleMap.get(query.getName());
            MeasureHandle measureHandle = cubeHandle.getMeasure(measureName);
            try {
                return DataAdapterUtil.adaptModelAggregationType(measureHandle.getFunction());
            }
            catch (AdapterException adapterException) {}
        }
        return "SUM";
    }

    private List getAllAggrOns(ICubeQueryDefinition query) {
        List levels = CubeQueryDefinitionUtil.populateMeasureAggrOns((ICubeQueryDefinition)query);
        ArrayList<String> levelExprs = new ArrayList<String>();
        for (DimLevel level : levels) {
            levelExprs.add(ExpressionUtil.createJSDimensionExpression((String)level.getDimensionName(), (String)level.getLevelName()));
        }
        return levelExprs;
    }

    private static ResourceIdentifiers createResourceIdentifiers(final ModuleHandle handle) {
        if (handle == null) {
            return null;
        }
        try {
            ResourceIdentifiers identifiers = new ResourceIdentifiers();
            if (handle.getSystemId() != null) {
                identifiers.setDesignResourceBaseURI(handle.getSystemId().toURI());
            }
            if (handle.getResourceFolder() != null) {
                URI uri = AccessController.doPrivileged(new PrivilegedAction<URI>(){

                    @Override
                    public URI run() {
                        return new File(handle.getModule().getSession().getResourceFolder()).toURI();
                    }
                });
                identifiers.setApplResourceBaseURI(uri);
            }
            return identifiers;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    @Override
    public IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        return this.dataEngine.getCachedDataSetMetaData(dataSource, dataSet);
    }

    @Override
    public ICubeQueryUtil getCubeQueryUtil() {
        return new CubeQueryUtil(this);
    }

    @Override
    public AggregationManager getAggregationManager() throws DataException {
        return AggregationManager.getInstance();
    }

    public Scriptable getScope() throws AdapterException {
        try {
            return this.sessionContext.getDataEngineContext().getJavaScriptScope();
        }
        catch (BirtException e) {
            throw new AdapterException("exception.error", e);
        }
    }

    @Override
    public void cancel() {
        this.dataEngine.cancel();
    }

    @Override
    public void restart() {
        this.dataEngine.restart();
    }

    @Override
    public IQueryDefinitionUtil getQueryDefinitionUtil() {
        return new QueryDefinitionUtil();
    }

    @Override
    public void registerQueries(IDataQueryDefinition[] queryDefns) throws AdapterException {
        try {
            this.dataEngine.registerQueries(queryDefns);
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public IPreparedCubeQuery prepare(ISubCubeQueryDefinition query, Map appContext) throws BirtException {
        QueryAdapter.adaptQuery((IDataQueryDefinition)query);
        this.setModuleHandleToAppContext(appContext);
        return this.dataEngine.prepare(query, appContext);
    }

    private void setModuleHandleToAppContext() {
        if (this.sessionContext.getAppContext() == null) {
            this.sessionContext.setAppContext(new HashMap());
        }
        this.setModuleHandleToAppContext(this.sessionContext.getAppContext());
    }

    private void setModuleHandleToAppContext(Map appContext) {
        String resouceIDs;
        if (appContext == null) {
            appContext = new HashMap<String, Object>();
        }
        if (!appContext.containsKey(resouceIDs = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds") || appContext.get(resouceIDs) == null) {
            if (this.sessionContext.getModuleHandle() != null) {
                appContext.put(resouceIDs, DataRequestSessionImpl.createResourceIdentifiers(this.sessionContext.getModuleHandle()));
            } else if (this.sessionContext.getAppContext() != null) {
                appContext.put(resouceIDs, this.sessionContext.getAppContext().get(resouceIDs));
            }
        }
    }

    private void defineDataSourceDataSet(IQueryDefinition queryDefn) throws BirtException {
        String dataSetName = queryDefn.getDataSetName();
        ModuleHandle module = this.sessionContext.getModuleHandle();
        if (module != null) {
            List l = module.getAllDataSets();
            DataSetHandle handle = null;
            int i = 0;
            while (i < l.size()) {
                if (((DataSetHandle)l.get(i)).getQualifiedName() != null && ((DataSetHandle)l.get(i)).getQualifiedName().equals(dataSetName)) {
                    handle = (DataSetHandle)l.get(i);
                    break;
                }
                ++i;
            }
            DefineDataSourceSetUtil.defineDataSourceAndDataSet(handle, (DataEngine)this.dataEngine, this.modelAdaptor, null);
            DefineDataSourceSetUtil.prepareForTransientQuery(this.sessionContext, this.dataEngine, handle, queryDefn);
        }
    }

    private void prepareLevels(QueryDefinition query, TabularHierarchyHandle hierHandle, List metaList, String dimName, String levelColumnName, boolean addGroup) throws BirtException {
        try {
            List levels = hierHandle.getContents("levels");
            int j = 0;
            while (j < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(j);
                DataSetIterator.ColumnMeta temp = null;
                String exprString = ExpressionUtil.createJSDataSetRowExpression((String)(levelColumnName == null ? level.getColumnName() : levelColumnName));
                int type = DataAdapterUtil.adaptModelDataType(level.getDataType());
                if (type == -1 || type == 0) {
                    type = 5;
                }
                if (level.getDateTimeLevelType() != null) {
                    temp = new DataSetIterator.ColumnMeta(DataSetIterator.createLevelName(dimName, level.getName()), new DataSetIterator.DataProcessorWrapper(GroupCalculatorFactory.getGroupCalculator(99, 2, String.valueOf(DataSetIterator.getDefaultStartValue(level.getDateTimeLevelType(), level.getIntervalBase())), level.getIntervalRange(), this.sessionContext.getDataEngineContext().getLocale(), this.sessionContext.getDataEngineContext().getTimeZone())), 1);
                    temp.setDataType(2);
                    exprString = DataSetIterator.createDateTransformerExpr(level.getDateTimeLevelType(), exprString);
                } else {
                    DataSetIterator.DataProcessorWrapper processor = null;
                    if ("dynamic".equals(level.getLevelType())) {
                        int interval = GroupAdapter.intervalFromModel(level.getInterval());
                        if (interval != 0) {
                            processor = new DataSetIterator.DataProcessorWrapper(GroupCalculatorFactory.getGroupCalculator(interval, type, level.getIntervalBase(), level.getIntervalRange(), this.sessionContext.getDataEngineContext().getLocale(), this.sessionContext.getDataEngineContext().getTimeZone()));
                        }
                    } else if ("mirrored".equals(level.getLevelType())) {
                        Iterator it = level.staticValuesIterator();
                        ArrayList<String> dispExpr = new ArrayList<String>();
                        ArrayList<String> filterExpr = new ArrayList<String>();
                        while (it.hasNext()) {
                            RuleHandle o = (RuleHandle)it.next();
                            dispExpr.add(o.getDisplayExpression());
                            filterExpr.add(o.getRuleExpression());
                        }
                        StringBuffer buf = new StringBuffer();
                        if (level.getDefaultValue() != null) {
                            buf.append("\"");
                            buf.append(JavascriptEvalUtil.transformToJsConstants((String)level.getDefaultValue()));
                            buf.append("\";");
                        }
                        int i = 0;
                        while (i < dispExpr.size()) {
                            String disp = "\"" + JavascriptEvalUtil.transformToJsConstants((String)String.valueOf(dispExpr.get(i))) + "\"";
                            String filter = String.valueOf(filterExpr.get(i));
                            buf.append("if(");
                            buf.append(filter);
                            buf.append(")");
                            buf.append(disp);
                            buf.append(";");
                            ++i;
                        }
                        exprString = buf.toString();
                    }
                    temp = new DataSetIterator.ColumnMeta(DataSetIterator.createLevelName(dimName, level.getName()), processor, 1);
                    temp.setDataType(type);
                }
                metaList.add(temp);
                Iterator it = level.attributesIterator();
                while (it.hasNext()) {
                    LevelAttributeHandle levelAttr = (LevelAttributeHandle)it.next();
                    DataSetIterator.DateTimeAttributeProcessor processor = null;
                    String bindingExpr = null;
                    if (level.getDateTimeLevelType() != null && "DateTime".equals(levelAttr.getName())) {
                        processor = new DataSetIterator.DateTimeAttributeProcessor(level.getDateTimeLevelType(), this.sessionContext.getDataEngineContext().getLocale(), this.sessionContext.getDataEngineContext().getTimeZone());
                        bindingExpr = ExpressionUtil.createJSDataSetRowExpression((String)(levelColumnName == null ? level.getColumnName() : levelColumnName));
                    } else {
                        bindingExpr = ExpressionUtil.createJSDataSetRowExpression((String)levelAttr.getName());
                    }
                    DataSetIterator.ColumnMeta meta = new DataSetIterator.ColumnMeta(DataSetIterator.createLevelName(dimName, OlapExpressionUtil.getAttributeColumnName((String)level.getName(), (String)levelAttr.getName())), processor, 3);
                    meta.setDataType(DataAdapterUtil.adaptModelDataType(levelAttr.getDataType()));
                    metaList.add(meta);
                    query.addBinding((IBinding)new Binding(meta.getName(), (IBaseExpression)new ScriptExpression(bindingExpr)));
                }
                if ("dynamic".equals(level.getLevelType()) && level.getDisplayColumnName() != null) {
                    DataSetIterator.ColumnMeta meta = new DataSetIterator.ColumnMeta(DataSetIterator.createLevelName(dimName, OlapExpressionUtil.getDisplayColumnName((String)level.getName())), null, 3);
                    meta.setDataType(5);
                    metaList.add(meta);
                    ExpressionHandle displayExprHandle = level.getExpressionProperty("displayColumnName");
                    if (displayExprHandle != null) {
                        query.addBinding((IBinding)new Binding(meta.getName(), (IBaseExpression)this.modelAdaptor.adaptJSExpression(displayExprHandle.getStringExpression(), displayExprHandle.getType())));
                    }
                }
                if (level.getMemberACLExpression() != null && level.getMemberACLExpression().getExpression() != null) {
                    String aclExprName = DataSetIterator.createLevelACLName(level.getName());
                    ScriptExpression expr = this.modelAdaptor.adaptExpression((Expression)level.getMemberACLExpression().getValue());
                    query.addBinding((IBinding)new Binding(aclExprName, (IBaseExpression)expr));
                    DataSetIterator.ColumnMeta meta = new DataSetIterator.ColumnMeta(aclExprName, null, 3);
                    metaList.add(meta);
                }
                String levelName = DataSetIterator.createLevelName(dimName, level.getName());
                query.addBinding((IBinding)new Binding(levelName, (IBaseExpression)new ScriptExpression(exprString, type)));
                GroupDefinition gd = new GroupDefinition(String.valueOf(query.getGroups().size()));
                gd.setKeyExpression(ExpressionUtil.createJSRowExpression((String)levelName));
                if (level.getLevelType() != null && level.getDateTimeLevelType() == null) {
                    gd.setIntervalRange(level.getIntervalRange());
                    gd.setIntervalStart((Object)level.getIntervalBase());
                    gd.setInterval(GroupAdapter.intervalFromModel(level.getInterval()));
                }
                if (level.getDateTimeLevelType() != null) {
                    gd.setIntervalRange(level.getIntervalRange() == 0.0 ? 1.0 : level.getIntervalRange());
                    gd.setIntervalStart((Object)String.valueOf(DataSetIterator.getDefaultStartValue(level.getDateTimeLevelType(), level.getIntervalBase())));
                    gd.setInterval(99);
                }
                if (addGroup) {
                    query.addGroup(gd);
                }
                ++j;
            }
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private void prepareMeasure(TabularCubeHandle cubeHandle, QueryDefinition query, List metaList) throws AdapterException {
        try {
            List measureGroups = cubeHandle.getContents("measureGroups");
            int i = 0;
            while (i < measureGroups.size()) {
                MeasureGroupHandle mgh = (MeasureGroupHandle)measureGroups.get(i);
                List measures = mgh.getContents("measures");
                int j = 0;
                while (j < measures.size()) {
                    MeasureHandle measure = (MeasureHandle)measures.get(j);
                    if (!measure.isCalculated()) {
                        String function = measure.getFunction();
                        String exprText = measure.getMeasureExpression();
                        ExpressionHandle measureExprHandle = measure.getExpressionProperty("measureExpression");
                        ScriptExpression expr = null;
                        if (exprText != null && measureExprHandle != null) {
                            expr = this.modelAdaptor.adaptJSExpression(measureExprHandle.getStringExpression(), measureExprHandle.getType());
                        }
                        Binding binding = new Binding(measure.getName(), expr);
                        binding.setAggrFunction(DataAdapterUtil.adaptModelAggregationType(function));
                        query.addBinding((IBinding)binding);
                        DataSetIterator.ColumnMeta meta = new DataSetIterator.ColumnMeta(measure.getName(), null, 2);
                        meta.setDataType(DataAdapterUtil.adaptModelDataType(measure.getDataType()));
                        metaList.add(meta);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private static void popualteFilter(DataRequestSession session, Iterator filterIterator, QueryDefinition query) throws AdapterException {
        while (filterIterator.hasNext()) {
            FilterConditionHandle filter = (FilterConditionHandle)filterIterator.next();
            query.addFilter((IFilterDefinition)session.getModelAdaptor().adaptFilter(filter));
        }
    }

    private boolean isDateTimeDimension(TabularHierarchyHandle hierHandle) {
        List levels = hierHandle.getContents("levels");
        int j = 0;
        while (j < levels.size()) {
            TabularLevelHandle level = (TabularLevelHandle)levels.get(j);
            if (level.getDateTimeLevelType() == null) {
                return false;
            }
            ++j;
        }
        return true;
    }

    QueryDefinition createQuery(DataRequestSessionImpl session, TabularCubeHandle cubeHandle, List metaList) throws BirtException {
        if (metaList == null) {
            metaList = new ArrayList<DataSetIterator.ColumnMeta>();
        }
        CubeCreationQueryDefinition query = new CubeCreationQueryDefinition();
        query.setAsTempQuery();
        query.setName(String.valueOf(cubeHandle.getElement().getID()));
        if (cubeHandle.getDataSet() == null) {
            throw new AdapterException(AdapterResourceHandle.getInstance().getMessage("cube.error.datasetmiss"));
        }
        query.setDataSetName(cubeHandle.getDataSet().getQualifiedName());
        List dimensions = cubeHandle.getContents("dimensions");
        if (dimensions != null) {
            int i = 0;
            while (i < dimensions.size()) {
                DimensionHandle dimension = (DimensionHandle)dimensions.get(i);
                List hiers = dimension.getContents("hierarchies");
                TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)hiers.get(0);
                if (hierHandle.getDataSet() == null || hierHandle.getDataSet().getQualifiedName().equals(cubeHandle.getDataSet().getQualifiedName())) {
                    this.prepareLevels((QueryDefinition)query, hierHandle, metaList, dimension.getName(), null, true);
                } else {
                    DimensionJoinConditionHandle condition = this.getFacttableJointKey(cubeHandle, hierHandle);
                    if (this.isDateTimeDimension(hierHandle) && this.existColumnName(hierHandle, condition.getHierarchyKey())) {
                        this.prepareLevels((QueryDefinition)query, hierHandle, metaList, dimension.getName(), condition.getCubeKey(), true);
                    } else {
                        Iterator it = cubeHandle.joinConditionsIterator();
                        while (it.hasNext()) {
                            DimensionConditionHandle dimCondHandle = (DimensionConditionHandle)it.next();
                            if (!dimCondHandle.getHierarchy().getName().equals(hierHandle.getName())) continue;
                            for (DimensionJoinConditionHandle joinCondition : dimCondHandle.getJoinConditions()) {
                                String cubeKey = joinCondition.getCubeKey();
                                String cubeKeyWithDimIdentifier = OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)cubeKey);
                                DataSetIterator.ColumnMeta temp = new DataSetIterator.ColumnMeta(cubeKeyWithDimIdentifier, null, 1);
                                temp.setDataType(DataRequestSessionImpl.getColumnDataType(cubeHandle.getDataSet(), cubeKey));
                                metaList.add(temp);
                                query.addBinding((IBinding)new Binding(cubeKeyWithDimIdentifier, (IBaseExpression)new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)cubeKey))));
                            }
                        }
                    }
                }
                ++i;
            }
        }
        session.prepareMeasure(cubeHandle, (QueryDefinition)query, metaList);
        DataRequestSessionImpl.popualteFilter(session, cubeHandle.filtersIterator(), (QueryDefinition)query);
        return query;
    }

    private boolean existColumnName(TabularHierarchyHandle hierHandle, String name) {
        List levels = hierHandle.getContents("levels");
        int j = 0;
        while (j < levels.size()) {
            TabularLevelHandle level = (TabularLevelHandle)levels.get(j);
            if (level.getColumnName().equals(name)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private DimensionJoinConditionHandle getFacttableJointKey(TabularCubeHandle cubeHandle, TabularHierarchyHandle hierHandle) {
        Iterator it = cubeHandle.joinConditionsIterator();
        while (it.hasNext()) {
            Iterator conditionIt;
            DimensionConditionHandle dimCondHandle = (DimensionConditionHandle)it.next();
            if (!dimCondHandle.getHierarchy().getName().equals(hierHandle.getName()) || !(conditionIt = dimCondHandle.getJoinConditions().iterator()).hasNext()) continue;
            DimensionJoinConditionHandle joinCondition = (DimensionJoinConditionHandle)conditionIt.next();
            return joinCondition;
        }
        return null;
    }

    private QueryDefinition createQueryForTempPKDimension(TabularCubeHandle cubeHandle) throws BirtException {
        QueryDefinition query = new QueryDefinition();
        query.setAsTempQuery();
        query.setUsesDetails(false);
        query.setDataSetName(cubeHandle.getDataSet().getQualifiedName());
        query.setIsSummaryQuery(true);
        query.setName(String.valueOf(cubeHandle.getElement().getID()));
        DataRequestSessionImpl.popualteFilter(this, cubeHandle.filtersIterator(), query);
        return query;
    }

    private static String getDataSet(TabularHierarchyHandle handle) {
        if (handle.getDataSet() != null) {
            return handle.getDataSet().getQualifiedName();
        }
        CubeHandle cubeHandle = DataRequestSessionImpl.acquireContainerCube(handle);
        if (cubeHandle != null) {
            return cubeHandle.getElementProperty("dataSet").getQualifiedName();
        }
        return null;
    }

    private static CubeHandle acquireContainerCube(TabularHierarchyHandle hierHandle) {
        DesignElementHandle handle = hierHandle.getContainer().getContainer();
        if (handle == null || !(handle instanceof CubeHandle)) {
            return null;
        }
        return (CubeHandle)handle;
    }

    private static Iterator getFilterIterator(TabularHierarchyHandle handle) {
        if (handle.getDataSet() != null) {
            return handle.filtersIterator();
        }
        CubeHandle cubeHandle = DataRequestSessionImpl.acquireContainerCube(handle);
        if (cubeHandle != null) {
            return cubeHandle.filtersIterator();
        }
        return new ArrayList().iterator();
    }

    QueryDefinition createQuery(DataRequestSessionImpl session, TabularHierarchyHandle hierHandle, List metaList, String cubeName) throws BirtException {
        assert (metaList != null);
        CubeCreationQueryDefinition query = new CubeCreationQueryDefinition();
        query.setAsTempQuery();
        query.setUsesDetails(false);
        query.setDataSetName(DataRequestSessionImpl.getDataSet(hierHandle));
        query.setName(cubeName);
        this.prepareLevels((QueryDefinition)query, hierHandle, metaList, null, null, true);
        DataRequestSessionImpl.popualteFilter(session, DataRequestSessionImpl.getFilterIterator(hierHandle), (QueryDefinition)query);
        return query;
    }

    QueryDefinition createDimensionQuery(DataRequestSessionImpl session, DimensionHandle dim, TabularHierarchyHandle hierHandle, List metaList, String cubeName) throws BirtException {
        assert (metaList != null);
        CubeCreationQueryDefinition query = new CubeCreationQueryDefinition();
        query.setAsTempQuery();
        query.setDataSetName(DataRequestSessionImpl.getDataSet(hierHandle));
        query.setName(cubeName);
        this.prepareLevels((QueryDefinition)query, hierHandle, metaList, null, null, false);
        DataRequestSessionImpl.popualteFilter(session, DataRequestSessionImpl.getFilterIterator(hierHandle), (QueryDefinition)query);
        if (CubeHandleUtil.isTimeDimension(dim)) {
            FilterDefinition filter = null;
            filter = dim instanceof TabularDimensionHandle && ((TabularDimensionHandle)dim).getSharedDimension() != null ? this.buildFilterForTimeDimension(((TabularDimensionHandle)dim).getSharedDimension(), hierHandle) : this.buildFilterForTimeDimension(dim, hierHandle);
            if (filter != null) {
                query.addFilter((IFilterDefinition)filter);
            }
        }
        return query;
    }

    @Override
    public DataSessionContext getDataSessionContext() {
        return this.sessionContext;
    }

    private static String getCubeTempPKDimensionName(TabularCubeHandle tch) {
        return "TEMP_PK_DIMENSION_" + tch.hashCode();
    }

    private static String getCubeTempPKHierarchyName(TabularCubeHandle tch) {
        return "TEMP_PK_HIERARCHY_" + tch.hashCode();
    }

    private static String getCubeTempPKFieldName(TabularCubeHandle tch) {
        return "TEMP_PK_" + tch.hashCode();
    }

    private static <T> T[] appendArray(T[] src, T v) {
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length + 1);
        System.arraycopy(src, 0, result, 0, src.length);
        result[src.length] = v;
        return result;
    }

    private static int getColumnDataType(DataSetHandle dsh, String jointHierarchyKey) {
        CachedMetaDataHandle cmdh = dsh.getCachedMetaDataHandle();
        for (ResultSetColumnHandle rsch : cmdh.getResultSet()) {
            if (!rsch.getColumnName().equals(jointHierarchyKey)) continue;
            return DataAdapterUtil.adaptModelDataType(rsch.getDataType());
        }
        return 5;
    }

    private String getDummyLevelNameForJointHierarchyKey(String hierarchyKey) {
        return String.valueOf(hierarchyKey) + "_Dummy" + this.hashCode();
    }

    private String[] getDummyLevelNamesForJointHierarchyKeys(String[] hierarchyKeys) {
        String[] result = new String[hierarchyKeys.length];
        int i = 0;
        String[] stringArray = hierarchyKeys;
        int n = hierarchyKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            result[i] = this.getDummyLevelNameForJointHierarchyKey(key);
            ++i;
            ++n2;
        }
        return result;
    }

    public DataEngine getDataEngine() {
        return this.dataEngine;
    }

    @Override
    public IBasePreparedQuery prepare(IDataQueryDefinition query) throws AdapterException {
        return this.prepare(query, null);
    }

    @Override
    public IPreparedCubeQuery prepare(ISubCubeQueryDefinition query) throws BirtException {
        return this.prepare(query, null);
    }

    @Override
    public IFilterUtil getFilterUtil() throws BirtException {
        return new FilterUtil();
    }
}

