/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.PropertyElement;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.PropertyGroup;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDBCDriverInformation {
    private String driverClassName = null;
    private int majorVersion = 0;
    private int minorVersion = 0;
    private String urlFormat = null;
    private String driverDisplayName = null;
    private boolean hide = false;
    private List<PropertyGroup> propertyGroup = new ArrayList<PropertyGroup>();

    private JDBCDriverInformation() {
    }

    public static JDBCDriverInformation newInstance(Class driverClass) {
        block4: {
            try {
                Driver d = JDBCDriverManager.getInstance().getDriverInstance(driverClass, false);
                if (d == null) break block4;
                JDBCDriverInformation info = JDBCDriverInformation.newInstance(driverClass.getName());
                try {
                    info.setMajorVersion(d.getMajorVersion());
                    info.setMinorVersion(d.getMinorVersion());
                }
                catch (Throwable e) {
                    Logger.getLogger(JDBCDriverInformation.class.getName()).log(Level.WARNING, e.getMessage(), e);
                }
                return info;
            }
            catch (Throwable e) {
                Logger.getLogger(JDBCDriverInformation.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    public static JDBCDriverInformation newInstance(String driverClassName) {
        JDBCDriverInformation info = new JDBCDriverInformation();
        info.setDriverClassName(driverClassName);
        return info;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    protected void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    protected void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String getUrlFormat() {
        return this.urlFormat;
    }

    public boolean hasProperty() {
        if (this.propertyGroup == null) {
            return false;
        }
        return this.propertyGroup.size() > 0;
    }

    protected void setUrlFormat(String urlFormat) {
        this.urlFormat = urlFormat;
    }

    public String getDisplayName() {
        return this.driverDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.driverDisplayName = displayName;
    }

    public boolean getHide() {
        return this.hide;
    }

    public void setHide(String hide) {
        if (hide != null) {
            this.hide = hide.equals("true");
        }
    }

    public void setHide(boolean flag) {
        this.hide = flag;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.driverClassName);
        if (this.majorVersion != 0 || this.minorVersion != 0) {
            buffer.append(" (");
            buffer.append(this.majorVersion);
            buffer.append(".");
            buffer.append(this.minorVersion);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.driverClassName);
        if (this.majorVersion != 0 || this.minorVersion != 0 || this.driverDisplayName != null) {
            buffer.append(" (");
            if (this.driverDisplayName != null) {
                buffer.append(this.driverDisplayName);
            }
            if (this.majorVersion != 0 || this.minorVersion != 0) {
                if (this.driverDisplayName != null) {
                    buffer.append(" ");
                }
                buffer.append("v");
                buffer.append(this.majorVersion);
                buffer.append(".");
                buffer.append(this.minorVersion);
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public boolean equals(Object anotherObj) {
        if (this == anotherObj) {
            return true;
        }
        if (!(anotherObj instanceof JDBCDriverInformation)) {
            return false;
        }
        JDBCDriverInformation info = (JDBCDriverInformation)anotherObj;
        return this.driverClassName != null && this.driverClassName.equalsIgnoreCase(info.driverClassName) && this.majorVersion == info.majorVersion && this.minorVersion == info.minorVersion;
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.driverClassName != null) {
            hashcode += this.driverClassName.hashCode() * 11;
        }
        return hashcode + this.majorVersion * 13 + this.minorVersion * 17;
    }

    private PropertyElement populateProperty(IConfigurationElement configElement) {
        PropertyElement element = new PropertyElement();
        element.setAttribute("propertyName", configElement.getAttribute("propertyName"));
        element.setAttribute("displayName", configElement.getAttribute("displayName"));
        element.setAttribute("description", configElement.getAttribute("description"));
        element.setAttribute("encrypt", configElement.getAttribute("encrypt"));
        element.setAttribute("type", configElement.getAttribute("type"));
        return element;
    }

    public List<PropertyGroup> getPropertyGroup() {
        return this.propertyGroup;
    }

    public void populateProperties(IConfigurationElement configElement) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = configElement.getChildren("propertyGroup");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getAttribute("displayName");
            String desc = element.getAttribute("description");
            PropertyGroup group = new PropertyGroup(name, desc);
            IConfigurationElement[] propertiesConfigurationElements = element.getChildren("property");
            ArrayList<PropertyElement> list = new ArrayList<PropertyElement>();
            IConfigurationElement[] iConfigurationElementArray2 = propertiesConfigurationElements;
            int n3 = propertiesConfigurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement prElement = iConfigurationElementArray2[n4];
                list.add(this.populateProperty(prElement));
                ++n4;
            }
            group.setProperties(list);
            this.propertyGroup.add(group);
            ++n2;
        }
    }
}

