/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.ChildrenAllowedNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.FilterConfig;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.IDBNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.ProcedureFlagNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.ProcedureNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.SchemaNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.TableNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public class RootNode
extends ChildrenAllowedNode {
    private static Logger logger = Logger.getLogger(RootNode.class.getName());
    private static String ROOT_ICON = String.valueOf(RootNode.class.getName()) + ".RootIcon";
    private String dataSourceName;
    private String[] prefetechedSchemas;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(ROOT_ICON, ImageDescriptor.createFromFile(JdbcPlugin.class, (String)"icons/data_source.gif"));
    }

    public RootNode(String dataSourceName) {
        this(dataSourceName, null);
    }

    public RootNode(String dataSourceName, String[] allSchemaNames) {
        assert (dataSourceName != null);
        this.dataSourceName = dataSourceName;
        this.prefetechedSchemas = allSchemaNames;
    }

    @Override
    protected IDBNode[] refetchChildren(FilterConfig fc) {
        String namePattern = fc.getNamePattern();
        boolean supportsSchema = JdbcMetaDataProvider.getInstance().isSupportSchema();
        boolean supportsProcedure = JdbcMetaDataProvider.getInstance().isSupportProcedure();
        if (namePattern.equals("%")) {
            if (supportsSchema) {
                if (fc.getSchemaName() != null) {
                    IDBNode[] iDBNodeArray;
                    IDBNode node = this.fetchSpecifiedSchema(fc.getSchemaName());
                    if (node == null) {
                        iDBNodeArray = new IDBNode[]{};
                    } else {
                        IDBNode[] iDBNodeArray2 = new IDBNode[1];
                        iDBNodeArray = iDBNodeArray2;
                        iDBNodeArray2[0] = node;
                    }
                    return iDBNodeArray;
                }
                if (this.prefetechedSchemas == null) {
                    return this.fetchChildrenFromSchema(fc.getMaxSchemaCount());
                }
                ArrayList<SchemaNode> schemas = new ArrayList<SchemaNode>();
                int count = 0;
                String[] stringArray = this.prefetechedSchemas;
                int n = this.prefetechedSchemas.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (count >= fc.getMaxSchemaCount()) break;
                    schemas.add(new SchemaNode(name));
                    ++count;
                    ++n2;
                }
                return schemas.toArray(new IDBNode[0]);
            }
            return new SchemaNode(null).refetchChildren(fc);
        }
        Map<String, TablesAndProcedures> schemas = this.generateSchemaToTablesAndProceduresMap(fc, supportsProcedure);
        return this.fetchChildrenFromMap(schemas, fc.getMaxSchemaCount());
    }

    private Map<String, TablesAndProcedures> generateSchemaToTablesAndProceduresMap(FilterConfig fc, boolean supportsProcedure) {
        String schemaName;
        ResultSet rs;
        HashMap<String, TablesAndProcedures> schemas = new HashMap<String, TablesAndProcedures>();
        String[] tableTypes = fc.getTableTypesForJDBC();
        if (tableTypes != null && (rs = JdbcMetaDataProvider.getInstance().getAlltables(fc.getSchemaName(), fc.getNamePattern(), fc.getTableTypesForJDBC())) != null) {
            try {
                while (rs.next()) {
                    schemaName = rs.getString("TABLE_SCHEM");
                    String tableName = rs.getString("TABLE_NAME");
                    String type = rs.getString("TABLE_TYPE");
                    TableNode table = new TableNode(schemaName, tableName, "VIEW".equalsIgnoreCase(type));
                    TablesAndProcedures tap = (TablesAndProcedures)schemas.get(schemaName);
                    if (tap == null) {
                        tap = new TablesAndProcedures();
                        schemas.put(schemaName, tap);
                    }
                    if (tap.getTableCount() >= fc.getMaxTableCountPerSchema()) continue;
                    tap.addTable(table);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        if (supportsProcedure && (fc.getType() == FilterConfig.Type.ALL || fc.getType() == FilterConfig.Type.PROCEDURE) && (rs = JdbcMetaDataProvider.getInstance().getProcedures(fc.getSchemaName(), fc.getNamePattern())) != null) {
            try {
                while (rs.next()) {
                    schemaName = rs.getString("PROCEDURE_SCHEM");
                    String procedureName = rs.getString("PROCEDURE_NAME");
                    ProcedureNode procedure = new ProcedureNode(schemaName, procedureName);
                    TablesAndProcedures tap = (TablesAndProcedures)schemas.get(schemaName);
                    if (tap == null) {
                        tap = new TablesAndProcedures();
                        schemas.put(schemaName, tap);
                    }
                    tap.addProcedure(procedure);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return schemas;
    }

    private IDBNode[] fetchChildrenFromMap(Map<String, TablesAndProcedures> schemas, int maxSchemaCount) {
        ArrayList<SchemaNode> result = new ArrayList<SchemaNode>();
        int count = 0;
        for (Map.Entry<String, TablesAndProcedures> entry : schemas.entrySet()) {
            if (count >= maxSchemaCount) break;
            SchemaNode schema = new SchemaNode(entry.getKey());
            TablesAndProcedures tap = entry.getValue();
            ArrayList<ChildrenAllowedNode> children = new ArrayList<ChildrenAllowedNode>();
            children.addAll(Arrays.asList(tap.getTables()));
            if (tap.getProcedureCount() > 0) {
                ProcedureFlagNode procedureFlagNode = new ProcedureFlagNode(entry.getKey());
                procedureFlagNode.setChildren(tap.getProcedures());
                children.add(procedureFlagNode);
            }
            schema.setChildren(children.toArray(new IDBNode[0]));
            result.add(schema);
            ++count;
        }
        if (result.size() == 1 && ((SchemaNode)result.get(0)).getSchemaName() == null) {
            return ((SchemaNode)result.get(0)).getChildren();
        }
        Collections.sort(result);
        return result.toArray(new IDBNode[0]);
    }

    private IDBNode[] fetchChildrenFromSchema(int maxSchemaCount) {
        ArrayList<SchemaNode> schemas = new ArrayList<SchemaNode>();
        ResultSet rs = JdbcMetaDataProvider.getInstance().getAllSchemas();
        if (rs != null) {
            int count = 0;
            try {
                while (rs.next() && count < maxSchemaCount) {
                    String name = rs.getString("TABLE_SCHEM");
                    SchemaNode schema = new SchemaNode(name);
                    schemas.add(schema);
                    ++count;
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return schemas.toArray(new SchemaNode[0]);
    }

    private IDBNode fetchSpecifiedSchema(String schemaName) {
        assert (schemaName != null);
        IDBNode result = null;
        ResultSet rs = JdbcMetaDataProvider.getInstance().getAllSchemas();
        if (rs != null) {
            try {
                while (rs.next()) {
                    String name = rs.getString("TABLE_SCHEM");
                    if (!name.equals(schemaName)) continue;
                    return new SchemaNode(name);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    @Override
    public String getDisplayName(String metadataBidiFormatStr) {
        return BidiTransform.transform((String)this.dataSourceName, (String)metadataBidiFormatStr, (String)"ILYNN");
    }

    @Override
    public Image getImage() {
        return JFaceResources.getImageRegistry().get(ROOT_ICON);
    }

    @Override
    public String getQualifiedNameInSQL(boolean useIdentifierQuoteString, boolean includeSchema, String metadataBidiFormatStr) {
        return null;
    }

    private static class TablesAndProcedures {
        private List<TableNode> tables = new ArrayList<TableNode>();
        private List<ProcedureNode> procedures = new ArrayList<ProcedureNode>();

        private TablesAndProcedures() {
        }

        public void addTable(TableNode table) {
            assert (table != null);
            this.tables.add(table);
        }

        public void addProcedure(ProcedureNode procedure) {
            assert (procedure != null);
            this.procedures.add(procedure);
        }

        public int getTableCount() {
            return this.tables.size();
        }

        public int getProcedureCount() {
            return this.procedures.size();
        }

        public TableNode[] getTables() {
            return this.tables.toArray(new TableNode[0]);
        }

        public ProcedureNode[] getProcedures() {
            return this.procedures.toArray(new ProcedureNode[0]);
        }
    }
}

