/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.provider;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverLoader;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;

public class JdbcMetaDataProvider {
    private String userName;
    private String url;
    private String driverClass;
    private String password;
    private Properties props;
    private Connection connection;
    private boolean connect_fail = false;
    private static Logger logger = Logger.getLogger(JdbcMetaDataProvider.class.getName());
    private static JdbcMetaDataProvider instance = null;

    private String getCatalog() throws SQLException {
        if (this.connection.getCatalog() != null && this.connection.getCatalog().trim().length() == 0) {
            return null;
        }
        return this.connection.getCatalog();
    }

    private JdbcMetaDataProvider(String driverClass, String url, String userName, String password, Properties props) {
        this.driverClass = driverClass;
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.props = props;
    }

    public static void createInstance(DataSetDesign dataSetDesign) {
        JdbcMetaDataProvider.release();
        DataSourceDesign dataSourceDesign = dataSetDesign.getDataSourceDesign();
        Properties props = new Properties();
        try {
            props = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)dataSourceDesign);
        }
        catch (OdaException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        String userName = props.getProperty("odaUser");
        String password = props.getProperty("odaPassword");
        String url = props.getProperty("odaURL");
        String driverClass = props.getProperty("odaDriverClass");
        String metadataBidiFormatStr = props.getProperty("metadataBidiFormatStr");
        if (metadataBidiFormatStr != null) {
            userName = BidiTransform.transform((String)userName, (String)"ILYNN", (String)metadataBidiFormatStr);
            password = BidiTransform.transform((String)password, (String)"ILYNN", (String)metadataBidiFormatStr);
            url = BidiTransform.transformURL((String)url, (String)"ILYNN", (String)metadataBidiFormatStr);
        }
        instance = new JdbcMetaDataProvider(driverClass, url, userName, password, props);
    }

    public static void release() {
        if (instance != null) {
            instance.closeConnection();
            instance = null;
        }
    }

    public void reconnect() throws SQLException, OdaException {
        if (this.connect_fail) {
            return;
        }
        this.closeConnection();
        try {
            this.connection = DriverLoader.getConnection(this.driverClass, this.url, this.userName, this.password, this.props);
        }
        catch (SQLException sqlException) {
            this.connect_fail = true;
            throw sqlException;
        }
        catch (OdaException odaException) {
            this.connect_fail = true;
            throw odaException;
        }
    }

    private void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public static JdbcMetaDataProvider getInstance() {
        return instance;
    }

    public String getIdentifierQuoteString() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return "";
            }
            try {
                return this.connection.getMetaData().getIdentifierQuoteString();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        try {
            return this.connection.getMetaData().getIdentifierQuoteString();
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getIdentifierQuoteString();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return "";
            }
        }
    }

    public boolean isSupportProcedure() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
            try {
                return this.connection.getMetaData().supportsStoredProcedures();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            return this.connection.getMetaData().supportsStoredProcedures();
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().supportsStoredProcedures();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return true;
            }
        }
    }

    public boolean isSupportSchema() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
            try {
                return this.connection.getMetaData().supportsSchemasInTableDefinitions();
            }
            catch (SQLException e) {
                try {
                    ResultSet rs = this.connection.getMetaData().getSchemas();
                    return rs != null;
                }
                catch (SQLException sQLException) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            return this.connection.getMetaData().supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().supportsSchemasInTableDefinitions();
            }
            catch (Exception e1) {
                try {
                    ResultSet rs = this.connection.getMetaData().getSchemas();
                    return rs != null;
                }
                catch (SQLException sQLException) {
                    logger.log(Level.WARNING, e.getMessage(), e1);
                    return false;
                }
            }
        }
    }

    public ResultSet getTableColumns(String schemaPattern, String tableNamePattern, String columnNamePattern) {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getColumns(this.getCatalog(), schemaPattern, tableNamePattern, columnNamePattern);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getColumns(this.getCatalog(), schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException sQLException) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getColumns(this.getCatalog(), schemaPattern, tableNamePattern, columnNamePattern);
            }
            catch (SQLException e1) {
                logger.log(Level.WARNING, e1.getMessage(), e1);
                return null;
            }
            catch (OdaException e1) {
                logger.log(Level.WARNING, e1.getMessage(), e1);
                return null;
            }
        }
    }

    public ResultSet getProcedures(String schemaPattern, String procedureNamePattern) {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getProcedures(this.getCatalog(), schemaPattern, procedureNamePattern);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getProcedures(this.getCatalog(), schemaPattern, procedureNamePattern);
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getProcedures(this.getCatalog(), schemaPattern, procedureNamePattern);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    public String[] getTableTypeNames(long milliSeconds) {
        class TempThread
        extends Thread {
            private List<String> names = new ArrayList<String>();

            TempThread() {
            }

            @Override
            public void run() {
                ResultSet rs = JdbcMetaDataProvider.this.getTableTypes();
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            this.names.add(rs.getString("TABLE_TYPE"));
                        }
                    }
                    catch (SQLException e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }

            public String[] getResult() {
                return this.names.toArray(new String[0]);
            }
        }
        TempThread tt = new TempThread();
        tt.start();
        try {
            tt.join(milliSeconds);
        }
        catch (InterruptedException interruptedException) {}
        return tt.getResult();
    }

    public ResultSet getTableTypes() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getTableTypes();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getTableTypes();
        }
        catch (SQLException sQLException) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getTableTypes();
            }
            catch (SQLException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                return null;
            }
            catch (OdaException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                return null;
            }
        }
    }

    public ResultSet getProcedureColumns(String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getProcedureColumns(this.getCatalog(), schemaPattern, procedureNamePattern, columnNamePattern);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getProcedureColumns(this.getCatalog(), schemaPattern, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException sQLException) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getProcedureColumns(this.getCatalog(), schemaPattern, procedureNamePattern, columnNamePattern);
            }
            catch (SQLException e1) {
                logger.log(Level.WARNING, e1.getMessage(), e1);
                return null;
            }
            catch (OdaException e1) {
                logger.log(Level.WARNING, e1.getMessage(), e1);
                return null;
            }
        }
    }

    public ResultSet getAlltables(String schemaPattern, String namePattern, String[] types) {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getTables(this.getCatalog(), schemaPattern, namePattern, types);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getTables(this.getCatalog(), schemaPattern, namePattern, types);
        }
        catch (SQLException sQLException) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getTables(this.getCatalog(), schemaPattern, namePattern, types);
            }
            catch (SQLException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                return null;
            }
            catch (OdaException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                return null;
            }
        }
    }

    public ResultSet getAllSchemas() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getSchemas();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getSchemas();
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getSchemas();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    public String[] getAllSchemaNames(long milliSeconds) {
        class TempThread
        extends Thread {
            private List<String> names = new ArrayList<String>();

            TempThread() {
            }

            @Override
            public void run() {
                ResultSet rs = JdbcMetaDataProvider.this.getAllSchemas();
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            this.names.add(rs.getString("TABLE_SCHEM"));
                        }
                    }
                    catch (SQLException e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }

            public String[] getResult() {
                return this.names.toArray(new String[0]);
            }
        }
        TempThread tt = new TempThread();
        tt.start();
        try {
            tt.join(milliSeconds);
        }
        catch (InterruptedException interruptedException) {}
        return tt.getResult();
    }
}

