/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm.js;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.debug.internal.core.vm.VMConstants;
import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsVariable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebuggableObject;

public class JsValue
implements VMValue,
VMConstants {
    private boolean isPrimitive;
    private Object value;
    private String reservedValueType;

    public JsValue(Object value) {
        this(value, false);
    }

    JsValue(Object value, String fixedValueType) {
        this(value, false);
        this.reservedValueType = fixedValueType;
    }

    JsValue(Object value, boolean isPrimitive) {
        this.value = value;
        this.isPrimitive = isPrimitive;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsValue)) {
            return false;
        }
        JsValue that = (JsValue)obj;
        if (this.isPrimitive != that.isPrimitive) {
            return false;
        }
        if (this.value == null ? that.value != null : !this.value.equals(that.value)) {
            return false;
        }
        if (this.reservedValueType == null) {
            return that.reservedValueType == null;
        }
        return this.reservedValueType.equals(that.reservedValueType);
    }

    public int hashCode() {
        int hash = Boolean.valueOf(this.isPrimitive).hashCode();
        if (this.value != null) {
            hash ^= this.value.hashCode();
        }
        if (this.reservedValueType != null) {
            hash ^= this.reservedValueType.hashCode();
        }
        return hash;
    }

    public VMVariable[] getMembers() {
        return (VMVariable[])Context.call((ContextAction)new ContextAction(){

            public Object run(Context arg0) {
                try {
                    return JsValue.this.getMembersImpl(arg0);
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    return new VMVariable[]{new JsVariable((Object)sw.toString(), "<error>", "<exception>")};
                }
            }
        });
    }

    static boolean isValidJsValue(Object val) {
        return val != Scriptable.NOT_FOUND && !(val instanceof Undefined) && !(val instanceof NativeJavaMethod) && !(val instanceof NativeJavaConstructor) && !(val instanceof NativeJavaPackage);
    }

    private VMVariable[] getMembersImpl(Context cx) {
        if (this.reservedValueType != null) {
            return NO_CHILD;
        }
        Object valObj = this.value;
        if (this.value instanceof NativeJavaObject) {
            valObj = ((NativeJavaObject)this.value).unwrap();
        }
        if (valObj == null || valObj.getClass().isPrimitive() || this.isPrimitive) {
            return NO_CHILD;
        }
        ArrayList<JsVariable> children = new ArrayList<JsVariable>();
        if (valObj.getClass().isArray()) {
            int len = Array.getLength(valObj);
            boolean primitive = valObj.getClass().getComponentType().isPrimitive();
            int i = 0;
            while (i < len) {
                Object aobj = Array.get(valObj, i);
                if (JsValue.isValidJsValue(aobj)) {
                    children.add(new JsVariable(aobj, "[" + children.size() + "]", primitive));
                }
                ++i;
            }
        } else if (valObj instanceof Scriptable) {
            Object[] ids = valObj instanceof DebuggableObject ? ((DebuggableObject)valObj).getAllIds() : ((Scriptable)valObj).getIds();
            if (ids == null || ids.length == 0) {
                return NO_CHILD;
            }
            int i = 0;
            while (i < ids.length) {
                if (ids[i] instanceof String) {
                    Object val = ScriptableObject.getProperty((Scriptable)((Scriptable)valObj), (String)((String)ids[i]));
                    if (val instanceof NativeJavaObject) {
                        val = ((NativeJavaObject)val).unwrap();
                    }
                    if (JsValue.isValidJsValue(val)) {
                        children.add(new JsVariable(val, (String)ids[i]));
                    }
                }
                ++i;
            }
        } else {
            this.reflectMembers(valObj, children);
        }
        if (children.size() == 0) {
            return NO_CHILD;
        }
        Collections.sort(children);
        return children.toArray(new VMVariable[children.size()]);
    }

    private void reflectMembers(Object obj, List children) {
        HashMap names = new HashMap();
        Class<?> clz = obj.getClass();
        Field fd = null;
        try {
            while (clz != null) {
                Field[] fds = clz.getDeclaredFields();
                int i = 0;
                while (i < fds.length) {
                    fd = fds[i];
                    fd.setAccessible(true);
                    if (!(Modifier.isStatic(fd.getModifiers()) || names.containsKey(fd.getName()) || obj instanceof LinkedHashMap && "header".equals(fd.getName()))) {
                        JsVariable jsVar = new JsVariable(fd.get(obj), fd.getName(), fd.getType().isPrimitive());
                        jsVar.setTypeName(JsValue.convertArrayTypeName(fd.getType(), fd.getType().isPrimitive()));
                        children.add(jsVar);
                        names.put(fd.getName(), null);
                    }
                    ++i;
                }
                clz = clz.getSuperclass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String convertArrayTypeName(Class clz, boolean explicitPrimitive) {
        if (clz.isArray()) {
            return String.valueOf(JsValue.convertPrimativeTypeName(clz.getComponentType(), explicitPrimitive)) + "[]";
        }
        return JsValue.convertPrimativeTypeName(clz, explicitPrimitive);
    }

    private static String convertPrimativeTypeName(Class clz, boolean explictPrimitive) {
        if (clz.isPrimitive() || explictPrimitive) {
            if (Boolean.class.equals((Object)clz) || Boolean.TYPE.equals(clz)) {
                return "boolean";
            }
            if (Character.class.equals((Object)clz) || Character.TYPE.equals(clz)) {
                return "char";
            }
            if (Byte.class.equals((Object)clz) || Byte.TYPE.equals(clz)) {
                return "byte";
            }
            if (Short.class.equals((Object)clz) || Short.TYPE.equals(clz)) {
                return "short";
            }
            if (Integer.class.equals((Object)clz) || Integer.TYPE.equals(clz)) {
                return "int";
            }
            if (Long.class.equals((Object)clz) || Long.TYPE.equals(clz)) {
                return "long";
            }
            if (Float.class.equals((Object)clz) || Float.TYPE.equals(clz)) {
                return "float";
            }
            if (Double.class.equals((Object)clz) || Double.TYPE.equals(clz)) {
                return "double";
            }
            if (Void.class.equals((Object)clz) || Void.TYPE.equals(clz)) {
                return "void";
            }
        }
        return clz.getName();
    }

    public String getTypeName() {
        if (this.reservedValueType != null) {
            return this.reservedValueType;
        }
        Object valObj = this.value;
        if (this.value instanceof NativeJavaObject) {
            valObj = ((NativeJavaObject)this.value).unwrap();
        }
        if (valObj != null) {
            return JsValue.convertArrayTypeName(valObj.getClass(), this.isPrimitive);
        }
        return "null";
    }

    public String getValueString() {
        Object valObj = this.value;
        if (this.value instanceof NativeJavaObject) {
            valObj = ((NativeJavaObject)this.value).unwrap();
        }
        if (valObj instanceof String) {
            return "\"" + valObj + "\"";
        }
        if (valObj instanceof Character) {
            return "'" + valObj + "'";
        }
        if (valObj instanceof Number || valObj instanceof Boolean || valObj == null) {
            return String.valueOf(valObj);
        }
        if (valObj.getClass().isArray()) {
            Class<?> compType = valObj.getClass().getComponentType();
            int len = Array.getLength(valObj);
            return String.valueOf(JsValue.convertPrimativeTypeName(compType, this.isPrimitive)) + "[" + len + "]";
        }
        return JsValue.convertPrimativeTypeName(valObj.getClass(), this.isPrimitive);
    }

    public String toString() {
        return String.valueOf(this.getTypeName()) + ": " + this.getValueString();
    }
}

