/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm.js;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.birt.report.debug.internal.core.vm.VMConstants;
import org.eclipse.birt.report.debug.internal.core.vm.VMStackFrame;
import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsContextData;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsDebugger;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsFunctionSource;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsValue;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsVariable;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class JsDebugFrame
implements DebugFrame,
VMStackFrame,
VMConstants {
    private JsDebugger debugger;
    private DebuggableScript script;
    private JsFunctionSource src;
    private Scriptable scope;
    private Scriptable thisObj;
    private Context cx;
    private int lineNo;

    public JsDebugFrame(Context cx, JsDebugger debugger, DebuggableScript script, JsFunctionSource src) {
        this.cx = cx;
        this.debugger = debugger;
        this.script = script;
        this.src = src;
    }

    public DebuggableScript getScript() {
        return this.script;
    }

    public String getName() {
        return this.script.getSourceName();
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public JsFunctionSource getSource() {
        return this.src;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public Scriptable getThisObject() {
        return this.thisObj;
    }

    private JsContextData contextData(Context cx) {
        return (JsContextData)cx.getDebuggerContextData();
    }

    public void onDebuggerStatement(Context arg0) {
    }

    public void onEnter(Context arg0, Scriptable arg1, Scriptable arg2, Object[] arg3) {
        int currentState = this.debugger.currentState();
        if (currentState == 10) {
            return;
        }
        this.cx = arg0;
        this.scope = arg1;
        this.thisObj = arg2;
        this.lineNo = this.src.getStartLineNumber();
        System.out.println(">>>> Enter script. " + this.lineNo);
        JsContextData cxData = this.contextData(arg0);
        cxData.pushFrame(this);
        if (cxData.breakOnStart) {
            cxData.breakOnStart = false;
            this.debugger.handleBreakHit(cxData, 8);
        }
    }

    public void onExceptionThrown(Context arg0, Throwable arg1) {
        System.out.println(">>>> Debugger exception occured:");
        arg1.printStackTrace();
    }

    public void onExit(Context arg0, boolean arg1, Object arg2) {
        int currentState = this.debugger.currentState();
        if (currentState == 10) {
            return;
        }
        this.cx = arg0;
        JsContextData contextData = this.contextData(arg0);
        contextData.popFrame();
        System.out.println(">>>> Exit script.");
    }

    public void onLineChange(Context arg0, int arg1) {
        int currentState = this.debugger.currentState();
        if (currentState == 10) {
            return;
        }
        this.cx = arg0;
        this.lineNo = arg1;
        System.out.println(">>>> Line changed to: " + this.lineNo);
        this.handleBreak(arg0, currentState);
    }

    private void handleBreak(Context cx, int currentState) {
        JsContextData contextData = this.contextData(cx);
        contextData.currentLineNo = this.lineNo;
        contextData.currentName = this.script.getSourceName();
        boolean stepped = false;
        if (contextData.breakNextLine && (stepped = contextData.targetFrmaeDepth >= 0 ? contextData.frameCount() <= contextData.targetFrmaeDepth : true)) {
            this.cleanSteppingStatus(contextData);
            if (currentState == 2) {
                this.debugger.handleBreakHit(contextData, 12);
            } else if (currentState == 1) {
                this.debugger.handleBreakHit(contextData, 13);
            } else if (currentState == 3) {
                this.debugger.handleBreakHit(contextData, 14);
            }
        }
        if (!stepped) {
            if (currentState == 5) {
                this.cleanSteppingStatus(contextData);
                this.debugger.handleBreakHit(contextData, 8);
            } else if (this.debugger.breakHitTest(contextData)) {
                this.cleanSteppingStatus(contextData);
                this.debugger.handleBreakHit(contextData, 7);
            }
        }
    }

    private void cleanSteppingStatus(JsContextData contextData) {
        contextData.breakNextLine = false;
        contextData.targetFrmaeDepth = -1;
    }

    public synchronized VMValue evaluate(String expression) {
        JsValue result;
        block7: {
            int currentState = this.debugger.currentState();
            if (currentState == 10) {
                return null;
            }
            result = null;
            Debugger oldDebugger = this.cx.getDebugger();
            Object oldContextData = this.cx.getDebuggerContextData();
            int oldLevel = this.cx.getOptimizationLevel();
            this.cx.setDebugger(null, null);
            this.cx.setOptimizationLevel(-1);
            this.cx.setGeneratingDebug(false);
            try {
                try {
                    Callable script = (Callable)this.cx.compileString(expression, "<evaluator>", 0, null);
                    Object val = script.call(this.cx, this.scope, this.thisObj, ScriptRuntime.emptyArgs);
                    if (val == Undefined.instance) {
                        result = new JsValue((Object)"<undefined>", "<undefined>");
                        break block7;
                    }
                    result = new JsValue(val);
                }
                catch (Exception ex) {
                    result = new JsValue((Object)ex.getMessage(), "<exception>");
                    this.cx.setGeneratingDebug(true);
                    this.cx.setOptimizationLevel(oldLevel);
                    this.cx.setDebugger(oldDebugger, oldContextData);
                }
            }
            finally {
                this.cx.setGeneratingDebug(true);
                this.cx.setOptimizationLevel(oldLevel);
                this.cx.setDebugger(oldDebugger, oldContextData);
            }
        }
        return result;
    }

    public VMVariable[] getVariables() {
        return (VMVariable[])Context.call((ContextAction)new ContextAction(){

            public Object run(Context arg0) {
                try {
                    return JsDebugFrame.this.getVariablesImpl(arg0);
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    return new VMVariable[]{new JsVariable((Object)sw.toString(), "<error>", "<exception>")};
                }
            }
        });
    }

    private VMVariable[] getVariablesImpl(Context cx) {
        ArrayList<JsVariable> vars = new ArrayList<JsVariable>();
        if (this.thisObj != null) {
            vars.add(new JsVariable(this.thisObj, "this"));
        }
        if (this.scope != null && this.script != null) {
            int i = 0;
            while (i < this.script.getParamAndVarCount()) {
                String name = this.script.getParamOrVarName(i);
                Object val = ScriptableObject.getProperty((Scriptable)this.scope, (String)name);
                if (JsValue.isValidJsValue(val)) {
                    vars.add(new JsVariable(val, name));
                }
                ++i;
            }
        }
        if (vars.size() == 0) {
            return NO_VARS;
        }
        Collections.sort(vars);
        return vars.toArray(new VMVariable[vars.size()]);
    }
}

