/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IParameterMetaData;
import org.eclipse.birt.data.engine.impl.ParameterMetaData;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.ParameterPageUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.model.adapter.oda.ReportParameterAdapter;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.Workbench;

public class DataSetParametersPage
extends AbstractDescriptionPropertyPage
implements Listener {
    protected boolean modelChanged = true;
    protected PropertyHandle parameters;
    protected PropertyHandleTableViewer viewer;
    protected DataSetParameter originalStructure = null;
    protected String parameterName;
    protected boolean isOdaDataSetHandle;
    protected boolean isJointOrDerivedDataSetHandle;
    protected static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.parameters");
    protected static String NONE_DEFAULT_VALUE = Messages.getString((String)"DataSetParametersPage.default.None");
    protected static String UNLINKED_REPORT_PARAM = Messages.getString((String)"DataSetParametersPage.reportParam.None");
    protected static final char RENAME_SEPARATOR = '_';
    protected static final String PARAM_PREFIX = "param_";

    public Control createContents(Composite parent) {
        this.parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        this.adjustPositions();
        return this.createParameterPageControl(parent);
    }

    protected Control createParameterPageControl(Composite parent) {
        DataSetHandle dataSetHandle = (DataSetHandle)this.getContainer().getModel();
        this.isOdaDataSetHandle = ParameterPageUtil.isOdaDataSetHandle(dataSetHandle);
        this.isJointOrDerivedDataSetHandle = ParameterPageUtil.isJointOrDerivedDataSetHandle(dataSetHandle);
        this.viewer = new PropertyHandleTableViewer(parent, !this.isJointOrDerivedDataSetHandle, true, true, !this.isJointOrDerivedDataSetHandle);
        this.createTableColumns();
        this.setContentProvider();
        this.setLabelProvider(dataSetHandle);
        this.adjustParameterOnPosition(this.parameters);
        if (ParameterPageUtil.isJointOrDerivedDataSetHandle(dataSetHandle)) {
            this.viewer.getViewer().setInput((Object)dataSetHandle);
        } else {
            this.viewer.getViewer().setInput((Object)this.parameters);
        }
        this.setToolTips();
        if (!this.isJointOrDerivedDataSetHandle) {
            this.addRefreshMenu();
            this.addListeners();
        }
        dataSetHandle.addListener((Listener)this);
        return this.viewer.getControl();
    }

    protected void setLabelProvider(DataSetHandle dataSetHandle) {
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new ParameterViewLableProvider(dataSetHandle));
    }

    protected void setContentProvider() {
        this.viewer.getViewer().setContentProvider((IContentProvider)new ParameterViewContentProvider());
    }

    protected void createTableColumns() {
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(23);
        if (this.isOdaDataSetHandle) {
            String[] cellLabels = ParameterPageUtil.odaCellLabels;
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[0]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[1]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[2]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[3]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[4]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[5]);
            column.setWidth(180);
        } else {
            String[] cellLabels = ParameterPageUtil.cellLabels;
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[0]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[1]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[2]);
            column.setWidth(100);
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(cellLabels[3]);
            column.setWidth(100);
            if (this.isJointOrDerivedDataSetHandle) {
                column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
                column.setText(ParameterPageUtil.odaCellLabels[5]);
                column.setWidth(180);
            }
        }
    }

    private void addRefreshMenu() {
        MenuItem itmRefresh = new MenuItem(this.viewer.getMenu(), 0, 0);
        new MenuItem(this.viewer.getMenu(), 2, 1);
        itmRefresh.setText(Messages.getString((String)"parameters.menuItem.reset"));
        itmRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyHandle handle = (PropertyHandle)DataSetParametersPage.this.viewer.getViewer().getInput();
                try {
                    handle.clearValue();
                }
                catch (SemanticException semanticException) {}
                DataSetParametersPage.this.refreshParameters();
                DataSetParametersPage.this.viewer.getViewer().refresh();
            }
        });
    }

    protected String[] getDirections() {
        boolean supportInput = ((DataSetEditor)this.getContainer()).supportsInParameters();
        boolean supportOutput = ((DataSetEditor)this.getContainer()).supportsOutputParameters();
        String[] directions = supportInput && supportOutput ? new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")} : (supportInput ? new String[]{Messages.getString((String)"label.input")} : (supportOutput ? new String[]{Messages.getString((String)"label.output")} : new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")}));
        return directions;
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.doNew();
            }
        });
        this.viewer.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.doEdit();
            }
        });
        this.viewer.getUpButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.doUp();
            }

            private void doUp() {
                int index = DataSetParametersPage.this.viewer.getViewer().getTable().getSelectionIndex();
                DataSetParametersPage.this.refreshPositions();
                DataSetParametersPage.this.viewer.getViewer().refresh();
                DataSetParametersPage.this.viewer.getViewer().getTable().setFocus();
                DataSetParametersPage.this.viewer.getViewer().getTable().select(index);
                DataSetParametersPage.this.viewer.updateButtons();
            }
        });
        this.viewer.getDownButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.doDown();
            }

            private void doDown() {
                int index = DataSetParametersPage.this.viewer.getViewer().getTable().getSelectionIndex();
                DataSetParametersPage.this.refreshPositions();
                DataSetParametersPage.this.viewer.getViewer().refresh();
                DataSetParametersPage.this.viewer.getViewer().getTable().setFocus();
                DataSetParametersPage.this.viewer.getViewer().getTable().select(index);
                DataSetParametersPage.this.viewer.updateButtons();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DataSetParametersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetParametersPage.this.setPageProperties();
                    DataSetParametersPage.this.refreshMessage();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = DataSetParametersPage.this.viewer.getViewer().getTable().getSelectionIndex();
                DataSetParametersPage.this.refreshPositions();
                DataSetParametersPage.this.viewer.getViewer().refresh();
                DataSetParametersPage.this.viewer.getViewer().getTable().setFocus();
                DataSetParametersPage.this.viewer.getViewer().getTable().select(index);
                DataSetParametersPage.this.setPageProperties();
                DataSetParametersPage.this.refreshMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = DataSetParametersPage.this.viewer.getViewer().getTable().getSelectionIndex();
                DataSetParametersPage.this.refreshPositions();
                DataSetParametersPage.this.viewer.getViewer().refresh();
                DataSetParametersPage.this.viewer.getViewer().getTable().setFocus();
                DataSetParametersPage.this.viewer.getViewer().getTable().select(index);
                DataSetParametersPage.this.setPageProperties();
                DataSetParametersPage.this.refreshMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.setPageProperties();
                DataSetParametersPage.this.refreshMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private String[] getAllScalarParamName() {
        ArrayList<String> names = new ArrayList<String>();
        String[] paramNames = null;
        List allNames = Utility.getAllParameters();
        names.add(Messages.getString((String)"DataSetParametersPage.reportParam.None"));
        int i = 0;
        while (i < allNames.size()) {
            ReportElementHandle handle = (ReportElementHandle)allNames.get(i);
            if (handle instanceof ScalarParameterHandle) {
                names.add(handle.getQualifiedName());
            }
            ++i;
        }
        paramNames = new String[names.size()];
        i = 0;
        while (i < names.size()) {
            paramNames[i] = names.get(i).toString();
            ++i;
        }
        return paramNames;
    }

    private void doNew() {
        Object newParam = null;
        newParam = this.isOdaDataSetHandle ? new OdaDataSetParameter() : new DataSetParameter();
        int position = this.viewer.getViewer().getTable().getItemCount();
        newParam.setName(this.getUniqueName());
        newParam.setIsInput(true);
        newParam.setPosition(Integer.valueOf(position + 1));
        CommandStack stack = Utility.getCommandStack();
        stack.startTrans(Messages.getString((String)"DataSetParameterBindingInputDialog.Title.NewParameter"));
        ParameterInputDialog dlg = new ParameterInputDialog(newParam, this.isOdaDataSetHandle);
        if (dlg.open() == 0) {
            this.viewer.getViewer().refresh();
            this.refreshMessage();
            this.refreshLinkedReportParamStatus();
            if (newParam instanceof OdaDataSetParameter) {
                this.handleLinkedMultipleValuesReportParam((OdaDataSetParameter)newParam);
            }
            stack.commit();
        } else {
            stack.rollback();
        }
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        DataSetParameterHandle handle = (DataSetParameterHandle)this.viewer.getViewer().getTable().getItem(index).getData();
        this.originalStructure = (DataSetParameter)handle.getStructure().copy();
        CommandStack stack = Utility.getCommandStack();
        stack.startTrans(Messages.getString((String)"DataSetParameterBindingInputDialog.Title.EditParameter"));
        ParameterInputDialog dlg = new ParameterInputDialog(handle, this.isOdaDataSetHandle);
        if (dlg.open() == 0) {
            this.viewer.getViewer().refresh();
            this.refreshMessage();
            this.refreshLinkedReportParamStatus();
            if (handle instanceof OdaDataSetParameterHandle) {
                this.handleLinkedMultipleValuesReportParam((OdaDataSetParameter)((OdaDataSetParameterHandle)handle).getStructure());
            }
            stack.commit();
        } else {
            stack.rollback();
        }
    }

    private void handleLinkedMultipleValuesReportParam(OdaDataSetParameter dsParam) {
        if (dsParam.getParamName() == null) {
            return;
        }
        ScalarParameterHandle paramHandle = ParameterPageUtil.getScalarParameter(dsParam.getParamName(), true);
        if (paramHandle != null && "multi-value".equals(paramHandle.getParamType())) {
            MessageDialog.openWarning((Shell)Workbench.getInstance().getDisplay().getActiveShell(), (String)Messages.getString((String)"DataSetParameterPage.warningLinkedMultipleValuesParams.title"), (String)this.getWarning(dsParam));
        }
    }

    protected void refreshLinkedReportParamStatus() {
        TableItem[] items = this.viewer.getViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            OdaDataSetParameterHandle handle;
            if (items[i].getData() instanceof OdaDataSetParameterHandle && (handle = (OdaDataSetParameterHandle)items[i].getData()).getParamName() != null) {
                ScalarParameterHandle reportParam = ParameterPageUtil.getScalarParameter(handle.getParamName(), true);
                if (reportParam == null) {
                    this.getContainer().setMessage(Messages.getFormattedString((String)"DataSetParametersPage.errorMessage.LinkedReportParamNotFound", (Object[])new Object[]{handle.getParamName(), handle.getName()}), 3);
                }
                this.viewer.getViewer().refresh();
            }
            ++i;
        }
    }

    protected void refreshMessage() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        if (!this.doSaveEmptyParameter(this.parameters)) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.noInputParameterDefaultValue", (Object[])new Object[]{this.getNoneValuedParameterName()}), 3);
        }
    }

    protected DataSetParameter getStructure(Object structureOrHandle) {
        DataSetParameter structure = null;
        structure = structureOrHandle instanceof DataSetParameter ? (DataSetParameter)structureOrHandle : (DataSetParameter)((DataSetParameterHandle)structureOrHandle).getStructure();
        return structure;
    }

    private void adjustParameterOnPosition(PropertyHandle handle) {
        if (handle.getListValue() != null) {
            int i = 1;
            while (i <= handle.getListValue().size()) {
                int position = i - 1;
                while (position < handle.getListValue().size()) {
                    DataSetParameterHandle param = (DataSetParameterHandle)handle.getAt(position);
                    if (param.getPosition() == i) {
                        try {
                            handle.moveItem(position, i - 1);
                            break;
                        }
                        catch (PropertyValueException propertyValueException) {}
                    }
                    ++position;
                }
                ++i;
            }
        }
    }

    private void setToolTips() {
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.New"));
        this.viewer.getEditButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Edit"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Remove"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Up"));
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Down"));
    }

    protected final String getDirectionDisplayName(boolean isInput, boolean isOutput) {
        if (isInput && isOutput) {
            return ParameterPageUtil.directions[2];
        }
        if (isOutput) {
            return ParameterPageUtil.directions[1];
        }
        return ParameterPageUtil.directions[0];
    }

    public void pageActivated() {
        this.refreshMessage();
        if (this.viewer != null && this.modelChanged) {
            this.modelChanged = false;
            this.adjustParameterOnPosition(this.parameters);
            this.viewer.getViewer().refresh();
        }
        this.setPageProperties();
        this.refreshLinkedReportParamStatus();
        this.viewer.getViewer().getTable().select(0);
    }

    private void refreshParameters() {
        try {
            DataSetHandle ds = (DataSetHandle)this.getContainer().getModel();
            Collection paramsFromDataSet = null;
            paramsFromDataSet = DataSetProvider.getCurrentInstance().getParametersFromDataSet(ds);
            if (paramsFromDataSet != null) {
                for (IParameterMetaData paramFromDataSet : paramsFromDataSet) {
                    DataSetParameter parameter = null;
                    parameter = paramFromDataSet.getPosition() > 0 ? this.findParameterByPosition(paramFromDataSet.getPosition()) : this.findParameterByName(paramFromDataSet.getName());
                    if (parameter != null) {
                        DataSetParameter newParameter = this.newParameter(paramFromDataSet);
                        if (this.isSameParameters(parameter, newParameter)) continue;
                        this.parameters.replaceItem((IStructure)parameter, (IStructure)newParameter);
                        continue;
                    }
                    this.parameters.addItem((IStructure)this.newParameter(paramFromDataSet));
                }
                if (this.parameters.getListValue() != null && paramsFromDataSet.size() < this.parameters.getListValue().size()) {
                    int size = this.parameters.getListValue().size();
                    while (size > paramsFromDataSet.size()) {
                        this.parameters.removeItem(size - 1);
                        size = this.parameters.getListValue().size();
                    }
                }
                this.updateParams2UniqueName(this.parameters.getListValue());
            } else if (this.viewer != null) {
                PropertyHandle handle = (PropertyHandle)this.viewer.getViewer().getInput();
                handle.clearValue();
            }
            this.refreshPositions();
            this.setPageProperties();
            this.refreshMessage();
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private DataSetParameter newParameter(IParameterMetaData paramFromDataSet) {
        OdaDataSetParameter parameter = null;
        if (this.isOdaDataSetHandle) {
            parameter = new OdaDataSetParameter();
            if (paramFromDataSet instanceof ParameterMetaData) {
                parameter.setNativeName(((ParameterMetaData)paramFromDataSet).getNativeName());
            }
            if ("REF CURSOR".equals(paramFromDataSet.getNativeTypeName())) {
                parameter.setNativeDataType(Integer.valueOf(-10));
            }
        } else {
            parameter = new DataSetParameter();
        }
        try {
            parameter.setParameterDataType(DataAdapterUtil.coreDataTypeToModelDataType((String)paramFromDataSet.getDataTypeName()));
        }
        catch (Exception exception) {}
        parameter.setDefaultValue(paramFromDataSet.getDefaultInputValue());
        if (paramFromDataSet.isOptional() != null) {
            parameter.setIsOptional(paramFromDataSet.isOptional().booleanValue());
        }
        if (paramFromDataSet.isNullable() != null) {
            parameter.setAllowNull(paramFromDataSet.isNullable().booleanValue());
        }
        if (paramFromDataSet.isInputMode() != null) {
            parameter.setIsInput(paramFromDataSet.isInputMode().booleanValue());
        }
        if (paramFromDataSet.isOutputMode() != null) {
            parameter.setIsOutput(paramFromDataSet.isOutputMode().booleanValue());
        }
        if (paramFromDataSet.isInputMode() == null && paramFromDataSet.isOutputMode() == null || !parameter.isInput() && !parameter.isOutput()) {
            parameter.setIsInput(true);
        }
        if (paramFromDataSet.getName() == null || paramFromDataSet.getName().trim().length() == 0) {
            parameter.setName(this.getUniqueName());
        } else {
            parameter.setName(paramFromDataSet.getName());
        }
        parameter.setPosition(Integer.valueOf(paramFromDataSet.getPosition()));
        return parameter;
    }

    private boolean isSameParameters(DataSetParameter param1, DataSetParameter param2) {
        boolean isSame = false;
        if (param1 == param2) {
            isSame = true;
        } else if (param1 == null || param2 == null) {
            isSame = false;
        } else if (param1.getParameterDataType().equals(param2.getParameterDataType()) && param1.isInput() == param2.isInput() && param1.isOutput() == param2.isOutput()) {
            isSame = true;
        }
        return isSame;
    }

    private void updateParams2UniqueName(List parameters) {
        List existedNames = DataSetParametersPage.collectParameterNames(parameters);
        ArrayList<String> newNames = new ArrayList<String>();
        int i = 0;
        while (i < parameters.size()) {
            DataSetParameter param = (DataSetParameter)parameters.get(i);
            String name = param.getName();
            if (newNames.contains(name)) {
                String prefix = String.valueOf(name) + '_';
                int n = 1;
                while (existedNames.contains(name = String.valueOf(prefix) + n) || newNames.contains(name)) {
                    ++n;
                }
                param.setName(name);
            }
            newNames.add(name);
            ++i;
        }
    }

    private static List collectParameterNames(List parameters) {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < parameters.size()) {
            DataSetParameter param = (DataSetParameter)parameters.get(i);
            String name = param.getName();
            if (!StringUtil.isBlank((String)name) && !names.contains(name)) {
                names.add(name);
            }
            ++i;
        }
        return names;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.modelChanged = true;
    }

    protected final DataSetParameter findParameterByPosition(int position) {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (parameter.getPosition() == null || parameter.getPosition() != position) continue;
                return (DataSetParameter)parameter.getStructure();
            }
        }
        return null;
    }

    protected final DataSetParameter findParameterByName(String name) {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (name == null || !name.equals(parameter.getName())) continue;
                return (DataSetParameter)parameter.getStructure();
            }
        }
        return null;
    }

    protected final void refreshPositions() {
        if (this.parameters == null) {
            this.parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        }
        if (this.parameters != null) {
            int position = 1;
            Iterator iter = this.parameters.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                    if (parameter instanceof OdaDataSetParameterHandle) {
                        boolean hasNativeName;
                        boolean bl = hasNativeName = ((OdaDataSetParameterHandle)parameter).getNativeName() != null && ((OdaDataSetParameterHandle)parameter).getNativeName().trim().length() > 0;
                        if (!(hasNativeName || parameter.getPosition() != null && parameter.getPosition() == position)) {
                            parameter.setPosition(Integer.valueOf(position));
                        } else if (hasNativeName && parameter.getPosition() != null && parameter.getPosition() > 0 && parameter.getPosition() != position) {
                            parameter.setPosition(Integer.valueOf(position));
                        }
                        ++position;
                        continue;
                    }
                    parameter.setPosition(Integer.valueOf(position++));
                }
            }
        }
    }

    private final void adjustPositions() {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (parameter.getPosition() != null && parameter.getPosition() > 0) continue;
                this.refreshPositions();
                return;
            }
        }
    }

    protected final String getUniqueName() {
        int n = 1;
        StringBuffer buf = new StringBuffer();
        while (buf.length() == 0) {
            Iterator iter;
            buf.append(PARAM_PREFIX).append(n++);
            if (this.parameters == null || (iter = this.parameters.iterator()) == null) continue;
            while (iter.hasNext() && buf.length() > 0) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (!buf.toString().equalsIgnoreCase(parameter.getName())) continue;
                buf.setLength(0);
            }
        }
        return buf.toString();
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        DataSetHandle dataSetHandle = (DataSetHandle)this.getContainer().getModel();
        this.isOdaDataSetHandle = ParameterPageUtil.isOdaDataSetHandle(dataSetHandle);
        this.isJointOrDerivedDataSetHandle = ParameterPageUtil.isJointOrDerivedDataSetHandle(dataSetHandle);
        if (this.doSaveEmptyParameter(this.parameters)) {
            if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
                this.modelChanged = false;
                ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
            }
            ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
            return super.performOk();
        }
        String name = this.getNoneValuedParameterName();
        boolean confirm = MessageDialog.openConfirm(null, (String)Messages.getString((String)"dataset.editor.error.title"), (String)Messages.getFormattedString((String)"dataset.editor.error.validationParameter", (Object[])new Object[]{name}));
        if (confirm) {
            ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
        }
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return confirm;
    }

    private boolean doSaveEmptyParameter(PropertyHandle parameters) {
        if (this.isJointOrDerivedDataSetHandle) {
            return true;
        }
        if (parameters == null) {
            parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        }
        if (parameters != null) {
            Iterator iter = parameters.iterator();
            String paramName = null;
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                    if (this.isOdaDataSetHandle) {
                        paramName = ((OdaDataSetParameterHandle)parameter).getParamName();
                    }
                    if (!parameter.isInput() || paramName != null || parameter.isOutput() || parameter.getDefaultValue() != null && parameter.getDefaultValue().trim().length() != 0) continue;
                    this.setNoneValuedParameterName(parameter.getName());
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canLeave() {
        if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
            this.modelChanged = false;
            ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
        }
        return true;
    }

    public boolean canFinish() {
        return this.doSaveEmptyParameter(this.parameters);
    }

    private void setPageProperties() {
        boolean parametersExist;
        this.viewer.updateButtons();
        boolean bl = parametersExist = this.parameters != null && this.parameters.getListValue() != null && this.parameters.getListValue().size() > 0;
        if (!parametersExist) {
            this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetParametersPage.Filter.Tooltip");
    }

    public String getNoneValuedParameterName() {
        return this.parameterName;
    }

    private void setNoneValuedParameterName(String name) {
        this.parameterName = name;
    }

    private void enableModelChanged() {
        ((DataSetEditor)this.getContainer()).enableLinkedParamChanged();
    }

    private String getDefaultValue(OdaDataSetParameter parameter) {
        String value = null;
        value = parameter.getParamName() == null || parameter.getParamName().trim().length() == 0 ? parameter.getDefaultValue() : NONE_DEFAULT_VALUE;
        return value;
    }

    protected String getLinkedReportParameterLabel(OdaDataSetParameter parameter) {
        ScalarParameterHandle reportParam;
        String value = parameter.getParamName();
        if (value != null && (reportParam = ParameterPageUtil.getScalarParameter(parameter.getParamName(), true)) != null && "multi-value".equals(reportParam.getParamType())) {
            value = String.valueOf(value) + " (" + Messages.getString((String)"DataSetParameterPage.multiValuesType") + ")";
        }
        if (value == null || value.trim().length() == 0) {
            value = UNLINKED_REPORT_PARAM;
        }
        return value;
    }

    protected String getWarning(OdaDataSetParameter parameter) {
        ScalarParameterHandle reportParam;
        String value = "";
        if (parameter.getParamName() != null && (reportParam = ParameterPageUtil.getScalarParameter(parameter.getParamName(), true)) != null) {
            if ("multi-value".equals(reportParam.getParamType())) {
                value = Messages.getString((String)"DataSetParametersPage.errorMessage.InvalidType.LinkedReportParam");
            } else if (parameter.getDataType() != null && !parameter.getDataType().equalsIgnoreCase(reportParam.getDataType())) {
                value = Messages.getString((String)"DataSetParameterPage.warning.UnmatchedParamDataType");
            }
        }
        return value;
    }

    private class ParameterInputDialog
    extends PropertyHandleInputDialog {
        private DataSetParameterHandle structureHandle;
        private Composite defaultValueComposite;
        private Composite reportParamComposite;
        private String defaultValueString;
        private String directionString;
        private Text dataSetParamName;
        private Text nativeParameterName;
        private Combo dataType;
        private Combo direction;
        private Text defaultValueText;
        private Combo linkToScalarParameter;
        private boolean inputChanged;
        private boolean isOdaDataSetHandle;
        private Button parameterButton;
        private String originalLinkToParamName;

        protected ParameterInputDialog(Object structureOrHandle, boolean isOdaDataSetHandle) {
            super(structureOrHandle);
            this.structureHandle = null;
            this.defaultValueComposite = null;
            this.reportParamComposite = null;
            this.defaultValueString = "";
            this.directionString = "";
            this.dataSetParamName = null;
            this.nativeParameterName = null;
            this.dataType = null;
            this.direction = null;
            this.defaultValueText = null;
            this.linkToScalarParameter = null;
            this.inputChanged = DataSetParametersPage.this.modelChanged;
            this.isOdaDataSetHandle = false;
            this.isOdaDataSetHandle = isOdaDataSetHandle;
            this.structureHandle = this.getStructureHandle(structureOrHandle);
        }

        public void create() {
            super.create();
            this.validateSyntax();
        }

        protected void setSystemHelp(Composite composite) {
            Utility.setSystemHelp((Control)composite, (String)"org.eclipse.birt.cshelp.Dialog_DataSet_Parameters_ID");
        }

        protected void createCustomControls(Composite parent) {
            int index = 0;
            if (!this.isOdaDataSetHandle) {
                String[] dialogLables = ParameterPageUtil.dialogLabels;
                this.createNameCell(parent, dialogLables[index]);
                this.createComboCellDataType(parent, dialogLables[++index]);
                this.createComboCellDirection(parent, dialogLables[++index]);
                this.createExpressionCell(parent, dialogLables[++index]);
                this.directionChanged();
            } else {
                String[] dialogLables = ParameterPageUtil.odaDialogLabels;
                this.createNameCell(parent, dialogLables[index]);
                this.createNativeNameCell(parent, dialogLables[++index]);
                this.createComboCellDataType(parent, dialogLables[++index]);
                this.createComboCellDirection(parent, dialogLables[++index]);
                this.createExpressionCell(parent, dialogLables[++index]);
                this.createComboCellParameter(parent, dialogLables[++index]);
                this.directionChanged();
            }
        }

        private void createNameCell(Composite parent, String lable) {
            ControlProvider.createLabel(parent, lable);
            this.dataSetParamName = ControlProvider.createText(parent, this.structureHandle.getName());
            this.dataSetParamName.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.dataSetParamName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterInputDialog.this.validateSyntax();
                }
            });
        }

        private void createNativeNameCell(Composite parent, String lable) {
            ControlProvider.createLabel(parent, lable);
            this.nativeParameterName = ControlProvider.createText(parent, ((OdaDataSetParameterHandle)this.structureHandle).getNativeName());
            this.nativeParameterName.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.nativeParameterName.setEnabled(false);
        }

        private void createComboCellDataType(Composite parent, String label) {
            ControlProvider.createLabel(parent, label);
            this.dataType = ControlProvider.createCombo(parent, 8);
            this.dataType.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.dataType.setVisibleItemCount(30);
            if (this.structureHandle.getNativeDataType() != null && this.structureHandle.getNativeDataType() == -10) {
                this.dataType.setEnabled(false);
            } else {
                this.dataType.setItems(ParameterPageUtil.getDataTypeDisplayNames());
                this.dataType.select(Utility.findIndex((String[])this.dataType.getItems(), (String)ParameterPageUtil.getTypeDisplayName(this.structureHandle.getParameterDataType())));
                this.dataType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ParameterInputDialog.this.validateSyntax();
                    }
                });
            }
        }

        private void createComboCellDirection(Composite parent, String label) {
            ControlProvider.createLabel(parent, label);
            this.direction = ControlProvider.createCombo(parent, 8);
            this.direction.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.direction.setItems(DataSetParametersPage.this.getDirections());
            this.directionString = DataSetParametersPage.this.getDirectionDisplayName(this.structureHandle.isInput(), this.structureHandle.isOutput());
            this.direction.select(Utility.findIndex((String[])this.direction.getItems(), (String)this.directionString));
            this.direction.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ParameterInputDialog.this.needsUpdateUI()) {
                        ParameterInputDialog.this.directionString = ParameterInputDialog.this.direction.getText();
                        ParameterInputDialog.this.directionChanged();
                        ParameterInputDialog.this.validateSyntax();
                    }
                }
            });
        }

        private boolean needsUpdateUI() {
            if (this.directionString.equals(this.direction.getText())) {
                return false;
            }
            return this.directionString.equals(ParameterPageUtil.directions[1]) || this.isOutputParameter();
        }

        private void createExpressionCell(Composite parent, String label) {
            ControlProvider.createLabel(parent, label);
            this.defaultValueComposite = ControlProvider.getDefaultComposite(parent);
            this.defaultValueString = Utility.getNonNullString((String)this.structureHandle.getDefaultValue());
            this.defaultValueText = ControlProvider.createText(this.defaultValueComposite, this.defaultValueString);
            this.defaultValueText.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            this.defaultValueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ParameterInputDialog.this.defaultValueText.isEnabled()) {
                        ParameterInputDialog.this.defaultValueString = ParameterInputDialog.this.defaultValueText.getText();
                        ParameterInputDialog.this.validateSyntax();
                    }
                }
            });
            new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(ParameterInputDialog.this.defaultValueText.getText());
                    expressionBuilder.setExpressionProvier(null);
                    if (expressionBuilder.open() == 0) {
                        ParameterInputDialog.this.defaultValueText.setText(expressionBuilder.getResult().trim());
                    }
                }
            };
            ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)((DataSetHandle)DataSetParametersPage.this.getContainer().getModel()));
            ExpressionButtonUtil.createExpressionButton((Composite)this.defaultValueComposite, (Control)this.defaultValueText, (IExpressionProvider)provider, (Object)((DataSetHandle)DataSetParametersPage.this.getContainer().getModel()), (boolean)true, (int)8);
            ExpressionButtonUtil.initExpressionButtonControl((Control)this.defaultValueText, (Object)this.structureHandle, (String)"defaultValue");
        }

        private void createComboCellParameter(Composite parent, String label) {
            ControlProvider.createLabel(parent, label);
            this.reportParamComposite = ControlProvider.getDefaultComposite(parent);
            this.linkToScalarParameter = new Combo(this.reportParamComposite, 8);
            this.linkToScalarParameter.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            this.linkToScalarParameter.setItems(ParameterPageUtil.getLinkedReportParameterNames((OdaDataSetParameterHandle)this.structureHandle));
            this.linkToScalarParameter.setVisibleItemCount(30);
            this.linkToScalarParameter.select(Utility.findIndex((String[])this.linkToScalarParameter.getItems(), (String)((OdaDataSetParameterHandle)this.structureHandle).getParamName()));
            this.originalLinkToParamName = this.linkToScalarParameter.getText();
            this.linkToScalarParameter.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String originalLink = ParameterInputDialog.this.originalLinkToParamName;
                    ParameterInputDialog.this.linkToScalarParameterChanged();
                    ParameterInputDialog.this.originalLinkToParamName = ParameterInputDialog.this.linkToScalarParameter.getText();
                    ParameterInputDialog.this.updateLinkedReportParameter(originalLink);
                    if (ParameterInputDialog.this.linkToScalarParameter.isEnabled()) {
                        ParameterInputDialog.this.validateSyntax();
                    }
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ParameterInputDialog.this.updateStructureHandle();
                    OdaDataSetParameterHandle dataSetParameterHandle = (OdaDataSetParameterHandle)ParameterInputDialog.this.structureHandle;
                    String originalParamName = dataSetParameterHandle.getParamName();
                    ParameterDialog dialog = null;
                    ScalarParameterHandle handle = ParameterPageUtil.getScalarParameter(ParameterInputDialog.this.linkToScalarParameter.getText(), false);
                    boolean isCreateMode = true;
                    if (handle == null) {
                        handle = (ScalarParameterHandle)ElementProcessorFactory.createProcessor((String)"ScalarParameter").createElement(null);
                        dialog = new ParameterDialog(ParameterInputDialog.this.getParentShell(), Messages.getString((String)"ParameterGroupNodeProvider.Dialogue.ParameterNew"), false);
                        if (dataSetParameterHandle != null) {
                            ParameterInputDialog.this.executeLinkedReportParameterUpdate((ParameterHandle)handle, dataSetParameterHandle);
                        }
                        isCreateMode = true;
                    } else {
                        dialog = new ParameterDialog(ParameterInputDialog.this.getParentShell(), Messages.getString((String)"ParameterNodeProvider.dial.title.editScalar"), false);
                        isCreateMode = false;
                    }
                    ScalarParameterListener scalarParameterListener = new ScalarParameterListener();
                    handle.addListener((Listener)scalarParameterListener);
                    dialog.setInput((Object)handle);
                    if (dialog.open() == 0) {
                        if (dialog.getResult() instanceof ParameterHandle) {
                            ParameterHandle paramerHandle = (ParameterHandle)dialog.getResult();
                            if (isCreateMode) {
                                SlotHandle parameterSlotHandle = Utility.getReportModuleHandle().getParameters();
                                try {
                                    parameterSlotHandle.add((DesignElementHandle)paramerHandle);
                                    ParameterInputDialog.this.linkToScalarParameter.add(paramerHandle.getQualifiedName());
                                }
                                catch (ContentException e) {
                                    ExceptionHandler.handle((Throwable)e);
                                }
                                catch (NameException e) {
                                    ExceptionHandler.handle((Throwable)e);
                                }
                            }
                            ParameterInputDialog.this.linkToScalarParameter.setItems(ParameterPageUtil.getLinkedReportParameterNames((OdaDataSetParameterHandle)ParameterInputDialog.this.structureHandle));
                            ParameterInputDialog.this.originalLinkToParamName = paramerHandle.getQualifiedName();
                            ParameterInputDialog.this.linkToScalarParameter.select(Utility.findIndex((String[])ParameterInputDialog.this.linkToScalarParameter.getItems(), (String)paramerHandle.getQualifiedName()));
                        }
                    } else {
                        dataSetParameterHandle.setParamName(originalParamName);
                    }
                    handle.removeListener((Listener)scalarParameterListener);
                }
            };
            this.parameterButton = new Button(this.reportParamComposite, 8);
            this.parameterButton.setImage(ReportPlatformUIImages.getImage((String)"Parameter"));
            this.parameterButton.addSelectionListener((SelectionListener)listener);
            this.checkParameterButtonTooltip();
        }

        private void executeLinkedReportParameterUpdate(ParameterHandle handle, OdaDataSetParameterHandle dataSetParameterHandle) {
            ReportParameterAdapter adapter = new ReportParameterAdapter();
            try {
                adapter.updateLinkedReportParameter((ScalarParameterHandle)handle, dataSetParameterHandle, ((DataSetEditor)DataSetParametersPage.this.getContainer()).getCurrentDataSetDesign());
            }
            catch (SemanticException semanticException) {
            }
            catch (OdaException odaException) {}
        }

        public void updateLinkedReportParameter(String originalLink) {
            ScalarParameterHandle orignalHandle = null;
            if (!originalLink.equals(Messages.getString((String)"DataSetParametersPage.reportParam.None"))) {
                orignalHandle = ParameterPageUtil.getScalarParameter(originalLink, true);
            }
            ScalarParameterHandle currentHandle = null;
            if (!this.linkToScalarParameter.getText().equals(Messages.getString((String)"DataSetParametersPage.reportParam.None"))) {
                currentHandle = ParameterPageUtil.getScalarParameter(this.linkToScalarParameter.getText(), true);
            }
            OdaDataSetParameterHandle dataSetParameterHandle = (OdaDataSetParameterHandle)this.structureHandle;
            if (currentHandle != null && orignalHandle != currentHandle) {
                boolean setting = ReportPlugin.getDefault().getPluginPreferences().getBoolean("reportParam_update_enable");
                String option = ReportPlugin.getDefault().getPluginPreferences().getString("reportParam_update_enable_option");
                if (setting) {
                    if (option != null && option.equals("update")) {
                        this.executeLinkedReportParameterUpdate((ParameterHandle)currentHandle, dataSetParameterHandle);
                    }
                    return;
                }
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(Workbench.getInstance().getDisplay().getActiveShell(), Messages.getString((String)"DataSetParameterPage.updateReportParameter.title"), null, Messages.getString((String)"DataSetParameterPage.updateReportParameter.message"), 3, new String[]{Messages.getString((String)"DataSetParameterPage.updateReportParameter.promptButtonYes"), Messages.getString((String)"DataSetParameterPage.updateReportParameter.promptButtonNo")}, 1, Messages.getString((String)"DataSetParameterPage.updateReportParameter.propmtText"), false);
                dialog.open();
                if (dialog.getReturnCode() == 256) {
                    this.executeLinkedReportParameterUpdate((ParameterHandle)currentHandle, dataSetParameterHandle);
                }
                if (dialog.getToggleState()) {
                    ReportPlugin.getDefault().getPluginPreferences().setValue("reportParam_update_enable", true);
                    if (dialog.getReturnCode() == 256) {
                        ReportPlugin.getDefault().getPluginPreferences().setValue("reportParam_update_enable_option", "update");
                    } else {
                        ReportPlugin.getDefault().getPluginPreferences().setValue("reportParam_update_enable_option", "ignore");
                    }
                }
            }
        }

        protected void rollback() {
            DataSetParametersPage.this.modelChanged = this.inputChanged;
        }

        protected IStatus validateSemantics(Object structureOrHandle) {
            Status status = this.updateStructureHandle();
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
            return this.getOKStatus();
        }

        private Status updateStructureHandle() {
            try {
                this.structureHandle.setName(this.dataSetParamName.getText());
                this.structureHandle.setParameterDataType(ParameterPageUtil.getTypeName(this.dataType.getText()));
                this.setDirection(this.direction.getText());
                if (this.defaultValueText.isEnabled()) {
                    ExpressionButtonUtil.saveExpressionButtonControl((Control)this.defaultValueText, (Object)this.structureHandle, (String)"defaultValue");
                }
                if (this.isOdaDataSetHandle) {
                    ((OdaDataSetParameterHandle)this.structureHandle).setParamName(Utility.findIndex((String[])this.linkToScalarParameter.getItems(), (String)this.linkToScalarParameter.getText()) == 0 ? null : this.linkToScalarParameter.getText());
                }
            }
            catch (SemanticException e) {
                return this.getMiscStatus(4, Utility.getNonNullString((String)e.getMessage()));
            }
            return null;
        }

        private void setDirection(String direction) {
            if (direction == null || direction.equals("")) {
                return;
            }
            if (direction.equals(ParameterPageUtil.directions[0])) {
                this.structureHandle.setIsInput(true);
                this.structureHandle.setIsOutput(false);
            } else if (direction.equals(ParameterPageUtil.directions[1])) {
                this.structureHandle.setIsInput(false);
                this.structureHandle.setIsOutput(true);
            } else if (direction.equals(ParameterPageUtil.directions[2])) {
                this.structureHandle.setIsInput(true);
                this.structureHandle.setIsOutput(true);
            }
        }

        protected IStatus validateSyntax(Object structureOrHandle) {
            if (!this.isUniqueName()) {
                return this.getMiscStatus(4, Messages.getString((String)"dataset.editor.error.duplicateParameterName"));
            }
            if (this.isBlankProperty(this.dataSetParamName.getText())) {
                return this.getBlankPropertyStatus(ParameterPageUtil.dialogLabels[0]);
            }
            if (this.isNull()) {
                return this.getMiscStatus(4, Messages.getString((String)"dataset.editor.error.nonemptyDefaultvalue"));
            }
            return this.getOKStatus();
        }

        private boolean isNull() {
            return this.defaultValueText.isEnabled() && this.defaultValueString.trim().length() == 0;
        }

        private boolean isMatchedParamDataType() {
            String dataSetParamType = ParameterPageUtil.getTypeName(this.dataType.getText());
            ScalarParameterHandle scalarParam = ParameterPageUtil.getScalarParameter(this.linkToScalarParameter.getText(), false);
            if (dataSetParamType != null && scalarParam != null) {
                return dataSetParamType.equalsIgnoreCase(scalarParam.getDataType());
            }
            return true;
        }

        private boolean isUniqueName() {
            DataSetParameter structure = DataSetParametersPage.this.getStructure(this.getStructureOrHandle());
            Iterator iter = DataSetParametersPage.this.parameters.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle handle = (DataSetParameterHandle)iter.next();
                    if (DataSetParametersPage.this.originalStructure != null && this.dataSetParamName.getText().equals(DataSetParametersPage.this.originalStructure.getName())) {
                        return true;
                    }
                    if (structure == handle.getStructure() || !handle.getName().equals(this.dataSetParamName.getText())) continue;
                    return false;
                }
            }
            return true;
        }

        private void directionChanged() {
            if (this.isOutputParameter()) {
                this.enableComposite(this.defaultValueComposite, false);
                this.defaultValueText.setText("");
                this.defaultValueString = "";
                if (this.isOdaDataSetHandle) {
                    this.enableComposite(this.reportParamComposite, false);
                    this.linkToScalarParameter.select(0);
                }
            } else if (this.isOdaDataSetHandle) {
                this.enableComposite(this.reportParamComposite, true);
                this.linkToScalarParameterChanged();
            } else {
                this.enableComposite(this.defaultValueComposite, true);
            }
        }

        private void linkToScalarParameterChanged() {
            String paramName;
            String string = paramName = Utility.findIndex((String[])this.linkToScalarParameter.getItems(), (String)this.linkToScalarParameter.getText()) == 0 ? null : this.linkToScalarParameter.getText();
            if (paramName == null) {
                this.enableComposite(this.defaultValueComposite, this.linkToScalarParameter.isEnabled());
                this.defaultValueText.setText(this.defaultValueString);
            } else {
                if (this.defaultValueText.isEnabled()) {
                    this.defaultValueString = this.defaultValueText.getText();
                }
                this.enableComposite(this.defaultValueComposite, false);
                this.defaultValueText.setText(NONE_DEFAULT_VALUE);
            }
            this.checkParameterButtonTooltip();
        }

        private void checkParameterButtonTooltip() {
            ScalarParameterHandle handle = ParameterPageUtil.getScalarParameter(this.linkToScalarParameter.getText(), false);
            if (this.parameterButton != null && !this.parameterButton.isDisposed()) {
                if (handle == null) {
                    this.parameterButton.setToolTipText(Messages.getString((String)"DataSetParametersPage.ParameterButton.Tooltip.New"));
                } else {
                    this.parameterButton.setToolTipText(Messages.getString((String)"DataSetParametersPage.ParameterButton.Tooltip.Edit"));
                }
            }
        }

        private boolean isOutputParameter() {
            return this.direction.getText().equals(ParameterPageUtil.directions[1]);
        }

        private void enableComposite(Composite composite, boolean enable) {
            if (composite.isEnabled() != enable) {
                composite.setEnabled(enable);
                Control[] controls = composite.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].setEnabled(enable);
                    ++i;
                }
            }
        }

        private DataSetParameterHandle getStructureHandle(Object structureOrHandle) {
            if (structureOrHandle instanceof DataSetParameterHandle) {
                return (DataSetParameterHandle)structureOrHandle;
            }
            DataSetParameterHandle handle = null;
            try {
                handle = (DataSetParameterHandle)DataSetParametersPage.this.parameters.addItem((IStructure)((DataSetParameter)structureOrHandle));
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            assert (handle != null);
            return handle;
        }

        protected String getTitle() {
            return this.getStructureOrHandle() instanceof Structure ? Messages.getString((String)"DataSetParameterBindingInputDialog.Title.NewParameter") : Messages.getString((String)"DataSetParameterBindingInputDialog.Title.EditParameter");
        }
    }

    private class ParameterViewContentProvider
    implements IStructuredContentProvider {
        private static final String separator = "::";

        private ParameterViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof JointDataSetHandle) {
                JointDataSetHandle handle = (JointDataSetHandle)inputElement;
                List params = this.getSubDataSetParameters(handle, "", 0);
                return params.toArray();
            }
            if (inputElement instanceof DerivedDataSetHandle) {
                List paramList = this.getDerivedDataSetParameters((DerivedDataSetHandle)inputElement, "", 0);
                return paramList.toArray();
            }
            if (!(inputElement instanceof PropertyHandle)) {
                return new Object[0];
            }
            Iterator iter = ((PropertyHandle)inputElement).iterator();
            ArrayList params = new ArrayList(10);
            if (iter != null) {
                while (iter.hasNext()) {
                    params.add(iter.next());
                }
            }
            return params.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        /*
         * Unable to fully structure code
         */
        private List getSubDataSetParameters(JointDataSetHandle jointDataSetHandle, String prefix, int count) {
            block6: {
                subDataSetParams = new ArrayList<DataSetParameter>();
                children = jointDataSetHandle.dataSetsIterator();
                if (jointDataSetHandle.getDataSetNames().size() != 1 || !children.hasNext()) ** GOTO lbl37
                nextElement = (DataSetHandle)children.next();
                prefix = String.valueOf(prefix) + nextElement.getName();
                if (nextElement instanceof JointDataSetHandle) {
                    subDataSetParams.addAll(this.getSubDataSetParameters((JointDataSetHandle)nextElement, String.valueOf(prefix) + "1" + "::", count));
                    subDataSetParams.addAll(this.getSubDataSetParameters((JointDataSetHandle)nextElement, String.valueOf(prefix) + "2" + "::", count += subDataSetParams.size()));
                } else {
                    params = nextElement.parametersIterator();
                    while (params.hasNext()) {
                        param = (DataSetParameterHandle)params.next();
                        v0 = ++count;
                        newParam1 = this.createDataSetParameter(param, String.valueOf(prefix) + "1", v0);
                        newParam2 = this.createDataSetParameter(param, String.valueOf(prefix) + "2", ++count);
                        subDataSetParams.add(newParam1);
                        subDataSetParams.add(newParam2);
                    }
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    nextElement = (DataSetHandle)children.next();
                    preFixStr = String.valueOf(prefix) + nextElement.getName();
                    if (nextElement instanceof JointDataSetHandle) {
                        subDataSetParams.addAll(this.getSubDataSetParameters((JointDataSetHandle)nextElement, String.valueOf(preFixStr) + "::", count));
                        count += subDataSetParams.size();
                        continue;
                    }
                    params = nextElement.parametersIterator();
                    while (params.hasNext()) {
                        param = (DataSetParameterHandle)params.next();
                        subDataSetParams.add(this.createDataSetParameter(param, preFixStr, ++count));
                    }
lbl37:
                    // 3 sources

                    ** while (children.hasNext())
                }
            }
            return subDataSetParams;
        }

        private List getDerivedDataSetParameters(DerivedDataSetHandle derivedDataSetHandle, String prefix, int count) {
            ArrayList<DataSetParameter> subDataSetParams = new ArrayList<DataSetParameter>();
            List dataSets = derivedDataSetHandle.getInputDataSets();
            int i = 0;
            while (i < dataSets.size()) {
                DataSetHandle handle = (DataSetHandle)dataSets.get(i);
                String preFixStr = String.valueOf(prefix) + handle.getName();
                if (handle instanceof DerivedDataSetHandle) {
                    subDataSetParams.addAll(this.getDerivedDataSetParameters((DerivedDataSetHandle)handle, String.valueOf(preFixStr) + separator, count));
                    count += subDataSetParams.size();
                } else {
                    Iterator params = handle.parametersIterator();
                    while (params.hasNext()) {
                        DataSetParameterHandle param = (DataSetParameterHandle)params.next();
                        subDataSetParams.add(this.createDataSetParameter(param, preFixStr, ++count));
                    }
                }
                ++i;
            }
            return subDataSetParams;
        }

        private DataSetParameter createDataSetParameter(DataSetParameterHandle parameter, String dataSetName, int position) {
            OdaDataSetParameter dataSetParameter = null;
            if (parameter instanceof OdaDataSetParameterHandle) {
                dataSetParameter = new OdaDataSetParameter();
                dataSetParameter.setParamName(((OdaDataSetParameterHandle)parameter).getParamName());
            } else {
                dataSetParameter = new DataSetParameter();
            }
            dataSetParameter.setDataType(parameter.getDataType());
            dataSetParameter.setAllowNull(parameter.allowNull());
            dataSetParameter.setDefaultValue(parameter.getDefaultValue());
            dataSetParameter.setExpressionProperty("defaultValue", (Expression)parameter.getExpressionProperty("defaultValue").getValue());
            dataSetParameter.setIsInput(parameter.isInput());
            dataSetParameter.setIsOutput(parameter.isOutput());
            dataSetParameter.setName(String.valueOf(dataSetName) + separator + parameter.getName());
            dataSetParameter.setIsOptional(parameter.isOptional());
            dataSetParameter.setPosition(Integer.valueOf(position));
            return dataSetParameter;
        }
    }

    private class ParameterViewLableProvider
    implements ITableLabelProvider {
        private DataSetHandle dataSetHandle;

        public ParameterViewLableProvider(DataSetHandle dataSetHandle) {
            this.dataSetHandle = dataSetHandle;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = null;
            DataSetParameter parameter = DataSetParametersPage.this.getStructure(element);
            value = DataSetParametersPage.this.isOdaDataSetHandle ? this.getOdaParametersValue((OdaDataSetParameter)parameter, columnIndex) : (DataSetParametersPage.this.isJointOrDerivedDataSetHandle ? this.getJointDataSetParametersValue(parameter, columnIndex) : this.getParametersValue(parameter, columnIndex));
            return value == null ? "" : value;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        private String getJointDataSetParametersValue(DataSetParameter parameter, int columnIndex) {
            if (columnIndex == 4) {
                if (parameter instanceof OdaDataSetParameter) {
                    return DataSetParametersPage.this.getDefaultValue((OdaDataSetParameter)parameter);
                }
                return parameter.getDefaultValue();
            }
            if (columnIndex == 5) {
                String value = null;
                if (parameter instanceof OdaDataSetParameter) {
                    value = DataSetParametersPage.this.getLinkedReportParameterLabel((OdaDataSetParameter)parameter);
                }
                return value == null || value.trim().length() == 0 ? UNLINKED_REPORT_PARAM : value;
            }
            return this.getParametersValue(parameter, columnIndex);
        }

        private String getParametersValue(DataSetParameter parameter, int columnIndex) {
            String value = null;
            switch (columnIndex) {
                case 0: {
                    if (parameter.getPosition() == null) break;
                    value = parameter.getPosition().toString();
                    break;
                }
                case 1: {
                    value = parameter.getName();
                    break;
                }
                case 2: {
                    value = ParameterPageUtil.getTypeDisplayName(parameter.getParameterDataType());
                    break;
                }
                case 3: {
                    value = DataSetParametersPage.this.getDirectionDisplayName(parameter.isInput(), parameter.isOutput());
                    break;
                }
                case 4: {
                    value = parameter.getDefaultValue();
                }
            }
            return value;
        }

        private String getOdaParametersValue(OdaDataSetParameter parameter, int columnIndex) {
            String value = null;
            switch (columnIndex) {
                case 0: {
                    if (parameter.getPosition() != null && parameter.getPosition() > 0) {
                        value = parameter.getPosition().toString();
                        break;
                    }
                    value = "";
                    break;
                }
                case 1: {
                    value = parameter.getName();
                    break;
                }
                case 2: {
                    value = parameter.getNativeName();
                    break;
                }
                case 3: {
                    if (parameter.getNativeDataType() != null && parameter.getNativeDataType() == -10) {
                        value = null;
                        break;
                    }
                    value = ParameterPageUtil.getTypeDisplayName(parameter.getParameterDataType());
                    break;
                }
                case 4: {
                    value = DataSetParametersPage.this.getDirectionDisplayName(parameter.isInput(), parameter.isOutput());
                    break;
                }
                case 5: {
                    value = DataSetParametersPage.this.getDefaultValue(parameter);
                    break;
                }
                case 6: {
                    value = DataSetParametersPage.this.getLinkedReportParameterLabel(parameter);
                }
            }
            return value;
        }
    }

    protected class ScalarParameterListener
    implements Listener {
        protected ScalarParameterListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            DataSetParametersPage.this.modelChanged = true;
            DataSetParametersPage.this.enableModelChanged();
        }
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetParametersPage.this.setPageProperties();
        }
    }
}

