/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.report.designer.internal.ui.util.UIHelper;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.MultiPageReportEditor;
import org.eclipse.birt.report.designer.ui.preview.Activator;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.emitter.config.IEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.impl.EmitterConfigurationManager;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.viewer.utilities.IWebAppInfo;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PreviewSupport {
    protected static final String TYPE_HTML = "html";
    private static final Map<String, String> typeMap = new HashMap<String, String>();
    private static final String IMG_FILE_DEFAULT = "icons/etool16/preview.gif";
    private static final String IMG_FILE_WEB = "icons/etool16/preview.gif";

    static {
        typeMap.put("doc", "icons/etool16/preview_doc.gif");
        typeMap.put(TYPE_HTML, "icons/etool16/preview_html.gif");
        typeMap.put("pdf", "icons/etool16/preview_pdf.gif");
        typeMap.put("ppt", "icons/etool16/preview_ppt.gif");
        typeMap.put("postscript", "icons/etool16/preview_ps.gif");
        typeMap.put("xls", "icons/etool16/preview_xls.gif");
        typeMap.put("docx", "icons/etool16/preview_docx.gif");
        typeMap.put("pptx", "icons/etool16/preview_pptx.gif");
        typeMap.put("xhtml", "icons/etool16/preview_xhtml.gif");
    }

    PreviewSupport() {
    }

    protected Menu getPreviewMenu(Object parent, boolean fullLabel) {
        Menu menu;
        ReportEngine engine = new ReportEngine(new EngineConfig());
        EmitterInfo[] emitters = engine.getEmitterInfo();
        if (emitters == null) {
            return null;
        }
        TreeMap<String, ArrayList<EmitterInfo>> supportedFormats = new TreeMap<String, ArrayList<EmitterInfo>>();
        EmitterInfo[] emitterInfoArray = emitters;
        int n = emitters.length;
        int n2 = 0;
        while (n2 < n) {
            EmitterInfo ei = emitterInfoArray[n2];
            if (!ei.isHidden().booleanValue()) {
                ArrayList<EmitterInfo> list = (ArrayList<EmitterInfo>)supportedFormats.get(ei.getFormat());
                if (list == null) {
                    list = new ArrayList<EmitterInfo>();
                    supportedFormats.put(ei.getFormat(), list);
                }
                list.add(ei);
            }
            ++n2;
        }
        if (parent instanceof Control) {
            menu = new Menu((Control)parent);
        } else if (parent instanceof Menu) {
            menu = new Menu((Menu)parent);
        } else {
            return null;
        }
        MenuItem previewWebViewer = new MenuItem(menu, 8);
        previewWebViewer.setText("&1 " + Messages.getString((String)(fullLabel ? "designer.preview.previewaction.label.webviewer" : "designer.preview.run.webviewer")));
        previewWebViewer.setImage(UIHelper.getImage((Bundle)Activator.getDefault().getBundle(), (String)"icons/etool16/preview.gif"));
        previewWebViewer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewSupport.this.preview(PreviewSupport.TYPE_HTML, true);
            }
        });
        EmitterConfigurationManager configManager = new EmitterConfigurationManager();
        int i = 0;
        for (Map.Entry ent : supportedFormats.entrySet()) {
            String format = (String)ent.getKey();
            List emits = (List)ent.getValue();
            MenuItem previewOption = new MenuItem(menu, emits.size() > 1 ? 64 : 8);
            String indexPrefix = i > 7 ? "  " : "&" + (i++ + 2);
            previewOption.setText(String.valueOf(indexPrefix) + " " + Messages.getFormattedString((String)(fullLabel ? "designer.preview.previewaction.label" : "designer.preview.run"), (Object[])new Object[]{format.toUpperCase()}));
            previewOption.setImage(this.getFormatIcon(format, emits));
            if (emits.size() > 1) {
                Menu subMenu = new Menu(previewOption);
                previewOption.setMenu(subMenu);
                int j = 1;
                for (final EmitterInfo ei : emits) {
                    MenuItem sub1 = new MenuItem(subMenu, 8);
                    final IEmitterDescriptor emitterDescriptor = configManager.getEmitterDescriptor(ei.getID());
                    String label = null;
                    if (emitterDescriptor != null && emitterDescriptor.getDisplayName() != null) {
                        label = emitterDescriptor.getDisplayName();
                    }
                    if (label == null) {
                        label = this.getDefaultLabel(ei);
                    }
                    sub1.setText("&" + j++ + " " + label);
                    sub1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PreviewSupport.this.preview(ei, emitterDescriptor);
                        }
                    });
                }
                continue;
            }
            final EmitterInfo ei = (EmitterInfo)emits.get(0);
            final IEmitterDescriptor emitterDescriptor = configManager.getEmitterDescriptor(ei.getID());
            previewOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreviewSupport.this.preview(ei, emitterDescriptor);
                }
            });
        }
        return menu;
    }

    private String getDefaultLabel(EmitterInfo ei) {
        String format = ei.getFormat().toUpperCase();
        String formatDetail = ei.getID();
        return formatDetail == null ? format : String.valueOf(format) + " (" + formatDetail + ")";
    }

    private Image getFormatIcon(String format, List<EmitterInfo> emits) {
        Image icon = null;
        for (EmitterInfo ei : emits) {
            String path = ei.getIcon();
            IConfigurationElement confElem = ei.getEmitter();
            if (confElem == null || path == null) continue;
            String pluginId = confElem.getDeclaringExtension().getNamespace();
            Bundle bundle = Platform.getBundle((String)pluginId);
            icon = UIHelper.getImage((Bundle)bundle, (String)path, (boolean)false);
        }
        if (icon == null) {
            icon = typeMap.containsKey(format) ? UIHelper.getImage((Bundle)Activator.getDefault().getBundle(), (String)typeMap.get(format)) : UIHelper.getImage((Bundle)Activator.getDefault().getBundle(), (String)"icons/etool16/preview.gif");
        }
        return icon;
    }

    protected boolean prePreview() {
        System.clearProperty("TransientSecurityID");
        System.clearProperty("TransientDataSecurityID");
        System.clearProperty("MaxDataSetRows");
        return true;
    }

    protected void preview(String format, boolean allowPage) {
        if (!this.prePreview()) {
            return;
        }
        FormEditor editor = UIUtil.getActiveReportEditor((boolean)false);
        ModuleHandle model = null;
        if (editor instanceof MultiPageReportEditor) {
            model = ((MultiPageReportEditor)editor).getModel();
        }
        if (!UIUtil.canPreviewWithErrors(model)) {
            return;
        }
        if (editor != null) {
            IFormPage activePageInstance = editor.getActivePageInstance();
            if (model.needsSave() || activePageInstance != null && activePageInstance.isDirty()) {
                editor.doSave(null);
            }
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("FORMAT_KEY", format);
        options.put("ALLOW_PAGE_KEY", allowPage);
        options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder());
        if (this.hasParameters(model)) {
            options.put("SHOW_PARAMETER_PAGE", "true");
        }
        WebViewer.display((String)model.getFileName(), options);
    }

    private boolean hasParameters(ModuleHandle model) {
        IWebAppInfo webapp = WebViewer.getCurrentWebApp();
        if (webapp != null && webapp.useCustomParamHandling()) {
            return false;
        }
        List parameters = model.getFlattenParameters();
        if (parameters != null) {
            for (Object p : parameters) {
                if (!(p instanceof ParameterHandle) || ((ParameterHandle)p).isHidden()) continue;
                return true;
            }
        }
        return false;
    }

    protected void preview(EmitterInfo ei, IEmitterDescriptor descriptor) {
        if (!this.prePreview()) {
            return;
        }
        FormEditor editor = UIUtil.getActiveReportEditor((boolean)false);
        ModuleHandle model = null;
        if (editor instanceof MultiPageReportEditor) {
            model = ((MultiPageReportEditor)editor).getModel();
        }
        if (!UIUtil.canPreviewWithErrors(model)) {
            return;
        }
        if (editor != null && model.needsSave()) {
            editor.doSave(null);
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("EMITTER_ID_KEY", ei.getID());
        options.put("FORMAT_KEY", ei.getFormat());
        options.put("ALLOW_PAGE_KEY", false);
        options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder());
        WebViewer.display((String)model.getFileName(), options);
    }
}

