/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import com.ibm.icu.util.ULocale;
import java.text.Collator;
import java.util.Arrays;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.browsers.BrowserManager;
import org.eclipse.birt.report.viewer.utilities.AppContextUtil;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PreviewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button alwaysExternal;
    private Button svgFlag;
    private Button masterPageContent;
    private Button[] externalBrowsers;
    private Button customBrowserRadio;
    private Label customBrowserPathLabel;
    private Text customBrowserPath;
    private Button customBrowserBrowse;
    private Combo localeCombo;
    private Combo timeZoneCombo;
    private Button appContextExt;
    private Combo appContextExtCombo;
    private Combo bidiCombo;
    private static final String WBROWSER_PAGE_ID = "org.eclipse.ui.browser.preferencePage";
    private static final String PREFERENCE_HELPER_ID = "PreviewPreferencePage";
    private static final String[] BIDI_CHOICE_NAMES = new String[]{"auto", "ltr", "rtl"};
    private static final String[] BIDI_CHOICE_DISPLAYNAMES = new String[]{Messages.getString((String)"designer.preview.preference.bidiOrientation.auto"), Messages.getString((String)"designer.preview.preference.bidiOrientation.ltr"), Messages.getString((String)"designer.preview.preference.bidiOrientation.rtl")};
    public static TreeMap<String, String> timeZoneTable_disKey = null;
    public static TreeMap<String, String> timeZoneTable_idKey = null;

    static {
        timeZoneTable_disKey = new TreeMap(Collator.getInstance());
        String[] ids = TimeZone.getAvailableIDs();
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                String id = ids[i];
                if (id != null) {
                    TimeZone timeZone = TimeZone.getTimeZone(id);
                    String timeZoneDisplayName = timeZone.getDisplayName();
                    timeZoneTable_disKey.put(timeZoneDisplayName, id);
                }
                ++i;
            }
        }
    }

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.Preference_BIRT_Preview_ID");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        Label description = new Label(mainComposite, 0);
        description.setText(Messages.getString((String)"designer.preview.preference.browser.description"));
        this.createSpacer(mainComposite);
        Composite composite = new Composite(mainComposite, 0);
        data = new GridData(768);
        data.horizontalIndent = 0;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 0;
        layout.marginWidth = 0;
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)layout);
        Label localeDescription = new Label(composite, 0);
        localeDescription.setText(Messages.getString((String)"designer.preview.preference.locale.description"));
        this.localeCombo = new Combo(composite, 4);
        this.localeCombo.setLayoutData((Object)new GridData(768));
        this.localeCombo.setVisibleItemCount(30);
        assert (WebViewer.LOCALE_TABLE != null);
        String[] localeDisplayNames = new String[WebViewer.LOCALE_TABLE.size()];
        WebViewer.LOCALE_TABLE.keySet().toArray(localeDisplayNames);
        this.localeCombo.setItems(localeDisplayNames);
        String defaultLocale = ViewerPlugin.getDefault().getPluginPreferences().getString("user_locale");
        if (defaultLocale == null || defaultLocale.trim().length() <= 0) {
            assert (ULocale.getDefault() != null);
            defaultLocale = ULocale.getDefault().getDisplayName();
        } else if (WebViewer.LOCALE_TABLE.values().contains(defaultLocale)) {
            for (Map.Entry entry : WebViewer.LOCALE_TABLE.entrySet()) {
                if (!defaultLocale.equals(entry.getValue())) continue;
                defaultLocale = (String)entry.getKey();
                break;
            }
        }
        this.localeCombo.setText(defaultLocale);
        this.createTimeZoneChoice(composite);
        this.createBIDIChoice(composite);
        this.createSpacer(mainComposite);
        this.svgFlag = new Button(mainComposite, 32);
        this.svgFlag.setLayoutData((Object)new GridData(512));
        this.svgFlag.setText(Messages.getString((String)"designer.preview.preference.browser.svg"));
        this.svgFlag.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getBoolean("svg_flag"));
        this.masterPageContent = new Button(mainComposite, 32);
        this.masterPageContent.setLayoutData((Object)new GridData(512));
        this.masterPageContent.setText(Messages.getString((String)"designer.preview.preference.masterpagecontent"));
        this.masterPageContent.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getBoolean("master_page_content"));
        if (this.needAddItem()) {
            String[] appExtNames = AppContextUtil.getAppContextExtensionNames().toArray(new String[0]);
            String appKey = ViewerPlugin.getDefault().getPluginPreferences().getString("APPCONTEXT_EXTENSION_KEY");
            Composite appContextComposite = new Composite(mainComposite, 0);
            appContextComposite.setLayoutData((Object)new GridData(512));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            appContextComposite.setLayout((Layout)gridLayout);
            this.appContextExt = new Button(appContextComposite, 32);
            this.appContextExt.setSelection(appKey != null && appKey.length() > 0);
            this.appContextExt.setEnabled(appExtNames.length != 0);
            this.appContextExt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreviewPreferencePage.this.appContextExtCombo.setEnabled(PreviewPreferencePage.this.appContextExt.getSelection());
                    if (PreviewPreferencePage.this.appContextExt.getSelection()) {
                        if (PreviewPreferencePage.this.appContextExtCombo.getSelectionIndex() != -1) {
                            ViewerPlugin.getDefault().getPluginPreferences().setValue("APPCONTEXT_EXTENSION_KEY", PreviewPreferencePage.this.appContextExtCombo.getText());
                        }
                    } else {
                        ViewerPlugin.getDefault().getPluginPreferences().setValue("APPCONTEXT_EXTENSION_KEY", "");
                    }
                }
            });
            Label label = new Label(appContextComposite, 0);
            label.setText(Messages.getString((String)"designer.preview.preference.appcontextkey"));
            label.setLayoutData((Object)new GridData(512));
            new Label(appContextComposite, 0);
            this.appContextExtCombo = new Combo(appContextComposite, 12);
            this.appContextExtCombo.setVisibleItemCount(30);
            this.appContextExtCombo.setItems(appExtNames);
            if (this.appContextExt.getSelection()) {
                this.appContextExtCombo.setEnabled(this.appContextExt.isEnabled());
                this.appContextExtCombo.setText(appKey);
            } else {
                this.appContextExtCombo.setEnabled(false);
            }
            GridData extGd = new GridData();
            int width = this.appContextExtCombo.computeSize((int)-1, (int)-1).x;
            extGd.widthHint = width < 200 ? 200 : width;
            this.appContextExtCombo.setLayoutData((Object)extGd);
            this.appContextExtCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewerPlugin.getDefault().getPluginPreferences().setValue("APPCONTEXT_EXTENSION_KEY", PreviewPreferencePage.this.appContextExtCombo.getText());
                }
            });
        }
        this.createSpacer(mainComposite);
        this.alwaysExternal = new Button(mainComposite, 32);
        this.alwaysExternal.setLayoutData((Object)new GridData(512));
        this.alwaysExternal.setText(Messages.getString((String)"designer.preview.preference.browser.useExternal"));
        this.alwaysExternal.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getBoolean("always_external_browser"));
        if (!BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            this.alwaysExternal.setSelection(true);
            this.alwaysExternal.setEnabled(false);
        }
        this.createLinkArea(mainComposite);
        this.createSpacer(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
        this.createSpacer(mainComposite);
        return mainComposite;
    }

    private boolean needAddItem() {
        IDialogHelper helper = this.getPreviewPrefrence();
        return helper == null;
    }

    private IDialogHelper getPreviewPrefrence() {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)((Object)this), IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper helper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (helper = helperProvider.createHelper((Object)this, PREFERENCE_HELPER_ID)) != null) {
                    return helper;
                }
                ++i;
            }
        }
        return null;
    }

    private void createLinkArea(Composite parent) {
        IPreferenceNode node = this.getPreferenceNode(WBROWSER_PAGE_ID);
        if (node != null) {
            PreferenceLinkArea linkArea = new PreferenceLinkArea(parent, 64, WBROWSER_PAGE_ID, Messages.getString((String)"designer.preview.preference.browser.extbrowser.link"), (IWorkbenchPreferenceContainer)this.getContainer(), null);
            GridData data = new GridData(768);
            linkArea.getControl().setLayoutData((Object)data);
        }
    }

    private IPreferenceNode getPreferenceNode(String pageId) {
        for (IPreferenceNode next : PlatformUI.getWorkbench().getPreferenceManager().getElements(0)) {
            if (!next.getId().equals(pageId)) continue;
            return next;
        }
        return null;
    }

    private void createCustomBrowserPathPart(Composite mainComposite) {
        Font font = mainComposite.getFont();
        new Label(mainComposite, 0);
        Composite bPathComposite = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        bPathComposite.setLayout((Layout)layout);
        bPathComposite.setLayoutData((Object)new GridData(768));
        this.customBrowserPathLabel = new Label(bPathComposite, 16384);
        this.customBrowserPathLabel.setFont(font);
        this.customBrowserPathLabel.setText(Messages.getString((String)"designer.preview.preference.browser.program"));
        this.customBrowserPath = new Text(bPathComposite, 2048);
        this.customBrowserPath.setLayoutData((Object)new GridData(768));
        this.customBrowserPath.setFont(font);
        this.customBrowserPath.setText(ViewerPlugin.getDefault().getPluginPreferences().getString("custom_browser_path"));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.widthHint = this.convertWidthInCharsToPixels(10);
        this.customBrowserPath.setLayoutData((Object)data);
        this.customBrowserBrowse = new Button(bPathComposite, 0);
        this.customBrowserBrowse.setFont(font);
        this.customBrowserBrowse.setText(Messages.getString((String)"designer.preview.preference.browser.browse"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.customBrowserBrowse.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.customBrowserBrowse.setLayoutData((Object)data);
        this.customBrowserBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog d = new FileDialog(PreviewPreferencePage.this.getShell());
                d.setText(Messages.getString((String)"designer.preview.preference.browser.details"));
                String file = d.open();
                if (file != null) {
                    PreviewPreferencePage.this.customBrowserPath.setText("\"" + file + "\" %1");
                }
            }
        });
        this.setCustomBrowserPathEnabled();
    }

    protected void performDefaults() {
        if (this.svgFlag != null) {
            this.svgFlag.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getDefaultBoolean("svg_flag"));
        }
        if (this.bidiCombo != null) {
            String defualtBidi = ViewerPlugin.getDefault().getPluginPreferences().getDefaultString("bidi_orientation");
            int index = Arrays.asList(BIDI_CHOICE_NAMES).indexOf(defualtBidi);
            if (index < 0) {
                index = 0;
            }
            this.bidiCombo.select(index);
        }
        if (this.masterPageContent != null) {
            this.masterPageContent.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getDefaultBoolean("master_page_content"));
        }
        if (this.alwaysExternal != null) {
            this.alwaysExternal.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getDefaultBoolean("always_external_browser"));
        }
        if (this.localeCombo != null) {
            ULocale defaultLocale = ULocale.getDefault();
            assert (defaultLocale != null);
            this.localeCombo.setText(defaultLocale.getDisplayName());
        }
        if (this.timeZoneCombo != null) {
            String displayName = TimeZone.getDefault().getDisplayName();
            if (displayName == null) {
                displayName = "";
            }
            this.timeZoneCombo.setText(displayName);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        Preferences pref = ViewerPlugin.getDefault().getPluginPreferences();
        if (this.svgFlag != null) {
            pref.setValue("svg_flag", this.svgFlag.getSelection());
        }
        if (this.masterPageContent != null) {
            pref.setValue("master_page_content", this.masterPageContent.getSelection());
        }
        if (this.alwaysExternal != null) {
            pref.setValue("always_external_browser", this.alwaysExternal.getSelection());
            BrowserManager.getInstance().setAlwaysUseExternal(this.alwaysExternal.getSelection());
        }
        if (this.timeZoneCombo != null) {
            String timeZoneId = timeZoneTable_disKey.get(this.timeZoneCombo.getText());
            if (timeZoneId == null || timeZoneId.trim().length() <= 0) {
                timeZoneId = TimeZone.getDefault().getID();
            }
            pref.setValue("user_time_zone", timeZoneId);
        }
        if (this.localeCombo != null) {
            if (WebViewer.LOCALE_TABLE.containsKey(this.localeCombo.getText())) {
                pref.setValue("user_locale", (String)WebViewer.LOCALE_TABLE.get(this.localeCombo.getText()));
            } else {
                pref.setValue("user_locale", this.localeCombo.getText());
            }
        }
        if (this.bidiCombo != null) {
            int selection = this.bidiCombo.getSelectionIndex();
            selection = selection < 0 ? 0 : selection;
            pref.setValue("bidi_orientation", BIDI_CHOICE_NAMES[selection]);
        }
        ViewerPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void setCustomBrowserPathEnabled() {
        boolean enabled = this.customBrowserRadio.getSelection();
        this.customBrowserPathLabel.setEnabled(enabled);
        this.customBrowserPath.setEnabled(enabled);
        this.customBrowserBrowse.setEnabled(enabled);
    }

    private void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    protected Composite createTimeZoneChoice(Composite parent) {
        Label timeZoneDescription = new Label(parent, 0);
        timeZoneDescription.setText(Messages.getString((String)"designer.preview.preference.timezone.description"));
        this.timeZoneCombo = new Combo(parent, 12);
        this.timeZoneCombo.setLayoutData((Object)new GridData(768));
        this.timeZoneCombo.setVisibleItemCount(30);
        assert (timeZoneTable_disKey != null);
        String[] timeZoneDisplayNames = new String[timeZoneTable_disKey.size()];
        timeZoneTable_disKey.keySet().toArray(timeZoneDisplayNames);
        this.timeZoneCombo.setItems(timeZoneDisplayNames);
        String defaultTimeZone = ViewerPlugin.getDefault().getPluginPreferences().getString("user_time_zone");
        if (defaultTimeZone == null || defaultTimeZone.trim().length() <= 0) {
            defaultTimeZone = TimeZone.getDefault().getID();
        }
        TimeZone timeZone = TimeZone.getTimeZone(defaultTimeZone);
        this.timeZoneCombo.setText(timeZone.getDisplayName());
        return parent;
    }

    protected Composite createBIDIChoice(Composite parent) {
        Label lb = new Label(parent, 0);
        lb.setText(Messages.getString((String)"designer.preview.preference.bidiOrientation.label"));
        this.bidiCombo = new Combo(parent, 8);
        GridData gd = new GridData(768);
        gd.minimumWidth = 100;
        this.bidiCombo.setLayoutData((Object)gd);
        this.bidiCombo.setVisibleItemCount(30);
        this.bidiCombo.setItems(BIDI_CHOICE_DISPLAYNAMES);
        String bidiValue = ViewerPlugin.getDefault().getPluginPreferences().getString("bidi_orientation");
        int index = Arrays.asList(BIDI_CHOICE_NAMES).indexOf(bidiValue);
        index = index < 0 ? 0 : index;
        this.bidiCombo.select(index);
        return parent;
    }

    public void init(IWorkbench workbench) {
    }
}

