/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.CComboPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboAndButtonSection
extends Section {
    private int width = -1;
    private boolean fillCCombo = false;
    protected CComboPropertyDescriptor combo;
    protected Button button;
    private String buttonText;
    IDescriptorProvider provider;
    protected List buttonSelectList = new ArrayList();
    protected List comboSelectList = new ArrayList();
    private int buttonWidth = 60;
    private String oldValue;

    public ComboAndButtonSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public void createSection() {
        if (this.buttonSelectList == null) {
            this.buttonSelectList = new ArrayList();
        }
        if (this.comboSelectList == null) {
            this.comboSelectList = new ArrayList();
        }
        this.getLabelControl(this.parent);
        this.getComboControl(this.parent);
        this.getButtonControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public void layout() {
        GridData gd = (GridData)this.combo.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 2 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 2 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillCCombo;
        }
        gd = (GridData)this.button.getLayoutData();
        if (this.buttonWidth > -1) {
            gd.widthHint = Math.max(this.button.computeSize((int)-1, (int)-1).x, this.buttonWidth);
        }
    }

    protected CComboPropertyDescriptor getComboControl(Composite parent) {
        if (this.combo == null) {
            this.combo = DescriptorToolkit.createCComboPropertyDescriptor(true);
            if (this.getProvider() != null) {
                this.combo.setDescriptorProvider(this.getProvider());
            }
            this.combo.createControl(parent);
            this.combo.getControl().setLayoutData((Object)new GridData());
            this.combo.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ComboAndButtonSection.this.combo = null;
                }
            });
            if (!this.comboSelectList.isEmpty()) {
                this.combo.addComboSelectionListener((SelectionListener)this.comboSelectList.get(0));
            }
        } else {
            this.checkParent(this.combo.getControl(), parent);
        }
        return this.combo;
    }

    public CComboPropertyDescriptor getComboControl() {
        return this.combo;
    }

    public Button getButtonControl() {
        return this.button;
    }

    protected Button getButtonControl(Composite parent) {
        if (this.button == null) {
            this.button = FormWidgetFactory.getInstance().createButton(parent, 8, this.isFormStyle);
            this.button.setFont(parent.getFont());
            String text = this.getButtonText();
            this.button.setLayoutData((Object)new GridData());
            if (text != null) {
                this.button.setText(text);
            }
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ComboAndButtonSection.this.button = null;
                }
            });
            if (this.buttonSelectList.isEmpty()) {
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ComboAndButtonSection.this.onClickButton();
                    }
                };
                this.buttonSelectList.add(listener);
            }
            this.button.addSelectionListener((SelectionListener)this.buttonSelectList.get(0));
        } else {
            this.checkParent((Control)this.button, parent);
        }
        return this.button;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.combo != null) {
            this.combo.setDescriptorProvider(provider);
        }
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
        if (this.button != null) {
            this.button.setText(buttonText);
        }
    }

    public void addButtonSelectionListener(SelectionListener listener) {
        if (!this.buttonSelectList.contains(listener)) {
            if (!this.buttonSelectList.isEmpty()) {
                this.removeButtonSelectionListener((SelectionListener)this.buttonSelectList.get(0));
            }
            this.buttonSelectList.add(listener);
            if (this.button != null) {
                this.button.addSelectionListener(listener);
            }
        }
    }

    public void removeButtonSelectionListener(SelectionListener listener) {
        if (this.buttonSelectList.contains(listener)) {
            this.buttonSelectList.remove(listener);
            if (this.button != null) {
                this.button.removeSelectionListener(listener);
            }
        }
    }

    public void addComboSelectionListener(SelectionListener listener) {
        if (!this.comboSelectList.contains(listener)) {
            if (!this.comboSelectList.isEmpty()) {
                this.removeComboSelectionListener((SelectionListener)this.comboSelectList.get(0));
            }
            this.comboSelectList.add(listener);
            if (this.combo != null) {
                this.combo.addComboSelectionListener(listener);
            }
        }
    }

    public void removeComboSelectionListener(SelectionListener listener) {
        if (this.comboSelectList.contains(listener)) {
            this.comboSelectList.remove(listener);
            if (this.combo != null) {
                this.combo.removeComboSelectionListener(listener);
            }
        }
    }

    protected void onClickButton() {
    }

    public void forceFocus() {
        this.combo.getControl().forceFocus();
    }

    public void setInput(Object input) {
        this.combo.setInput(input);
    }

    public void load() {
        if (this.combo != null && !this.combo.getControl().isDisposed()) {
            this.combo.load();
        }
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth = buttonWidth;
        if (this.button != null) {
            GridData data = new GridData();
            data.widthHint = Math.max(this.button.computeSize((int)-1, (int)-1).x, buttonWidth);
            data.grabExcessHorizontalSpace = false;
            this.button.setLayoutData((Object)data);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public void setStringValue(String value) {
        if (this.combo != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.combo.getStringValue();
            if (!this.oldValue.equals(value)) {
                this.combo.setStringValue(value);
            }
        }
    }

    public boolean isFillText() {
        return this.fillCCombo;
    }

    public void setFillText(boolean fillCCombo) {
        this.fillCCombo = fillCCombo;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.combo != null) {
            this.combo.setHidden(isHidden);
        }
        if (this.button != null) {
            WidgetUtil.setExcludeGridData((Control)this.button, (boolean)isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.combo != null) {
            this.combo.setVisible(isVisible);
        }
        if (this.button != null) {
            this.button.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

