/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionComposite;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.OutputPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class OutputSection
extends Section {
    protected OutputPropertyDescriptor output;
    private int height = -1;
    IDescriptorProvider provider;

    public OutputSection(Composite parent, boolean isFormStyle) {
        super(" ", parent, isFormStyle);
    }

    public void createSection() {
        this.getOutputControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public OutputPropertyDescriptor getOutputControl() {
        return this.output;
    }

    protected OutputPropertyDescriptor getOutputControl(Composite parent) {
        if (this.output == null) {
            this.output = new OutputPropertyDescriptor(true);
            this.output.setDescriptorProvider(this.provider);
            this.output.createControl(parent);
            this.output.getControl().setLayoutData((Object)new GridData(1808));
            this.output.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    OutputSection.this.output = null;
                }
            });
            this.setAccessible(this.output.getControl());
        } else {
            this.checkParent(this.output.getControl(), parent);
        }
        return this.output;
    }

    private void setAccessible(final Control control) {
        if (control instanceof Composite) {
            Composite parent = (Composite)control;
            if (parent != null && parent.getTabList() != null) {
                Control[] children = parent.getTabList();
                int i = 0;
                while (i < children.length) {
                    this.setAccessible(children[i]);
                    ++i;
                }
            }
        } else {
            control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (control instanceof Text && control.getParent() instanceof ExpressionComposite) {
                        e.result = String.valueOf(UIUtil.stripMnemonic((String)Messages.getString((String)"VisibilityPage.Label.Expression"))) + ((Text)control).getText();
                    }
                }
            });
        }
    }

    public void layout() {
        GridData gd = (GridData)this.output.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        if (this.height > -1) {
            gd.heightHint = this.height;
            gd.grabExcessVerticalSpace = false;
            if (this.displayLabel != null) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 16;
            }
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void load() {
        if (this.output != null && !this.output.getControl().isDisposed()) {
            this.output.load();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.output != null) {
            this.output.setDescriptorProvider(provider);
        }
    }

    public void setInput(Object input) {
        assert (input != null);
        this.output.setInput(input);
    }

    public void setHidden(boolean isHidden) {
        if (this.output != null) {
            WidgetUtil.setExcludeGridData((Control)this.output.getControl(), (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisable) {
        if (this.output != null) {
            this.output.getControl().setVisible(isVisable);
        }
    }

    public void reset() {
        if (this.output != null && !this.output.getControl().isDisposed()) {
            this.output.reset();
        }
    }
}

