/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderToggleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FontStylePropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TogglePropertyDescriptor
extends PropertyDescriptor {
    Button button;

    public TogglePropertyDescriptor() {
        this.setFormStyle(false);
    }

    public void load() {
        boolean boolValue;
        String imageName;
        boolean stateFlag;
        String value = this.getDescriptorProvider().load().toString();
        boolean bl = stateFlag = value == null == this.button.getEnabled();
        if (stateFlag) {
            this.button.setEnabled(value != null);
        }
        if (this.getDescriptorProvider() instanceof FontStylePropertyDescriptorProvider) {
            imageName = ((FontStylePropertyDescriptorProvider)this.getDescriptorProvider()).getImageName();
            if (!this.button.isEnabled()) {
                imageName = String.valueOf(imageName) + "DIS";
            }
            if (this.button.getImage() == null) {
                this.button.setImage(ReportPlatformUIImages.getImage((String)imageName));
            }
            boolValue = ((FontStylePropertyDescriptorProvider)this.getDescriptorProvider()).getToogleValue().equals(value);
            if (this.button.getSelection() != boolValue) {
                this.button.setSelection(boolValue);
            }
            this.button.setToolTipText(((FontStylePropertyDescriptorProvider)this.getDescriptorProvider()).getTooltipText());
        }
        if (this.getDescriptorProvider() instanceof BorderToggleDescriptorProvider) {
            imageName = ((BorderToggleDescriptorProvider)this.getDescriptorProvider()).getImageName();
            if (this.button.getImage() == null) {
                this.button.setImage(ReportPlatformUIImages.getImage((String)imageName));
            }
            boolValue = (Boolean)((BorderToggleDescriptorProvider)this.getDescriptorProvider()).load();
            if (this.button.getSelection() != boolValue) {
                this.button.setSelection(boolValue);
            }
            this.button.setToolTipText(((BorderToggleDescriptorProvider)this.getDescriptorProvider()).getTooltipText());
        }
        this.button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Accessible accessible = (Accessible)e.getSource();
                Button item = (Button)accessible.getControl();
                if (item != null) {
                    e.result = item.getToolTipText();
                }
            }
        });
    }

    public Control getControl() {
        return this.button;
    }

    public Control createControl(Composite parent) {
        this.button = new Button(parent, 2);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TogglePropertyDescriptor.this.handleSelectEvent();
            }
        });
        return this.button;
    }

    public void setToolTipText(String toolTip) {
        if (this.button != null) {
            this.button.setToolTipText(toolTip);
        }
    }

    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.button, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.button.setVisible(isVisible);
    }

    protected void handleSelectEvent() {
        try {
            this.save(this.button.getSelection());
        }
        catch (SemanticException e1) {
            WidgetUtil.processError((Shell)this.button.getShell(), (Exception)((Object)e1));
        }
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }
}

