/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class TableDropAdapter
implements IDropAdapter {
    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        TableHandle tableHandle;
        CellHandle cellHandle;
        int result = 0;
        if (transfer.equals("DATA_TIMEPERIOD") && target instanceof TableCellEditPart && DEUtil.getBindingHolder((DesignElementHandle)(cellHandle = (CellHandle)((TableCellEditPart)target).getModel())) instanceof TableHandle && ExtendedDataModelUIAdapterHelper.isBoundToExtendedData((ReportItemHandle)(tableHandle = (TableHandle)DEUtil.getBindingHolder((DesignElementHandle)cellHandle)))) {
            result = 1;
        }
        return result;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (target instanceof TableCellEditPart) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            if ("DATA_TIMEPERIOD".equals(transfer)) {
                stack.startTrans("Add TimePeriod");
            }
            DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
            try {
                CellHandle targetElement = null;
                if (target instanceof TableCellEditPart) {
                    CellHandle cellHandle = (CellHandle)((TableCellEditPart)target).getModel();
                    cellHandle.addElement((DesignElementHandle)dataHandle, 0);
                    targetElement = cellHandle;
                }
                DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
                dialog.setLinkedModelTimePeriod(true);
                dialog.setInput((ReportItemHandle)dataHandle, null, targetElement);
                dialog.setAggreate(true);
                dialog.setTimePeriod(true);
                if (dialog.open() == 0) {
                    dataHandle.setResultSetColumn(dialog.getBindingColumn().getName());
                    stack.commit();
                } else {
                    stack.rollback();
                }
            }
            catch (Exception e) {
                stack.rollback();
                ExceptionHandler.handle(e);
            }
        }
        return true;
    }
}

