/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.processor;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TableOptionDialog;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.processor.AbstractElementProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class TableGridProcessor
extends AbstractElementProcessor {
    TableGridProcessor(String elementType) {
        super(elementType);
    }

    public DesignElementHandle createElement(Object extendedData) {
        boolean isTable = "Table".equals(this.getElementType());
        TableOptionDialog dialog = new TableOptionDialog(UIUtil.getDefaultShell(), isTable);
        if (dialog.open() == 0 && dialog.getResult() instanceof Object[]) {
            Object[] data = (Object[])dialog.getResult();
            GridHandle handle = null;
            if (isTable) {
                boolean isSummaryTable = data.length > 3 && data[3] != null && (Boolean)data[3] != false;
                handle = DesignElementFactory.getInstance().newTableItem(TableGridProcessor.getNewName(extendedData), (Integer)data[1], 1, isSummaryTable ? 0 : (Integer)data[0], 1);
                if (data[2] != null) {
                    try {
                        DataSetHandle dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(data[2].toString());
                        boolean isExtendedDataModel = false;
                        if (dataSet == null) {
                            ((ReportItemHandle)handle).setDataSet(null);
                            isExtendedDataModel = new LinkedDataSetAdapter().setLinkedDataModel((ReportItemHandle)handle, data[2].toString());
                        }
                        ((ReportItemHandle)handle).setDataSet(dataSet);
                        DataSetColumnBindingsFormHandleProvider provider = new DataSetColumnBindingsFormHandleProvider();
                        provider.setBindingObject((ReportElementHandle)((ReportItemHandle)handle));
                        if (!isExtendedDataModel) {
                            provider.generateAllBindingColumns();
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                    }
                }
                if (isSummaryTable) {
                    try {
                        ((TableHandle)handle).setIsSummaryTable(((Boolean)data[3]).booleanValue());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
            } else {
                handle = DesignElementFactory.getInstance().newGridItem(TableGridProcessor.getNewName(extendedData), (Integer)data[1], (Integer)data[0]);
            }
            InsertInLayoutUtil.setInitWidth(handle);
            return handle;
        }
        return null;
    }

    public boolean editElement(DesignElementHandle handle) {
        return false;
    }
}

