/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.resourcelocator;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.BaseResourceEntity;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceLocator;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.PlatformUI;

public class PathResourceEntry
extends BaseResourceEntity {
    protected Logger logger = Logger.getLogger(PathResourceEntry.class.getName());
    private String path;
    private URL url;
    private String name;
    private String displayName;
    private FileFilter filter;
    private PathResourceEntry parent;
    private boolean isFolder;
    private boolean isRoot;
    private LibraryHandle library;
    private ArrayList childrenList;
    private CssStyleSheetHandle cssStyleHandle;
    private boolean isFile;

    public PathResourceEntry() {
        this(null, true);
    }

    public PathResourceEntry(boolean showFiles) {
        this(null, showFiles);
    }

    public PathResourceEntry(String[] filePattern) {
        this(filePattern, true);
    }

    public PathResourceEntry(String[] filePattern, String path) {
        this(filePattern, path, Messages.getString((String)"PathResourceEntry.RootName"));
    }

    public PathResourceEntry(String[] filePattern, String path, String name) {
        this(filePattern);
        this.path = path;
        this.name = name;
        this.displayName = name;
        try {
            File file = new File(this.path);
            this.isFolder = file.isDirectory();
            this.url = file.toURL();
            if (this.path.length() == 0 && this.url != null) {
                file = new File(this.url.getPath());
                this.path = file.getPath();
                this.isFolder = file.isDirectory();
            }
            this.isFile = file.isFile();
        }
        catch (Exception exception) {}
    }

    public PathResourceEntry(final String[] filePattern, final boolean showFiles) {
        this.filter = filePattern != null ? new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                int i = 0;
                while (i < filePattern.length) {
                    String[] regs = filePattern[i].split(";");
                    int j = 0;
                    while (j < regs.length) {
                        if (pathname.getName().toLowerCase().endsWith(regs[j].toLowerCase().substring(1))) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
                return false;
            }
        } : new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return showFiles;
            }
        };
        this.name = Messages.getString((String)"PathResourceEntry.RootName");
        this.displayName = Messages.getString((String)"PathResourceEntry.RootDisplayName");
        this.isRoot = true;
    }

    protected PathResourceEntry(String path, String name, PathResourceEntry parent) {
        this.path = path;
        this.name = name;
        this.parent = parent;
        this.filter = parent.filter;
        try {
            File file = new File(this.path);
            this.isFolder = file.isDirectory();
            this.url = file.toURL();
            if (this.path.length() == 0 && this.url != null) {
                file = new File(this.url.getPath());
                this.path = file.getPath();
                this.isFolder = file.isDirectory();
            }
            this.isFile = file.isFile();
        }
        catch (Exception exception) {}
    }

    private void initRoot() {
        this.path = ReportPlugin.getDefault().getResourceFolder();
        if (this.path != null) {
            try {
                File file = new File(this.path);
                this.isFolder = file.isDirectory();
                this.url = file.toURL();
                if (this.path.length() == 0 && this.url != null) {
                    file = new File(this.url.getPath());
                    this.path = file.getPath();
                    this.isFolder = file.isDirectory();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean hasChildren() {
        File file;
        if (this.isRoot && this.path == null) {
            this.initRoot();
        }
        if ((file = new File(this.path)).isDirectory()) {
            String[] list = file.list();
            if (list == null) {
                return false;
            }
            return list.length > 0;
        }
        return false;
    }

    public ResourceEntry[] getChildren() {
        if (this.childrenList == null) {
            this.childrenList = new ArrayList();
            if (this.isRoot && this.path == null) {
                this.initRoot();
            }
            try {
                File[] children;
                File file = new File(this.path);
                if (file.isDirectory() && (children = file.listFiles(this.filter)) != null) {
                    int i = 0;
                    while (i < children.length) {
                        String childPath = children[i].getAbsolutePath();
                        String childName = children[i].getName();
                        ResourceEntry child = this.createChildResourceEntry(childPath, childName);
                        this.childrenList.add(child);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.childrenList.toArray(new ResourceEntry[this.childrenList.size()]);
    }

    protected ResourceEntry createChildResourceEntry(String childPath, String childName) {
        return new PathResourceEntry(childPath, childName, this);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Image getImage() {
        if (this.isFile()) {
            String path = this.getURL().toString().toLowerCase();
            if (path.endsWith(".rptdesign")) {
                return ReportPlatformUIImages.getImage("Report");
            }
            if (path.endsWith(".rpttemplate")) {
                return ReportPlatformUIImages.getImage("Template");
            }
            Object adapter = ElementAdapterManager.getAdapter(this, Image.class);
            if (adapter instanceof Image) {
                return (Image)adapter;
            }
        }
        if (this.isFolder || this.isRoot) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return super.getImage();
    }

    public ResourceEntry getParent() {
        return this.parent;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void dispose() {
        if (this.library != null) {
            this.library.close();
            this.library = null;
        }
        if (this.cssStyleHandle != null) {
            this.cssStyleHandle = null;
        }
        if (this.childrenList != null) {
            for (ResourceEntry entry : this.childrenList) {
                entry.dispose();
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == LibraryHandle.class && this.getURL().toString().toLowerCase().endsWith("library")) {
            if (!this.isFolder && this.library == null) {
                try {
                    String projectFolder = UIUtil.getProjectFolder();
                    if (projectFolder != null) {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("resourceFolder", projectFolder);
                        this.library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(this.path, new ModuleOption(properties));
                    } else {
                        this.library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(this.path);
                    }
                }
                catch (Exception exception) {}
            }
            return this.library;
        }
        if (adapter == ReportDesignHandle.class && this.getURL().toString().toLowerCase().endsWith("rptdesign")) {
            return this.getPath();
        }
        if (adapter == CssStyleSheetHandle.class && this.getURL().toString().toLowerCase().endsWith(".css")) {
            if (!this.isFolder && this.cssStyleHandle == null) {
                try {
                    String fileName = ResourceLocator.relativize(this.path);
                    this.cssStyleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(fileName);
                }
                catch (Exception exception) {}
            }
            return this.cssStyleHandle;
        }
        if (adapter == IActionFilter.class) {
            return new IActionFilter(){

                public boolean testAttribute(Object target, String name, String value) {
                    PathResourceEntry entry;
                    return target instanceof PathResourceEntry && "extension".equals(name) && (entry = (PathResourceEntry)target).getURL() != null && entry.getURL().toString().toLowerCase().endsWith(value);
                }
            };
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PathResourceEntry) && !(object instanceof String)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof PathResourceEntry) {
            PathResourceEntry temp = (PathResourceEntry)object;
            if (temp.path.equals(this.path)) {
                return true;
            }
        } else if (object instanceof String && object.equals(this.path)) {
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.path != null) {
            return this.path.hashCode();
        }
        return super.hashCode();
    }

    public String getPath() {
        return this.path;
    }
}

