/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import com.ibm.icu.text.Collator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Bidi;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.ICubeQueryUtil;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.runtime.ErrorStatus;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DeleteWarningDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ImportLibraryDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.IRelatedFileChangeResolve;
import org.eclipse.birt.report.designer.internal.ui.editors.IReportEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventManager;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GridEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MultipleEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.IExtendedDataModelUIAdapter;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.util.CategorizedElementSorter;
import org.eclipse.birt.report.designer.internal.ui.util.ColorHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.bidi.BidiUIUtils;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.GroupDialog;
import org.eclipse.birt.report.designer.ui.editors.AbstractMultiPageEditor;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtil {
    protected static final Logger logger = Logger.getLogger(UIUtil.class.getName());
    private static final String MSG_DIALOG_TITLE = Messages.getString((String)"ImportLibraryAction.Title.ImportSuccessfully");
    private static final String MSG_DIALOG_MSG = Messages.getString((String)"ImportLibraryAction.Message.ImportSuccessfully");
    private static final String AC_GROUP_COLLAPSE_LEVEL_PROPERTY = "__ac_group_collapse_level";
    private static String[] EDITOR_IDS = new String[]{"org.eclipse.birt.report.designer.ui.editors.ReportEditor", "org.eclipse.birt.report.designer.ui.editors.LibraryEditor", "org.eclipse.birt.report.designer.ui.editors.TemplateEditor"};
    static Pattern punctuation = Pattern.compile("\\p{Punct}||\\p{Blank}||\\p{Space}");
    private static boolean embeddedBrowserTested = false;
    private static boolean embeddedBrowserAvailable = false;
    public static final String CONFIRM_PARAM_DELETE_TITLE = Messages.getString((String)"DefaultNodeProvider.ParameterGroup.ConfirmTitle");
    public static final String CONFIRM_PARAM_DELETE_MESSAGE = Messages.getString((String)"DefaultNodeProvider.ParameterGroup.ConfirmMessage");
    public static final String DLG_CONFIRM_MSG = Messages.getString((String)"DefaultNodeProvider.Dlg.Confirm");
    public static final String DLG_HAS_FOLLOWING_CLIENTS_MSG = Messages.getString((String)"DefaultNodeProvider.Tree.Clients");
    public static final String DLG_REFERENCE_FOUND_TITLE = Messages.getString((String)"DefaultNodeProvider.Tree.Reference");
    private static final String[] htmlCode = new String[256];

    static {
        int i = 0;
        while (i < 10) {
            UIUtil.htmlCode[i] = "&#00" + i + ";";
            ++i;
        }
        i = 10;
        while (i < 32) {
            UIUtil.htmlCode[i] = "&#0" + i + ";";
            ++i;
        }
        i = 32;
        while (i < 128) {
            UIUtil.htmlCode[i] = String.valueOf((char)i);
            ++i;
        }
        UIUtil.htmlCode[9] = "\t";
        UIUtil.htmlCode[10] = "<br/>\n";
        UIUtil.htmlCode[34] = "&quot;";
        UIUtil.htmlCode[38] = "&amp;";
        UIUtil.htmlCode[60] = "&lt;";
        UIUtil.htmlCode[62] = "&gt;";
        i = 128;
        while (i < 256) {
            UIUtil.htmlCode[i] = "&#" + i + ";";
            ++i;
        }
    }

    public static int getStringWidth(String string, Control control) {
        int width = 0;
        GC gc = new GC((Drawable)control);
        width = gc.textExtent((String)string).x;
        gc.dispose();
        return width;
    }

    public static int getMaxStringWidth(String[] strArray, Control control) {
        int maxWidth = 0;
        GC gc = new GC((Drawable)control);
        int i = 0;
        while (i < strArray.length) {
            int width = gc.textExtent((String)strArray[i]).x;
            maxWidth = maxWidth >= width ? maxWidth : width;
            ++i;
        }
        gc.dispose();
        return maxWidth;
    }

    public static boolean isReportEditorActivated() {
        return UIUtil.getActiveReportEditor() != null;
    }

    public static FormEditor getActiveReportEditor() {
        return UIUtil.getActiveReportEditor(true);
    }

    public static FormEditor getActiveReportEditor(boolean activePageOnly) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            if (activePageOnly) {
                IEditorPart editor;
                IWorkbenchPage pg = window.getActivePage();
                if (pg != null && (editor = pg.getActiveEditor()) != null) {
                    if (editor instanceof IReportEditor) {
                        IEditorPart part = ((IReportEditor)editor).getEditorPart();
                        if (part instanceof FormEditor) {
                            return (FormEditor)part;
                        }
                    } else if (editor instanceof FormEditor) {
                        return (FormEditor)editor;
                    }
                }
            } else {
                IWorkbenchPage[] pgs = window.getPages();
                int i = 0;
                while (i < pgs.length) {
                    IWorkbenchPage pg = pgs[i];
                    if (pg != null) {
                        IEditorPart editor = pg.getActiveEditor();
                        if (editor instanceof IReportEditor) {
                            IEditorPart part = ((IReportEditor)editor).getEditorPart();
                            if (part instanceof FormEditor) {
                                return (FormEditor)part;
                            }
                        } else if (editor instanceof FormEditor) {
                            return (FormEditor)editor;
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public static IEditorPart getActiveEditor(boolean activePageOnly) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            if (activePageOnly) {
                IWorkbenchPage pg = window.getActivePage();
                if (pg != null) {
                    return pg.getActiveEditor();
                }
            } else {
                IWorkbenchPage[] pgs = window.getPages();
                int i = 0;
                while (i < pgs.length) {
                    IEditorPart editor;
                    IWorkbenchPage pg = pgs[i];
                    if (pg != null && (editor = pg.getActiveEditor()) != null) {
                        return editor;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public static IProject getDefaultProject() {
        IResource resource;
        IWorkbenchWindow benchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart part = benchWindow.getPartService().getActivePart();
        Object selection = null;
        if (part instanceof IEditorPart) {
            selection = ((IEditorPart)part).getEditorInput();
        } else {
            ISelection sel = benchWindow.getSelectionService().getSelection();
            if (sel != null && sel instanceof IStructuredSelection) {
                selection = ((IStructuredSelection)sel).getFirstElement();
            }
        }
        if (selection instanceof IAdaptable && (resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class)) != null && resource.getProject() != null && resource.getProject().isAccessible()) {
            return resource.getProject();
        }
        IProject[] pjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < pjs.length) {
            if (pjs[i].isAccessible()) {
                return pjs[i];
            }
            ++i;
        }
        return null;
    }

    public static IProject getCurrentProject() {
        IWorkbench iworkbench = PlatformUI.getWorkbench();
        if (iworkbench == null) {
            return null;
        }
        IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
        if (iworkbenchwindow == null) {
            return null;
        }
        IWorkbenchPage iworkbenchpage = iworkbenchwindow.getActivePage();
        if (iworkbenchpage == null) {
            return null;
        }
        IEditorPart ieditorpart = iworkbenchpage.getActiveEditor();
        if (ieditorpart == null) {
            return null;
        }
        IEditorInput input = ieditorpart.getEditorInput();
        if (input == null) {
            return null;
        }
        return (IProject)ElementAdapterManager.getAdapter(input, IProject.class);
    }

    public static Shell getDefaultShell() {
        Shell shell = null;
        try {
            shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            if (shell == null) {
                shell = Display.getCurrent().getActiveShell();
            }
            if (shell == null) {
                shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            }
        }
        catch (Exception exception) {}
        if (shell == null) {
            return new Shell();
        }
        return shell;
    }

    public static boolean createGroup(DesignElementHandle parent) {
        assert (parent != null);
        try {
            return UIUtil.addGroup(parent, -1);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
    }

    public static boolean createGroup(DesignElementHandle parent, int position) {
        assert (parent != null);
        try {
            return UIUtil.addGroup(parent, position);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
    }

    private static boolean addGroup(DesignElementHandle parent, int position) throws SemanticException {
        TableGroupHandle groupHandle = null;
        SlotHandle slotHandle = null;
        DesignElementFactory factory = DesignElementFactory.getInstance(parent.getModuleHandle());
        if (parent instanceof TableHandle) {
            groupHandle = factory.newTableGroup();
            slotHandle = ((TableHandle)parent).getGroups();
            int columnCount = ((TableHandle)parent).getColumnCount();
            groupHandle.getHeader().add((DesignElementHandle)factory.newTableRow(columnCount));
            groupHandle.getFooter().add((DesignElementHandle)factory.newTableRow(columnCount));
        } else if (parent instanceof ListHandle) {
            groupHandle = factory.newListGroup();
            slotHandle = ((ListHandle)parent).getGroups();
        }
        if (groupHandle != null && slotHandle != null) {
            String collapseLevel = parent.getStringProperty(AC_GROUP_COLLAPSE_LEVEL_PROPERTY);
            if (collapseLevel != null && collapseLevel.trim().length() > 0 && position >= 0) {
                String[] levels = collapseLevel.split(",");
                ArrayList<Integer> levelList = new ArrayList<Integer>();
                int i = 0;
                while (i < levels.length) {
                    try {
                        int level = Integer.parseInt(levels[i]);
                        if (level >= position) {
                            ++level;
                        }
                        levelList.add(level);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ++i;
                }
                StringBuffer buffer = new StringBuffer();
                int i2 = 0;
                while (i2 < levelList.size()) {
                    buffer.append(levelList.get(i2));
                    if (i2 < levelList.size() - 1) {
                        buffer.append(",");
                    }
                    ++i2;
                }
                String value = buffer.toString().trim().length() > 0 ? buffer.toString().trim() : null;
                parent.setStringProperty(AC_GROUP_COLLAPSE_LEVEL_PROPERTY, value);
            }
            slotHandle.add((DesignElementHandle)groupHandle, position);
            GroupDialog dialog = new GroupDialog(UIUtil.getDefaultShell(), GroupDialog.GROUP_DLG_TITLE_NEW);
            dialog.setInput(groupHandle);
            return dialog.open() != 1;
        }
        return false;
    }

    public static EditPart getCurrentEditPart() {
        EditPartViewer viewer = UIUtil.getLayoutEditPartViewer();
        if (viewer == null) {
            return null;
        }
        IStructuredSelection targets = (IStructuredSelection)viewer.getSelection();
        if (targets.isEmpty()) {
            return null;
        }
        return (EditPart)targets.getFirstElement();
    }

    public static EditPartViewer getLayoutEditPartViewer() {
        IEditorPart activeEditor;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        AbstractMultiPageEditor reportEditor = null;
        if (part instanceof AbstractMultiPageEditor) {
            reportEditor = (AbstractMultiPageEditor)part;
        } else if (part instanceof IReportEditor && (activeEditor = ((IReportEditor)part).getEditorPart()) instanceof AbstractMultiPageEditor) {
            reportEditor = (AbstractMultiPageEditor)activeEditor;
        }
        if (reportEditor == null || !(reportEditor.getActivePageInstance() instanceof GraphicalEditorWithFlyoutPalette)) {
            return null;
        }
        return ((GraphicalEditorWithFlyoutPalette)reportEditor.getActivePageInstance()).getGraphicalViewer();
    }

    public static GridLayout createGridLayoutWithoutMargin() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static GridLayout createGridLayoutWithMargin(int margin) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = layout.marginWidth = margin;
        return layout;
    }

    public static GridLayout createGridLayoutWithoutMargin(int numsColumn, boolean makeColumnsEqualWidth) {
        GridLayout layout = new GridLayout(numsColumn, makeColumnsEqualWidth);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static String convertToGUIString(String string) {
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String convertToModelString(String string, boolean trim) {
        if (string == null) {
            return null;
        }
        if (trim) {
            string = string.trim();
        }
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static int getWidthHint(int wHint, Control c) {
        boolean wrap = UIUtil.isWrapControl(c);
        return wrap ? wHint : -1;
    }

    public static int getHeightHint(int hHint, Control c) {
        Layout layout;
        if (c instanceof Composite && (layout = ((Composite)c).getLayout()) instanceof ColumnLayout) {
            return hHint;
        }
        return -1;
    }

    public static void updatePageIncrement(ScrolledComposite scomp) {
        ScrollBar vbar = scomp.getVerticalBar();
        if (vbar != null) {
            Rectangle clientArea = scomp.getClientArea();
            int increment = clientArea.height - 5;
            vbar.setPageIncrement(increment);
        }
    }

    private static boolean isWrapControl(Control c) {
        if (c instanceof Composite) {
            return ((Composite)c).getLayout() instanceof ILayoutExtension;
        }
        return (c.getStyle() & 0x40) != 0;
    }

    public static TableEditPart getTableEditPart(List editParts) {
        if (editParts == null || editParts.isEmpty()) {
            return null;
        }
        int size = editParts.size();
        TableEditPart part = null;
        int i = 0;
        while (i < size) {
            block11: {
                TableEditPart currentEditPart;
                block9: {
                    Object obj;
                    block10: {
                        block8: {
                            obj = editParts.get(i);
                            currentEditPart = null;
                            if (!(obj instanceof TableEditPart)) break block8;
                            currentEditPart = (TableEditPart)obj;
                            break block9;
                        }
                        if (!(obj instanceof TableCellEditPart)) break block10;
                        currentEditPart = (TableEditPart)((TableCellEditPart)obj).getParent();
                        break block9;
                    }
                    if (obj instanceof DummyEditpart) break block11;
                }
                if (part == null) {
                    part = currentEditPart;
                }
                if (currentEditPart == null || currentEditPart != null && part != currentEditPart) {
                    return null;
                }
            }
            ++i;
        }
        if (part instanceof GridEditPart) {
            return null;
        }
        return part;
    }

    public static ReportElementEditPart getTableMultipleEditPart(List editParts) {
        if (editParts == null || editParts.isEmpty()) {
            return null;
        }
        int size = editParts.size();
        ReportElementEditPart part = null;
        int i = 0;
        while (i < size) {
            block10: {
                ReportElementEditPart currentEditPart;
                block9: {
                    Object obj;
                    block8: {
                        obj = editParts.get(i);
                        currentEditPart = null;
                        if (!(obj instanceof MultipleEditPart) || !(((MultipleEditPart)obj).getModel() instanceof TableHandle)) break block8;
                        currentEditPart = (ReportElementEditPart)obj;
                        break block9;
                    }
                    if (obj instanceof DummyEditpart) break block10;
                }
                if (part == null) {
                    part = currentEditPart;
                }
                if (currentEditPart == null || currentEditPart != null && part != currentEditPart) {
                    return null;
                }
            }
            ++i;
        }
        if (part instanceof GridEditPart) {
            return null;
        }
        return part;
    }

    public static ListEditPart getListEditPart(List editParts) {
        if (editParts == null || editParts.isEmpty()) {
            return null;
        }
        int size = editParts.size();
        ListEditPart part = null;
        int i = 0;
        while (i < size) {
            Object obj = editParts.get(i);
            ListEditPart currentEditPart = null;
            if (obj instanceof ListEditPart) {
                currentEditPart = (ListEditPart)obj;
            } else if (obj instanceof ListBandEditPart) {
                currentEditPart = (ListEditPart)((ListBandEditPart)obj).getParent();
            }
            if (part == null) {
                part = currentEditPart;
            }
            if (currentEditPart == null || currentEditPart != null && part != currentEditPart) {
                return null;
            }
            ++i;
        }
        return part;
    }

    public static boolean containElement(AbstractTreeViewer treeViewer, Object element) {
        ITreeContentProvider provider = (ITreeContentProvider)treeViewer.getContentProvider();
        Object input = treeViewer.getInput();
        if (input instanceof Object[]) {
            Object[] inputs = (Object[])input;
            int i = 0;
            while (i < inputs.length) {
                if (UIUtil.containElement(inputs[i], provider, element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return UIUtil.containElement(input, provider, element);
    }

    private static boolean containElement(Object parent, ITreeContentProvider provider, Object element) {
        if (parent == null) {
            return false;
        }
        if (parent == element || parent.equals(element)) {
            return true;
        }
        if (provider == null) {
            return false;
        }
        Object[] children = provider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (UIUtil.containElement(children[i], provider, element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getPluginProvider(String pluginId) {
        return UIUtil.getBundleValue(pluginId, "Bundle-Vendor");
    }

    public static String getPluginName(String pluginId) {
        return UIUtil.getBundleValue(pluginId, "Bundle-Name");
    }

    public static String getPluginVersion(String pluginId) {
        return UIUtil.getBundleValue(pluginId, "Bundle-Version");
    }

    private static String getBundleValue(String pluginId, String key) {
        assert (pluginId != null);
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            return (String)bundle.getHeaders().get(key);
        }
        return null;
    }

    public static void resetViewSelection(EditPartViewer viewer, boolean notifyToMedia) {
        ArrayList list = new ArrayList(((StructuredSelection)viewer.getSelection()).toList());
        boolean hasColumnOrRow = false;
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof TableEditPart.DummyRowEditPart || list.get(i) instanceof TableEditPart.DummyColumnEditPart) {
                hasColumnOrRow = true;
                break;
            }
            ++i;
        }
        if (hasColumnOrRow) {
            boolean selectionType = false;
            TableEditPart part = null;
            int[] selectContents = new int[]{};
            int i2 = 0;
            while (i2 < list.size()) {
                Object obj = list.get(i2);
                int number = -1;
                if (obj instanceof TableEditPart.DummyRowEditPart) {
                    selectionType = false;
                    number = ((TableEditPart.DummyRowEditPart)obj).getRowNumber();
                } else if (obj instanceof TableEditPart.DummyColumnEditPart) {
                    selectionType = true;
                    number = ((TableEditPart.DummyColumnEditPart)obj).getColumnNumber();
                } else if (obj instanceof TableCellEditPart) {
                    part = (TableEditPart)((TableCellEditPart)obj).getParent();
                }
                if (number != -1) {
                    int lenegth = selectContents.length;
                    int[] temp = new int[lenegth + 1];
                    System.arraycopy(selectContents, 0, temp, 0, lenegth);
                    temp[lenegth] = number;
                    selectContents = temp;
                }
                ++i2;
            }
            if (part == null || selectContents.length == 0 || !viewer.getControl().isVisible()) {
                return;
            }
            if (!selectionType) {
                part.selectRow(selectContents, notifyToMedia);
            } else if (selectionType) {
                part.selectColumn(selectContents, notifyToMedia);
            }
        } else if (!viewer.getControl().isDisposed() && viewer instanceof DeferredGraphicalViewer) {
            ((DeferredGraphicalViewer)viewer).setSelection((ISelection)new StructuredSelection(list), notifyToMedia);
        }
    }

    public static void createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        try {
            if (!folderHandle.exists()) {
                IPath path = folderHandle.getFullPath();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int numSegments = path.segmentCount();
                if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                    int i = numSegments - 2;
                    while (i > 0) {
                        IFolder folder = root.getFolder(path.removeLastSegments(i));
                        if (!folder.exists()) {
                            folder.create(false, true, monitor);
                        }
                        --i;
                    }
                }
                folderHandle.create(false, true, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                folderHandle.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static String getHomeDirectory() {
        URL url = ReportPlugin.getDefault().getBundle().getEntry("/");
        String home = null;
        try {
            home = new File(FileLocator.resolve((URL)url).getPath()).getAbsolutePath();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return home;
    }

    public static String getFragmentDirectory() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.resources");
        if (bundle == null) {
            return null;
        }
        URL url = bundle.getEntry("/");
        if (url == null) {
            return null;
        }
        String directory = null;
        try {
            directory = FileLocator.resolve((URL)url).getPath();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return directory;
    }

    public static Label createBlankLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setVisible(false);
        return label;
    }

    public static boolean includeLibrary(ModuleHandle moduleHandle, String libraryPath) throws DesignFileException, SemanticException {
        return UIUtil.includeLibrary(moduleHandle, libraryPath, false);
    }

    public static boolean includeLibrary(ModuleHandle moduleHandle, String libraryPath, boolean isDefault) throws DesignFileException, SemanticException {
        String namespace = UIUtil.getLibraryNamespace(moduleHandle, libraryPath, isDefault);
        if (namespace != null) {
            if (libraryPath.startsWith("file") || new File(libraryPath).exists()) {
                moduleHandle.includeLibrary(DEUtil.getRelativedPath((String)ReportPlugin.getDefault().getResourceFolder(), (String)libraryPath), namespace);
            } else if (libraryPath.startsWith("bundleresource")) {
                try {
                    moduleHandle.includeLibrary(new URL(libraryPath).getPath(), namespace);
                }
                catch (MalformedURLException malformedURLException) {
                    ExceptionHandler.openMessageBox(MSG_DIALOG_TITLE, MessageFormat.format(MSG_DIALOG_MSG, libraryPath), 2);
                }
            } else {
                moduleHandle.includeLibrary(libraryPath, namespace);
            }
            return true;
        }
        return false;
    }

    public static boolean includeLibrary(ModuleHandle moduleHandle, LibraryHandle libraryHandle) throws DesignFileException, SemanticException {
        if (moduleHandle != libraryHandle && !moduleHandle.isInclude(libraryHandle)) {
            return UIUtil.includeLibrary(moduleHandle, libraryHandle.getFileName());
        }
        return true;
    }

    public static boolean includeLibrary(LibraryHandle libraryHandle) throws DesignFileException, SemanticException {
        return UIUtil.includeLibrary(SessionHandleAdapter.getInstance().getReportDesignHandle(), libraryHandle);
    }

    public static String getSimpleFileName(String filePath) {
        return new File(filePath).getName();
    }

    private static String getLibraryNamespace(ModuleHandle handle, String libraryPath, boolean isDefault) {
        String namespace = UIUtil.getSimpleFileName(libraryPath).split("\\.")[0];
        if (isDefault && handle.getLibrary(namespace) != null) {
            return null;
        }
        if (handle.getLibrary(namespace) != null) {
            ImportLibraryDialog dialog = new ImportLibraryDialog(namespace);
            namespace = dialog.open() == 0 ? (String)dialog.getResult() : null;
        }
        return namespace;
    }

    public static ThemeHandle themeInModuleHandle(ThemeHandle handle, ModuleHandle moduleHandle) {
        String themeName = handle.getName().trim();
        String themeFileName = handle.getModuleHandle().getFileName();
        LibraryHandle libHandle = moduleHandle.findLibrary(themeFileName);
        if (libHandle == null) {
            return null;
        }
        Iterator iterator = moduleHandle.getVisibleThemes(1).iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ReportElementHandle elementHandle = (ReportElementHandle)iterator.next();
                if (!elementHandle.getName().trim().equals(themeName) || elementHandle.getRoot() != libHandle) continue;
                return (ThemeHandle)elementHandle;
            }
        }
        return null;
    }

    public static ThemeHandle applyTheme(ThemeHandle handle, ModuleHandle moduleHandle, LibraryHandle library) {
        if (handle.getRoot() == moduleHandle) {
            try {
                moduleHandle.setTheme(handle);
            }
            catch (SemanticException e) {
                GUIException exception = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e, (String)"Library.DND.messages.cannotApplyTheme");
                ExceptionHandler.handle((Throwable)exception);
            }
            return handle;
        }
        ThemeHandle applyThemeHandle = UIUtil.themeInModuleHandle(handle, moduleHandle);
        if (applyThemeHandle != null) {
            try {
                moduleHandle.setTheme(applyThemeHandle);
            }
            catch (SemanticException e) {
                GUIException exception = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e, (String)"Library.DND.messages.cannotApplyTheme");
                ExceptionHandler.handle((Throwable)exception);
            }
        }
        return applyThemeHandle;
    }

    public static int[] getExpressionBidiSegments(String lineText) {
        if (lineText == null || "".equals(lineText)) {
            return null;
        }
        int[] level = UIUtil.getExpressionBidiLevel(lineText);
        int[] segments = new int[level.length];
        int j = 0;
        segments[j++] = 0;
        int i = 1;
        while (i < level.length) {
            if (level[i] != level[i - 1]) {
                segments[j++] = i;
            }
            ++i;
        }
        if (j < segments.length) {
            int[] result = new int[j];
            System.arraycopy(segments, 0, result, 0, j);
            segments = result;
        }
        return segments;
    }

    public static int[] getExpressionBidiLevel(String message) {
        Bidi bidi = new Bidi(message, 0);
        int[] level = new int[message.length()];
        boolean bidiStart = false;
        Stack<Character> bracket = new Stack<Character>();
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            if (UIUtil.isNeutral(c)) {
                if (c == '\'' || c == '\"') {
                    if (bracket.empty()) {
                        bracket.add(Character.valueOf(c));
                    } else if (((Character)bracket.peek()).charValue() == c) {
                        bracket.pop();
                        bidiStart = false;
                    } else {
                        bracket.add(Character.valueOf(c));
                    }
                }
                level[i] = bidiStart && !bracket.empty() ? 1 : 0;
            } else {
                level[i] = bidi.getLevelAt(i);
                if (level[i] % 2 != 0) {
                    bidiStart = true;
                }
            }
            ++i;
        }
        return level;
    }

    private static boolean isNeutral(char c) {
        boolean match = punctuation.matcher(new StringBuffer(0).append(c)).matches();
        return match;
    }

    public static void bindHelp(Control control, String contextId) {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getHelpSystem().setHelp(control, contextId);
        }
        catch (RuntimeException runtimeException) {}
    }

    public static IViewPart getView(String id) {
        IWorkbenchPage tPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] v = tPage.getViewReferences();
        int i = 0;
        while (i < v.length) {
            if (v[i].getId().equals(id)) {
                return (IViewPart)v[i].getPart(true);
            }
            ++i;
        }
        return null;
    }

    public static IEditorPart getEditor(String id) {
        IWorkbenchPage tPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (tPage == null) {
            return null;
        }
        IEditorReference[] v = tPage.getEditorReferences();
        int i = 0;
        while (i < v.length) {
            if (v[i].getId().equals(id)) {
                return (IEditorPart)v[i].getPart(true);
            }
            ++i;
        }
        return null;
    }

    public static IEditorPart getActiveEditor(String id) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage tPage = window.getActivePage();
        if (tPage == null) {
            return null;
        }
        IEditorPart activeEditPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorReference[] v = tPage.getEditorReferences();
        int i = 0;
        while (i < v.length) {
            IEditorPart temp;
            if (v[i].getId().equals(id) && (temp = (IEditorPart)v[i].getPart(false)) == activeEditPart) {
                return activeEditPart;
            }
            ++i;
        }
        return null;
    }

    public static boolean needAddQuote(String elementName, String property, String value) {
        IChoice[] choices = ChoiceSetFactory.getElementChoiceSet(elementName, property).getChoices();
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getValue().equals(value)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Image newImageFromComposite(Composite composite) {
        Point compositeSize = composite.getSize();
        GC gc = new GC((Drawable)composite);
        Image image = new Image((Device)Display.getCurrent(), compositeSize.x, compositeSize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        return image;
    }

    public static IModelEventManager getModelEventManager() {
        IEditorPart part;
        IEditorPart input = null;
        int i = 0;
        while (i < EDITOR_IDS.length) {
            input = UIUtil.getActiveEditor(EDITOR_IDS[i]);
            if (input != null) break;
            ++i;
        }
        if (input == null && (part = UIUtil.getActiveEditor(true)) instanceof IReportEditor) {
            input = part;
        }
        if (input == null) {
            return null;
        }
        Object adapter = input.getAdapter(IModelEventManager.class);
        if (adapter instanceof IModelEventManager) {
            return (IModelEventManager)adapter;
        }
        return null;
    }

    public static String getProjectFolder() {
        IEditorInput input;
        FormEditor editor = UIUtil.getActiveReportEditor();
        if (editor != null && (input = editor.getEditorInput()) != null) {
            return UIUtil.getProjectFolder(input);
        }
        return null;
    }

    public static String getColumnDisplayName(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            String displayName;
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            if (element.getDisplayNameKey() != null && (displayName = element.getExternalizedValue("displayNameID", "displayName")) != null) {
                return displayName;
            }
            return element.getDisplayName() == null ? column.getColumnName() : element.getDisplayName();
        }
        return column.getColumnName();
    }

    public static String getColumnDisplayNameKey(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element.getDisplayNameKey();
        }
        return null;
    }

    public static String getColumnHeaderDisplayNameKey(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element.getHeadingKey();
        }
        return null;
    }

    public static boolean isWordWrap(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element.wordWrap();
        }
        return false;
    }

    public static String getClolumnHandleAlignment(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element.getHorizontalAlign();
        }
        return null;
    }

    public static String getClolumnHandleHelpText(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element.getHelpText();
        }
        return null;
    }

    public static String getColumnAnalysis(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        Iterator iter = dataset.columnHintsIterator();
        while (iter.hasNext()) {
            ColumnHintHandle element = (ColumnHintHandle)iter.next();
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element.getAnalysis();
        }
        return null;
    }

    public static String getAnalysisColumn(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element.getAnalysisColumn();
        }
        return null;
    }

    public static ActionHandle getColumnAction(ResultSetColumnHandle column) {
        DataSetHandle dataset = UIUtil.getDataSet(column);
        Iterator iter = dataset.columnHintsIterator();
        while (iter.hasNext()) {
            ColumnHintHandle element = (ColumnHintHandle)iter.next();
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element.getActionHandle();
        }
        return null;
    }

    public static void setExpressionButtonImage(Button button) {
        String imageName = button.isEnabled() ? "Enable Expression Builder" : "Disable Expression Builder";
        Image image = ReportPlatformUIImages.getImage(imageName);
        GridData gd = new GridData();
        if (!Platform.getOS().equals("macosx")) {
            gd.widthHint = 20;
            gd.heightHint = 20;
        }
        button.setLayoutData((Object)gd);
        button.setImage(image);
        if (button.getImage() != null) {
            button.getImage().setBackground(button.getBackground());
        }
        button.setToolTipText(Messages.getString((String)"ExpressionBuilder.ToolTip"));
    }

    public static ExpressionButton createExpressionButton(Composite parent, int style) {
        return UIUtil.createExpressionButton(parent, style, true);
    }

    public static ExpressionButton createExpressionButton(Composite parent, int style, boolean allowConstant) {
        ExpressionButton button = new ExpressionButton(parent, style, allowConstant);
        IExpressionButtonProvider provider = (IExpressionButtonProvider)ElementAdapterManager.getAdapter(button, IExpressionButtonProvider.class);
        if (provider != null) {
            button.setExpressionButtonProvider(provider);
        }
        GridData gd = new GridData();
        if (!Platform.getOS().equals("macosx")) {
            gd.heightHint = 20;
        }
        button.getControl().setLayoutData(gd);
        return button;
    }

    public static String getDefaultScriptType() {
        return PreferenceFactory.getInstance().getPreferences(ReportPlugin.getDefault(), UIUtil.getCurrentProject()).getString("report.designer.ui.preferences.default.scripttype");
    }

    public static List<IElementDefn> getInvisibleExtensionElements() {
        PaletteEntryExtension[] entries;
        ArrayList<IElementDefn> list = new ArrayList<IElementDefn>();
        list.addAll(DEUtil.getMetaDataDictionary().getExtensions());
        List<ExtendedElementUIPoint> points = ExtensionPointManager.getInstance().getExtendedElementPoints();
        for (ExtendedElementUIPoint point : points) {
            if (!UIUtil.isVisibleExtensionElement(point)) continue;
            list.remove(DEUtil.getElementDefn((String)point.getExtensionName()));
        }
        PaletteEntryExtension[] paletteEntryExtensionArray = entries = EditpartExtensionManager.getPaletteEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            PaletteEntryExtension entry = paletteEntryExtensionArray[n2];
            list.remove(DEUtil.getElementDefn((String)entry.getItemName()));
            ++n2;
        }
        return list;
    }

    public static boolean isVisibleExtensionElement(ExtendedElementUIPoint point) {
        String preference = (String)point.getAttribute("showInDesignerByPreference");
        if (preference != null) {
            IPreferences wrapper;
            String[] splits = preference.split("/");
            if (splits.length == 2 && (wrapper = PreferenceFactory.getInstance().getPluginPreferences(splits[0], null)) != null) {
                Boolean bool = wrapper.getBoolean(splits[1]);
                return bool;
            }
        } else {
            return (Boolean)point.getAttribute("showInDesigner");
        }
        return true;
    }

    private static List<IElementDefn> sortElements(List<IElementDefn> elements) {
        CategorizedElementSorter<IElementDefn> elementSorter = new CategorizedElementSorter<IElementDefn>();
        HashMap<String, TreeSet<IElementDefn>> extendedEntriesMap = new HashMap<String, TreeSet<IElementDefn>>();
        Comparator<IElementDefn> entryComparator = new Comparator<IElementDefn>(){

            @Override
            public int compare(IElementDefn o1, IElementDefn o2) {
                return Collator.getInstance().compare(o1.getDisplayName(), o2.getDisplayName());
            }
        };
        for (IElementDefn def : elements) {
            String eleName = def.getName();
            ExtendedElementUIPoint point = ExtensionPointManager.getInstance().getExtendedElementPoint(eleName);
            if (point != null) {
                String category = (String)point.getAttribute("category");
                if (!extendedEntriesMap.containsKey(category)) {
                    extendedEntriesMap.put(category, new TreeSet<IElementDefn>(entryComparator));
                }
                ((SortedSet)extendedEntriesMap.get(category)).add(def);
                continue;
            }
            PaletteEntryExtension palette = EditpartExtensionManager.getPaletteEntry(eleName);
            if (palette != null) {
                elementSorter.addElement(palette.getCategory(), def);
                continue;
            }
            elementSorter.addElement("Content", def);
        }
        for (Map.Entry entry : extendedEntriesMap.entrySet()) {
            for (IElementDefn def : (SortedSet)entry.getValue()) {
                elementSorter.addElement((String)entry.getKey(), def);
            }
        }
        List<IElementDefn> sortedElements = elementSorter.getSortedElements();
        return sortedElements;
    }

    public static List<IElementDefn> getUIElementSupportList(ElementDetailHandle slotHandle) {
        List list = null;
        if (slotHandle instanceof SlotHandle) {
            list = DEUtil.getElementSupportList((SlotHandle)((SlotHandle)slotHandle));
        } else if (slotHandle instanceof PropertyHandle) {
            list = DEUtil.getElementSupportList((PropertyHandle)((PropertyHandle)slotHandle));
        }
        list.removeAll(UIUtil.getInvisibleExtensionElements());
        return list;
    }

    public static List<IElementDefn> getUIElementSupportList(PropertyHandle propertyHandle) {
        List list = DEUtil.getElementSupportList((PropertyHandle)propertyHandle);
        list.removeAll(UIUtil.getInvisibleExtensionElements());
        return list;
    }

    public static void doFinishSave(ModuleHandle model) {
        Object[] resolves = ElementAdapterManager.getAdapters(model, IRelatedFileChangeResolve.class);
        if (resolves == null) {
            return;
        }
        int i = 0;
        while (i < resolves.length) {
            IRelatedFileChangeResolve find = (IRelatedFileChangeResolve)resolves[i];
            find.notifySaveFile(model);
            ++i;
        }
    }

    public static boolean reloadModuleHandleLibraries(ModuleHandle moduleHandle) {
        boolean retBoolean = true;
        try {
            moduleHandle.reloadLibraries();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            retBoolean = false;
        }
        catch (DesignFileException e) {
            ExceptionHandler.handle(e);
            retBoolean = false;
        }
        return retBoolean;
    }

    public static String getDefaultLibraryTemplate() {
        if (Platform.getBundle((String)"org.eclipse.birt.resources") == null) {
            return null;
        }
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.resources"), (IPath)new Path("/templates/blank_library.rpttemplate"), null);
        if (url == null) {
            return null;
        }
        try {
            return FileLocator.resolve((URL)url).getPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Font getFont(ReportItemHandle handle) {
        StyleHandle styleHandle = handle.getPrivateStyle();
        String family = (String)styleHandle.getFontFamilyHandle().getValue();
        String FontFamily = (String)DesignerConstants.familyMap.get(family = DEUtil.removeQuote((String)family));
        if (FontFamily == null) {
            FontFamily = family;
        }
        int fontSize = Math.max(DEUtil.getFontSizeIntValue((DesignElementHandle)handle), 1);
        int fontStyle = 0;
        String fontWeight = styleHandle.getFontWeight();
        String style = styleHandle.getFontStyle();
        if (fontWeight.equals("bold") || fontWeight.equals("bolder") || fontWeight.equals("700") || fontWeight.equals("800") || fontWeight.equals("900")) {
            fontStyle |= 1;
        }
        if (style.equals("italic") || style.equals("oblique")) {
            fontStyle |= 2;
        }
        Font font = FontManager.getFont((String)FontFamily, (int)fontSize, (int)fontStyle);
        return font;
    }

    public static boolean canPreviewWithErrors(ModuleHandle model) {
        if (model == null) {
            return false;
        }
        model.checkReport();
        List errorList = model.getErrorList();
        if (errorList.size() > 0) {
            ErrorStatus status = new ErrorStatus("org.eclipse.birt.report.designer.ui", 1009, Messages.getString((String)"UIUtil.previewconfirm.title"), null);
            int i = 0;
            while (i < errorList.size()) {
                ErrorDetail ed = (ErrorDetail)errorList.get(i);
                status.addError("Line " + ed.getLineNo() + ": " + ed.getMessage());
                ++i;
            }
            return new ErrorDialog(Display.getCurrent().getActiveShell(), Messages.getString((String)"UIUtil.previewconfirm.title"), Messages.getString((String)"UIUtil.previewconfirm.message"), (IStatus)status, 7){

                protected void createButtonsForButtonBar(Composite parent) {
                    this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                    this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                    this.createDetailsButton(parent);
                }
            }.open() == 0;
        }
        return true;
    }

    public static Shell createDefaultShell() {
        return new Shell(0x4F0 | Window.getDefaultOrientation());
    }

    public static void refreshCurrentEditorMarkers() {
        FormEditor editor = UIUtil.getActiveReportEditor();
        if (editor instanceof AbstractMultiPageEditor) {
            try {
                ((AbstractMultiPageEditor)editor).refreshMarkers(editor.getEditorInput());
            }
            catch (CoreException coreException) {}
        }
    }

    public static boolean canDelete(Object object) {
        if (object instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)object) {
                if (UIUtil.canDelete(obj)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            for (Object obj : (List)object) {
                if (UIUtil.canDelete(obj)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof EditPart) {
            return UIUtil.canDelete(((EditPart)object).getModel());
        }
        if (object instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)object;
            if (handle instanceof ParameterGroupHandle && ((ParameterGroupHandle)handle).getParameters().getCount() > 0) {
                if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)CONFIRM_PARAM_DELETE_TITLE, (String)CONFIRM_PARAM_DELETE_MESSAGE)) {
                    return false;
                }
                for (Object obj : ((ParameterGroupHandle)handle).getParameters()) {
                    if (!(obj instanceof ParameterHandle)) continue;
                    ParameterHandle parameter = (ParameterHandle)obj;
                    ConfigVariable cv = parameter.getModuleHandle().findConfigVariable(parameter.getName());
                    try {
                        if (cv == null) continue;
                        parameter.getModuleHandle().getPropertyHandle("configVars").removeItem((Object)cv);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
            }
            ArrayList referenceList = new ArrayList();
            Iterator itor = handle.clientsIterator();
            while (itor.hasNext()) {
                referenceList.add(itor.next());
            }
            if (!referenceList.isEmpty()) {
                DeleteWarningDialog dialog = new DeleteWarningDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), DLG_REFERENCE_FOUND_TITLE, referenceList);
                dialog.setPreString(Messages.getFormattedString((String)"DefaultNodeProvider.Tree.Clients", (Object[])new Object[]{DEUtil.getDisplayLabel((Object)handle)}));
                dialog.setSufString(Messages.getFormattedString((String)"DefaultNodeProvider.Dlg.Confirm", (Object[])new Object[]{DEUtil.getDisplayLabel((Object)handle)}));
                return dialog.open() != 1;
            }
            return true;
        }
        return true;
    }

    public static boolean validateDimensionName(String name) {
        DataRequestSession session = null;
        ICubeQueryUtil cubeQueryUtil = null;
        try {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            cubeQueryUtil = session.getCubeQueryUtil();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return false;
        }
        boolean bool = false;
        if (cubeQueryUtil != null) {
            bool = cubeQueryUtil.isValidDimensionName(name);
        }
        if (session != null) {
            session.shutdown();
        }
        return bool;
    }

    public static String getProjectFolder(IEditorInput input) {
        Object fileAdapter = input.getAdapter(IFile.class);
        IFile file = null;
        if (fileAdapter != null) {
            file = (IFile)fileAdapter;
        }
        if (file != null && file.getProject() != null) {
            return file.getProject().getLocation().toOSString();
        }
        if (input instanceof IPathEditorInput) {
            File fileSystemFile = ((IPathEditorInput)input).getPath().toFile();
            return fileSystemFile.getParent();
        }
        return null;
    }

    public static void processSessionResourceFolder(IEditorInput input, IProject project, ModuleHandle handle) {
        String resourceFolder = "";
        if (input != null) {
            resourceFolder = UIUtil.getProjectFolder(input);
        }
        if (project == null) {
            project = UIUtil.getProjectFromInput(input);
        }
        if (StringUtil.isBlank((String)resourceFolder) && project != null) {
            resourceFolder = project.getLocation().toOSString();
        }
        if (StringUtil.isBlank((String)resourceFolder) && handle != null) {
            resourceFolder = handle.getResourceFolder();
        }
        resourceFolder = ReportPlugin.getDefault().getResourceFolder(project, resourceFolder);
        SessionHandleAdapter.getInstance().getSessionHandle().setResourceFolder(resourceFolder);
    }

    public static IProject getProjectFromInput(IEditorInput input) {
        IProject retValue = null;
        if (input == null) {
            retValue = UIUtil.getCurrentProject();
        } else {
            Object fileAdapter = input.getAdapter(IFile.class);
            IFile file = null;
            if (fileAdapter != null) {
                file = (IFile)fileAdapter;
            }
            if (file != null) {
                retValue = file.getProject();
            }
        }
        if (retValue == null) {
            retValue = UIUtil.getCurrentProject();
        }
        return retValue;
    }

    public static void processOrientationChange(String newOrientation, EditPartViewer viewer) {
        if (newOrientation == null || viewer == null) {
            return;
        }
        boolean mirrored = "rtl".equals(newOrientation);
        viewer.flush();
        Composite parent = viewer.getControl().getParent();
        BidiUIUtils.INSTANCE.applyOrientation((Control)parent, mirrored);
        parent.layout(true);
        viewer.setProperty("bidiLayoutOrientation", (Object)newOrientation);
    }

    public static void drawArrow(GC gc, Rectangle rect, int style) {
        Point point = new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
        int[] points = null;
        switch (style) {
            case 16384: {
                points = new int[]{point.x + 2, point.y - 4, point.x + 2, point.y + 4, point.x - 2, point.y};
                gc.fillPolygon(points);
                break;
            }
            case 128: {
                gc.fillRectangle(new Rectangle(point.x, point.y - 1, 1, 1));
                gc.fillRectangle(new Rectangle(point.x - 1, point.y, 3, 1));
                gc.fillRectangle(new Rectangle(point.x - 2, point.y + 1, 5, 1));
                break;
            }
            case 131072: {
                points = new int[]{point.x - 2, point.y - 4, point.x - 2, point.y + 4, point.x + 2, point.y};
                gc.fillPolygon(points);
                break;
            }
            default: {
                gc.fillRectangle(new Rectangle(point.x - 2, point.y - 1, 5, 1));
                gc.fillRectangle(new Rectangle(point.x - 1, point.y, 3, 1));
                gc.fillRectangle(new Rectangle(point.x, point.y + 1, 1, 1));
            }
        }
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = UIUtil.blend(c1.red, c2.red, ratio);
        int g = UIUtil.blend(c1.green, c2.green, ratio);
        int b = UIUtil.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    public static String encode(String string) {
        int n = string.length();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < n) {
            char character = string.charAt(i);
            if (character < '\u0100') {
                buffer.append(htmlCode[character]);
            } else {
                buffer.append("&#").append((int)character).append(";");
            }
            ++i;
        }
        return buffer.toString().trim();
    }

    public static Object[] getInsertPamaterElements(Object[] newObjs) {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        Object[] insertedObjs = new Object[newObjs.length];
        int i = 0;
        while (i < newObjs.length) {
            LibraryHandle library;
            insertedObjs[i] = newObjs[i];
            DesignElementHandle elementHandle = (DesignElementHandle)newObjs[i];
            if (elementHandle.getRoot() instanceof LibraryHandle && moduleHandle != (library = (LibraryHandle)elementHandle.getRoot())) {
                try {
                    if (UIUtil.includeLibrary(moduleHandle, library)) {
                        elementHandle = moduleHandle.getElementFactory().newElementFrom(elementHandle, elementHandle.getName());
                        moduleHandle.addElement(elementHandle, 1);
                        insertedObjs[i] = elementHandle;
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
            }
            ++i;
        }
        return insertedObjs;
    }

    public static synchronized boolean isEmbeddedBrowserAvailable() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                UIUtil.test();
            }
        });
        embeddedBrowserTested = true;
        return embeddedBrowserAvailable;
    }

    private static boolean test() {
        if (!"win32".equalsIgnoreCase(Platform.getOS()) && !"linux".equalsIgnoreCase(Platform.getOS())) {
            return false;
        }
        if (!embeddedBrowserTested) {
            embeddedBrowserTested = true;
            Shell sh = new Shell();
            try {
                new Browser((Composite)sh, 0);
                embeddedBrowserAvailable = true;
            }
            catch (SWTError se) {
                if (se.code == 2) {
                    embeddedBrowserAvailable = false;
                }
            }
            catch (Exception exception) {}
            if (sh != null && !sh.isDisposed()) {
                sh.dispose();
            }
        }
        return embeddedBrowserAvailable;
    }

    public static void addCreateBy(ModuleHandle handle) {
        String VERSION_MESSAGE = Messages.getString((String)"TextPropertyDescriptor.Message.Version");
        String designerVersion = MessageFormat.format(VERSION_MESSAGE, ReportPlugin.getVersion(), ReportPlugin.getBuildInfo());
        handle.setCreatedBy(designerVersion);
    }

    public static void setDPI(ReportDesignHandle handle) {
        int[] DPI = UIUtil.getScreenResolution();
        try {
            handle.setImageDPI(DPI[0]);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public static int[] getScreenResolution() {
        int[] dpi = new int[2];
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getThread().equals(Thread.currentThread())) {
            Point p = display.getDPI();
            dpi[0] = p.x;
            dpi[1] = p.y;
            return dpi;
        }
        final Point[] points = new Point[]{new Point(0, 0)};
        final Display tempDisplay = display;
        display.syncExec(new Runnable(){

            public void run() {
                points[0] = tempDisplay.getDPI();
            }
        });
        dpi[0] = points[0].x;
        dpi[1] = points[0].y;
        return dpi;
    }

    public static int[] getImageResolution(InputStream imageStream) {
        int[] dpi = new int[2];
        if (imageStream != null) {
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(imageStream);
                Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
                ImageReader r = i.next();
                r.setInput(iis);
                r.read(0);
                IIOMetadata meta = r.getImageMetadata(0);
                if (meta != null) {
                    double mm2inch = 25.4;
                    Element node = (Element)meta.getAsTree("javax_imageio_1.0");
                    NodeList lst = node.getElementsByTagName("HorizontalPixelSize");
                    if (lst != null && lst.getLength() == 1) {
                        dpi[0] = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
                    }
                    if ((lst = node.getElementsByTagName("VerticalPixelSize")) != null && lst.getLength() == 1) {
                        dpi[1] = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dpi;
    }

    public static String formatData(Object str, AbstractScalarParameterHandle param) {
        DateFormatter formatter = new DateFormatter();
        String dataType = param.getDataType();
        try {
            if ("dateTime".equals(dataType)) {
                formatter.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                return formatter.format((Date)str);
            }
            if ("date".equals(dataType)) {
                formatter.applyPattern("yyyy-MM-dd");
                return formatter.format((Date)str);
            }
            if ("time".equals(dataType)) {
                formatter.applyPattern("HH:mm:ss.SSS");
                return formatter.format((Date)str);
            }
        }
        catch (Exception exception) {
            return str.toString();
        }
        return str.toString();
    }

    public static IEditorPart findOpenedEditor(String fileName) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editors = page.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorPart part = editors[i].getEditor(true);
            IPath location = ((IPathEditorInput)part.getEditorInput()).getPath();
            if (fileName.equalsIgnoreCase(location.toOSString())) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static Object getVariableFromContext(IEvaluationContext context, String key) {
        Object retValue = context.getVariable(key);
        if (retValue == null) {
            return null;
        }
        if (retValue.getClass().getName().equals("java.lang.Object")) {
            retValue = null;
        }
        return retValue;
    }

    public static TextAttribute getAttributeFor(String preferenceName) {
        String prefString = PreferenceFactory.getInstance().getPreferences(ReportPlugin.getDefault()).getString(preferenceName);
        String[] stylePrefs = ColorHelper.unpackStylePreferences(prefString);
        Color fDefaultForeground = UIUtil.getEclipseEditorForeground();
        Color fDefaultBackground = UIUtil.getEclipseEditorBackground();
        TextAttribute ta = new TextAttribute(fDefaultForeground, fDefaultBackground, 0);
        if (stylePrefs != null) {
            boolean on;
            RGB foreground = ColorHelper.toRGB(stylePrefs[0]);
            RGB background = ColorHelper.toRGB(stylePrefs[1]);
            int fontModifier = 0;
            if (stylePrefs.length > 2 && (on = Boolean.valueOf(stylePrefs[2]).booleanValue())) {
                fontModifier |= 1;
            }
            if (stylePrefs.length > 3 && (on = Boolean.valueOf(stylePrefs[3]).booleanValue())) {
                fontModifier |= 2;
            }
            if (stylePrefs.length > 4 && (on = Boolean.valueOf(stylePrefs[4]).booleanValue())) {
                fontModifier |= 0x20000000;
            }
            if (stylePrefs.length > 5 && (on = Boolean.valueOf(stylePrefs[5]).booleanValue())) {
                fontModifier |= 0x40000000;
            }
            ta = new TextAttribute(foreground != null ? ColorManager.getColor((RGB)foreground) : null, background != null ? ColorManager.getColor((RGB)background) : null, fontModifier);
        }
        return ta;
    }

    public static Color getEclipseEditorForeground() {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.ui.editors");
        Color color = null;
        if (preferenceStore != null) {
            Color color2 = color = preferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : UIUtil.createColor((IPreferenceStore)preferenceStore, "AbstractTextEditor.Color.Foreground", Display.getCurrent());
        }
        if (color == null) {
            color = Display.getDefault().getSystemColor(24);
        }
        return color;
    }

    public static Color getEclipseEditorBackground() {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.ui.editors");
        Color color = null;
        if (preferenceStore != null) {
            Color color2 = color = preferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : UIUtil.createColor((IPreferenceStore)preferenceStore, "AbstractTextEditor.Color.Background", Display.getCurrent());
        }
        if (color == null) {
            color = Display.getDefault().getSystemColor(25);
        }
        return color;
    }

    public static Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public static String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return String.valueOf(string.substring(0, index - 1)) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    private static DataSetHandle getDataSet(ResultSetColumnHandle column) {
        IExtendedDataModelUIAdapter adapter = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter();
        DataSetHandle dataSet = adapter != null && adapter.getDataSet(column) != null ? adapter.getDataSet(column) : (DataSetHandle)column.getElementHandle();
        return dataSet;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean containsFocusControl(Control container) {
        control = container.getDisplay().getFocusControl();
        if (control != container) ** GOTO lbl6
        return true;
lbl-1000:
        // 1 sources

        {
            if ((control = control.getParent()) != container) continue;
            return true;
lbl6:
            // 2 sources

            ** while (control != null)
        }
lbl7:
        // 1 sources

        return false;
    }
}

