/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class PasteAction
extends AbstractViewAction {
    private static final String DEFAULT_TEXT = Messages.getString((String)"PasteAction.text");

    public PasteAction(Object selectedObject) {
        this(selectedObject, DEFAULT_TEXT);
    }

    public PasteAction(Object selectedObject, String text) {
        super(selectedObject, text);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setAccelerator(262230);
    }

    public void run() {
        ArrayList infoList = new ArrayList();
        if (!this.canPaste(infoList)) {
            String message = null;
            if (infoList.size() != 0 && (message = ((SemanticException)((Object)infoList.get(0))).getLocalizedMessage()) != null) {
                MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"PasteAction.dlg.title"), null, message, 2, new String[]{Messages.getString((String)"PasteAction.ok")}, 0);
                prefDialog.open();
            }
            return;
        }
        try {
            CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.pasteAction", null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    private boolean canPaste(List info) {
        return PasteAction.validateCanPaste(this.getSelection(), this.getClipBoardContents(), info);
    }

    protected Object getClipBoardContents() {
        return Clipboard.getDefault().getContents();
    }

    public Object getSelection() {
        Object selection = super.getSelection();
        if (selection instanceof StructuredSelection) {
            selection = ((StructuredSelection)selection).getFirstElement();
        }
        return selection;
    }

    public static boolean validateCanPaste(Object targetObj, Object transferData, List infoList) {
        return (infoList == null ? DNDUtil.handleValidateTargetCanContain((Object)targetObj, (Object)transferData) : DNDUtil.handleValidateTargetCanContain((Object)targetObj, (Object)transferData, (List)infoList)) && DNDUtil.handleValidateTargetCanContainMore((Object)targetObj, (int)DNDUtil.getObjectLength((Object)transferData));
    }
}

