/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.IFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.FilterConditionBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.FilterModelProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class FilterHandleProvider
implements IFormHandleProvider {
    protected List input;
    protected String[] columnKeys = new String[]{"expr", "operator", "value1", "value2"};
    private static int[] columnWidth = new int[]{200, 150, 200, 200};
    protected FilterModelProvider modelAdapter = new FilterModelProvider();
    private String[] columnNames;
    private CellEditor[] editors;
    private List columnList = new ArrayList();
    protected ParamBindingHandle[] bindingParams = null;

    private void getDataSetColumns(Object obj) {
        if (obj instanceof DesignElementHandle) {
            this.columnList = new ArrayList();
            String[] columns = this.modelAdapter.getChoiceSet(obj, "expr");
            if (columns != null) {
                this.columnList.addAll(Arrays.asList(columns));
            }
        }
    }

    public void setBindingParams(ParamBindingHandle[] params) {
        this.bindingParams = params;
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.modelAdapter.getColumnNames(this.columnKeys);
        }
        return this.columnNames;
    }

    public String getTitle() {
        return Messages.getString((String)"FilterHandleProvider.Label.Filterby");
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnKeys.length];
            this.editors[0] = new TextCellEditor((Composite)table);
            this.editors[1] = new TextCellEditor((Composite)table);
            this.editors[2] = new TextCellEditor((Composite)table);
            this.editors[3] = new TextCellEditor((Composite)table);
        }
        return this.editors;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws PropertyValueException {
        return this.modelAdapter.moveItem(this.input.get(0), oldPos, newPos);
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        return this.modelAdapter.deleteItem(this.input.get(0), pos);
    }

    public boolean doAddItem(int pos) throws SemanticException {
        Object item = this.input.get(0);
        if (item instanceof DesignElementHandle) {
            FilterConditionBuilder dialog = new FilterConditionBuilder(UIUtil.getDefaultShell(), FilterConditionBuilder.DLG_TITLE_NEW, FilterConditionBuilder.DLG_MESSAGE_NEW);
            dialog.setDesignHandle((DesignElementHandle)item);
            dialog.setInput(null);
            dialog.setBindingParams(this.bindingParams);
            if (item instanceof ReportItemHandle) {
                dialog.setReportElement((ReportElementHandle)((ReportItemHandle)item));
            } else if (item instanceof GroupHandle) {
                if (((GroupHandle)item).getContainer() instanceof ReportItemHandle) {
                    dialog.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)item).getContainer()));
                }
            } else if (item instanceof DataGroupHandle && ((DataGroupHandle)item).getContainer() instanceof ReportItemHandle) {
                dialog.setReportElement((ReportElementHandle)((ReportItemHandle)((DataGroupHandle)item).getContainer()));
            }
            if (dialog.open() == 1) {
                return false;
            }
        }
        return true;
    }

    public boolean doEditItem(int pos) {
        Object item = this.input.get(0);
        if (item instanceof DesignElementHandle) {
            DesignElementHandle element = (DesignElementHandle)item;
            PropertyHandle propertyHandle = element.getPropertyHandle("filter");
            FilterConditionHandle filterHandle = (FilterConditionHandle)propertyHandle.getAt(pos);
            if (filterHandle == null) {
                return false;
            }
            FilterConditionBuilder dialog = new FilterConditionBuilder(UIUtil.getDefaultShell(), FilterConditionBuilder.DLG_TITLE_EDIT, FilterConditionBuilder.DLG_MESSAGE_EDIT);
            dialog.setDesignHandle((DesignElementHandle)item);
            dialog.setInput(filterHandle);
            dialog.setBindingParams(this.bindingParams);
            if (item instanceof ReportItemHandle) {
                dialog.setReportElement((ReportElementHandle)((ReportItemHandle)item));
            } else if (item instanceof GroupHandle && ((GroupHandle)item).getContainer() instanceof ReportItemHandle) {
                dialog.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)item).getContainer()));
            }
            if (dialog.open() == 1) {
                return false;
            }
        }
        return true;
    }

    public String getColumnText(Object element, int columnIndex) {
        String key = this.columnKeys[columnIndex];
        return this.modelAdapter.getText(element, key);
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Image getImage(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            this.input = (List)inputElement;
        } else {
            this.input = new ArrayList();
            this.input.add(inputElement);
        }
        this.getDataSetColumns(DEUtil.getInputFirstElement((Object)this.input));
        Object[] elements = this.modelAdapter.getElements(this.input);
        return elements;
    }

    public boolean canModify(Object element, String property) {
        return false;
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean modify(Object data, String property, Object value) throws NameException, SemanticException {
        if (property.equals(this.modelAdapter.getColumnNames(this.columnKeys)[1]) && !value.equals(this.getDisplayName("operator", "between")) && !value.equals(this.getDisplayName("operator", "not-between"))) {
            this.modelAdapter.setStringValue(this.input.get(0), data, "value2", "");
        }
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String key = this.columnKeys[index];
        String strValue = "";
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (intValue == -1) {
                CCombo combo = (CCombo)this.editors[index].getControl();
                strValue = combo.getText();
            } else {
                String[] choices = this.modelAdapter.getChoiceSet(this.input.get(0), this.columnKeys[index]);
                strValue = choices[intValue];
            }
        } else {
            strValue = (String)value;
        }
        return this.modelAdapter.setStringValue(this.input.get(0), data, key, strValue);
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public boolean needRefreshed(NotificationEvent event) {
        if (event instanceof PropertyEvent) {
            String propertyName = ((PropertyEvent)event).getPropertyName();
            if ("boundDataColumns".equals(propertyName)) {
                this.getDataSetColumns(this.input.get(0));
            }
            return true;
        }
        return false;
    }

    private Object getDisplayName(String key, String value) {
        IChoiceSet choiceSet = ChoiceSetFactory.getStructChoiceSet("FilterCondition", key);
        IChoice choice = choiceSet.findChoice(value);
        if (choice != null) {
            return choice.getDisplayName();
        }
        return null;
    }

    public boolean isEditable() {
        return true;
    }
}

