/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IBindingDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class ColumnBindingDialog
extends BaseDialog {
    private static final String ALL = Messages.getString((String)"ColumnBindingDialog.All");
    private static final String CHOICE_DATASET_FROM_CONTAINER = Messages.getString((String)"ColumnBindingDialog.Choice.DatasetFromContainer");
    private static final String CHOICE_NONE = Messages.getString((String)"ColumnBindingDialog.NONE");
    private static final String CHOICE_REPORTITEM_FROM_CONTAINER = Messages.getString((String)"ColumnBindingDialog.Choice.ReportItemFromContainer");
    private static final String COLUMN_AGGREGATEON = Messages.getString((String)"ColumnBindingDialog.Column.AggregateOn");
    private static final String COLUMN_FILTER = Messages.getString((String)"ColumnBindingDialog.Column.Filter");
    private static final String COLUMN_FUNCTION = Messages.getString((String)"ColumnBindingDialog.Column.Function");
    private static final String COLUMN_DATATYPE = Messages.getString((String)"ColumnBindingDialog.Column.DataType");
    private static final String COLUMN_DISPLAYNAME = Messages.getString((String)"ColumnBindingDialog.Column.DisplayName");
    private static final String COLUMN_DISPLAYNAME_ID = Messages.getString((String)"ColumnBindingDialog.Column.DisplayNameID");
    private static final String COLUMN_EXPRESSION = Messages.getString((String)"ColumnBindingDialog.Column.Expression");
    private static final String COLUMN_NAME = Messages.getString((String)"ColumnBindingDialog.Column.Name");
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    public static final String DEFAULT_DLG_TITLE = Messages.getString((String)"ColumnBindingDialog.DialogTitle");
    private static final String dummyChoice = "dummy";
    private static final String INPUT_PROPMT = Messages.getString((String)"ColumnBindingDialog.InputPrompt");
    private static final String LABEL_COLUMN_BINDINGS = Messages.getString((String)"ColumnBindingDialog.Label.DataSet");
    private static final String MSG_ADD = Messages.getString((String)"ColumnBindingDialog.Text.Add");
    private static final String MSG_DELETE = Messages.getString((String)"ColumnBindingDialog.Text.Del");
    private static final String MSG_REFRESH = Messages.getString((String)"ColumnBindingDialog.Text.Refresh");
    private static final String MSG_ADDAGGREGATEON = Messages.getString((String)"ColumnBindingDialog.Text.AddAggr");
    private static final String MSG_EDIT = Messages.getString((String)"ColumnBindingDialog.Text.Edit");
    private static final String NONE_AGGREGATEON = Messages.getString((String)"ColumnBindingDialog.AGGREGATEON.NONE");
    private static final String WARN_COLUMN_BINDINGS = Messages.getString((String)"ColumnBingingDialog.Label.Warn");
    protected TableViewer bindingTable;
    protected Button btnAdd;
    protected Button btnDel;
    protected Button btnEdit;
    private boolean canAggregate = false;
    private boolean canSelect = false;
    private Composite composite;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            List elementsList = ColumnBindingDialog.this.getBindingList((DesignElementHandle)inputElement);
            Object[] arrays = elementsList.toArray();
            Arrays.sort(arrays, new BindingComparator());
            return arrays;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    private Combo datasetCombo;
    private Button datasetRadio;
    private transient boolean enableAutoCommit = false;
    protected ExpressionProvider expressionProvider;
    private List groupList = Collections.EMPTY_LIST;
    private String[] groups;
    protected ReportItemHandle inputElement;
    private boolean isDataSetVisible;
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == ColumnBindingDialog.dummyChoice) {
                if (columnIndex == 1) {
                    return INPUT_PROPMT;
                }
                return "";
            }
            ComputedColumnHandle handle = (ComputedColumnHandle)element;
            String text = null;
            switch (columnIndex) {
                case 1: {
                    text = handle.getName();
                    break;
                }
                case 2: {
                    text = handle.getDisplayNameID();
                    break;
                }
                case 3: {
                    text = handle.getDisplayName();
                    break;
                }
                case 4: {
                    text = ChoiceSetFactory.getDisplayNameFromChoiceSet(handle.getDataType(), DATA_TYPE_CHOICE_SET);
                    break;
                }
                case 5: {
                    text = DataUtil.getAggregationExpression(handle);
                    break;
                }
                case 6: {
                    try {
                        String function = handle.getAggregateFunction();
                        if (function == null || DataUtil.getAggregationManager().getAggregation(function) == null) break;
                        text = DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
                    }
                    catch (BirtException e) {
                        ExceptionHandler.handle(e);
                    }
                    break;
                }
                case 7: {
                    text = handle.getFilterExpression();
                    break;
                }
                case 8: {
                    String value = DEUtil.getAggregateOn((ComputedColumnHandle)handle);
                    if (value == null) {
                        if (handle.getAggregateFunction() != null) {
                            text = ALL;
                            break;
                        }
                        text = NONE_AGGREGATEON;
                        break;
                    }
                    text = value;
                }
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private String NullDatasetChoice = null;
    private String NullReportItemChoice = null;
    private Combo reportItemCombo;
    private Button reportItemRadio;
    private String selectedColumnName = null;
    private int selectIndex;
    private CLabel warnLabel;
    private boolean filterSelf;
    protected Map<String, ReportItemHandle> referMap = new HashMap<String, ReportItemHandle>();
    private Button btnAddAggr;
    private Button btnRefresh;
    private BindingInfo oldInfo;
    private int sortingColumnIndex;
    private int sortDirection = 128;

    protected int getOriginalIndex(int pos) {
        ArrayList children = new ArrayList();
        Iterator iter = this.getBindingList((DesignElementHandle)this.inputElement).iterator();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        Object[] arrays = children.toArray();
        Arrays.sort(arrays, new BindingComparator());
        return children.indexOf(Arrays.asList(arrays).get(pos));
    }

    protected int getShowIndex(int pos) {
        ArrayList children = new ArrayList();
        Iterator iter = this.getBindingList((DesignElementHandle)this.inputElement).iterator();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        Object[] arrays = children.toArray();
        Arrays.sort(arrays, new BindingComparator());
        return Arrays.asList(arrays).indexOf(children.get(pos));
    }

    public ColumnBindingDialog(ReportItemHandle input) {
        super(DEFAULT_DLG_TITLE);
        this.setInput(input);
    }

    public ColumnBindingDialog(ReportItemHandle input, boolean canSelect) {
        super(DEFAULT_DLG_TITLE);
        this.setInput(input);
        this.canSelect = canSelect;
    }

    public ColumnBindingDialog(ReportItemHandle input, Shell parent, boolean canSelect) {
        this(input, parent, DEFAULT_DLG_TITLE, canSelect, true);
    }

    public ColumnBindingDialog(ReportItemHandle input, Shell parent, boolean canSelect, boolean canAggregate) {
        this(input, parent, DEFAULT_DLG_TITLE, canSelect, canAggregate);
    }

    public ColumnBindingDialog(ReportItemHandle input, Shell parent, String title, boolean canSelect, boolean canAggregate) {
        super(parent, title);
        this.setInput(input);
        this.canSelect = canSelect;
        this.canAggregate = canAggregate;
    }

    public ColumnBindingDialog(ReportItemHandle input, String title) {
        super(title);
        this.setInput(input);
    }

    public ColumnBindingDialog(ReportItemHandle input, String title, boolean canAggregate) {
        super(title);
        this.setInput(input);
        this.canAggregate = canAggregate;
    }

    public ColumnBindingDialog(ReportItemHandle input, String title, boolean canAggregate, boolean canSelect, boolean filterSelf) {
        super(title);
        this.setInput(input);
        this.canSelect = canSelect;
        this.canAggregate = canAggregate;
        this.filterSelf = filterSelf;
    }

    protected void addBinding(ComputedColumn column) {
        try {
            DEUtil.addColumn((DesignElementHandle)DEUtil.getBindingHolder((DesignElementHandle)this.inputElement), (ComputedColumn)column, (boolean)false);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void generateOutputParmsBindings(DataSetHandle datasetHandle) {
        ArrayList<DataSetParameterHandle> outputParams = new ArrayList<DataSetParameterHandle>();
        Iterator iter = datasetHandle.parametersIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof DataSetParameterHandle) || !((DataSetParameterHandle)obj).isOutput()) continue;
            outputParams.add((DataSetParameterHandle)obj);
        }
        int ret = -1;
        if (outputParams.size() > 0) {
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.generateOutputParam"), null, Messages.getString((String)"dataBinding.msg.generateOutputParam"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No")}, 0);
            ret = prefDialog.open();
        }
        if (ret == 0) {
            int i = 0;
            while (i < outputParams.size()) {
                DataSetParameterHandle param = (DataSetParameterHandle)outputParams.get(i);
                ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)this.inputElement, (String)param.getName());
                bindingColumn.setDataType(param.getDataType());
                ExpressionUtility.setBindingColumnExpression(param, bindingColumn, true);
                try {
                    this.inputElement.addColumnBinding(bindingColumn, false);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
                ++i;
            }
        }
    }

    protected int addButtons(Composite cmp, Table table) {
        this.btnRefresh = new Button(cmp, 8);
        this.btnRefresh.setText(MSG_REFRESH);
        GridData data = new GridData(2);
        data.widthHint = Math.max(60, this.btnRefresh.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnRefresh.setLayoutData((Object)data);
        this.btnRefresh.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DataSetHandle datasetHandle;
                if (ColumnBindingDialog.this.inputElement != null && (datasetHandle = ColumnBindingDialog.this.inputElement.getDataSet()) != null) {
                    try {
                        CachedMetaDataHandle cmdh = DataSetUIUtil.getCachedMetaDataHandle(datasetHandle);
                        for (ResultSetColumnHandle element : cmdh.getResultSet()) {
                            ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)ColumnBindingDialog.this.inputElement, (String)element.getColumnName());
                            bindingColumn.setDataType(element.getDataType());
                            ExpressionUtility.setBindingColumnExpression(element, bindingColumn);
                            ColumnBindingDialog.this.inputElement.addColumnBinding(bindingColumn, false);
                        }
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                    ColumnBindingDialog.this.refreshBindingTable();
                    ColumnBindingDialog.this.updateButtons();
                }
            }
        });
        return 1;
    }

    private void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ColumnBindingDialog_ID");
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        if (this.canSelect) {
            this.composite = new Composite(parentComposite, 0);
            this.composite.setLayoutData((Object)new GridData(768));
            this.composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
            this.warnLabel = new CLabel(this.composite, 0);
            this.warnLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            this.warnLabel.setText(WARN_COLUMN_BINDINGS);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.warnLabel.setLayoutData((Object)gd);
            this.datasetRadio = new Button(this.composite, 16);
            this.datasetRadio.setText(LABEL_COLUMN_BINDINGS);
            this.datasetRadio.setLayoutData((Object)new GridData(1));
            this.datasetRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnBindingDialog.this.refreshBinding();
                    if (ColumnBindingDialog.this.datasetRadio.getSelection() && ColumnBindingDialog.this.inputElement.getDataBindingType() == 2 && (DEUtil.getBindingHolder((DesignElementHandle)ColumnBindingDialog.this.inputElement, (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)ColumnBindingDialog.this.inputElement, (boolean)true).getDataBindingType() != 2)) {
                        ColumnBindingDialog.this.saveBinding();
                    }
                }
            });
            this.datasetCombo = new Combo(this.composite, 2056);
            this.datasetCombo.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
            this.datasetCombo.setVisibleItemCount(30);
            String[] dataSets = ChoiceSetFactory.getDataSets();
            String[] newList = new String[dataSets.length + 1];
            newList[0] = this.NullDatasetChoice;
            System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
            this.datasetCombo.setItems(newList);
            String dataSetName = this.getDataSetName();
            this.datasetCombo.deselectAll();
            if (dataSetName != null) {
                this.datasetCombo.setText(dataSetName);
            } else {
                this.datasetCombo.select(0);
            }
            gd = new GridData();
            gd.widthHint = 250;
            this.datasetCombo.setLayoutData((Object)gd);
            this.datasetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ColumnBindingDialog.this.saveBinding();
                }
            });
            this.reportItemRadio = new Button(this.composite, 16);
            this.reportItemRadio.setText(Messages.getString((String)"BindingPage.ReportItem.Label"));
            this.reportItemRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnBindingDialog.this.refreshBinding();
                    if (ColumnBindingDialog.this.reportItemRadio.getSelection() && ColumnBindingDialog.this.inputElement.getDataBindingType() == 1 && (DEUtil.getBindingHolder((DesignElementHandle)ColumnBindingDialog.this.inputElement, (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)ColumnBindingDialog.this.inputElement, (boolean)true).getDataBindingType() == 2)) {
                        ColumnBindingDialog.this.saveBinding();
                    }
                }
            });
            this.reportItemCombo = new Combo(this.composite, 2056);
            this.reportItemCombo.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
            this.reportItemCombo.setVisibleItemCount(30);
            gd = new GridData();
            gd.widthHint = 250;
            this.reportItemCombo.setLayoutData((Object)gd);
            this.reportItemCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnBindingDialog.this.saveBinding();
                }
            });
        }
        Composite contentComposite = new Composite(parentComposite, 0);
        contentComposite.setLayoutData((Object)new GridData(1808));
        contentComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        final Table table = new Table(contentComposite, 0x10804 | (this.canSelect ? 32 : 0));
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.verticalSpan = 5;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int modelPos = -1;
                if (table.getSelectionIndex() > -1) {
                    modelPos = ColumnBindingDialog.this.getOriginalIndex(table.getSelectionIndex());
                }
                TableColumn sortColumn = table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = table.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(currentColumn);
                    dir = 128;
                    int i = 0;
                    while (i < table.getColumnCount()) {
                        if (currentColumn == table.getColumn(i)) {
                            ColumnBindingDialog.this.setSortingColumnIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
                ColumnBindingDialog.this.setSortDirection(dir);
                table.setSortDirection(dir);
                ColumnBindingDialog.this.refreshBindingTable();
                if (modelPos > -1) {
                    table.setSelection(ColumnBindingDialog.this.getShowIndex(modelPos));
                }
            }
        };
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && (DEUtil.getBindingHolder((DesignElementHandle)ColumnBindingDialog.this.inputElement).getDataBindingType() == 1 || DEUtil.getBindingHolder((DesignElementHandle)ColumnBindingDialog.this.inputElement).getDataBindingType() == 0 && (DEUtil.getBindingHolder((DesignElementHandle)ColumnBindingDialog.this.inputElement, (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)ColumnBindingDialog.this.inputElement, (boolean)true).getDataBindingType() != 2))) {
                    int itemCount = table.getItemCount();
                    if (ColumnBindingDialog.this.selectIndex == itemCount) {
                        return;
                    }
                    if (ColumnBindingDialog.this.selectIndex == itemCount - 1) {
                        ColumnBindingDialog columnBindingDialog = ColumnBindingDialog.this;
                        columnBindingDialog.selectIndex = columnBindingDialog.selectIndex - 1;
                    }
                    try {
                        ColumnBindingDialog.this.handleDelEvent();
                    }
                    catch (Exception e1) {
                        WidgetUtil.processError(ColumnBindingDialog.this.getShell(), e1);
                    }
                    ColumnBindingDialog.this.refreshBindingTable();
                }
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnBindingDialog.this.selectIndex = table.getSelectionIndex();
                ColumnBindingDialog.this.updateButtons();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ColumnBindingDialog.this.editSelectedBinding(table.getSelectionIndex());
                ColumnBindingDialog.this.refreshBindingTable();
            }
        });
        String[] columns = null;
        int[] columnWidth = null;
        this.groups = new String[this.groupList.size() + 1];
        this.groups[0] = ALL;
        int i = 0;
        while (i < this.groupList.size()) {
            this.groups[i + 1] = ((GroupHandle)this.groupList.get(i)).getName();
            ++i;
        }
        if (this.canAggregate) {
            String[] stringArray = new String[9];
            stringArray[1] = COLUMN_NAME;
            stringArray[2] = COLUMN_DISPLAYNAME_ID;
            stringArray[3] = COLUMN_DISPLAYNAME;
            stringArray[4] = COLUMN_DATATYPE;
            stringArray[5] = COLUMN_EXPRESSION;
            stringArray[6] = COLUMN_FUNCTION;
            stringArray[7] = COLUMN_FILTER;
            stringArray[8] = COLUMN_AGGREGATEON;
            columns = stringArray;
            columnWidth = new int[]{this.canSelect ? 25 : 20, 100, 100, 100, 70, 100, 100, 100, 100};
        } else {
            String[] stringArray = new String[6];
            stringArray[1] = COLUMN_NAME;
            stringArray[2] = COLUMN_DISPLAYNAME_ID;
            stringArray[3] = COLUMN_DISPLAYNAME;
            stringArray[4] = COLUMN_DATATYPE;
            stringArray[5] = COLUMN_EXPRESSION;
            columns = stringArray;
            columnWidth = new int[]{this.canSelect ? 25 : 20, 120, 120, 120, 70, 120};
        }
        i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 16384);
            if (i == 0) {
                table.setSortColumn(column);
            }
            column.setResizable(columns[i] != null);
            if (columns[i] != null) {
                column.setText(columns[i]);
            }
            column.setWidth(columnWidth[i]);
            column.addListener(13, sortListener);
            ++i;
        }
        table.setSortDirection(128);
        if (this.canSelect) {
            this.bindingTable = new CheckboxTableViewer(table);
            ((CheckboxTableViewer)this.bindingTable).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getElement() instanceof ComputedColumnHandle) {
                        ComputedColumnHandle handle = (ComputedColumnHandle)event.getElement();
                        if (handle.getName().equals(ColumnBindingDialog.this.selectedColumnName)) {
                            ColumnBindingDialog.this.selectedColumnName = null;
                        } else {
                            ColumnBindingDialog.this.selectedColumnName = handle.getName();
                        }
                        ColumnBindingDialog.this.updateSelection();
                        ColumnBindingDialog.this.updateButtons();
                    } else {
                        ((CheckboxTableViewer)ColumnBindingDialog.this.bindingTable).setChecked((Object)ColumnBindingDialog.dummyChoice, false);
                    }
                }
            });
        } else {
            this.bindingTable = new TableViewer(table);
        }
        this.bindingTable.setColumnProperties(columns);
        this.bindingTable.setContentProvider((IContentProvider)this.contentProvider);
        this.bindingTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.bindingTable.setInput((Object)this.inputElement);
        this.bindingTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnBindingDialog.this.updateButtons();
            }
        });
        this.btnAdd = new Button(contentComposite, 8);
        this.btnAdd.setText(MSG_ADD);
        GridData data = new GridData();
        data.widthHint = Math.max(60, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnBindingDialog.this.handleAddEvent();
                ColumnBindingDialog.this.refreshBindingTable();
                if (table.getItemCount() > 0) {
                    ColumnBindingDialog.this.selectIndex = ColumnBindingDialog.this.getShowIndex(table.getItemCount() - 1);
                }
                ColumnBindingDialog.this.updateButtons();
            }
        });
        if (this.canAggregate) {
            this.btnAddAggr = new Button(contentComposite, 8);
            this.btnAddAggr.setText(MSG_ADDAGGREGATEON);
            data = new GridData();
            data.widthHint = Math.max(60, this.btnAddAggr.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnAddAggr.setLayoutData((Object)data);
            this.btnAddAggr.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
                    dialog.setInput(ColumnBindingDialog.this.inputElement);
                    dialog.setExpressionProvider(ColumnBindingDialog.this.expressionProvider);
                    dialog.setAggreate(true);
                    if (dialog.open() == 0 && ColumnBindingDialog.this.bindingTable != null) {
                        ColumnBindingDialog.this.refreshBindingTable();
                        ColumnBindingDialog.this.bindingTable.getTable().setSelection(ColumnBindingDialog.this.bindingTable.getTable().getItemCount() - 1);
                    }
                    ColumnBindingDialog.this.refreshBindingTable();
                    if (table.getItemCount() > 0) {
                        ColumnBindingDialog.this.setSelectionInTable(table.getItemCount() - 1);
                    }
                    ColumnBindingDialog.this.updateButtons();
                }
            });
        }
        this.btnEdit = new Button(contentComposite, 8);
        this.btnEdit.setText(MSG_EDIT);
        data = new GridData();
        data.widthHint = Math.max(60, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnEdit.setLayoutData((Object)data);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnBindingDialog.this.handleEditEvent();
                ColumnBindingDialog.this.refreshBindingTable();
            }
        });
        this.btnDel = new Button(contentComposite, 8);
        this.btnDel.setText(MSG_DELETE);
        data = new GridData();
        data.widthHint = Math.max(60, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        this.btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int pos;
                if (ColumnBindingDialog.this.bindingTable.isCellEditorActive()) {
                    ColumnBindingDialog.this.bindingTable.cancelEditing();
                }
                if ((pos = ColumnBindingDialog.this.bindingTable.getTable().getSelectionIndex()) == -1) {
                    ColumnBindingDialog.this.bindingTable.getTable().setFocus();
                    return;
                }
                ColumnBindingDialog.this.selectIndex = pos;
                int itemCount = ColumnBindingDialog.this.bindingTable.getTable().getItemCount();
                if (ColumnBindingDialog.this.selectIndex == itemCount - 1) {
                    ColumnBindingDialog columnBindingDialog = ColumnBindingDialog.this;
                    columnBindingDialog.selectIndex = columnBindingDialog.selectIndex - 1;
                }
                try {
                    ColumnBindingDialog.this.handleDelEvent();
                }
                catch (Exception e1) {
                    WidgetUtil.processError(ColumnBindingDialog.this.getShell(), e1);
                }
                ColumnBindingDialog.this.refreshBindingTable();
            }
        });
        int buttonsNumber = this.addButtons(contentComposite, table);
        if (buttonsNumber > 0 && table.getLayoutData() instanceof GridData) {
            ((GridData)table.getLayoutData()).verticalSpan += buttonsNumber;
        }
        if (!this.isDataSetVisible && this.composite != null) {
            ((GridData)this.composite.getLayoutData()).exclude = true;
        }
        return parentComposite;
    }

    protected void deleteRow(ComputedColumnHandle handle) {
        try {
            if (handle.getName().equals(this.selectedColumnName)) {
                this.selectedColumnName = null;
            }
            handle.drop();
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void generateBindingColumns() throws SemanticException {
        List columnList = org.eclipse.birt.report.designer.internal.ui.util.DataUtil.generateComputedColumns(this.inputElement);
        if (columnList.size() > 0) {
            Iterator iter = columnList.iterator();
            while (iter.hasNext()) {
                this.addBinding((ComputedColumn)iter.next());
            }
        }
        if (this.inputElement != null && this.inputElement.getDataSet() != null) {
            this.generateOutputParmsBindings(this.inputElement.getDataSet());
        }
        this.refreshBindingTable();
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    public String[] getAvailableDatasetItems() {
        String[] dataSets = ChoiceSetFactory.getDataSets();
        String[] newList = new String[dataSets.length + 1];
        newList[0] = this.NullDatasetChoice;
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        return newList;
    }

    protected List getBindingList(DesignElementHandle inputElement) {
        List elementsList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)inputElement);
        if (this.filterSelf) {
            Iterator iterator = this.inputElement.columnBindingsIterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                System.out.println(obj);
                elementsList.remove(obj);
            }
        }
        return elementsList;
    }

    private String getColumnName(String expression) {
        List columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)this.inputElement);
        for (ComputedColumnHandle cachedColumn : columnList) {
            String columnName = cachedColumn.getName();
            if (!DEUtil.getColumnExpression((String)columnName).equals(expression)) continue;
            return columnName;
        }
        return null;
    }

    private String getDataSetName() {
        if (this.inputElement.getDataSet() == null) {
            return null;
        }
        String dataSetName = this.inputElement.getDataSet().getQualifiedName();
        if (StringUtil.isBlank((String)dataSetName)) {
            dataSetName = null;
        }
        return dataSetName;
    }

    protected String[] getReferences() {
        List referenceList = this.inputElement.getAvailableDataSetBindingReferenceList();
        Object[] references = new String[referenceList.size() + 1];
        references[0] = this.NullReportItemChoice;
        this.referMap.put(references[0], null);
        int j = 0;
        int i = 0;
        while (i < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i);
            if (item.getName() != null) {
                references[++j] = item.getQualifiedName();
                this.referMap.put((String)references[j], item);
            }
            ++i;
        }
        int tmp = j + 1;
        Arrays.sort(references, 1, tmp);
        int i2 = 0;
        while (i2 < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i2);
            if (item.getName() == null) {
                references[++j] = String.valueOf(item.getElement().getDefn().getDisplayName()) + " (ID " + item.getID() + ") - " + Messages.getString((String)"BindingPage.ReportItem.NoName");
                this.referMap.put((String)references[j], item);
            }
            ++i2;
        }
        Arrays.sort(references, tmp, referenceList.size() + 1);
        return references;
    }

    private ComputedColumnHandle getSelectColumnHandle() {
        if (this.selectedColumnName != null) {
            int i = 0;
            while (i < this.bindingTable.getTable().getItemCount()) {
                ComputedColumnHandle handle = (ComputedColumnHandle)this.bindingTable.getElementAt(i);
                if (this.selectedColumnName.equals(handle.getName())) {
                    return handle;
                }
                ++i;
            }
        }
        return null;
    }

    protected void handleAddEvent() {
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
        dialog.setInput(this.inputElement);
        dialog.setExpressionProvider(this.expressionProvider);
        if (dialog.open() == 0 && this.bindingTable != null) {
            this.refreshBindingTable();
        }
    }

    protected void handleDelEvent() {
        if (!this.btnDel.isEnabled()) {
            return;
        }
        int pos = this.bindingTable.getTable().getSelectionIndex();
        if ((pos = this.getOriginalIndex(pos)) > -1) {
            try {
                ComputedColumnHandle handle = (ComputedColumnHandle)DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getColumnBindings().getAt(pos);
                this.deleteRow(handle);
            }
            catch (Exception e1) {
                ExceptionHandler.handle(e1);
            }
        }
    }

    protected void handleEditEvent() {
        int pos = this.bindingTable.getTable().getSelectionIndex();
        this.editSelectedBinding(pos);
    }

    private void editSelectedBinding(int bindingIndex) {
        if (!this.btnEdit.isEnabled()) {
            return;
        }
        ComputedColumnHandle bindingHandle = null;
        if ((bindingIndex = this.getOriginalIndex(bindingIndex)) > -1) {
            bindingHandle = (ComputedColumnHandle)DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getColumnBindings().getAt(bindingIndex);
        }
        if (bindingHandle == null) {
            return;
        }
        String bindingName = bindingHandle.getName();
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(false);
        this.setDialogInput(dialog, bindingHandle);
        dialog.setExpressionProvider(this.expressionProvider);
        if (dialog.open() == 0) {
            if (this.bindingTable != null) {
                this.bindingTable.getTable().setSelection(bindingIndex);
            }
            if (this.selectedColumnName != null && this.selectedColumnName.equals(bindingName)) {
                this.selectedColumnName = bindingHandle.getName();
            }
        }
        this.selectIndex = this.getShowIndex(bindingIndex);
    }

    protected void setDialogInput(DataColumnBindingDialog dialog, ComputedColumnHandle bindingHandle) {
        if (dialog != null) {
            dialog.setInput(this.inputElement, bindingHandle);
        }
    }

    protected boolean initDialog() {
        if (this.canSelect) {
            if (this.inputElement instanceof DataItemHandle) {
                this.selectedColumnName = ((DataItemHandle)this.inputElement).getResultSetColumn();
                this.updateSelection();
            } else if (this.inputElement instanceof ImageHandle) {
                this.selectedColumnName = this.getColumnName(((ImageHandle)this.inputElement).getValueExpression());
                this.updateSelection();
            }
        }
        this.load();
        return super.initDialog();
    }

    protected boolean needRememberLastSize() {
        return true;
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void load() {
        if (this.canSelect) {
            this.datasetRadio.setEnabled(true);
            this.reportItemRadio.setEnabled(true);
            BindingInfo info = (BindingInfo)this.loadValue();
            if (info != null) {
                this.refreshBindingInfo(info);
            }
        }
        this.refreshBindingTable();
    }

    public Object loadValue() {
        if (this.canSelect) {
            String value;
            int type = this.inputElement.getDataBindingType();
            if (type == 0) {
                type = DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getDataBindingType();
            }
            switch (type) {
                case 1: {
                    DataSetHandle dataset = this.inputElement.getDataSet();
                    if (dataset == null) {
                        value = this.NullDatasetChoice;
                        break;
                    }
                    value = dataset.getQualifiedName();
                    break;
                }
                case 2: {
                    ReportItemHandle reference = this.inputElement.getDataBindingReference();
                    if (reference == null) {
                        value = this.NullReportItemChoice;
                        break;
                    }
                    value = reference.getQualifiedName();
                    break;
                }
                default: {
                    value = this.NullDatasetChoice;
                }
            }
            BindingInfo info = new BindingInfo(type, value);
            return info;
        }
        return null;
    }

    protected void okPressed() {
        if (this.canSelect) {
            this.setResult(this.selectedColumnName);
            if (this.inputElement instanceof DataItemHandle) {
                try {
                    ((DataItemHandle)this.inputElement).setResultSetColumn(this.selectedColumnName);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }
        super.okPressed();
    }

    private void refreshBinding() {
        if (this.datasetRadio.getSelection()) {
            this.datasetRadio.setSelection(true);
            this.datasetCombo.setEnabled(true);
            this.reportItemRadio.setSelection(false);
            this.reportItemCombo.setEnabled(false);
            if (this.datasetCombo.getSelectionIndex() == -1) {
                this.datasetCombo.setItems(this.getAvailableDatasetItems());
                this.datasetCombo.select(0);
            }
        } else {
            this.datasetRadio.setSelection(false);
            this.datasetCombo.setEnabled(false);
            this.reportItemRadio.setSelection(true);
            this.reportItemCombo.setEnabled(true);
            if (this.reportItemCombo.getSelectionIndex() == -1) {
                this.reportItemCombo.setItems(this.getReferences());
                this.reportItemCombo.select(0);
            }
        }
    }

    private void refreshBindingInfo(BindingInfo info) {
        if (this.canSelect) {
            int type = info.getBindingType();
            Object value = info.getBindingValue();
            this.datasetCombo.setItems(this.getAvailableDatasetItems());
            this.reportItemCombo.setItems(this.getReferences());
            if (type == 0) {
                type = DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getDataBindingType();
            }
            switch (type) {
                case 0: {
                    if (this.oldInfo != null) {
                        if (this.oldInfo.getBindingType() == 1) {
                            this.selectDatasetType(value);
                            break;
                        }
                        if (this.oldInfo.getBindingType() != 2) break;
                        this.selectReferenceType(value);
                        break;
                    }
                }
                case 1: {
                    this.selectDatasetType(value);
                    break;
                }
                case 2: {
                    this.selectReferenceType(value);
                }
            }
        }
    }

    private void selectReferenceType(Object value) {
        this.datasetRadio.setSelection(false);
        this.datasetCombo.setEnabled(false);
        this.reportItemRadio.setSelection(true);
        this.reportItemCombo.setEnabled(true);
        this.reportItemCombo.setText(value.toString());
    }

    private void selectDatasetType(Object value) {
        this.datasetRadio.setSelection(true);
        this.datasetCombo.setEnabled(true);
        this.datasetCombo.setText(value.toString());
        this.reportItemRadio.setSelection(false);
        this.reportItemCombo.setEnabled(false);
    }

    protected void refreshBindingTable() {
        this.bindingTable.refresh();
        if (this.canSelect) {
            this.updateSelection();
        }
        this.updateButtons();
    }

    private void resetDataSetReference(Object value, boolean clearHistory) {
        try {
            this.startTrans("");
            this.inputElement.setDataBindingReference(null);
            DataSetHandle dataSet = null;
            if (value != null) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(value.toString());
            }
            if (this.inputElement.getDataBindingType() == 2) {
                this.inputElement.setDataBindingReference(null);
            }
            boolean isExtendedDataModel = false;
            if (dataSet == null && value != null) {
                this.inputElement.setDataSet(null);
                isExtendedDataModel = new LinkedDataSetAdapter().setLinkedDataModel(this.inputElement, value.toString());
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel(this.inputElement, null);
                this.inputElement.setDataSet(dataSet);
            }
            if (clearHistory) {
                this.inputElement.getColumnBindings().clearValue();
                this.inputElement.getPropertyHandle("paramBindings").clearValue();
            }
            if (!isExtendedDataModel) {
                this.generateBindingColumns();
            }
            this.selectedColumnName = null;
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionHandler.handle(e);
        }
        this.load();
    }

    private void resetReference(Object value) {
        if (value == null && this.inputElement.getDataBindingType() == 1) {
            this.resetDataSetReference(null, true);
        } else {
            try {
                this.startTrans(Messages.getString((String)"DataColumBindingDialog.stackMsg.resetReference"));
                ReportItemHandle element = null;
                if (value != null) {
                    element = (ReportItemHandle)SessionHandleAdapter.getInstance().getReportDesignHandle().findElement(value.toString());
                }
                this.inputElement.setDataBindingReference(element);
                this.selectedColumnName = null;
                this.commit();
            }
            catch (SemanticException e) {
                this.rollback();
                ExceptionHandler.handle(e);
            }
            this.load();
        }
    }

    private void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public void save(Object saveValue) throws SemanticException {
        if (saveValue instanceof BindingInfo) {
            BindingInfo info = (BindingInfo)saveValue;
            int type = info.getBindingType();
            String value = info.getBindingValue().toString();
            block0 : switch (type) {
                case 1: {
                    if (value.equals(this.NullDatasetChoice)) {
                        value = null;
                    }
                    int ret = 0;
                    if (!this.NullDatasetChoice.equals(((BindingInfo)this.loadValue()).getBindingValue().toString()) || this.inputElement.getColumnBindings().iterator().hasNext()) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret = prefDialog.open();
                    }
                    switch (ret) {
                        case 0: {
                            this.resetDataSetReference(value, true);
                            break;
                        }
                        case 1: {
                            this.resetDataSetReference(value, false);
                            break;
                        }
                        case 2: {
                            this.load();
                        }
                    }
                    break;
                }
                case 2: {
                    if (value.equals(this.NullReportItemChoice)) {
                        value = null;
                    } else if (this.referMap.get(value).getName() == null) {
                        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.haveNoName"), null, Messages.getString((String)"dataBinding.message.haveNoName"), 3, new String[]{Messages.getString((String)"dataBinding.button.OK")}, 0);
                        dialog.open();
                        this.load();
                        return;
                    }
                    int ret1 = 0;
                    if (!this.NullReportItemChoice.equals(((BindingInfo)this.loadValue()).getBindingValue().toString()) || this.inputElement.getColumnBindings().iterator().hasNext()) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeReference"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret1 = prefDialog.open();
                    }
                    switch (ret1) {
                        case 0: {
                            this.resetReference(value);
                            break block0;
                        }
                        case 1: {
                            this.load();
                        }
                    }
                }
            }
        }
    }

    private void saveBinding() {
        BindingInfo info = new BindingInfo();
        if (this.datasetRadio.getSelection()) {
            info.setBindingType(1);
            info.setBindingValue(this.datasetCombo.getText());
        } else {
            info.setBindingType(2);
            info.setBindingValue(this.reportItemCombo.getText());
        }
        try {
            this.oldInfo = info;
            this.save(info);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public void setExpressionProvider(ExpressionProvider provider) {
        this.expressionProvider = provider;
    }

    public void setGroupList(List groupList) {
        this.groupList = groupList;
    }

    private void setInput(ReportItemHandle input) {
        this.inputElement = input;
        ReportItemHandle container = DEUtil.getBindingHolder((DesignElementHandle)input.getContainer());
        this.NullDatasetChoice = container != null && (container.getDataSet() != null || container.columnBindingsIterator().hasNext()) ? CHOICE_DATASET_FROM_CONTAINER : CHOICE_NONE;
        this.NullReportItemChoice = container != null && container.getDataBindingReference() != null ? CHOICE_REPORTITEM_FROM_CONTAINER : CHOICE_NONE;
        this.isDataSetVisible = DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getElement().getDefn().isPropertyVisible("dataSet");
        IBindingDialogHelper dialogHelper = (IBindingDialogHelper)ElementAdapterManager.getAdapter(this.inputElement, IBindingDialogHelper.class);
        if (dialogHelper != null) {
            dialogHelper.setBindingHolder(DEUtil.getBindingHolder((DesignElementHandle)this.inputElement));
        }
        this.canAggregate = dialogHelper == null ? false : dialogHelper.canProcessAggregation();
    }

    protected void setSelectionInTable(int selectedIndex) {
        this.selectIndex = selectedIndex;
    }

    private void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    protected void updateButtons() {
        boolean okEnable = false;
        if (!this.canSelect || !this.isDataSetVisible && this.selectedColumnName != null || this.getSelectColumnHandle() != null) {
            okEnable = true;
        }
        this.getOkButton().setEnabled(okEnable);
        int min = 0;
        int max = this.bindingTable.getTable().getItemCount() - 1;
        if (min <= this.selectIndex && this.selectIndex <= max) {
            this.btnDel.setEnabled(true);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(true);
            }
        } else {
            this.btnDel.setEnabled(false);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(false);
            }
        }
        this.bindingTable.getTable().select(this.selectIndex);
        if (DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getDataBindingType() == 1) {
            this.btnAdd.setEnabled(true);
            if (this.btnAddAggr != null) {
                this.btnAddAggr.setEnabled(true);
            }
            if (this.btnRefresh != null) {
                this.btnRefresh.setEnabled(true);
            }
        } else if (DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getDataBindingType() == 0 && (DEUtil.getBindingHolder((DesignElementHandle)this.inputElement, (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)this.inputElement, (boolean)true).getDataBindingType() != 2)) {
            this.btnAdd.setEnabled(true);
            if (this.btnAddAggr != null) {
                this.btnAddAggr.setEnabled(true);
            }
            if (this.btnRefresh != null) {
                this.btnRefresh.setEnabled(true);
            }
        } else {
            this.btnAdd.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnDel.setEnabled(false);
            if (this.btnAddAggr != null) {
                this.btnAddAggr.setEnabled(false);
            }
            if (this.btnRefresh != null) {
                this.btnRefresh.setEnabled(false);
            }
        }
    }

    private void updateSelection() {
        if (this.canSelect) {
            ((CheckboxTableViewer)this.bindingTable).setAllChecked(false);
            ((CheckboxTableViewer)this.bindingTable).setGrayed((Object)dummyChoice, true);
            if (this.getSelectColumnHandle() != null) {
                ((CheckboxTableViewer)this.bindingTable).setChecked((Object)this.getSelectColumnHandle(), true);
            }
        }
    }

    protected Button getAggregationButton() {
        return this.btnAddAggr;
    }

    public void setSortingColumnIndex(int index) {
        this.sortingColumnIndex = index;
    }

    public void setSortDirection(int dir) {
        this.sortDirection = dir;
    }

    private class BindingComparator
    implements Comparator {
        private BindingComparator() {
        }

        public int compare(Object o1, Object o2) {
            ComputedColumnHandle binding1 = (ComputedColumnHandle)o1;
            ComputedColumnHandle binding2 = (ComputedColumnHandle)o2;
            String columnText1 = ColumnBindingDialog.this.labelProvider.getColumnText((Object)binding1, ColumnBindingDialog.this.sortingColumnIndex);
            String columnText2 = ColumnBindingDialog.this.labelProvider.getColumnText((Object)binding2, ColumnBindingDialog.this.sortingColumnIndex);
            int result = (columnText1 == null ? "" : columnText1).compareTo(columnText2 == null ? "" : columnText2);
            if (ColumnBindingDialog.this.sortDirection == 128) {
                return result;
            }
            return 0 - result;
        }
    }

    public static class BindingInfo {
        private int bindingType;
        private Object bindingValue;

        public BindingInfo() {
        }

        public BindingInfo(int type, Object value) {
            this.bindingType = type;
            this.bindingValue = value;
        }

        public int getBindingType() {
            return this.bindingType;
        }

        public Object getBindingValue() {
            return this.bindingValue;
        }

        public void setBindingType(int bindingType) {
            this.bindingType = bindingType;
        }

        public void setBindingValue(Object bindingValue) {
            this.bindingValue = bindingValue;
        }
    }
}

