/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.preference.IPreferenceChangeListener;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.EditorBreadcrumb;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.ReportLayoutEditorBreadcrumb;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.EditorSelectionProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.providers.SchematicContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.actions.CopyTemplateAction;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.CustomizeAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.LayoutAction;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteEditPartFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.palette.SettingsAction;
import org.eclipse.gef.ui.palette.customize.PaletteSettingsDialog;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public abstract class GraphicalEditorWithFlyoutPalette
extends GraphicalEditor
implements EditorSelectionProvider,
IPropertyChangeListener,
IPreferenceChangeListener {
    private static final String VIEW_CONTEXT_ID = "org.eclipse.birt.report.designer.internal.ui.editors.parts.graphicaleditorwithflyoutpalette.context";
    private PaletteViewerProvider provider;
    private FlyoutPaletteComposite splitter;
    private CustomPalettePage page;
    private static boolean shellActiveFlag = false;
    private static Shell lastActiveShell = null;
    private ShellListener shellActiveListener = new ShellAdapter(){

        public void shellActivated(ShellEvent e) {
            if (!shellActiveFlag) {
                shellActiveFlag = true;
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (lastActiveShell == GraphicalEditorWithFlyoutPalette.this.getSite().getShell()) {
                            shellActiveFlag = false;
                            return;
                        }
                        lastActiveShell = GraphicalEditorWithFlyoutPalette.this.getSite().getShell();
                        IEditorPart editor = UIUtil.getActiveEditor(true);
                        if (editor instanceof IPartListener) {
                            ((IPartListener)editor).partActivated((IWorkbenchPart)editor);
                        }
                        shellActiveFlag = false;
                    }
                });
            }
        }
    };
    private List stackActionIDs = new ArrayList();
    private List editorActionIDs = new ArrayList();
    private List editPartActionIDs = new ArrayList();
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            GraphicalEditorWithFlyoutPalette.this.updateActions(GraphicalEditorWithFlyoutPalette.this.editPartActionIDs);
        }
    };
    private EditorBreadcrumb fBreadcrumb;
    private boolean fIsBreadcrumbVisible;
    private static IContextActivation contextActivation;
    public static final String EDITOR_SHOW_BREADCRUMB = "breadcrumb";
    private Composite fBreadcrumbComposite;

    protected void initializeGraphicalViewer() {
        this.splitter.hookDropTargetListener(this.getGraphicalViewer());
        this.updateActions(this.stackActionIDs);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getSelectionListener());
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.updateActions(this.editorActionIDs);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getBreadcrumbPreferenceKey().equals(event.getProperty())) {
            this.fIsBreadcrumbVisible = this.isBreadcrumbShown();
            if (this.fIsBreadcrumbVisible) {
                this.showBreadcrumb();
                List list = this.getModelList(this.getGraphicalViewer().getSelection());
                if (list != null && list.size() == 1) {
                    this.setBreadcrumbInput(list.get(0));
                } else {
                    this.setBreadcrumbInput(null);
                }
            } else {
                this.hideBreadcrumb();
            }
        }
    }

    private List getModelList(ISelection selection) {
        List<Object> list = new ArrayList();
        if (selection == null) {
            return list;
        }
        if (!(selection instanceof StructuredSelection)) {
            return list;
        }
        StructuredSelection structured = (StructuredSelection)selection;
        if (structured.getFirstElement() instanceof ReportElementEditPart) {
            boolean bool = false;
            for (ReportElementEditPart object : structured) {
                if (object instanceof DummyEditpart) {
                    list.add(object.getModel());
                    bool = true;
                }
                if (bool) continue;
                list.add(object.getModel());
            }
        } else {
            list = structured.toList();
        }
        return list;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(final PaletteViewer viewer) {
                viewer.setContextMenu((MenuManager)new PaletteContextMenuProvider(viewer){

                    public void buildContextMenu(IMenuManager menu) {
                        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
                        List lst = this.getPaletteViewer().getSelectedEditParts();
                        if (lst.size() == 0) {
                            return;
                        }
                        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new LayoutAction(this.getPaletteViewer().getPaletteViewerPreferences()));
                        if (this.getPaletteViewer().getCustomizer() != null) {
                            menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new CustomizeAction(this.getPaletteViewer()));
                        }
                        final PaletteViewer paletteViewer = this.getPaletteViewer();
                        menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new SettingsAction(paletteViewer){

                            public void run() {
                                final PaletteViewerPreferences prefs = paletteViewer.getPaletteViewerPreferences();
                                PaletteSettingsDialog settings = new PaletteSettingsDialog(paletteViewer.getControl().getShell(), prefs){

                                    protected Control createLayoutSettings(Composite parent) {
                                        Composite composite = new Composite(parent, 0);
                                        composite.setFont(parent.getFont());
                                        GridLayout layout = new GridLayout(1, false);
                                        composite.setLayout((Layout)layout);
                                        Control layoutOptions = this.createLayoutOptions(composite);
                                        GridData data = new GridData(2);
                                        layoutOptions.setLayoutData((Object)data);
                                        this.handleLayoutSettingChanged(prefs.getLayoutSetting());
                                        return composite;
                                    }

                                    protected void handleLayoutSettingChanged(int newSetting) {
                                        prefs.setLayoutSetting(newSetting);
                                    }
                                };
                                settings.open();
                            }
                        });
                    }
                });
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
                viewer.getControl().addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent e) {
                        EditPart editPart = viewer.findObjectAt(new Point(e.x, e.y));
                        CombinedTemplateCreationEntry entry = null;
                        if (editPart != null && editPart.getModel() instanceof CombinedTemplateCreationEntry) {
                            entry = (CombinedTemplateCreationEntry)editPart.getModel();
                        }
                        if (entry == null) {
                            return;
                        }
                        ReportCreationTool tool = (ReportCreationTool)entry.createTool();
                        final EditDomain domain = UIUtil.getLayoutEditPartViewer().getEditDomain();
                        tool.setEditDomain(domain);
                        tool.setViewer(UIUtil.getLayoutEditPartViewer());
                        tool.performCreation(UIUtil.getCurrentEditPart());
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                domain.loadDefaultTool();
                            }
                        });
                    }

                    public void mouseDown(MouseEvent e) {
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
            }

            public PaletteViewer createPaletteViewer(Composite parent) {
                PaletteViewer pViewer = new PaletteViewer();
                pViewer.setEditPartFactory((EditPartFactory)new PaletteEditPartFactory());
                pViewer.createControl(parent);
                this.configurePaletteViewer(pViewer);
                this.hookPaletteViewer(pViewer);
                return pViewer;
            }
        };
    }

    protected CustomPalettePage createPalettePage() {
        return new CustomPalettePage(this.getPaletteViewerProvider());
    }

    protected void createActions() {
        this.addStackAction((StackAction)new UndoAction((IEditorPart)this){

            protected void init() {
                super.init();
                this.setToolTipText(Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Undo.ToolTip0"));
                this.setText(Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Undo.Text0"));
                this.setId(ActionFactory.UNDO.getId());
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
                this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
            }

            protected void refresh() {
                super.refresh();
                Command undoCmd = this.getCommandStack().getUndoCommand();
                if (this.getLabelForCommand(undoCmd).length() == 0) {
                    this.setToolTipText(Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Undo.ToolTip0"));
                    this.setText(Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Undo.Text0"));
                } else {
                    this.setToolTipText(MessageFormat.format((String)Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Undo.ToolTip1"), (Object[])new Object[]{this.getLabelForCommand(undoCmd)}).trim());
                    this.setText(MessageFormat.format((String)Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Undo.Text1"), (Object[])new Object[]{this.getLabelForCommand(undoCmd)}).trim());
                }
            }
        });
        this.addStackAction((StackAction)new RedoAction((IEditorPart)this){

            protected void init() {
                super.init();
                this.setToolTipText(Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Redo.ToolTip0"));
                this.setText(Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Redo.Text0"));
                this.setId(ActionFactory.REDO.getId());
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
                this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
            }

            protected void refresh() {
                super.refresh();
                Command redoCmd = this.getCommandStack().getRedoCommand();
                if (this.getLabelForCommand(redoCmd).length() == 0) {
                    this.setToolTipText(Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Redo.ToolTip0"));
                    this.setText(Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Redo.Text0"));
                } else {
                    this.setToolTipText(MessageFormat.format((String)Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Redo.ToolTip1"), (Object[])new Object[]{this.getLabelForCommand(redoCmd)}).trim());
                    this.setText(MessageFormat.format((String)Messages.getString((String)"GraphicalEditorWithFlyoutPalette_Redo.Text1"), (Object[])new Object[]{this.getLabelForCommand(redoCmd)}).trim());
                }
            }
        });
        this.addEditPartAction((SelectionAction)new DeleteAction((IWorkbenchPart)this){

            public Command createDeleteCommand(List objects) {
                if (objects.isEmpty()) {
                    return null;
                }
                if (!(objects.get(0) instanceof EditPart)) {
                    return null;
                }
                GroupRequest deleteReq = new GroupRequest((Object)"delete");
                deleteReq.setEditParts(objects);
                List temp = TableUtil.filletCellModel(objects);
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while (i < temp.size()) {
                    EditPart object = (EditPart)temp.get(i);
                    list.add(object.getModel());
                    ++i;
                }
                return new DeleteCommand((Object)list.toArray());
            }

            public void run() {
                if (UIUtil.canDelete(this.getSelectedObjects())) {
                    super.run();
                }
            }
        });
        SaveAction saveAction = new SaveAction((IEditorPart)this);
        saveAction.setLazyEnablementCalculation(true);
        this.addEditorAction((EditorPartAction)saveAction);
        this.addAction((IAction)new CopyTemplateAction((IEditorPart)this));
    }

    protected boolean hasRuler() {
        return false;
    }

    protected boolean hasButtonPane() {
        return true;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fBreadcrumbComposite = new Composite(composite, 0);
        GridData layoutData = new GridData(4, 128, true, false);
        this.fBreadcrumbComposite.setLayoutData((Object)layoutData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layoutData.exclude = true;
        this.fBreadcrumbComposite.setLayout((Layout)layout);
        this.splitter = new FlyoutPaletteComposite(composite, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), this.getPalettePreferences());
        super.createPartControl((Composite)this.splitter);
        this.splitter.setLayoutData((Object)new GridData(1808));
        Control ctrl = this.getGraphicalControl();
        this.splitter.setGraphicalControl(ctrl);
        if (this.page != null) {
            this.splitter.setExternalViewer(this.page.getPaletteViewer());
            this.page = null;
        }
        this.fBreadcrumb = this.createBreadcrumb();
        this.fBreadcrumb.setMenuManager((MenuManager)new SchematicContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry()));
        this.fIsBreadcrumbVisible = this.isBreadcrumbShown();
        if (this.fIsBreadcrumbVisible) {
            this.showBreadcrumb();
        }
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.registerExtensionPreference("showInDesignerByPreference");
        this.getSite().getShell().addShellListener(this.shellActiveListener);
        lastActiveShell = this.getSite().getShell();
        this.activateDesignerEditPart();
    }

    private void activateDesignerEditPart() {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (contextActivation == null) {
            contextActivation = contextService.activateContext(VIEW_CONTEXT_ID);
        }
    }

    public void dispose() {
        if (this.getSite() != null && !this.getSite().getShell().isDisposed()) {
            this.getSite().getShell().removeShellListener(this.shellActiveListener);
        }
        if (this.fBreadcrumb != null) {
            this.fBreadcrumb.dispose();
        }
        this.deregisterExtensionPreference("showInDesignerByPreference");
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.getSelectionListener());
        super.dispose();
        if (this.splitter != null) {
            this.splitter.setExternalViewer(null);
        }
        this.splitter = null;
        this.getSelectionActions().clear();
        this.getActionRegistry().dispose();
        ArrayList<IAction> list = new ArrayList<IAction>();
        Iterator actions = this.getActionRegistry().getActions();
        while (actions.hasNext()) {
            IAction action = (IAction)actions.next();
            list.add(action);
        }
        int i = 0;
        while (i < list.size()) {
            this.getActionRegistry().removeAction((IAction)list.get(i));
            ++i;
        }
        this.deActivateDesignerEditPart();
    }

    private void deActivateDesignerEditPart() {
        if (!UIUtil.isReportEditorActivated()) {
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            if (contextActivation != null) {
                contextService.deactivateContext(contextActivation);
                contextActivation = null;
            }
        }
    }

    public Object getAdapter(Class type) {
        if (type == PalettePage.class) {
            if (this.splitter == null) {
                this.page = this.createPalettePage();
                return this.page;
            }
            return this.createPalettePage();
        }
        if (type == PaletteRoot.class) {
            return this.getPaletteRoot();
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    protected abstract IEditorPart getMultiPageEditor();

    protected Control getGraphicalControl() {
        return this.getGraphicalViewer().getControl();
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    protected abstract FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences();

    protected abstract PaletteRoot getPaletteRoot();

    protected final PaletteViewerProvider getPaletteViewerProvider() {
        if (this.provider == null) {
            this.provider = this.createPaletteViewerProvider();
        }
        return this.provider;
    }

    protected void setEditDomain(DefaultEditDomain ed) {
        super.setEditDomain(ed);
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
    }

    protected void createGraphicalViewer(Composite parent) {
        DeferredGraphicalViewer viewer = new DeferredGraphicalViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected void hookZoom(ScalableFreeformRootEditPart root) {
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
    }

    protected ISelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addEditorAction(EditorPartAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editorActionIDs.add(action.getId());
    }

    protected void addEditPartAction(SelectionAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editPartActionIDs.add(action.getId());
    }

    protected void removeEditPartAction(SelectionAction action) {
        this.getActionRegistry().removeAction((IAction)action);
        this.editPartActionIDs.remove(action.getId());
    }

    protected void addStackAction(StackAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.stackActionIDs.add(action.getId());
    }

    protected void updateActions(List actionIds) {
        Iterator ids = actionIds.iterator();
        while (ids.hasNext()) {
            IAction action = this.getActionRegistry().getAction(ids.next());
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public void updateStackActions() {
        this.updateActions(this.stackActionIDs);
    }

    public void setFocus() {
        if (this.getGraphicalViewer() != null && this.getGraphicalViewer().getControl() != null) {
            super.setFocus();
        }
    }

    protected EditorBreadcrumb createBreadcrumb() {
        return new ReportLayoutEditorBreadcrumb(this);
    }

    protected boolean isBreadcrumbShown() {
        IPreferenceStore store = this.getPreferenceStore();
        String key = this.getBreadcrumbPreferenceKey();
        return store != null && key != null && store.getBoolean(key);
    }

    private IPreferenceStore getPreferenceStore() {
        return ReportPlugin.getDefault().getPreferenceStore();
    }

    public String getBreadcrumbPreferenceKey() {
        IPerspectiveDescriptor perspective = this.getSite().getPage().getPerspective();
        if (perspective == null) {
            return null;
        }
        return "breadcrumb." + perspective.getId();
    }

    private void showBreadcrumb() {
        if (this.fBreadcrumb == null) {
            return;
        }
        if (this.fBreadcrumbComposite.getChildren().length == 0) {
            this.fBreadcrumb.createContent(this.fBreadcrumbComposite);
        }
        ((GridData)this.fBreadcrumbComposite.getLayoutData()).exclude = true;
        this.fBreadcrumbComposite.setVisible(false);
        this.fBreadcrumbComposite.getParent().layout(true, true);
    }

    protected void setBreadcrumbInput(Object element) {
        if (!this.isBreadcrumbShown()) {
            return;
        }
        if (this.fBreadcrumb == null) {
            return;
        }
        if (element != null) {
            this.fBreadcrumb.setInput(element);
        } else {
            this.fBreadcrumb.setInput(new Object[0]);
        }
        ((GridData)this.fBreadcrumbComposite.getLayoutData()).exclude = false;
        this.fBreadcrumbComposite.setVisible(true);
        this.fBreadcrumbComposite.getParent().layout(true, true);
    }

    public EditorBreadcrumb getBreadcrumb() {
        return this.fBreadcrumb;
    }

    private void hideBreadcrumb() {
        if (this.fBreadcrumb == null) {
            return;
        }
        ((GridData)this.fBreadcrumbComposite.getLayoutData()).exclude = true;
        this.fBreadcrumbComposite.setVisible(false);
        this.fBreadcrumbComposite.getParent().layout(true, true);
    }

    protected void registerExtensionPreference(String extension) {
        List<ExtendedElementUIPoint> exts = ExtensionPointManager.getInstance().getExtendedElementPoints();
        for (ExtendedElementUIPoint point : exts) {
            IPreferences wrapper;
            String[] splits;
            String preference = (String)point.getAttribute(extension);
            if (preference == null || (splits = preference.split("/")).length != 2 || (wrapper = PreferenceFactory.getInstance().getPluginPreferences(splits[0], null)) == null) continue;
            wrapper.removePreferenceChangeListener((IPreferenceChangeListener)this);
            wrapper.addPreferenceChangeListener((IPreferenceChangeListener)this);
            ExtensionPointManager.getInstance().addPreference(extension, splits[1]);
        }
    }

    protected void deregisterExtensionPreference(String extension) {
        List<ExtendedElementUIPoint> exts = ExtensionPointManager.getInstance().getExtendedElementPoints();
        for (ExtendedElementUIPoint point : exts) {
            IPreferences wrapper;
            String[] splits;
            String preference = (String)point.getAttribute(extension);
            if (preference == null || (splits = preference.split("/")).length != 2 || (wrapper = PreferenceFactory.getInstance().getPluginPreferences(splits[0], null)) == null) continue;
            wrapper.removePreferenceChangeListener((IPreferenceChangeListener)this);
        }
    }

    protected class CustomPalettePage
    extends PaletteViewerPage {
        public CustomPalettePage(PaletteViewerProvider provider) {
            super(provider);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (GraphicalEditorWithFlyoutPalette.this.splitter != null) {
                GraphicalEditorWithFlyoutPalette.this.splitter.setExternalViewer(this.viewer);
            }
        }

        public void dispose() {
            if (GraphicalEditorWithFlyoutPalette.this.splitter != null) {
                GraphicalEditorWithFlyoutPalette.this.splitter.setExternalViewer(null);
            }
            super.dispose();
        }

        public PaletteViewer getPaletteViewer() {
            return this.viewer;
        }
    }
}

