/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.emitter.config.DefaultEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.RenderOptionDefn;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RenderOptionParser {
    private static final String OPTIONS_CONFIG_FILE = "RenderDefaults.cfg";
    private static final String RENDER_OPTIONS_FILE = "RenderOptions.xml";
    private static final String OPTION_QNAME = "option";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_DEFAULT = "default";
    private static final String OPTION_ENABLED = "enabled";
    protected DefaultEmitterDescriptor descriptor;

    RenderOptionParser(DefaultEmitterDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    void parseConfigFor(String bundleName) throws Exception {
        this.loadCfgFile(this.getResourceURL(bundleName, OPTIONS_CONFIG_FILE));
        this.loadXMLFile(bundleName, RENDER_OPTIONS_FILE);
    }

    protected DefaultHandler getHandler() {
        return new RenderOptionHandler();
    }

    protected void loadCfgFile(URL url) throws Exception {
        if (url != null) {
            InputStream in = url.openStream();
            Properties defaultValues = new Properties();
            defaultValues.load(in);
            for (Map.Entry<Object, Object> entry : defaultValues.entrySet()) {
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                this.descriptor.addRenderOption(name, new RenderOptionDefn(name, value, true));
            }
            in.close();
        }
    }

    protected void loadXMLFile(String bundleName, String fileName) throws Exception {
        URL url = this.getResourceURL(bundleName, fileName);
        if (url != null) {
            InputStream in = url.openStream();
            this.parseConfigXML(in);
            in.close();
        }
    }

    private void parseConfigXML(InputStream in) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        try {
            parser.parse(in, this.getHandler());
        }
        catch (Throwable throwable) {
            try {
                parser.reset();
                parser = null;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            parser.reset();
            parser = null;
        }
        catch (Exception exception) {}
    }

    private URL getResourceURL(String bundleName, String resourceName) {
        IBundle bundle = Platform.getBundle((String)bundleName);
        if (bundle != null) {
            return bundle.getEntry(resourceName);
        }
        return null;
    }

    protected class RenderOptionHandler
    extends DefaultHandler {
        protected RenderOptionHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            if (RenderOptionParser.OPTION_QNAME.equalsIgnoreCase(qName) && !this.isEmpty(name = attributes.getValue(RenderOptionParser.OPTION_NAME))) {
                String defualt = attributes.getValue(RenderOptionParser.OPTION_DEFAULT);
                Boolean enabled = Boolean.TRUE;
                String enabledStr = attributes.getValue(RenderOptionParser.OPTION_ENABLED);
                if (!this.isEmpty(enabledStr)) {
                    enabled = Boolean.valueOf(enabledStr);
                }
                RenderOptionParser.this.descriptor.addRenderOption(name, new RenderOptionDefn(name, defualt, enabled));
            }
        }

        protected boolean isEmpty(String str) {
            return str == null || str.length() == 0;
        }
    }
}

