/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.docx;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.CompressionMode;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.docx.writer.DocxWriter;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;

public class DocxEmitterImpl
extends AbstractEmitterImpl {
    private static final String OUTPUT_FORMAT = "docx";
    private boolean embedHtml = true;

    public DocxEmitterImpl(ContentEmitterVisitor contentVisitor) {
        this.contentVisitor = contentVisitor;
    }

    public void initialize(IEmitterServices service) throws EngineException {
        super.initialize(service);
        String tempFileDir = service.getReportEngine().getConfig().getTempDir();
        this.wordWriter = new DocxWriter(this.out, tempFileDir, this.getCompressionMode(service).getValue());
        IRenderOption renderOption = service.getRenderOption();
        Object value = renderOption.getOption("EmbedHtml");
        if (value instanceof Boolean) {
            this.embedHtml = (Boolean)value;
        }
    }

    private CompressionMode getCompressionMode(IEmitterServices service) {
        RenderOption renderOption = (RenderOption)service.getRenderOption();
        CompressionMode compressionMode = CompressionMode.BEST_COMPRESSION;
        Object mode = renderOption.getOption("BEST_COMPRESSION");
        if (mode instanceof CompressionMode) {
            compressionMode = (CompressionMode)mode;
        }
        return compressionMode;
    }

    public String getOutputFormat() {
        return OUTPUT_FORMAT;
    }

    public void endTable(ITableContent table) {
        this.endTable();
        this.decreaseTOCLevel((IContent)table);
    }

    public void startForeign(IForeignContent foreign) throws BirtException {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            if (this.embedHtml) {
                int width = WordUtil.convertTo((DimensionType)foreign.getWidth(), (int)this.context.getCurrentWidth(), (int)this.reportDpi);
                width = Math.min(width, this.context.getCurrentWidth());
                this.wordWriter.startTable(foreign.getComputedStyle(), width, true);
                this.wordWriter.startTableRow(-1.0);
                this.wordWriter.startTableCell(width, foreign.getComputedStyle(), null);
                this.wordWriter.writeForeign(foreign);
                if (this.isInSpannedCell(foreign)) {
                    this.wordWriter.endTableCell(true, true);
                } else {
                    this.wordWriter.endTableCell(true, false);
                }
                this.wordWriter.endTableRow();
                this.wordWriter.endTable();
                this.context.setIsAfterTable(true);
                this.context.addContainer(true);
            } else {
                this.writeBookmark((IContent)foreign);
                this.writeToc((IContent)foreign);
                HTML2Content.html2Content((IForeignContent)foreign);
                this.contentVisitor.visitChildren((IContent)foreign, null);
                this.adjustInline();
            }
        } else {
            Object rawValue = foreign.getRawValue();
            String foreignText = rawValue == null ? "" : rawValue.toString();
            this.writeContent(-1, foreignText, (IContent)foreign);
        }
    }

    private boolean isInSpannedCell(IForeignContent foreign) {
        ICellContent cell;
        IElement content = foreign.getParent();
        return content instanceof ICellContent && (cell = (ICellContent)content) != null && cell.getColSpan() > 1;
    }

    protected void writeContent(int type, String txt, IContent content) {
        this.context.addContainer(false);
        IStyle computedStyle = content.getComputedStyle();
        IStyle inlineStyle = null;
        AbstractEmitterImpl.InlineFlag inlineFlag = AbstractEmitterImpl.InlineFlag.BLOCK;
        String textAlign = null;
        if ("inline".equalsIgnoreCase(content.getComputedStyle().getDisplay())) {
            if (this.context.isFirstInline()) {
                this.context.startInline();
                inlineFlag = AbstractEmitterImpl.InlineFlag.FIRST_INLINE;
                computedStyle = this.computeStyle(computedStyle);
            } else {
                inlineFlag = AbstractEmitterImpl.InlineFlag.MIDDLE_INLINE;
            }
            IContent parent = (IContent)content.getParent();
            if (parent != null && parent.getComputedStyle() != null) {
                textAlign = parent.getComputedStyle().getTextAlign();
            }
        } else {
            this.adjustInline();
        }
        this.writeBookmark(content);
        this.writeToc(content, inlineFlag == AbstractEmitterImpl.InlineFlag.MIDDLE_INLINE);
        this.writeText(type, txt, content, inlineFlag, computedStyle, inlineStyle, textAlign);
        this.context.setIsAfterTable(false);
    }
}

