/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Component;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Core;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Slide;
import org.eclipse.birt.report.engine.emitter.pptx.writer.SlideMaster;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Theme;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.ImageManager;
import org.eclipse.birt.report.engine.ooxml.Package;
import org.eclipse.birt.report.engine.ooxml.util.OOXmlUtil;

public class Presentation
extends Component {
    private static final String TAG_CY = "cy";
    private static final String TAG_CX = "cx";
    private static final String TAG_NOTES_SZ = "p:notesSz";
    private static final String TAG_SLIDE_SZ = "p:sldSz";
    private static final String TAG_SLIDE_ID = "p:sldId";
    private static final String TAG_SLIDE_ID_LIST = "p:sldIdLst";
    private static final String TAG_RELATIONSHIP_ID = "r:id";
    private static final String TAG_ID = "id";
    private static final String TAG_SLIDE_MASTER_ID = "p:sldMasterId";
    private static final String TAG_SLIDE_MASTER_ID_LIST = "p:sldMasterIdLst";
    private int width = 0;
    private int height = 0;
    private Package pkg;
    private SlideMaster slideMaster;
    private List<Slide> slides = new ArrayList<Slide>();
    private String author;
    private String title;
    private String description;
    private String subject;

    public Presentation(OutputStream out, String tempFileDir, int compressionMode) {
        this.pkg = Package.createInstance((OutputStream)out, (String)tempFileDir, (int)compressionMode);
        String uri = "ppt/presentation.xml";
        String type = "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml";
        String relationshipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
        this.part = this.pkg.getPart(uri, type, relationshipType);
        this.pkg.setExtensionData((Object)new ImageManager());
        try {
            this.writer = this.part.getCacheWriter();
            this.initialize();
            Theme theme = new Theme(this.part);
            this.createSlideMaster();
            this.slideMaster.referTo(theme);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createSlideMaster() throws IOException {
        this.slideMaster = new SlideMaster(this);
        this.writer.openTag(TAG_SLIDE_MASTER_ID_LIST);
        this.writer.openTag(TAG_SLIDE_MASTER_ID);
        this.writer.attribute(TAG_ID, "2147483648");
        this.writer.attribute(TAG_RELATIONSHIP_ID, this.slideMaster.getPart().getRelationshipId());
        this.writer.closeTag(TAG_SLIDE_MASTER_ID);
        this.writer.closeTag(TAG_SLIDE_MASTER_ID_LIST);
    }

    public void initialize() {
        this.writer.startWriter();
        this.writer.openTag("p:presentation");
        this.writer.nameSpace("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        this.writer.nameSpace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        this.writer.nameSpace("p", "http://schemas.openxmlformats.org/presentationml/2006/main");
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Slide createSlide(int pageWidth, int pageHeight) throws IOException {
        if (pageWidth > this.width) {
            this.width = pageWidth;
        }
        if (pageHeight > this.height) {
            this.height = pageHeight;
        }
        return this.createSlide();
    }

    public Slide createSlide() throws IOException {
        int slideIndex = this.slides.size() + 1;
        Slide slide = new Slide(this, slideIndex);
        this.slides.add(slide);
        return slide;
    }

    private void outputSlides() {
        this.writer.openTag(TAG_SLIDE_ID_LIST);
        for (Slide slide : this.slides) {
            this.writer.openTag(TAG_SLIDE_ID);
            this.writer.attribute(TAG_ID, slide.getSlideId());
            this.writer.attribute(TAG_RELATIONSHIP_ID, slide.getPart().getRelationshipId());
            this.writer.closeTag(TAG_SLIDE_ID);
        }
        this.writer.closeTag(TAG_SLIDE_ID_LIST);
    }

    public void close() throws IOException {
        new Core(this, this.author, this.title, this.description, this.subject);
        this.slideMaster.close();
        this.outputSlides();
        this.writer.openTag(TAG_SLIDE_SZ);
        if (this.width == 0) {
            this.width = 612;
            this.height = 792;
        }
        long convertedWidth = OOXmlUtil.convertPointerToEmus((double)this.width);
        long convertedHeight = OOXmlUtil.convertPointerToEmus((double)this.height);
        this.writer.attribute(TAG_CX, convertedWidth);
        this.writer.attribute(TAG_CY, convertedHeight);
        this.writer.closeTag(TAG_SLIDE_SZ);
        this.writer.openTag(TAG_NOTES_SZ);
        this.writer.attribute(TAG_CX, convertedHeight);
        this.writer.attribute(TAG_CY, convertedWidth);
        this.writer.closeTag(TAG_NOTES_SZ);
        this.writer.closeTag("p:presentation");
        this.copyPropertyFile("viewProps");
        this.copyPropertyFile("tableStyles");
        this.copyPropertyFile("presProps");
        this.writer.close();
        this.pkg.close();
    }

    public void copyPropertyFile(String propFile) throws IOException {
        String url = "ppt/" + propFile + ".xml";
        String type = "application/vnd.openxmlformats-officedocument.presentationml." + propFile + "+xml";
        IPart part = this.pkg.getPart(url, type, null);
        this.copyPartContent(String.valueOf(propFile) + ".xml", part);
    }

    private void copyPartContent(String file, IPart part) throws IOException {
        int len;
        InputStream is = this.getClass().getResourceAsStream(file);
        OutputStream os = part.getOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        is.close();
        os.close();
    }

    public Package getPackage() {
        return this.pkg;
    }

    public SlideMaster getSlideMaster() {
        return this.slideMaster;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }
}

