/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.writer.ExtendedXMLWriter;
import org.eclipse.birt.report.engine.odf.writer.StyleEntryWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesWriter {
    protected ExtendedXMLWriter writer = new ExtendedXMLWriter();
    protected StyleEntryWriter styleEntryWriter;

    public StylesWriter(OutputStream out, int reportDpi) {
        this.writer.open(out);
        this.styleEntryWriter = new StyleEntryWriter(this.writer, reportDpi);
    }

    public void start() {
        this.writer.startWriter();
        this.writeDocumentHeader();
    }

    public void writeStyles(Collection<StyleEntry> autoStyles) throws IOException {
        this.writer.openTag("office:styles");
        this.writeDefaultStyles();
        this.writer.closeTag("office:styles");
        this.writer.openTag("office:automatic-styles");
        this.styleEntryWriter.writeStyles(autoStyles);
        this.writer.closeTag("office:automatic-styles");
    }

    public void writeMasterPage(InputStream masterPageContent) throws IOException {
        this.writer.write(masterPageContent);
    }

    public void end() {
        this.writeDocumentFooter();
        this.writer.endWriter();
        this.writer.close();
    }

    public void writeDefaultStyles() {
        this.writer.openTag("style:style");
        this.writer.attribute("style:name", "Standard");
        this.writer.attribute("style:family", "paragraph");
        this.writer.attribute("style:class", "text");
        this.writer.closeTag("style:style");
        this.writer.openTag("style:style");
        this.writer.attribute("style:name", "Graphics");
        this.writer.attribute("style:family", "graphic");
        this.writer.openTag("style:graphic-properties");
        this.writer.attribute("text:anchor-type", "paragraph");
        this.writer.attribute("svg:x", "0in");
        this.writer.attribute("svg:y", "0in");
        this.writer.attribute("style:wrap", "dynamic");
        this.writer.attribute("style:number-wrapped-paragraphs", "no-limit");
        this.writer.attribute("style:wrap-contour", "false");
        this.writer.attribute("style:vertical-pos", "top");
        this.writer.attribute("style:vertical-rel", "paragraph");
        this.writer.attribute("style:horizontal-pos", "center");
        this.writer.attribute("style:horizontal-rel", "paragraph");
        this.writer.closeTag("style:graphic-properties");
        this.writer.closeTag("style:style");
        this.writer.openTag("style:style");
        this.writer.attribute("style:name", "Hidden");
        this.writer.attribute("style:family", "paragraph");
        this.writer.openTag("style:paragraph-properties");
        this.writer.attribute("text:display", "none");
        this.writer.closeTag("style:paragraph-properties");
        this.writer.closeTag("style:style");
    }

    private void writeDocumentHeader() {
        this.writer.literal("\n");
        this.writer.openTag("office:document-styles");
        this.writer.attribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        this.writer.attribute("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        this.writer.attribute("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        this.writer.attribute("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        this.writer.attribute("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        this.writer.attribute("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        this.writer.attribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.writer.attribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        this.writer.attribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        this.writer.attribute("xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        this.writer.attribute("xmlns:svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        this.writer.attribute("xmlns:chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        this.writer.attribute("xmlns:dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        this.writer.attribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        this.writer.attribute("xmlns:form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        this.writer.attribute("xmlns:script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        this.writer.attribute("xmlns:ooo", "http://openoffice.org/2004/office");
        this.writer.attribute("xmlns:ooow", "http://openoffice.org/2004/writer");
        this.writer.attribute("xmlns:oooc", "http://openoffice.org/2004/calc");
        this.writer.attribute("xmlns:dom", "http://www.w3.org/2001/xml-events");
        this.writer.attribute("xmlns:rpt", "http://openoffice.org/2005/report");
        this.writer.attribute("xmlns:of", "urn:oasis:names:tc:opendocument:xmlns:of:1.2");
        this.writer.attribute("xmlns:xhtml", "http://www.w3.org/1999/xhtml");
        this.writer.attribute("xmlns:grddl", "http://www.w3.org/2003/g/data-view#");
        this.writer.attribute("xmlns:officeooo", "http://openoffice.org/2009/office");
        this.writer.attribute("xmlns:tableooo", "http://openoffice.org/2009/table");
        this.writer.attribute("xmlns:css3t", "http://www.w3.org/TR/css3-text/");
        this.writer.attribute("office:version", "1.2");
        this.writer.attribute("grddl:transformation", "http://docs.oasis-open.org/office/1.2/xslt/odf2rdf.xsl");
    }

    private void writeDocumentFooter() {
        this.writer.closeTag("office:document-styles");
    }
}

