/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ooxml;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.ooxml.ContentType;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.MimeType;
import org.eclipse.birt.report.engine.ooxml.Part;
import org.eclipse.birt.report.engine.ooxml.PartContainer;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public class Package
extends PartContainer {
    private static Logger logger = Logger.getLogger(Package.class.getName());
    private String tempFileName;
    private List<ContentType> contents = new ArrayList<ContentType>();
    private ArchiveWriter archiveWriter;
    private ArchiveFile archive;
    private Object data;
    private ZipOutputStream zipStream;
    private boolean hasEntryWriter = false;

    public static Package createInstance(OutputStream out, String tempFileDir, int compressionMode) {
        String name = "BIRT_OOXML_Temp_" + Thread.currentThread().getId() + System.nanoTime();
        if (tempFileDir != null && !tempFileDir.endsWith(String.valueOf(File.separatorChar))) {
            tempFileDir = String.valueOf(tempFileDir) + File.separatorChar;
        }
        String fullFileName = String.valueOf(tempFileDir) + name;
        try {
            ArchiveFile archive = new ArchiveFile(fullFileName, "rw");
            archive.setCacheSize(4084L);
            return new Package(archive, out, compressionMode, fullFileName);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    private Package(ArchiveFile archive, OutputStream out, int compressionMode, String fileName) throws IOException {
        super("/");
        this.tempFileName = fileName;
        this.archive = archive;
        this.archiveWriter = new ArchiveWriter((IArchiveFile)archive);
        this.zipStream = new ZipOutputStream(out);
        this.zipStream.setLevel(compressionMode);
        this.addContentType(MimeType.RELS);
        this.addContentType(MimeType.XML);
    }

    protected Package getPackage() {
        return this;
    }

    public String getAbsoluteUri() {
        return this.uri;
    }

    OutputStream getOutputStream(String uri) throws IOException {
        return this.archiveWriter.getOutputStream(uri);
    }

    OOXmlWriter getTempWriter(String uri) throws IOException {
        OutputStream out = this.getOutputStream(uri);
        OOXmlWriter writer = new OOXmlWriter();
        writer.open(out, "UTF-8");
        return writer;
    }

    void addContentType(ContentType contentType) {
        if (!this.contents.contains(contentType)) {
            this.contents.add(contentType);
        }
    }

    private InputStream getInputStream(String uri) throws IOException {
        return this.archiveWriter.getInputStream(uri);
    }

    private void save() throws IOException {
        try {
            this.outputRelationships();
            this.outputContentTypes();
            Collection<IPart> parts = this.getParts();
            for (IPart part : parts) {
                this.write(part);
            }
            this.zipStream.flush();
        }
        finally {
            if (this.zipStream != null) {
                this.zipStream.close();
            }
        }
    }

    private void write(IPart part) throws IOException {
        if (!part.isReference()) {
            Part part2 = (Part)part;
            this.writePart(part2);
            part2.release();
        }
    }

    private void writePart(Part part) throws IOException {
        part.outputRelationships();
        this.writePartData(part);
        Collection<IPart> children = part.getParts();
        for (IPart child : children) {
            if (child.isReference()) continue;
            this.writePart((Part)child);
        }
    }

    private void writePartData(Part part) throws IOException {
        if (!part.isCached()) {
            return;
        }
        InputStream inStream = null;
        try {
            String uri = part.getAbsoluteUri().toString();
            inStream = this.getInputStream(uri);
            this.zipStream.putNextEntry(new ZipEntry(uri.substring(1)));
            int length = -1;
            byte[] buff = new byte[4096];
            while ((length = inStream.read(buff)) != -1) {
                this.zipStream.write(buff, 0, length);
            }
            this.zipStream.closeEntry();
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private void outputContentTypes() throws IOException {
        OOXmlWriter writer = this.getEntryWriter("/[Content_Types].xml");
        writer.startWriter();
        writer.openTag("Types");
        writer.attribute("xmlns", "http://schemas.openxmlformats.org/package/2006/content-types");
        for (ContentType type : this.contents) {
            type.write(writer);
        }
        writer.closeTag("Types");
        writer.endWriter();
        writer.close();
    }

    OOXmlWriter getEntryWriter(String entry) throws IOException {
        OOXmlWriter writer = new OOXmlWriter();
        writer.open(this.getFinalOutputStream(entry), "UTF-8");
        return writer;
    }

    public void close() throws IOException {
        this.save();
        this.archiveWriter.finish();
        this.archive.close();
        File file = new File(this.tempFileName);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public Object getExtensionData() {
        return this.data;
    }

    public void setExtensionData(Object data) {
        this.data = data;
    }

    ZipOutputStream getZipOutputStream() {
        return this.zipStream;
    }

    protected String getRelationshipUri() {
        return "/_rels/.rels";
    }

    OutputStream getFinalOutputStream(String entry) throws IOException {
        assert (entry != null && entry.length() > 0);
        return new FinalOutputStream(entry.substring(1));
    }

    private class FinalOutputStream
    extends FilterOutputStream {
        public FinalOutputStream(String entry) throws IOException {
            super(Package.this.zipStream);
            if (Package.this.hasEntryWriter) {
                throw new RuntimeException("It is not allowed to open more than 1 entry writers concurrently.");
            }
            Package.this.hasEntryWriter = true;
            Package.this.zipStream.putNextEntry(new ZipEntry(entry));
        }

        public void write(byte[] b, int off, int len) throws IOException {
            Package.this.zipStream.write(b, off, len);
        }

        public void close() {
            Package.this.hasEntryWriter = false;
            try {
                Package.this.zipStream.flush();
                Package.this.zipStream.closeEntry();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
    }
}

