/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.w3c.dom.css.CSSValue;

public abstract class ContainerLayout
extends Layout {
    protected ContainerContext currentContext;
    protected LinkedList<ContainerContext> contextList = new LinkedList();
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected boolean isInBlockStacking = true;
    protected boolean isInline = false;

    public ContainerLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        if (parent != null && !parent.isInBlockStacking) {
            this.isInBlockStacking = false;
        }
    }

    public void layout() throws BirtException {
    }

    public boolean isPageEmpty() {
        if (!this.isRootEmpty()) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.isPageEmpty();
        }
        return true;
    }

    public void addToRoot(AbstractArea area, int index) {
        ContainerContext cc = this.currentContext;
        this.currentContext = this.contextList.get(index);
        this.addToRoot(area);
        this.currentContext = cc;
    }

    protected void addToRoot(AbstractArea area) {
        this.addToRoot(area, true);
    }

    protected void addToRoot(AbstractArea area, boolean clipFlag) {
        this.currentContext.root.addChild(area);
        area.setAllocatedPosition(this.currentContext.currentIP + this.offsetX, this.currentContext.currentBP + this.offsetY);
        this.currentContext.currentBP += area.getAllocatedHeight();
        if (clipFlag) {
            if (this.currentContext.currentIP + area.getAllocatedWidth() > this.currentContext.root.getContentWidth()) {
                this.currentContext.root.setNeedClip(true);
            } else if (this.currentContext.currentBP > this.currentContext.maxAvaHeight) {
                this.currentContext.root.setNeedClip(true);
            }
        }
    }

    public boolean addArea(AbstractArea area) {
        return this.addArea(area, true);
    }

    public boolean addArea(AbstractArea area, int index) {
        ContainerContext cc = this.currentContext;
        this.currentContext = this.contextList.get(index);
        boolean ret = this.addArea(area);
        this.currentContext = cc;
        return ret;
    }

    protected boolean addArea(AbstractArea area, boolean clipFlag) {
        if (this.currentContext != null) {
            if (!this.context.autoPageBreak) {
                this.addToRoot(area, clipFlag);
                return true;
            }
            if (area.getAllocatedHeight() + this.currentContext.currentBP > this.getMaxAvaHeight()) {
                if (this.isPageEmpty()) {
                    this.addToRoot(area, clipFlag);
                    return true;
                }
                return false;
            }
            this.addToRoot(area, clipFlag);
            return true;
        }
        return true;
    }

    public void autoPageBreak() throws BirtException {
        int size;
        if (this.parent != null) {
            this.parent.autoPageBreak();
        }
        if ((size = this.contextList.size()) == 0 || size > 0 && this.currentContext == this.contextList.getLast()) {
            this.initialize();
        } else {
            int index = this.contextList.indexOf(this.currentContext) + 1;
            if (index >= 0 && index < this.contextList.size()) {
                this.setCurrentContext(index);
            }
        }
    }

    public int getMaxAvaWidth() {
        return this.currentContext.maxAvaWidth;
    }

    public int getMaxAvaHeight() {
        return this.currentContext.maxAvaHeight;
    }

    public int getCurrentMaxContentWidth() {
        return this.currentContext.maxAvaWidth - this.currentContext.currentIP;
    }

    public int getCurrentMaxContentHeight() {
        return this.currentContext.maxAvaHeight - this.currentContext.currentBP;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    protected boolean isRootEmpty() {
        return this.currentContext.root == null || this.currentContext.root.getChildrenCount() <= 0;
    }

    public int getLineHeight() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return PropertyUtil.getLineHeight(contentStyle.getLineHeight());
        }
        return 0;
    }

    protected abstract void createRoot();

    public void step(int step) {
        int index;
        if (this.currentContext != null && (index = this.contextList.indexOf(this.currentContext) + step) >= 0 && index < this.contextList.size()) {
            this.setCurrentContext(index);
            if (this.parent != null) {
                this.parent.step(step);
            }
        }
    }

    public void gotoLastPage() {
        int size = this.contextList.size();
        if (size == 1) {
            return;
        }
        int index = this.contextList.indexOf(this.currentContext);
        if (index != size - 1) {
            this.setCurrentContext(size - 1);
            this.parent.step(size - 1 - index);
        }
    }

    public void gotoFirstPage() {
        int size = this.contextList.size();
        if (size == 1) {
            return;
        }
        int index = this.contextList.indexOf(this.currentContext);
        if (index > 0) {
            this.setCurrentContext(0);
            this.parent.step(0 - index);
        }
    }

    protected void setCurrentContext(int index) {
        if (index >= 0 && index < this.contextList.size()) {
            this.currentContext = this.contextList.get(index);
        }
    }

    protected void closeExcludingLast() throws BirtException {
        int size = this.contextList.size();
        this.closeFirstN(size - 1);
    }

    protected void closeFirstN(int size) throws BirtException {
        int i = 0;
        while (i < size) {
            this.closeLayout(this.contextList.removeFirst(), i, false);
            ++i;
        }
        this.setCurrentContext(0);
        if (this.parent != null) {
            this.parent.closeFirstN(size);
        }
    }

    protected void closeLayout() throws BirtException {
        int size = this.contextList.size();
        if (this.isInline) {
            int i = 0;
            while (i < size) {
                this.closeLayout(this.contextList.removeFirst(), i, i == size - 1);
                ++i;
            }
            if (this.isInBlockStacking && size > 1) {
                this.parent.closeExcludingLast();
            }
            if (this.parent != null) {
                this.parent.gotoFirstPage();
            }
        } else if (this.parent != null) {
            int i = 0;
            while (i < size) {
                int parentSize = this.parent.contextList.size();
                this.closeLayout(this.contextList.removeFirst(), parentSize - size + i, i == size - 1);
                ++i;
            }
            if (this.isInBlockStacking && size > 1) {
                this.parent.closeExcludingLast();
            }
            this.parent.gotoLastPage();
        } else {
            int i = 0;
            while (i < size) {
                this.closeLayout(this.contextList.removeFirst(), i, i == size - 1);
                ++i;
            }
        }
    }

    protected abstract void closeLayout(ContainerContext var1, int var2, boolean var3) throws BirtException;

    protected void align(ContainerArea container) {
        if (container == null || this.content == null) {
            return;
        }
        CSSValue align = this.content.getComputedStyle().getProperty(23);
        boolean isRightAligned = BidiAlignmentResolver.isRightAligned(this.content, align, false);
        if (isRightAligned || IStyle.CENTER_VALUE.equals(align)) {
            Iterator iter = container.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                int spacing = this.getMaxAvaWidth() - area.getAllocatedWidth();
                if (spacing <= 0) continue;
                if (isRightAligned) {
                    area.setAllocatedPosition(spacing + area.getAllocatedX(), area.getAllocatedY());
                    continue;
                }
                if (!IStyle.CENTER_VALUE.equals(align)) continue;
                area.setAllocatedPosition(spacing / 2 + area.getAllocatedX(), area.getAllocatedY());
            }
        }
    }

    class ContainerContext {
        protected ContainerArea root;
        protected int currentIP = 0;
        protected int currentBP = 0;
        protected int maxAvaHeight = 0;
        protected int maxAvaWidth = 0;

        ContainerContext() {
        }
    }
}

