/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddLevelHandleAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddSubTotalAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.DeleteDimensionViewHandleAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;

public class LevelCrosstabPopMenuProvider
extends ContextMenuProvider {
    public LevelCrosstabPopMenuProvider(EditPartViewer viewer) {
        super(viewer);
    }

    public void buildContextMenu(IMenuManager menu) {
        if (this.getElements().size() != 1) {
            return;
        }
        Object firstSelectedElement = this.getFirstElement();
        DesignElementHandle element = null;
        if (firstSelectedElement instanceof DesignElementHandle) {
            element = (DesignElementHandle)firstSelectedElement;
        } else if (firstSelectedElement instanceof CrosstabCellAdapter) {
            element = ((CrosstabCellAdapter)firstSelectedElement).getDesignElementHandle();
        }
        if (element != null) {
            AbstractCrosstabAction action = new AddLevelHandleAction(element);
            if (!CrosstabUtil.isBoundToLinkedDataSet((AbstractCrosstabItemHandle)this.getCrosstab(element))) {
                menu.add((IAction)action);
            }
            action = new AddSubTotalAction(element);
            menu.add((IAction)action);
            action = new DeleteDimensionViewHandleAction(element);
            menu.add((IAction)action);
        }
    }

    protected ISelection getSelection() {
        return this.getViewer().getSelection();
    }

    protected List getElements() {
        return InsertInLayoutUtil.editPart2Model((ISelection)this.getSelection()).toList();
    }

    protected Object getSelectedElement() {
        Object[] array = this.getElements().toArray();
        if (array.length == 1) {
            return array[0];
        }
        return array;
    }

    protected Object getFirstElement() {
        Object[] array = this.getElements().toArray();
        if (array.length > 0) {
            return array[0];
        }
        return null;
    }

    private CrosstabReportItemHandle getCrosstab(DesignElementHandle handle) {
        if (handle == null) {
            return null;
        }
        IReportItem item = null;
        try {
            item = ((ExtendedItemHandle)handle).getReportItem();
        }
        catch (ExtendedElementException extendedElementException) {
            return null;
        }
        if (item instanceof CrosstabReportItemHandle) {
            return (CrosstabReportItemHandle)item;
        }
        return this.getCrosstab(handle.getContainer());
    }
}

