/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AggregateOnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;

public class CrosstabBindingsFormHandleProvider
extends AggregateOnBindingsFormHandleProvider {
    public CrosstabBindingsFormHandleProvider() {
    }

    public CrosstabBindingsFormHandleProvider(boolean bShowAggregation) {
        super(bShowAggregation);
    }

    private ExtendedItemHandle getExtendedItemHandle() {
        return (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
    }

    public void generateAllBindingColumns() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(Messages.getString("CrosstabBindingRefresh.action.message"));
        try {
            ExtendedItemHandle handle = this.getExtendedItemHandle();
            if (handle.getCube() != null) {
                CubeHandle cube = this.getExtendedItemHandle().getCube();
                List dimensions = cube.getContents("dimensions");
                for (DimensionHandle dimension : dimensions) {
                    if (dimension instanceof TabularDimensionHandle && !dimension.isTimeType()) {
                        this.generateDimensionBindings(handle, dimension, 0);
                        continue;
                    }
                    this.generateDimensionBindings(handle, dimension, 1);
                }
                CrosstabReportItemHandle crosstab = (CrosstabReportItemHandle)handle.getReportItem();
                int i = 0;
                while (i < crosstab.getMeasureCount()) {
                    MeasureViewHandle measureView = crosstab.getMeasure(i);
                    String function = CrosstabModelUtil.getAggregationFunction((CrosstabReportItemHandle)crosstab, (AggregationCellHandle)measureView.getCell());
                    LevelHandle rowLevel = measureView.getCell().getAggregationOnRow();
                    LevelHandle colLevel = measureView.getCell().getAggregationOnColumn();
                    String aggregateRowName = rowLevel == null ? null : rowLevel.getQualifiedName();
                    String aggregateColumnName = colLevel == null ? null : colLevel.getQualifiedName();
                    CrosstabModelUtil.generateAggregation((CrosstabReportItemHandle)crosstab, (AggregationCellHandle)measureView.getCell(), (MeasureViewHandle)measureView, (String)function, null, (String)aggregateRowName, null, (String)aggregateColumnName);
                    ++i;
                }
            }
            stack.commit();
        }
        catch (SemanticException e) {
            stack.rollback();
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void generateDimensionBindings(ExtendedItemHandle handle, DimensionHandle dimensionHandle, int type) throws SemanticException {
        if (dimensionHandle.getDefaultHierarchy().getLevelCount() > 0) {
            IReportItem reportItem = handle.getReportItem();
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)reportItem;
            LevelHandle[] levels = this.getLevelHandles(dimensionHandle);
            int j = 0;
            while (j < levels.length) {
                CrosstabAdaptUtil.createColumnBinding((ReportItemHandle)((ExtendedItemHandle)xtabHandle.getModelHandle()), levels[j]);
                ++j;
            }
        }
    }

    private LevelHandle[] getLevelHandles(DimensionHandle dimensionHandle) {
        LevelHandle[] dimensionLevelHandles = new LevelHandle[dimensionHandle.getDefaultHierarchy().getLevelCount()];
        int i = 0;
        while (i < dimensionLevelHandles.length) {
            dimensionLevelHandles[i] = dimensionHandle.getDefaultHierarchy().getLevel(i);
            ++i;
        }
        return dimensionLevelHandles;
    }
}

