/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.ErrorCodes;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorDetail
implements ErrorCodes {
    private String type = null;
    private String errorCode = null;
    private int lineNo = 0;
    private String tagName;
    private DesignElement element;
    private String exceptionName;
    private String message;
    private String validationID;
    private String subEditor = null;
    private StringBuffer description = new StringBuffer();

    public ErrorDetail(Exception e) {
        if (e instanceof XMLParserException) {
            this.translate((XMLParserException)e);
        } else if (e instanceof DesignParserException) {
            this.translate((DesignParserException)((Object)e));
        } else if (e instanceof SemanticException) {
            this.translate((SemanticException)((Object)e));
        } else if (e instanceof SAXParseException) {
            this.translate((SAXParseException)e);
        } else if (e instanceof SAXException) {
            this.translate((SAXException)e);
        } else if (e instanceof ExtendedElementException) {
            this.translate((ExtendedElementException)((Object)e));
        } else {
            this.translate(e);
        }
    }

    private void translate(XMLParserException e) {
        this.type = "Error.DesignFileException.SYNTAX_ERROR";
        this.lineNo = e.getLineNumber();
        this.tagName = e.getTag();
        this.description.append(" ( line = ");
        this.description.append(e.getLineNumber());
        this.description.append(", ");
        this.description.append("tag = ");
        this.description.append(e.getTag());
        this.description.append(") ");
        if (e.getErrorCode().equalsIgnoreCase("Error.XMLParserException.EXCEPTION")) {
            if (e.getException() instanceof DesignParserException) {
                this.translate((DesignParserException)((Object)e.getException()));
            } else if (e.getException() instanceof SemanticException) {
                this.translate((SemanticException)((Object)e.getException()));
            }
        } else {
            this.exceptionName = e.getClass().getName();
            this.errorCode = e.getErrorCode();
            this.message = e.getMessage();
            this.description.append(e.getClass().getName());
            this.description.append(" (");
            this.description.append("code = ");
            this.description.append(e.getErrorCode());
            this.description.append(", ");
            this.description.append("message : ");
            this.description.append(e.getMessage());
            this.description.append(")");
        }
    }

    private void translate(DesignParserException e) {
        this.type = "Error.DesignFileException.SYNTAX_ERROR";
        this.exceptionName = e.getClass().getName();
        this.errorCode = e.getErrorCode();
        this.message = e.getMessage();
        this.description.append(" ");
        this.description.append(e.getClass().getName());
        this.description.append(" (");
        this.description.append("code = ");
        this.description.append(e.getErrorCode());
        this.description.append(", ");
        this.description.append("message : ");
        this.description.append(e.getMessage());
        this.description.append(")");
        if (e.getCause() != null && e.getCause() instanceof IOException) {
            this.translateCausedException(e.getCause());
        }
    }

    private void translate(SemanticException e) {
        this.type = "Error.DesignFileException.SEMANTIC_ERROR";
        if (e instanceof SemanticError && ((SemanticError)e).getErrorLevel() == 1) {
            this.type = "Error.DesignFileException.SEMANTIC_WARNING";
        }
        if (e instanceof CssException) {
            Module module = (Module)e.getElement();
            this.lineNo = module.getLineNo(((CssException)e).getIncludedStyleSheet());
        }
        this.element = e.getElement();
        this.exceptionName = ((Object)((Object)e)).getClass().getName();
        this.errorCode = e.getErrorCode();
        this.message = e.getMessage();
        this.description.append(" ");
        if (e.getElement() != null) {
            this.description.append(" (Element = ");
            this.description.append(e.getElement().getElementName());
            this.description.append(", Name = ");
            this.description.append(e.getElement().getFullName());
            this.description.append("), ");
        }
        this.description.append(((Object)((Object)e)).getClass().getName());
        this.description.append(" (");
        if (e instanceof SemanticError) {
            int level = ((SemanticError)e).getErrorLevel();
            if (level == 0) {
                this.description.append("level = error, ");
            } else if (level == 1) {
                this.description.append("level = warning, ");
            }
        }
        this.description.append("code = ");
        this.description.append(e.getErrorCode());
        this.description.append(", ");
        this.description.append("message : ");
        this.description.append(e.getMessage());
        this.description.append(")");
    }

    private void translate(SAXParseException e) {
        this.type = "Error.DesignFileException.INVALID_XML";
        this.exceptionName = e.getClass().getName();
        this.message = e.getMessage();
        this.description.append(" ( line = ");
        this.description.append(e.getLineNumber());
        this.description.append(") ");
        this.description.append(e.getClass().getName());
        this.description.append(" (");
        this.description.append("message : ");
        this.description.append(e.getMessage());
        this.description.append(")");
        this.lineNo = e.getLineNumber();
        if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
            this.translateCausedException(e.getCause());
        }
    }

    private void translate(SAXException e) {
        this.type = "Error.DesignFileException.INVALID_XML";
        this.exceptionName = e.getClass().getName();
        this.message = e.getMessage();
        this.description.append(" ");
        this.description.append(e.getClass().getName());
        this.description.append(" (");
        this.description.append("message : ");
        this.description.append(e.getMessage());
        this.description.append(")");
        if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
            this.translateCausedException(e.getCause());
        }
    }

    private void translateCausedException(Throwable e) {
        assert (e != null);
        StackTraceElement[] elements = e.getStackTrace();
        int i = 0;
        while (i < elements.length) {
            this.description.append("\tat ");
            this.description.append(elements[i].getClassName());
            this.description.append("(");
            this.description.append(elements[i].getFileName());
            this.description.append(":");
            this.description.append(elements[i].getLineNumber());
            this.description.append(")\n");
            ++i;
        }
    }

    private void translate(ExtendedElementException e) {
        assert (e != null);
        this.subEditor = (String)e.getProperty("sub_editor");
        String tempNumber = (String)e.getProperty("lineNo");
        if (tempNumber != null) {
            try {
                this.lineNo = Integer.parseInt(tempNumber);
            }
            catch (NumberFormatException numberFormatException) {
                this.lineNo = -1;
            }
        }
        this.message = e.getLocalizedMessage();
        this.exceptionName = ((Object)((Object)e)).getClass().getName();
        this.description.append("display in ");
        this.description.append(this.subEditor);
        this.description.append(" ( line = ");
        this.description.append(this.lineNo);
        this.description.append(") ");
        this.description.append(this.exceptionName);
        this.description.append(" (");
        this.description.append("message : ");
        this.description.append(this.message);
        this.description.append(")");
        if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
            this.translateCausedException(e.getCause());
        }
    }

    private void translate(Exception e) {
        this.subEditor = null;
        this.lineNo = -1;
        this.message = e.getLocalizedMessage();
        this.exceptionName = e.getClass().getName();
        this.description.append("display in ");
        this.description.append(this.subEditor);
        this.description.append(" ( line = ");
        this.description.append(this.lineNo);
        this.description.append(") ");
        this.description.append(this.exceptionName);
        this.description.append(" (");
        this.description.append("message : ");
        this.description.append(this.message);
        this.description.append(")");
        if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
            this.translateCausedException(e.getCause());
        }
    }

    public String toString() {
        return this.description.toString();
    }

    public DesignElement getElement() {
        return this.element;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public int getLineNo() {
        if (this.lineNo <= 0) {
            if (this.element == null) {
                return 1;
            }
            Module root = this.element.getRoot();
            if (root != null) {
                return root.getLineNo(this.element);
            }
            return 1;
        }
        return this.lineNo;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getType() {
        return this.type;
    }

    public void setValidationID(String validationID) {
        this.validationID = validationID;
    }

    public String getValidationID() {
        return this.validationID;
    }

    public static List<ErrorDetail> convertExceptionList(List<Exception> exceptionList) {
        ArrayList<ErrorDetail> errorDetailList = new ArrayList<ErrorDetail>();
        for (Exception e : exceptionList) {
            ErrorDetail errorDetail = new ErrorDetail(e);
            errorDetailList.add(errorDetail);
        }
        return errorDetailList;
    }

    public static List<ErrorDetail> getSemanticErrors(List<ErrorDetail> errors, String errorType) {
        ArrayList<ErrorDetail> retList = new ArrayList<ErrorDetail>();
        int i = 0;
        while (i < errors.size()) {
            ErrorDetail errorDetail = errors.get(i);
            if (errorType.equalsIgnoreCase(errorDetail.getType())) {
                retList.add(errorDetail);
            }
            ++i;
        }
        return retList;
    }

    public String getSubEditor() {
        return this.subEditor;
    }
}

