/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.TemplateException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.AbstractContentCommand;
import org.eclipse.birt.report.model.command.AbstractPropertyCommand;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ContentRecord;
import org.eclipse.birt.report.model.command.ElementBackRefRecord;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.TemplateCommand;
import org.eclipse.birt.report.model.command.TemplateTransformRecord;
import org.eclipse.birt.report.model.command.UserPropertyCommand;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.IContainerDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;

public class ContentCommand
extends AbstractContentCommand {
    protected boolean unresolveReference;
    protected boolean flag;

    public ContentCommand(Module module, ContainerContext containerInfo) {
        super(module, containerInfo);
    }

    ContentCommand(Module module, ContainerContext containerInfo, boolean flag) {
        super(module, containerInfo);
        this.flag = flag;
    }

    public ContentCommand(Module module, ContainerContext containerInfo, boolean flag, boolean unresolveReference) {
        super(module, containerInfo);
        this.flag = flag;
        this.unresolveReference = unresolveReference;
    }

    protected void checkBeforeAdd(DesignElement content) throws ContentException, NameException {
        assert (content.getContainer() == null);
        super.checkBeforeAdd(content);
        if (this.element.isVirtualElement() || this.element.getExtendsName() != null) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (this.focus.getSlotID() == 5 && StringUtil.isBlank(content.getName())) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.CONTENT_NAME_REQUIRED");
        }
        if (!this.flag) {
            this.checkContainmentContext(content);
        }
    }

    protected void doAdd(int newPos, DesignElement content) throws ContentException, NameException {
        ContentRecord addRecord = newPos == -1 ? new ContentRecord(this.module, this.focus, content, true) : new ContentRecord(this.module, this.focus, content, newPos);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(addRecord.getLabel());
        try {
            TemplateCommand cmd = new TemplateCommand(this.module, this.focus);
            cmd.checkAdd(content);
            this.checkEmptyName(content);
            super.doAdd(newPos, content);
            this.addElementNames(content);
        }
        catch (NameException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    protected void checkEmptyName(DesignElement content) {
        ElementDefn metaData = (ElementDefn)content.getDefn();
        String name = content.getName();
        if (name == null && metaData.getNameOption() == 2) {
            NameExecutor executor = new NameExecutor(this.module, this.focus, content);
            executor.makeUniqueName();
        }
    }

    private void checkContainmentContext(DesignElement content) throws NameException, ContentException {
        List<SemanticException> errors = this.focus.checkContainmentContext(this.module, content);
        if (!errors.isEmpty()) {
            SemanticException e = errors.get(0);
            assert (e instanceof NameException || e instanceof ContentException);
            if (e instanceof NameException) {
                throw (NameException)e;
            }
            if (e instanceof ContentException) {
                throw (ContentException)e;
            }
        }
    }

    protected void checkBeforeRemove(DesignElement content) throws SemanticException {
        assert (content != null);
        super.checkBeforeRemove(content);
        if (!this.flag && !content.canDrop(this.module)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (this.hasDescendents(content)) {
            throw ContentExceptionFactory.createContentException(new ContainerContext(content, this.focus.getSlotID()), "Error.ContentException.HAS_DESCENDENTS");
        }
    }

    private void adjustDerived(DesignElement obj) throws ExtendsException {
        List<DesignElement> derived = obj.getDerived();
        if (derived.isEmpty()) {
            return;
        }
        DesignElement parent = obj.getExtendsElement();
        for (DesignElement child : derived) {
            ExtendsCommand childCmd = new ExtendsCommand(this.module, child);
            childCmd.setExtendsElement(parent);
        }
    }

    private void adjustReferenceClients(IReferencableElement referred) throws SemanticException {
        ArrayList<BackRef> clients = new ArrayList<BackRef>(referred.getClientList());
        boolean isDimension = referred instanceof Dimension;
        for (BackRef ref : clients) {
            AbstractPropertyCommand cmd;
            Structure struct;
            DesignElement client = ref.getElement();
            if (isDimension && "internalDimensionRef".equals(ref.getPropertyName())) {
                ContainerContext context = client.getContainerInfo();
                assert (client instanceof TabularDimension && context.getElement() instanceof Cube);
                ContentCommand command = new ContentCommand(client.getRoot(), context);
                command.remove(client);
                continue;
            }
            if (this.unresolveReference) {
                ElementBackRefRecord record = null;
                record = client != null ? new ElementBackRefRecord(this.module, referred, client, ref.getPropertyName()) : new ElementBackRefRecord(this.module, referred, ref.getStructure(), ref.getPropertyName());
                this.getActivityStack().execute(record);
                continue;
            }
            if (((DesignElement)((Object)referred)).isStyle()) {
                struct = ref.getStructure();
                if (struct != null) {
                    cmd = new PropertyCommand(this.module, client);
                    ((PropertyCommand)cmd).setMember(new StructureContext(struct, (PropertyDefn)struct.getDefn().getMember(ref.getPropertyName()), struct), null);
                    continue;
                }
                StyleCommand clientCmd = new StyleCommand(this.module, client);
                clientCmd.setStyleElement((DesignElement)null);
                continue;
            }
            struct = ref.getStructure();
            if (struct != null) {
                cmd = new ComplexPropertyCommand(this.module, client);
                ((ComplexPropertyCommand)cmd).removeItem(struct.getContext(), struct);
                continue;
            }
            if (ref.getPropertyName() == null) continue;
            String propName = ref.getPropertyName();
            ElementPropertyDefn propDefn = client.getPropertyDefn(propName);
            if (propDefn.getTypeCode() == 20 && propDefn.getSubTypeCode() == 15) {
                this.clearMatchedElementRefInList(client, propDefn, referred);
                continue;
            }
            PropertyCommand cmd2 = new PropertyCommand(this.module, client);
            cmd2.setProperty(ref.getPropertyName(), null);
        }
    }

    private void clearMatchedElementRefInList(DesignElement client, ElementPropertyDefn propDefn, IReferencableElement referred) throws SemanticException {
        assert (propDefn.getTypeCode() == 20 && propDefn.getSubTypeCode() == 15);
        List values = (List)client.getProperty(this.module, propDefn);
        if (values == null || values.isEmpty()) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < values.size()) {
            ElementRefValue refValue = (ElementRefValue)values.get(i);
            if (refValue.getElement() == referred) {
                index = i;
                break;
            }
            ++i;
        }
        assert (index != -1);
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, client);
        cmd.removeItem(new StructureContext(client, propDefn, null), index);
    }

    private void adjustReferredClients(DesignElement element) {
        List<IElementPropertyDefn> propDefns = element.getPropertyDefns();
        for (PropertyDefn propertyDefn : propDefns) {
            List valueList;
            if ("extends".equalsIgnoreCase(propertyDefn.getName()) || "style".equalsIgnoreCase(propertyDefn.getName())) continue;
            if (propertyDefn.getTypeCode() == 15 || propertyDefn.getTypeCode() == 19) {
                Object value = element.getLocalProperty(this.module, (ElementPropertyDefn)propertyDefn);
                if (value == null || !(value instanceof StructRefValue) && !((ElementRefValue)value).isResolved()) continue;
                try {
                    PropertyCommand cmd = new PropertyCommand(this.module, element);
                    cmd.setProperty(propertyDefn.getName(), null);
                    continue;
                }
                catch (SemanticException semanticException) {
                    assert (false);
                    continue;
                }
            }
            if (propertyDefn.getTypeCode() != 20 || propertyDefn.getSubTypeCode() != 15 || (valueList = (List)element.getLocalProperty(this.module, (ElementPropertyDefn)propertyDefn)) == null) continue;
            StructureContext tmpMemberRef = new StructureContext(element, (ElementPropertyDefn)propertyDefn, null);
            int i = valueList.size() - 1;
            while (i >= 0) {
                block9: {
                    ElementRefValue item = (ElementRefValue)valueList.get(i);
                    if (item.isResolved()) {
                        try {
                            ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, element);
                            cmd.removeItem(tmpMemberRef, i);
                        }
                        catch (SemanticException semanticException) {
                            if ($assertionsDisabled) break block9;
                            throw new AssertionError();
                        }
                    }
                }
                --i;
            }
        }
    }

    private void dropUserProperties(DesignElement obj) throws UserPropertyException {
        List<UserPropertyDefn> props = obj.getLocalUserProperties();
        if (props != null) {
            UserPropertyCommand propCmd = new UserPropertyCommand(this.module, obj);
            for (UserPropertyDefn prop : props) {
                propCmd.dropUserProperty(prop.getName());
            }
        }
    }

    protected void checkBeforeMove(DesignElement content, ContainerContext toContainerInfor) throws ContentException {
        assert (content != null);
        assert (toContainerInfor != null);
        super.checkBeforeMove(content, toContainerInfor);
        if (content.isVirtualElement() || content.getExtendsName() != null) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (this.hasDescendents(content)) {
            throw ContentExceptionFactory.createContentException(new ContainerContext(content, this.focus.getSlotID()), "Error.ContentException.HAS_DESCENDENTS");
        }
    }

    protected void checkBeforeMovePosition(DesignElement content, int newPosn) throws ContentException {
        assert (content != null);
        super.checkBeforeMovePosition(content, newPosn);
        if (content.isVirtualElement()) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (!this.canMovePosition(content, newPosn)) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.MOVE_FORBIDDEN");
        }
    }

    private boolean canMovePosition(DesignElement content, int newPosn) {
        if (this.element instanceof ReportDesign && this.focus.getSlotID() == 5) {
            List<DesignElement> derived = content.getDerived();
            for (DesignElement child : derived) {
                if (!this.focus.contains(this.module, child) || this.focus.indexOf(this.module, child) > newPosn) continue;
                return false;
            }
            DesignElement e = content.getExtendsElement();
            while (e != null) {
                if (this.focus.indexOf(this.module, e) >= newPosn) {
                    return false;
                }
                e = e.getExtendsElement();
            }
        }
        return true;
    }

    private boolean hasDescendents(DesignElement content) {
        return this.element instanceof ReportDesign && this.focus.getSlotID() == 5 && content.hasDerived();
    }

    public void transformTemplate(DesignElement from, DesignElement to, boolean unresolveReference) throws SemanticException {
        this.doReplace(from, to, unresolveReference);
    }

    private void doReplace(DesignElement oldElement, DesignElement newElement, boolean unresolveReference) throws SemanticException {
        this.unresolveReference = unresolveReference;
        assert (newElement.getContainer() == null);
        ElementDefn metaData = (ElementDefn)this.element.getDefn();
        if (!metaData.isContainer()) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.NOT_CONTAINER");
        }
        IContainerDefn containerDefn = this.focus.getContainerDefn();
        if (containerDefn == null) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!containerDefn.canContain(newElement)) {
            throw ContentExceptionFactory.createContentException(this.focus, newElement, "Error.ContentException.WRONG_TYPE");
        }
        if (this.element.isContentOf(newElement)) {
            throw ContentExceptionFactory.createContentException(this.focus, newElement, "Error.ContentException.RECURSIVE");
        }
        if (this.focus.getSlotID() == 5 && StringUtil.isBlank(newElement.getName())) {
            throw ContentExceptionFactory.createContentException(this.focus, newElement, "Error.ContentException.CONTENT_NAME_REQUIRED");
        }
        if (!this.focus.contains(this.module, oldElement)) {
            throw ContentExceptionFactory.createContentException(this.focus, oldElement, "Error.ContentException.CONTENT_NOT_FOUND");
        }
        if (oldElement instanceof TemplateElement) {
            if (!(oldElement.canDrop(this.module) && oldElement.isTemplateParameterValue(this.module) && newElement.getDefn().isKindOf(((TemplateElement)oldElement).getDefaultElement(this.module).getDefn()))) {
                throw new TemplateException(oldElement, "Error.TemplateException.REVERT_TO_TEMPLATE_FORBIDDEN");
            }
        } else if (!oldElement.canTransformToTemplate(this.module) || !(newElement instanceof TemplateElement)) {
            throw ContentExceptionFactory.createContentException(this.focus, "Error.ContentException.TEMPLATE_TRANSFORM_FORBIDDEN");
        }
        if (this.hasDescendents(oldElement)) {
            throw ContentExceptionFactory.createContentException(new ContainerContext(oldElement, this.focus.getSlotID()), "Error.ContentException.HAS_DESCENDENTS");
        }
        TemplateTransformRecord replaceRecord = new TemplateTransformRecord(this.module, this.focus, oldElement, newElement);
        ActivityStack stack = this.getActivityStack();
        stack.startFilterEventTrans(replaceRecord.getLabel());
        try {
            this.doDelectAction(oldElement);
            TemplateCommand cmd = new TemplateCommand(this.module, this.focus);
            cmd.checkAdd(newElement);
            stack.execute(replaceRecord);
            this.addElementNames(newElement);
        }
        catch (ContentException e) {
            stack.rollback();
            throw e;
        }
        catch (NameException e) {
            stack.rollback();
            throw e;
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    protected void doDelectAction(DesignElement content) throws SemanticException {
        if (content instanceof ListingElement && content.hasReferences()) {
            this.adjustReferenceClients((IReferencableElement)((Object)content));
        }
        super.doDelectAction(content);
        this.dropUserProperties(content);
        if (!(this.element instanceof ListingElement) && content.hasReferences()) {
            this.adjustReferenceClients((IReferencableElement)((Object)content));
        }
        this.adjustReferredClients(content);
        this.adjustDerived(content);
        if (content.getStyle(this.module) != null) {
            StyleCommand styleCmd = new StyleCommand(this.module, content);
            styleCmd.setStyle(null);
        }
        if (content.getExtendsElement() != null) {
            ExtendsCommand extendsCmd = new ExtendsCommand(this.module, content);
            extendsCmd.setExtendsName(null);
        }
        this.removeElementFromNameSpace(content);
        List<PropertyBinding> propertyBindings = this.module.getPropertyBindings(content);
        int i = 0;
        while (i < propertyBindings.size()) {
            PropertyBinding propBinding = propertyBindings.get(i);
            ElementPropertyDefn propDefn = this.module.getPropertyDefn("propertyBindings");
            ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.module);
            propCommand.removeItem(new StructureContext(this.module, propDefn, null), propBinding);
            ++i;
        }
    }

    protected void doMove(DesignElement content, ContainerContext toContainerInfor, int newPos) {
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.MoveElement");
        stack.startTrans(label);
        super.doMove(content, toContainerInfor, newPos);
        stack.commit();
    }

    protected void doMovePosition(DesignElement content, int newPosn) throws ContentException {
        int adjustedNewPosn;
        if (!this.focus.isContainerMultipleCardinality()) {
            return;
        }
        int oldPosn = this.focus.indexOf(this.module, content);
        if (oldPosn == (adjustedNewPosn = ContentCommand.checkAndAdjustPosition(oldPosn, newPosn, this.focus.getContentCount(this.module)))) {
            return;
        }
        super.doMovePosition(content, newPosn);
    }
}

