/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupElementCommand
extends ContentCommand {
    public GroupElementCommand(Module module, ContainerContext containerInfo) {
        super(module, containerInfo);
    }

    GroupElementCommand(Module module, ContainerContext containerInfo, boolean flag) {
        super(module, containerInfo, flag);
    }

    GroupElementCommand(Module module, ContainerContext containerInfo, boolean flag, boolean unresolveReference) {
        super(module, containerInfo, flag, unresolveReference);
    }

    private void addDataGroups(ListingElement tmpContainer, int groupLevel, GroupElement content) throws ContentException, NameException {
        List<DesignElement> tmpElements = tmpContainer.findReferredListingElements(this.getModule());
        int i = 0;
        while (i < tmpElements.size()) {
            ListingElement tmpElement = (ListingElement)tmpElements.get(i);
            assert (tmpElement.getRoot() == this.getModule());
            GroupElement tmpGroup = GroupElementCommand.createNewGroupElement(tmpElement);
            GroupElementCommand cmd = new GroupElementCommand(this.module, this.newContainerContext(tmpElement), true);
            cmd.add(tmpGroup);
            ++i;
        }
    }

    private static List<GroupElement> createNewGroupElement(ListingElement tmpElement, int groupCount) {
        ArrayList<GroupElement> groupsToAdd = new ArrayList<GroupElement>();
        int i = 0;
        while (i < groupCount) {
            groupsToAdd.add(GroupElementCommand.createNewGroupElement(tmpElement));
            ++i;
        }
        return groupsToAdd;
    }

    private static GroupElement createNewGroupElement(ListingElement tmpElement) {
        if (tmpElement instanceof TableItem) {
            return new TableGroup();
        }
        if (tmpElement instanceof ListItem) {
            return new ListGroup();
        }
        assert (false);
        return null;
    }

    private void deleteDataGroups(ListingElement tmpContainer, int groupIndex) throws SemanticException {
        List<DesignElement> tmpElements = tmpContainer.findReferredListingElements(this.getModule());
        int i = 0;
        while (i < tmpElements.size()) {
            ListingElement tmpElement = (ListingElement)tmpElements.get(i);
            assert (tmpElement.getRoot() == this.getModule());
            GroupElement tmpGroup = (GroupElement)tmpElement.getGroups().get(groupIndex);
            GroupElementCommand cmd = new GroupElementCommand(this.module, this.newContainerContext(tmpElement), true, this.unresolveReference);
            cmd.remove(tmpGroup);
            ++i;
        }
    }

    private void handleColumnBinding(DesignElement content) {
        ListingElement tmpContainer;
        if (this.element instanceof ListingElement && content instanceof GroupElement && (tmpContainer = (ListingElement)this.element).isDataBindingReferring(this.module)) {
            return;
        }
        List<Object> boundColumns = this.element.getListProperty(this.module, "boundDataColumns");
        if (boundColumns == null || boundColumns.isEmpty()) {
            return;
        }
        String groupName = (String)content.getProperty(this.module, "groupName");
        ArrayList<Integer> toCleared = new ArrayList<Integer>();
        int i = 0;
        while (i < boundColumns.size()) {
            ComputedColumn column = (ComputedColumn)boundColumns.get(i);
            String aggregateGroup = column.getAggregateOn();
            if (aggregateGroup != null && aggregateGroup.equals(groupName)) {
                toCleared.add(i);
            }
            ++i;
        }
        StructPropertyDefn structPropDefn = (StructPropertyDefn)MetaDataDictionary.getInstance().getStructure("ComputedColumn").getMember("aggregateOn");
        try {
            int i2 = 0;
            while (i2 < toCleared.size()) {
                int columnIndex = (Integer)toCleared.get(i2);
                StructureContext memberRef = new StructureContext((Structure)boundColumns.get(columnIndex), structPropDefn, null);
                PropertyCommand propCmd = new PropertyCommand(this.module, this.element);
                propCmd.setMember(memberRef, null);
                ++i2;
            }
        }
        catch (SemanticException semanticException) {}
    }

    @Override
    protected void checkBeforeAdd(DesignElement content) throws ContentException, NameException {
        ListingElement tmpContainer;
        super.checkBeforeAdd(content);
        if (!this.flag && this.element instanceof ListingElement && content instanceof GroupElement && (tmpContainer = (ListingElement)this.element).isDataBindingReferring(this.module)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.GROUPS_CHANGE_FORBIDDEN");
        }
    }

    @Override
    protected void checkBeforeMovePosition(DesignElement content, int newPosn) throws ContentException {
        ListingElement tmpContainer;
        super.checkBeforeMovePosition(content, newPosn);
        if (!this.flag && this.element instanceof ListingElement && content instanceof GroupElement && (tmpContainer = (ListingElement)this.element).isDataBindingReferring(this.module)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.GROUPS_CHANGE_FORBIDDEN");
        }
    }

    @Override
    protected void checkBeforeRemove(DesignElement content) throws SemanticException {
        ListingElement tmpContainer;
        super.checkBeforeRemove(content);
        if (!this.flag && this.element instanceof ListingElement && content instanceof GroupElement && (tmpContainer = (ListingElement)this.element).isDataBindingReferring(this.module)) {
            throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.GROUPS_CHANGE_FORBIDDEN");
        }
    }

    @Override
    protected void doAdd(int newPos, DesignElement content) throws ContentException, NameException {
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.AddElement"));
        try {
            super.doAdd(newPos, content);
            NameExecutor executor = new NameExecutor(this.module, content);
            assert (executor.hasNamespace());
            String name = executor.getUniqueName();
            if (!this.flag && name != null && !name.equals(content.getName())) {
                PropertyRecord propertyRecord = new PropertyRecord(content, "groupName", (Object)name);
                stack.execute(propertyRecord);
            }
            this.addDataGroups((ListingElement)this.element, ((GroupElement)content).getGroupLevel(), (GroupElement)content);
        }
        catch (NameException e) {
            stack.rollback();
            throw e;
        }
        catch (ContentException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    @Override
    protected void doDelectAction(DesignElement content) throws SemanticException {
        int groupIndex = -1;
        if (content instanceof GroupElement) {
            groupIndex = ((GroupElement)content).getGroupLevel() - 1;
        }
        super.doDelectAction(content);
        this.deleteDataGroups((ListingElement)this.element, groupIndex);
        this.handleColumnBinding(content);
    }

    @Override
    protected void doMovePosition(DesignElement content, int newPosn) throws ContentException {
        int oldPosn = this.focus.indexOf(this.module, content);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.MoveContent"));
        try {
            super.doMovePosition(content, newPosn);
            ListingElement tmpContainer = (ListingElement)this.element;
            List<DesignElement> tmpElements = tmpContainer.findReferredListingElements(this.getModule());
            int i = 0;
            while (i < tmpElements.size()) {
                ListingElement tmpElement = (ListingElement)tmpElements.get(i);
                assert (tmpElement.getRoot() == this.getModule());
                GroupElement tmpContent = (GroupElement)tmpElement.getGroups().get(oldPosn);
                GroupElementCommand tmpCmd = new GroupElementCommand(this.module, this.newContainerContext(tmpElement), true);
                tmpCmd.movePosition(tmpContent, newPosn);
                ++i;
            }
        }
        catch (ContentException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void setupSharedDataGroups(DesignElement targetElement) throws SemanticException {
        if (!ModelUtil.isCompatibleDataBindingElements(this.element, targetElement)) {
            return;
        }
        ArrayList<DesignElement> groupsToRemove = new ArrayList<DesignElement>();
        groupsToRemove.addAll(((ListingElement)this.element).getGroups());
        int i = 0;
        while (i < groupsToRemove.size()) {
            GroupElementCommand tmpCmd = new GroupElementCommand(this.module, new ContainerContext(this.element, 1), true, this.unresolveReference);
            tmpCmd.remove((DesignElement)groupsToRemove.get(i));
            ++i;
        }
        List<DesignElement> targetGroups = ((ListingElement)targetElement).getGroups();
        List<GroupElement> groupsToAdd = GroupElementCommand.createNewGroupElement((ListingElement)this.element, targetGroups.size());
        int i2 = 0;
        while (i2 < groupsToAdd.size()) {
            GroupElementCommand tmpCmd = new GroupElementCommand(this.module, new ContainerContext(this.element, 1), true);
            tmpCmd.add(groupsToAdd.get(i2));
            ++i2;
        }
    }

    private ContainerContext newContainerContext(DesignElement tmpElement) {
        ContainerContext tmpContext = this.focus.createContext(tmpElement);
        if (tmpContext == null) {
            tmpContext = new ContainerContext(tmpElement, this.focus.getSlotID());
        }
        return tmpContext;
    }

    void updateBindingRef(ElementRefValue oldValue, ElementRefValue value) throws SemanticException {
        if (!(this.element instanceof ListingElement)) {
            return;
        }
        if (value != null && value.isResolved()) {
            this.setupSharedDataGroups(value.getElement());
        } else if (value == null && oldValue.isResolved()) {
            this.setupSharedDataGroups(oldValue.getElement());
        }
    }
}

