/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.IVersionInfo;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.UnicodeUtil;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.strategy.CopyForPastePolicy;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.EncryptionUtil;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.ModelUtilBase;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;
import org.eclipse.birt.report.model.util.URIUtilImpl;
import org.eclipse.birt.report.model.util.VersionInfo;
import org.eclipse.birt.report.model.util.VersionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil
extends ModelUtilBase {
    public static final int MAP_CAPACITY_LOW = 6;
    public static final int MAP_CAPACITY_MEDIUM = 12;

    public static Object wrapPropertyValue(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Expression) {
            return defn.getStringValue(module, value);
        }
        if (value instanceof ReferenceValue) {
            return ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, module);
        }
        if (value instanceof List && defn != null && defn.getSubTypeCode() == 15) {
            List valueList = (List)value;
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < valueList.size()) {
                ElementRefValue item = (ElementRefValue)valueList.get(i);
                names.add(ReferenceValueUtil.needTheNamespacePrefix(item, module));
                ++i;
            }
            return names;
        }
        if (defn != null && defn.isElementType()) {
            if (value instanceof DesignElement) {
                return ((DesignElement)value).getHandle(module);
            }
            if (value instanceof List) {
                List items = (List)value;
                ArrayList<DesignElementHandle> handles = new ArrayList<DesignElementHandle>();
                int i = 0;
                while (i < items.size()) {
                    DesignElement item = (DesignElement)items.get(i);
                    handles.add(item.getHandle(module));
                    ++i;
                }
                return handles;
            }
        }
        if (value instanceof List) {
            ArrayList retValue = new ArrayList();
            retValue.addAll((List)value);
            return retValue;
        }
        return value;
    }

    public static void duplicateProperties(DesignElementHandle source, DesignElementHandle destination, boolean onlyFactoryProperty, boolean removeNameSpace) {
        assert (source != null);
        assert (destination != null);
        if (!(source instanceof ReportDesignHandle) || !(destination instanceof ModuleHandle)) assert (destination.getDefn().getName().equalsIgnoreCase(source.getDefn().getName()));
        if (source.getDefn().allowsUserProperties()) {
            PropertyHandle propHandle = source.getPropertyHandle("userProperties");
            List<UserPropertyDefn> value = source.getElement().getUserProperties();
            Object valueToSet = null;
            if (propHandle != null) {
                valueToSet = ModelUtil.copyValue(propHandle.getDefn(), value);
            }
            if (valueToSet != null) {
                for (UserPropertyDefn userPropDefn : (List)valueToSet) {
                    destination.getElement().addUserPropertyDefn(userPropDefn);
                }
            }
        }
        if (source.getElement() instanceof IExtendableElement) {
            ModelUtil.duplicateExtensionIdentifier(source.getElement(), destination.getElement(), source.getModule());
        }
        Iterator iter = source.getPropertyIterator();
        while (iter.hasNext()) {
            ElementPropertyDefn propDefn;
            PropertyHandle propHandle = (PropertyHandle)iter.next();
            String propName = propHandle.getDefn().getName();
            if (ModelUtil.needSkipProperty(destination, propName) || (propDefn = destination.getElement().getPropertyDefn(propName)) == null || propDefn.getTypeCode() == 23) continue;
            Object value = null;
            if (propHandle.getElement() instanceof GroupElement && ("toc".equals(propName) || "pageBreakAfter".equals(propName) || "pageBreakBefore".equals(propName) || "pageBreakInside".equals(propName))) {
                value = propHandle.getElement().getLocalProperty(propHandle.getModule(), propDefn);
            } else if (onlyFactoryProperty) {
                value = propHandle.getElement().getFactoryProperty(propHandle.getModule(), propDefn);
            } else {
                if ("images".equals(propName)) {
                    Iterator images = source.getPropertyHandle("images").iterator();
                    while (images.hasNext()) {
                        StructureHandle image = (StructureHandle)images.next();
                        try {
                            ElementExportUtil.exportStructure(image, (LibraryHandle)destination, false);
                        }
                        catch (SemanticException semanticException) {
                            assert (false);
                        }
                    }
                    continue;
                }
                value = propHandle.getElement().getStrategy().getPropertyExceptRomDefault(propHandle.getModule(), propHandle.getElement(), propDefn);
            }
            if (propDefn.isEncryptable()) {
                String encryption = propHandle.getElement().getEncryptionID(propDefn);
                Object valueToSet = EncryptionUtil.encrypt(propDefn, encryption, ModelUtil.copyValue(propHandle.getDefn(), value));
                destination.getElement().setProperty(propName, valueToSet);
                destination.getElement().setEncryptionHelper(propDefn, encryption);
                continue;
            }
            Object valueToSet = ModelUtil.copyValue(propDefn, value);
            if (removeNameSpace && value instanceof ReferenceValue) {
                ((ReferenceValue)valueToSet).setLibraryNamespace(null);
            }
            destination.getElement().setProperty(propName, valueToSet);
            if (valueToSet == null || propDefn.getTypeCode() != 24) continue;
            if (propDefn.isList()) {
                List values = (List)valueToSet;
                int i = 0;
                while (i < values.size()) {
                    DesignElement item = (DesignElement)values.get(i);
                    item.setContainer(destination.getElement(), propName);
                    ++i;
                }
                continue;
            }
            ((DesignElement)valueToSet).setContainer(destination.getElement(), propName);
        }
    }

    static void duplicateExtensionIdentifier(DesignElement source, DesignElement destination, Module sourceModule) {
        if (source instanceof IOdaExtendableElementModel) {
            String extensionId = (String)source.getProperty(sourceModule, "extensionID");
            destination.setProperty("extensionID", (Object)extensionId);
        } else if (source instanceof IExtendedItemModel) {
            String extensionId = (String)source.getProperty(sourceModule, "extensionName");
            destination.setProperty("extensionName", (Object)extensionId);
        } else assert (false);
    }

    public static ArrayList cloneStructList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<IStructure> returnList = new ArrayList<IStructure>();
        int i = 0;
        while (i < list.size()) {
            Object item = list.get(i);
            if (item instanceof IStructure) {
                returnList.add(((IStructure)item).copy());
            } else assert (false);
            ++i;
        }
        return returnList;
    }

    public static Object copyValue(IPropertyDefn propDefn, Object value) {
        return ModelUtil.copyValue(propDefn, value, CopyForPastePolicy.getInstance());
    }

    public static Object copyValue(IPropertyDefn propDefn, Object value, CopyPolicy policy) {
        if (value == null || propDefn == null) {
            return null;
        }
        if (propDefn.allowExpression() && value instanceof Expression) {
            return new Expression(((Expression)value).getExpression(), ((Expression)value).getUserDefinedType());
        }
        switch (propDefn.getTypeCode()) {
            case 16: {
                if (propDefn.isList()) {
                    return ModelUtil.cloneStructList((List)value);
                }
                return ((Structure)value).copy();
            }
            case 15: 
            case 19: {
                ReferenceValue refValue = (ReferenceValue)value;
                return refValue.copy();
            }
            case 20: {
                return ModelUtil.clonePropertyList((List)value);
            }
            case 23: 
            case 24: {
                if (propDefn.isList()) {
                    return ModelUtil.cloneElementList((List)value, policy);
                }
                return ModelUtil.getCopy((DesignElement)value, policy);
            }
        }
        return value;
    }

    private static List clonePropertyList(List value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        int i = 0;
        while (i < value.size()) {
            Object item = value.get(i);
            if (item instanceof ElementRefValue) {
                returnList.add(((ElementRefValue)item).copy());
            } else if (item instanceof Expression) {
                returnList.add(new Expression(((Expression)item).getExpression(), ((Expression)item).getUserDefinedType()));
            } else {
                returnList.add(item);
            }
            ++i;
        }
        return returnList;
    }

    private static List cloneElementList(List value, CopyPolicy policy) {
        if (value == null) {
            return null;
        }
        ArrayList<DesignElement> returnList = new ArrayList<DesignElement>();
        int i = 0;
        while (i < value.size()) {
            DesignElement item = (DesignElement)value.get(i);
            returnList.add(ModelUtil.getCopy(item, policy));
            ++i;
        }
        return returnList;
    }

    public static List<RecordTask> filterLayoutTasks(List<RecordTask> tasks) {
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>();
        LinkedHashSet<DesignElement> elements = new LinkedHashSet<DesignElement>();
        int i = 0;
        while (i < tasks.size()) {
            DesignElement compoundElement;
            RecordTask task = tasks.get(i);
            if (task instanceof LayoutRecordTask && !elements.contains(compoundElement = (DesignElement)((LayoutRecordTask)task).getTarget())) {
                retList.add(task);
                elements.add(compoundElement);
            }
            ++i;
        }
        return retList;
    }

    public static Exception getFirstFatalException(List<Exception> list) {
        for (Exception ex : list) {
            String errorCode;
            XMLParserException parserException;
            if (!(ex instanceof XMLParserException) || !((parserException = (XMLParserException)ex).getException() instanceof LibraryException) || (errorCode = ((LibraryException)((Object)parserException.getException())).getErrorCode()) != "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY" && errorCode != "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE") continue;
            return parserException.getException();
        }
        return null;
    }

    public static String checkUTFSignature(InputStream inputStream, String fileName) throws IOException, SAXException {
        String encoding = UnicodeUtil.checkUTFSignature(inputStream);
        if (encoding != null && !"UTF-8".equals(encoding)) {
            DesignParserException cause = new DesignParserException("Error.DesignParserException.UNSUPPORTED_ENCODING");
            DesignFileException fileException = new DesignFileException(fileName, (Exception)((Object)cause));
            throw new SAXException((Exception)((Object)fileException));
        }
        return encoding;
    }

    public static List<IPropertyDefn> sortPropertiesByLocalizedName(List<IPropertyDefn> propDefns) {
        ULocale locale = ThreadResources.getLocale();
        Collator collator = Collator.getInstance((ULocale)locale);
        if (ULocale.ENGLISH.equals((Object)locale)) {
            collator.setStrength(0);
        }
        final HashMap<PropertyDefn, CollationKey> keysMap = new HashMap<PropertyDefn, CollationKey>();
        int i = 0;
        while (i < propDefns.size()) {
            PropertyDefn propDefn = (PropertyDefn)propDefns.get(i);
            CollationKey key = collator.getCollationKey(propDefn.getDisplayName());
            keysMap.put(propDefn, key);
            ++i;
        }
        Collections.sort(propDefns, new Comparator<IPropertyDefn>(){

            @Override
            public int compare(IPropertyDefn o1, IPropertyDefn o2) {
                PropertyDefn p1 = (PropertyDefn)o1;
                PropertyDefn p2 = (PropertyDefn)o2;
                CollationKey key1 = (CollationKey)keysMap.get(p1);
                CollationKey key2 = (CollationKey)keysMap.get(p2);
                return key1.compareTo(key2);
            }
        });
        return propDefns;
    }

    public static List<DesignElementHandle> sortElementsByName(List<DesignElementHandle> elements) {
        ArrayList<DesignElementHandle> temp = new ArrayList<DesignElementHandle>(elements);
        Collections.sort(temp, new Comparator<DesignElementHandle>(){

            @Override
            public int compare(DesignElementHandle o1, DesignElementHandle o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 == null) {
                    if (name2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        return temp;
    }

    public static void reviseNameSpace(Module module, DesignElement content, String nameSpace) {
        Iterator<String> propNames = content.propertyWithLocalValueIterator();
        IElementDefn defn = content.getDefn();
        while (propNames.hasNext()) {
            String propName = propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)defn.getProperty(propName);
            ModelUtil.revisePropertyNameSpace(module, content, propDefn, nameSpace);
        }
        LevelContentIterator iter = new LevelContentIterator(module, content, 1);
        while (iter.hasNext()) {
            DesignElement item = (DesignElement)iter.next();
            ModelUtil.reviseNameSpace(module, item, nameSpace);
        }
    }

    public static void revisePropertyNameSpace(Module module, DesignElement content, IElementPropertyDefn propDefn, String nameSpace) {
        if (propDefn == null || content == null) {
            return;
        }
        if (propDefn.getTypeCode() != 15 && propDefn.getTypeCode() != 17) {
            return;
        }
        Object value = content.getLocalProperty(module, (ElementPropertyDefn)propDefn);
        if (value == null) {
            return;
        }
        ReferenceValue refValue = (ReferenceValue)value;
        refValue.setLibraryNamespace(nameSpace);
    }

    public static boolean containElement(Module module, DesignElement element, IElementDefn defn) {
        if (element == null || defn == null) {
            return false;
        }
        ContentIterator iter = new ContentIterator(module, element);
        while (iter.hasNext()) {
            DesignElement e = (DesignElement)iter.next();
            IElementDefn targetDefn = e.getDefn();
            if (!targetDefn.isKindOf(defn)) continue;
            return true;
        }
        return false;
    }

    public static boolean containElement(Module module, DesignElement element, String elementName) {
        IElementDefn defn = MetaDataDictionary.getInstance().getElement(elementName);
        return ModelUtil.containElement(module, element, defn);
    }

    public static DesignElement getCopy(DesignElement element, CopyPolicy policy) {
        if (element == null) {
            return null;
        }
        try {
            DesignElement copy = (DesignElement)element.doClone(policy);
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static DesignElement getCopy(DesignElement element) {
        return ModelUtil.getCopy(element, CopyForPastePolicy.getInstance());
    }

    public static String searchForExternalizedValue(DesignElement element, String propIDName, ULocale locale) {
        if (element == null) {
            return null;
        }
        ElementPropertyDefn defn = element.getPropertyDefn(propIDName);
        if (defn == null) {
            return null;
        }
        String textKey = (String)element.getProperty(element.getRoot(), propIDName);
        if (StringUtil.isBlank(textKey)) {
            return null;
        }
        DesignElement temp = element;
        while (temp != null) {
            String externalizedText = temp.getRoot().getMessage(textKey, locale);
            if (externalizedText != null) {
                return externalizedText;
            }
            if (!defn.canInherit()) {
                return null;
            }
            temp = -1L != temp.getBaseId() ? temp.getVirtualParent() : temp.getExtendsElement();
        }
        return null;
    }

    public static String getExternalizedValue(DesignElement element, String propIDName, String propName, ULocale locale) {
        if (element == null || element.getPropertyDefn(propName) == null || element.getPropertyDefn(propIDName) == null) {
            return null;
        }
        String textKey = ModelUtil.searchForExternalizedValue(element, propIDName, locale);
        if (!StringUtil.isBlank(textKey)) {
            return textKey;
        }
        return element.getStringProperty(element.getRoot(), propName);
    }

    public static String getExternalizedStructValue(DesignElement element, IStructure structure, String propIDName, String propName, ULocale locale) {
        if (structure == null) {
            return null;
        }
        String textKey = (String)structure.getProperty(element.getRoot(), propIDName);
        if (!StringUtil.isBlank(textKey)) {
            DesignElement temp = element;
            String externalizedText = null;
            while (temp != null) {
                externalizedText = temp.getRoot().getMessage(textKey, locale);
                if (!StringUtil.isBlank(externalizedText)) {
                    return externalizedText;
                }
                temp = -1L != temp.getBaseId() ? temp.getVirtualParent() : temp.getExtendsElement();
            }
        }
        return (String)structure.getProperty(element.getRoot(), propName);
    }

    public static List<IVersionInfo> checkVersion(String version) {
        ArrayList<IVersionInfo> rtnList = new ArrayList<IVersionInfo>();
        int versionNo = -1;
        try {
            versionNo = VersionUtil.parseVersion(version);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (versionNo < 0 || versionNo > 3022300) {
            rtnList.add(new VersionInfo(version, 2));
        }
        if (versionNo <= 3000000) {
            rtnList.add(new VersionInfo(version, 1));
        }
        return rtnList;
    }

    public static List<IVersionInfo> checkVersion(String version, boolean isSupportedUnknownVersion) {
        ArrayList<IVersionInfo> rtnList = new ArrayList<IVersionInfo>();
        int versionNo = -1;
        try {
            versionNo = VersionUtil.parseVersion(version);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (versionNo < 0) {
            rtnList.add(new VersionInfo(version, 2));
        } else if (versionNo > 3022300) {
            if (isSupportedUnknownVersion) {
                rtnList.add(new VersionInfo(version, 3));
            } else {
                rtnList.add(new VersionInfo(version, 2));
            }
        }
        if (versionNo <= 3000000) {
            rtnList.add(new VersionInfo(version, 1));
        }
        return rtnList;
    }

    public static boolean isTemplateSupported(DesignElement element) {
        if (element instanceof DataSet) {
            return true;
        }
        if (element instanceof ReportItem) {
            IChoiceSet choiceSet = MetaDataDictionary.getInstance().getChoiceSet("templateElementType");
            assert (choiceSet != null);
            IChoice[] choices = choiceSet.getChoices();
            int i = 0;
            while (i < choices.length) {
                String name = choices[i].getName();
                MetaDataDictionary dd = MetaDataDictionary.getInstance();
                if ("ExtendedItem".equals(name)) {
                    if (element instanceof ExtendedItem && element.getDefn().isKindOf(dd.getElement("ReportItem"))) {
                        return true;
                    }
                } else {
                    IElementDefn defn = MetaDataDictionary.getInstance().getElement(name);
                    if (element.getDefn().isKindOf(defn)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isValidReferenceForCompoundElement(Module module, DesignElement element) {
        ElementRefValue refValue = (ElementRefValue)element.getLocalProperty(module, "extends");
        if (refValue == null) {
            return true;
        }
        if (element.getDefn().isContainer() && !refValue.isResolved()) {
            return false;
        }
        DesignElement parent = element.getExtendsElement();
        while (parent != null) {
            if (!ModelUtil.isValidReferenceForCompoundElement(parent.getRoot(), parent)) {
                return false;
            }
            parent = parent.getExtendsElement();
        }
        return true;
    }

    public static DesignElement getParent(DesignElement element) {
        DesignElement parent = null;
        parent = element.isVirtualElement() ? element.getVirtualParent() : element.getExtendsElement();
        return parent;
    }

    public static boolean isValidLayout(Module module, DesignElement element) {
        if (!(element instanceof ReportItem)) {
            return true;
        }
        if (!element.getDefn().isContainer()) {
            return true;
        }
        if (element instanceof TableItem) {
            return LayoutUtil.isValidLayout((TableItem)element, module);
        }
        if (element instanceof GridItem) {
            return LayoutUtil.isValidLayout((GridItem)element, module);
        }
        return true;
    }

    public static void addElement2NameSpace(Module module, DesignElement element) {
        NameSpace namespace;
        if (module == null || element == null || !element.isManagedByNameSpace()) {
            return;
        }
        NameExecutor executor = new NameExecutor(module, element);
        executor.makeUniqueName();
        if (element.getName() != null && (namespace = executor.getNameSpace()) != null) {
            namespace.insert(element);
        }
    }

    public static boolean isRecursiveReference(DesignElement reference, IReferencableElement referred) {
        if (reference == referred) {
            return true;
        }
        List<BackRef> backRefs = referred.getClientList();
        ArrayList<DesignElement> referenceElements = new ArrayList<DesignElement>();
        int i = 0;
        while (i < backRefs.size()) {
            BackRef backRef = backRefs.get(i);
            DesignElement tmpElement = backRef.getElement();
            if (tmpElement == reference) {
                return true;
            }
            if (tmpElement instanceof ReferenceableElement) {
                referenceElements.add(tmpElement);
            }
            ++i;
        }
        i = 0;
        while (i < referenceElements.size()) {
            if (ModelUtil.isRecursiveReference(reference, (ReferenceableElement)referenceElements.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static URL getURLPresentation(String filePath) {
        return URIUtilImpl.getURLPresentation(filePath);
    }

    public static String getTagByPropertyType(PropertyDefn prop) {
        assert (prop != null);
        assert (prop.getTypeCode() != 16);
        switch (prop.getTypeCode()) {
            case 7: {
                return "expression";
            }
            case 12: {
                return "xml-property";
            }
            case 18: {
                return "method";
            }
        }
        if (prop.isEncryptable()) {
            return "encrypted-property";
        }
        return "property";
    }

    public static ContentElementInfo getContentContainer(DesignElement content, PropertyDefn propDefn) {
        if (content == null) {
            return null;
        }
        Module root = content.getRoot();
        DesignElement tmpElement = content;
        PropertyDefn tmpPropDefn = propDefn;
        ContentElementInfo retTarget = new ContentElementInfo(true);
        while (tmpElement != null && tmpPropDefn != null) {
            List tmplist;
            DesignElement tmpContainer = tmpElement.getContainer();
            if (tmpContainer == null) {
                return null;
            }
            int index = -1;
            if (tmpPropDefn.isList() && (tmplist = (List)tmpContainer.getLocalProperty(root, (ElementPropertyDefn)tmpPropDefn)) != null) {
                index = tmplist.indexOf(tmpElement);
            }
            retTarget.pushStep(tmpPropDefn, index);
            if (tmpPropDefn.getTypeCode() == 24 && !(tmpContainer instanceof ContentElement)) {
                retTarget.setTopElement(tmpContainer);
                return retTarget;
            }
            ContainerContext context = tmpElement.getContainerInfo();
            if (context == null) break;
            context = (tmpElement = tmpElement.getContainer()).getContainerInfo();
            if (context == null) {
                return null;
            }
            tmpContainer = tmpElement.getContainer();
            tmpPropDefn = tmpContainer.getPropertyDefn(context.getPropertyName());
        }
        return null;
    }

    public static boolean isCompatibleDataBindingElements(DesignElement element1, DesignElement element2) {
        return element1.getDefn() == element2.getDefn() || element1 instanceof ListingElement && element2 instanceof ListingElement;
    }

    public static CssException convertSheetExceptionToCssException(Module module, IncludedCssStyleSheet styleSheet, String fileName, StyleSheetException sheetException) {
        String tmpErrorCode = sheetException.getErrorCode();
        tmpErrorCode = "Error.StyleSheetException.STYLE_SHEET_NOT_FOUND".equalsIgnoreCase(tmpErrorCode) ? "Error.CSSException.CSS_NOT_FOUND" : "Error.CSSException.BADCSSFILE";
        return new CssException(module, styleSheet, new String[]{fileName}, tmpErrorCode);
    }

    public static void duplicateDefaultHierarchy(Dimension targetDimension, Dimension sourceDimension) {
        if (targetDimension == null || sourceDimension == null) {
            return;
        }
        DesignElement hierarchy = sourceDimension.getDefaultHierarchy(sourceDimension.getRoot());
        if (hierarchy != null) {
            int index = hierarchy.getIndex(sourceDimension.getRoot());
            assert (index > -1);
            targetDimension.setDefaultHierarchy(index);
        }
    }

    public static boolean checkContainerOrContent(DesignElement firstElement, DesignElement secondElement) {
        if (firstElement == null || secondElement == null) {
            return false;
        }
        if (firstElement == secondElement) {
            return false;
        }
        if (firstElement.isContentOf(secondElement)) {
            return true;
        }
        return secondElement.isContentOf(firstElement);
    }

    public static boolean isEquals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null && value2 != null) {
            return false;
        }
        assert (value1 != null && value2 != null);
        if (value1.getClass() != value2.getClass()) {
            return false;
        }
        return value1.equals(value2);
    }

    public static boolean isExtensionPropertyOwnModel(IPropertyDefn propDefn) {
        assert (propDefn != null);
        return propDefn instanceof ExtensionPropertyDefn && ((ExtensionPropertyDefn)propDefn).hasOwnModel();
    }

    public static List getExpressionCompatibleList(List<Expression> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        if (!values.isEmpty()) {
            int i = 0;
            while (i < values.size()) {
                Expression tmpValue = values.get(i);
                if (tmpValue != null) {
                    newList.add(tmpValue.getExpression());
                } else {
                    newList.add(null);
                }
                ++i;
            }
        }
        return newList;
    }

    public static boolean canInherit(ElementPropertyDefn defn) {
        assert (defn != null);
        return defn.canInherit() || defn.isStyleProperty();
    }
}

