/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.core.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.birt.data.engine.core.DataException;

public class URLSecurity {
    public static URL getURL(final String protocol, final String host, final String file) throws MalformedURLException, DataException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL(protocol, host, file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof MalformedURLException) {
                throw (MalformedURLException)typedException;
            }
            throw new DataException(e.getLocalizedMessage());
        }
    }

    public static URL getURL(final String spec) throws MalformedURLException, DataException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL(spec);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof MalformedURLException) {
                throw (MalformedURLException)typedException;
            }
            throw new DataException(e.getLocalizedMessage());
        }
    }
}

