/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.util.DataJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.DimensionJSEvalHelper;
import org.eclipse.birt.data.engine.olap.util.IJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.IAggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class AggrMeasureFilterEvalHelper
extends DimensionJSEvalHelper
implements IAggrMeasureFilterEvalHelper {
    private DummyDimensionObject dimObj;

    public AggrMeasureFilterEvalHelper(IBaseQueryResults outResults, Scriptable scope, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter, ScriptContext cx) throws DataException {
        assert (cubeFilter != null);
        super.init(outResults, scope, queryDefn, cx, cubeFilter.getExpression());
    }

    @Override
    public boolean evaluateFilter(IResultRow resultRow) throws DataException {
        super.setData(resultRow);
        this.dimObj.setCurrentRow(resultRow);
        try {
            Object result = ScriptEvalUtil.evalExpr(this.expr, this.cx.newContext(this.scope), ScriptExpression.defaultID, 0);
            return DataTypeUtil.toBoolean(result);
        }
        catch (IJSObjectPopulator.InMatchDimensionIndicator inMatchDimensionIndicator) {
            return true;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    @Override
    protected void registerJSObjectPopulators() throws DataException {
        super.registerJSObjectPopulators();
        this.register(new DataJSObjectPopulator(this.outResults, this.scope, this.queryDefn.getBindings(), true, this.cx));
        this.dimObj = new DummyDimensionObject();
        this.scope.put("dimension", this.scope, (Object)this.dimObj);
    }

    @Override
    public IBaseExpression getExpression() {
        return this.expr;
    }

    private static class DummyDimensionObject
    extends ScriptableObject {
        private IResultRow row;
        private Map<String, DummyLevelObject> dimLevMap = new HashMap<String, DummyLevelObject>();

        private DummyDimensionObject() {
        }

        public String getClassName() {
            return "DummyDimensionObject";
        }

        public void setCurrentRow(IResultRow row) {
            this.row = row;
        }

        public Object get(String dimName, Scriptable scope) {
            try {
                if (this.dimLevMap.containsKey(dimName)) {
                    return this.dimLevMap.get(dimName);
                }
                this.dimLevMap.put(dimName, new DummyLevelObject(this, dimName));
                return this.dimLevMap.get(dimName);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static class DummyLevelAttrObject
    extends ScriptableObject {
        private String dimName;
        private String levelName;
        private DummyDimensionObject host;

        public DummyLevelAttrObject(DummyDimensionObject host, String dimName, String levelName) {
            this.host = host;
            this.dimName = dimName;
            this.levelName = levelName;
        }

        public String getClassName() {
            return "DummyLevelAttrObject";
        }

        public Object get(String attrName, Scriptable scope) {
            try {
                if (this.levelName.equals(attrName)) {
                    return this.getDefaultValue(null);
                }
                return this.host.row.getFieldValue(OlapExpressionUtil.getAttrReference(this.dimName, this.levelName, attrName));
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Object getDefaultValue(Class hint) {
            try {
                Object value = this.host.row.getFieldValue(OlapExpressionUtil.getAttrReference(this.dimName, this.levelName, this.levelName));
                if (value != null) {
                    return value;
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static class DummyLevelObject
    extends ScriptableObject {
        private DummyDimensionObject host;
        private String dimName;
        private Map<String, DummyLevelAttrObject> levelAttrMap;

        public DummyLevelObject(DummyDimensionObject host, String dimName) {
            this.host = host;
            this.dimName = dimName;
            this.levelAttrMap = new HashMap<String, DummyLevelAttrObject>();
        }

        public Object get(String levelName, Scriptable scope) {
            try {
                if (this.levelAttrMap.containsKey(levelName)) {
                    return this.levelAttrMap.get(levelName);
                }
                this.levelAttrMap.put(levelName, new DummyLevelAttrObject(this.host, this.dimName, levelName));
                return this.levelAttrMap.get(levelName);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getClassName() {
            return "DummyLevelObject";
        }
    }
}

