/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class CascadingParameterTypeValidator
extends AbstractElementValidator {
    private static final CascadingParameterTypeValidator instance = new CascadingParameterTypeValidator();

    public static CascadingParameterTypeValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        if (!(element instanceof ScalarParameter)) {
            return Collections.emptyList();
        }
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        ScalarParameter param = (ScalarParameter)element;
        if (param.getContainer() instanceof CascadingParameterGroup && !"dynamic".equalsIgnoreCase(param.getStringProperty(module, "valueType"))) {
            list.add(new SemanticError(element, "Error.SemanticError.INVALID_SCALAR_PARAMETER_TYPE"));
        }
        return list;
    }
}

